/**
 * Created by phpStorm
 * author      : linwang5@iflytek.com
 * createTime  : 2017/1/5 11:24
 * description :
 */
;

(function (win) {

    function _CALLFun() {
    }

    win._CALL = new _CALLFun();
    var BP = APP_CONFIG.BASE_PATH+'/user/';
//test
    _CALLFun.prototype.test = function (data, cb) {
        setTimeout(function () {
            cb && cb('please use right method,it\'s a default call method.');
        }, 100);
    };
    /*--------------------register method------------------------------*/
    _CALLFun.prototype.reg = function (data, cb) {
        var _self = this;
        switch (data.method) {
            case 'createFolder':_self.createFolder(data,cb);break;
            case 'deleteFolder':_self.deleteFolder(data,cb);break;
            case 'addPreFile':_self.addPreFile(data,cb);break;
            case 'searchPreIndex':_self.searchPreIndex(data,cb);break;
            case 'searchPreAll':_self.searchPreAll(data,cb);break;
            case 'searchPreDir':_self.searchPreDir(data,cb);break;
            case 'addDir':_self.addDir(data,cb);break;
            case 'deletePreFiles':_self.deletePreFiles(data,cb);break;
            case 'renamePreDir':_self.renamePreDir(data,cb);break;
            case 'movePrePosition':_self.movePrePosition(data,cb);break;
            case 'addTPFile':_self.addTPFile(data,cb);break;
            case 'addMTBKFile':_self.addMTBKFile(data,cb);break;
            case 'updateTPP':_self.updateTPP(data,cb);break;
            case 'updateTPE':_self.updateTPE(data,cb);break;
            case 'updateTPER':_self.updateTPER(data,cb);break;
            case 'deleteTPUuids':_self.deleteTPUuids(data,cb);break;
            case 'deleteTPUnit':_self.deleteTPUnit(data,cb);break;
            case 'getTPUnit':_self.getTPUnit(data,cb);break;
            case 'getTPIndex':_self.getTPIndex(data,cb);break;
            case 'readMTBKList':_self.readMTBKList(data,cb);break;
            case 'getMTBKInfo':_self.getMTBKInfo(data,cb);break;
            case 'deleteTPBook':_self.deleteTPBook(data,cb);break;
            case 'renamePreFile':_self.renamePreFile(data,cb);break;
            case 'upload':_self.upload(data,cb);break;
            case 'deleteTPIndex':_self.deleteTPIndex(data,cb);break;
            case 'getTPBook':_self.getTPBook(data,cb);break;
            case 'exportMtbk':_self.exportMtbk(data,cb);break;
            case 'updatePreMd5':_self.updatePreMd5(data,cb);break;
            case 'updateTPMd5':_self.updateTPMd5(data,cb);break;
            default:
                _self.test(data, cb);
        }
    };
    /*-----------------------------common-------------------------------*/
    /**
     * 上传文件
     * @param obj = {
     *      method:'upload',
     *      data:{
     *          file:'d:/demo/example.ppt',
     *          access_token:'',
     *          openId:''
     *          _from:'clientA' 自己客户端的名字
     *          showProcess:true or false 是否返回除-1 和100 之外的进度, 默认为false
     *       *  error: //此字段不可使用 用于失败时通知错误
     *       *  process://此字段不可使用 用于通知进度 -1 代表失败  100 代表完成
     *       * contextId://此字段不可使用 用于标识上传完成的通知字段
     *       * platForm://此字段不可使用 用于标识上传到了什么地方
     *      },
     *      extension:{} //内容自定义字段（extension名称不可变）  进度返回时会原样返回
     * }
     * @param cb type function 回调
     */
    _CALLFun.prototype.upload = function (obj,cb) {
        win.global_upload(obj,cb);
    };
    /**
     * 创建用于下载的文件夹
     * @param obj = {
     *      method:'createFolder',
     *      data:{
     *          userName:'***',
     *          bookCode:'****',     *
     *      }
     * }
     * @param cb type function 回调
     */
    _CALLFun.prototype.createFolder = function (obj,cb) {
        var data = obj.data;
        _FILE.checkBook(data.userName,data.bookCode).done(function () {
            var uuid = _COMMON.guid();
            _COMMON.mkdir(BP+data.userName+'/books/'+data.bookCode+'/'+uuid).done(function () {
                cb&&cb({
                    code:1,
                    data:{
                        uuid:uuid,
                        path:BP+data.userName+'/books/'+data.bookCode+'/'+uuid,
                        userName:data.userName,
                        bookCode:data.bookCode
                    }
                });
            }).fail(function (e) {
                cb&&cb({
                    code:-1,
                    error:e
                });
            });
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            });
        })
    };
    /**
     *删除创建的文件夹
     * @param obj = {
     *      method:'deleteFolder',
     *      data:{
     *          userName:'***',
     *          bookCode:'****',
     *          uuid:'*****'
     *      }
     * }
     * @param cb 
     */
    _CALLFun.prototype.deleteFolder = function (obj,cb) {
        var data = obj.data;
        if(!data.userName||!data.bookCode||!data.uuid) {
            cb&&cb({
                code:-1,
                error:'bad arguments'
            });
            return;
        }

        _FILE.deleteFolder(data.userName,data.bookCode,data.uuid).done(function () {
            cb&&cb({
                code:1,
                message:'success'
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            });
        })

    };
    /**
     * 读取mtbk里面的授课文件信息列表
     * @param obj = {
     *      method:'readMTBKList',
     *      data:{
     *          path:'d:/demo/example.mtbk' 授课包文件的绝对地址
     *      }
     * }
     * @param cb
     */
    _CALLFun.prototype.readMTBKList = function (obj,cb) {
        _FILE.readMTBKList(obj.data.path).done(function (list) {
            cb&&cb({
                code:1,
                list:list
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            });
        })
    };
    /**
     * 获取mtbk里面的书本和index信息
     * @param obj = {
     *      method:'getMTBKInfo',
     *      data:{
     *          path:'d:/demo/example.mtbk' 授课包文件的绝对地址
     *      }
     * }
     * @param cb
     */
    _CALLFun.prototype.getMTBKInfo = function (obj,cb) {
        _FILE.getMTBKInfo(obj.data.path).done(function (orgInfo) {
            var code = '',temp=[],arr=[];
            for(var i in orgInfo){
                temp = orgInfo[i].split('/');
                if(!code) code = temp[0];
                if(temp[1]&&$.inArray(temp[1],arr)<0) arr.push(temp[1]);
            }
            cb&&cb({
                code:1,
                data:{
                    bookCode:code,
                    pageList:arr
                }
            });
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            });
        })
    };
    /*----------------------------use for TA start----------------------*/
    /**
     * 根据目录信息查找文件和文件夹列表
     * @param obj = {
     *        method:'searchPreIndex',
     *        data:{
     *          userName:'**',
     *          bookCode:'***',
     *          unit1:'',
     *          unit2:'',
     *          unit3:'',
     *          unit4:'',
     *          searchAll: true or false bool值  默认为false 当为true是查找全书的内容
     *        }
     * }
     * @param cb
     */
    _CALLFun.prototype.searchPreIndex = function (obj,cb) {
        var cnf = {
            userName:obj.data.userName,
            bookCode:obj.data.bookCode,
            unit1:obj.data.unit1,
            unit2:obj.data.unit2,
            unit3:obj.data.unit3,
            unit4:obj.data.unit4
        };
        $.when(_DB.searchPreIndex(obj.data),_MENU.getRouter(cnf)).done(function (ret,router) {
            cb&&cb({
                code:1,
                data:ret,
                router:router
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        });
    };
    /**
     * 查询文件夹的内容
     * @param obj = {
     *      method:'searchPreDir',
     *      data:{
     *          userName:'***',
     *          uuid:'***'
     *      }
     * }
     * @param cb
     */
    _CALLFun.prototype.searchPreDir = function (obj,cb) {
        var check = {
            userName:obj.data.userName,
            list:[obj.data.uuid]
        };
        _DB.searchPreByUuids(check).done(function (detail) {
            if(detail.length==0){
                cb&&cb({
                    code:-1,
                    error:'con\'t find this folder'
                });
                return;
            }
            var cnf = {
                userName:obj.data.userName,
                bookCode:detail[0].bookCode,
                unit1:detail[0].unit1,
                unit2:detail[0].unit2,
                unit3:detail[0].unit3,
                unit4:detail[0].unit4
            };
            $.when(_DB.searchPreDir(obj.data),_MENU.getRouter(cnf)).done(function (ret,router) {
                router.push({name:detail[0].fileName});//放入文件夹的名称
                cb&&cb({
                    code:1,
                    data:ret,
                    router:router
                })
            }).fail(function (e) {
                cb&&cb({
                    code:-1,
                    error:e
                })
            });
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        });
    };
    /**
     * 根据关键字搜索某本书下的资源列表
     * @param obj = {
     *      method:'searchPreAll',
     *      data:{
     *          userName:''
     *          bookCode:'',
     *          search:'',// 要查找的内容,非空
     *      }
     * }
     * @param cb
     */
    _CALLFun.prototype.searchPreAll = function (obj,cb) {
        _DB.searchPreAll(obj.data).done(function (ret) {
            cb&&cb({
                code:1,
                data:ret
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        });
    };
    /**
     * 根据目录信息插入文件
     * @param obj = {
     *      method:'addPreFile',
     *      data:{
     *          bookCode:'',
     *          userName:'',
     *          path:'' 文件的真实路径 ，例如 D://demo/some.doc
     *          fileName:'',文件的名字 包含后缀  例如 some.doc
     *          uuid:'',如果文件已经在已生成的uuid目录下面，则传此字段，否则，忽略此字段，主要用于下载和导入的区分使用
     *          unit1:'',
     *          unit2:'',
     *          unit3:'',
     *          unit4:'',
     *          parentDir:'',如果是插入在某个文件夹下，则提供这个文件夹的uuid赋值，否则忽略此字段
     *          resId:'',资源的id,
     *          source:'', 来源
     *          type:''    类型
     *      }
     * }
     * @param cb
     */
    _CALLFun.prototype.addPreFile = function (obj,cb) {
        _FILE.checkBook(obj.data.userName,obj.data.bookCode).done(function () {
            var path = obj.data.path.replace(/\\/g,'/').replace('file:///','');
            var fileName = obj.data.fileName;
            obj.data.pathDir = path.substr(0,path.lastIndexOf('/')+1);
            obj.data.fileName = fileName.substr(0,fileName.lastIndexOf('.'));
            obj.data.mime = fileName.substr(fileName.lastIndexOf('.')+1);
            obj.data.mime = obj.data.mime.toLowerCase();
            obj.data.isDir = 0;
            $.when(_COMMON.fileStat(obj.data.path),_DB.getPreNames(obj.data),_COMMON.getMd5(obj.data.path),_DB.getParentName(obj.data))
                .done(function (stat,names,md5,parentName) {
                var nowTime = (new Date()).Format('yyyy-MM-dd hh:mm:ss');
                obj.data.md5 = md5;
                obj.data.createTime = nowTime;
                obj.data.modifyTime = nowTime;
                obj.data.size = stat.size;
                obj.data.isDir = 0;
                obj.data.parentName = parentName;
                var oldName = obj.data.fileName;
                obj.data.fileName = _FILE.checkName(obj.data.fileName,names);
                if(obj.data.parentDir&&obj.data.parentDir!='') _DB.upPreMTime(obj.data.userName,obj.data.parentDir);
                if(obj.data.uuid&&obj.data.uuid!=''){
                    obj.data.path = obj.data.pathDir+obj.data.fileName+'.'+obj.data.mime;
                    if(oldName==obj.data.fileName){
                        _DB.insertPreDb(obj.data,cb);
                    }else {
                        _COMMON.renameFile(stat.path,obj.data.path).done(function () {
                            _DB.insertPreDb(obj.data,cb);
                        })
                    }
                }else {
                    var uuid = _COMMON.guid();
                    obj.data.uuid = uuid;
                    var newPath = BP+obj.data.userName+'/books/'+obj.data.bookCode+'/'+uuid;
                    obj.data.path = newPath+'/'+obj.data.fileName+'.'+obj.data.mime;
                    _COMMON.mkdir(newPath).done(function () {
                        _COMMON.copyFile(stat.path,obj.data.path).done(function () {
                            _DB.insertPreDb(obj.data,cb);
                        }).fail(function (e) {
                            cb&&cb({
                                code:-1,
                                error:e
                            })
                        })
                    })
                }

            });
        });
    };
    /**
     * 新建文件夹
     * @param obj = {
     *      method:'addDir',
     *      data:{
     *          userName:'',
     *          bookCode:'',
     *          unit1:'',
     *          unit2:'',
     *          unit3:'',
     *          unit4:'',
     *          fileName:'' 新建文件夹的命名
     *          source:'',
     *          type:''
     *      }
     * }
     * @param cb
     */
    _CALLFun.prototype.addDir = function (obj,cb) {
        var uuid = _COMMON.guid();
        obj.data.uuid = uuid;
        obj.data.isDir = 1;
        var time = (new Date()).Format('yyyy-MM-dd hh:mm:ss');
        obj.data.modifyTime = time;
        obj.data.createTime = time;
        obj.data.parentDir = '';
        $.when(_DB.getPreNames(obj.data),_DB.getParentName(obj.data)).done(function (names,parentName) {
            obj.data.parentName = parentName;
            obj.data.fileName = _FILE.checkName(obj.data.fileName,names);
            _DB.insertPreDb(obj.data,cb);
        });

    };
    /**
     * 删除文件和文件夹
     * @param obj = {
     *      method:'deletePreFiles',
     *      data:{
     *          userName:'',
     *          bookCode:'',
     *          listDir:['***','***'],文件夹的uuid字符串数组，无的话请使用空数组,
     *          list:['***','***'],文件夹的uuid字符串数组，无的话请使用空数组
     *      }
     * }
     * @param cb
     */
    _CALLFun.prototype.deletePreFiles = function (obj,cb) {
        _DB.deletePreDBArr(obj.data).done(function () {
            cb&&cb({
                code:1,
                message:'success'
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            });
        })
    };
    /**
     * 重命名文件夹
     * @param obj = {
     *      method:'renamePreDir',
     *      data:{
     *          userName:'',
     *          bookCode:'',
     *          unit1:'',//文件夹所在的目录信息
     *          unit2:'',
     *          unit3:'',
     *          unit4:'',
     *          oldName:'',非空字符串
     *          newName:'',非空字符串,
     *          uuid:'',文件夹的uuid
     *      }
     * }
     * @param cb
     */
    _CALLFun.prototype.renamePreDir = function (obj,cb) {
        if(obj.data.newName == obj.data.oldName) {
            cb&&cb({
               code:-2,
               error:'新旧名称相同'
            });
        }
        else {
            _DB.renamePreDir(obj.data).done(function () {
                cb&&cb({
                    code:1,
                    message:'success'
                });
            }).fail(function (e) {
                cb&&cb({
                    code:-1,
                    error:e
                });
            })
        }
    };
    /**
     * 重命名备课本里的文件名称
     * @param obj = {
     *       method:'renamePreFile',
     *       data:{
     *          userName:'',
     *          uuid:'',
     *          newName:''
     *       }
     * }
     * @param cb 结果 code: -1  已有改文件名称
     *                      -2  该文件不存在
     *                      -3 其他错误
     *                      0 success
     */
    _CALLFun.prototype.renamePreFile = function (obj,cb) {
        var data = obj.data;
        var config = {
            userName:data.userName,
            list:data.uuid?[data.uuid]:[]
        };
        _DB.searchPreByUuids(config).done(function (detail) {
            if(!detail.length){
                cb&&cb({
                    code:-2,
                    error:' this file is not exist'
                })
            }else {
                config.unit1 = detail[0].unit1;
                config.unit2 = detail[0].unit2;
                config.unit3 = detail[0].unit3;
                config.unit4 = detail[0].unit4;
                config.parentDir = detail[0].parentDir;
                config.bookCode = detail[0].bookCode;
                config.mime = detail[0].mime;
                config.isDir = 0;

                _DB.getPreNames(config).done(function (names) {
                    if($.inArray(data.newName,names)>=0){
                        cb&&cb({
                            code:-1,
                            error:'this name have existed'
                        })
                    }else {
                        config.fileName = data.newName;
                        config.uuid = data.uuid;
                        var oldPath = BP+config.userName+'/books/'+config.bookCode+'/'+config.uuid+'/'+detail[0].fileName+'.'+config.mime;
                        var newPath = BP+config.userName+'/books/'+config.bookCode+'/'+config.uuid+'/'+config.fileName+'.'+config.mime;
                        $.when(_DB.renamePreDBFileName(config),_COMMON.renameFile(oldPath,newPath)).done(function () {
                            _DB.upPreMTime(data.userName,config.parentDir);
                            cb&&cb({
                                code:1,
                                message:'success'
                            });
                        }).fail(function (e) {
                            cb&&cb({
                                code:-3,
                                error:e
                            })
                        })
                    }
                })
            }
        });
    };
    /**
     * 移动文件和文件夹的位置
     * @param obj = {
     *      method:'movePrePosition',
     *      data:{
     *          userName:'',
     *          bookCode:'',
     *          unit1:'',新的目录信息
     *          unit2:'',
     *          unit3:'',
     *          unit4:''
     *          listDir:['***','***'],文件夹的uuid字符串数组，无的话请使用空数组,
     *          list:['***','***'],文件夹的uuid字符串数组，无的话请使用空数组
     *      }
     * @param cb
     */
    _CALLFun.prototype.movePrePosition = function (obj,cb) {
        var list = obj.data.list,
            listDir = obj.data.listDir,
            arr = [],
            arrDir = [];
        for(var i in list){
            arr.push({
                userName:obj.data.userName,
                bookCode:obj.data.bookCode,
                unit1:obj.data.unit1,
                unit2:obj.data.unit2,
                unit3:obj.data.unit3,
                unit4:obj.data.unit4,
                uuid:list[i]
            });
        }
        for(var k in listDir){
            arrDir.push({
                userName:obj.data.userName,
                bookCode:obj.data.bookCode,
                unit1:obj.data.unit1,
                unit2:obj.data.unit2,
                unit3:obj.data.unit3,
                unit4:obj.data.unit4,
                uuid:listDir[k]
            });
        }
        _DB.upPrePMTime(obj.data.userName,obj.data.list[0]).done(function () {
            global_queue(arr,_DB.movePreSingleFile).done(function () {
                global_queue(arrDir,_DB.movePreSingleDir).done(function () {
                    cb&&cb({
                        code:1,
                        message:'success'
                    });
                }).fail(function (e) {
                    cb&&cb({
                        code:-1,
                        error:e
                    });
                })
            }).fail(function (e) {
                cb&&cb({
                    code:-1,
                    error:e
                });
            });
        });



    };


    /**
     * 根据uuid更新资源MD5值
     * @param obj = {
     *        method:'updatePreMd5',
     *        data:{
     *          userName:'**',
     *          uuid:'***',
     *          md5:'',
     *          modifyTime:'',
     *          size:'',
     *        }
     * }
     * @param cb
     */
    _CALLFun.prototype.updatePreMd5 = function (obj,cb) {
        _DB.upPreMd5(obj.data).done(function (ret,router) {
            cb&&cb({
                code:1,
                data:ret,
                router:router
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        });
    };

    /*----------------------------use for BOOK start--------------------*/
    /**
     * 根据书本目录增加授课文件
     * @param obj = {
     *          method:'addTPFile',
     *          data:{
     *              userName:'',
     *              bookCode:'',
     *              path:'c:/demo/example.doc'文件路径的绝对地址
     *              fileName:'example.doc' 带后缀的文件名称
     *              unit1:'',
     *              unit2:'',
     *              unit3:'',
     *              unit4:'',
     *              uuid:''如果文件已经在已生成的uuid目录下面，则传此字段，否则，忽略此字段，主要用于下载和导入的区分使用
     *              title:'',
     *              pageCode:'',
     *              pageIndex:'',
     *              position:'',格式化的JSON字符串
     *              creator:'',
     *              uploader:'',
     *              description:'',
     *              widgetId:'',
     *              widgetType:'',//方鑫需要 json字符串 2017年2月21日
     *              resId:'',
     *              fid:'',
     *              source:'',
     *              resFrom:'',
     *              reserve1:'', //付年节新增 json字符串 2017年2月21日
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.addTPFile = function (obj,cb) {
        _FILE.checkBook(obj.data.userName,obj.data.bookCode).done(function () {
            var path = obj.data.path.replace('/\\/g','/').replace('file:///','');
            var fileName = path.substr(path.lastIndexOf('/')+1);
            obj.data.pathDir = path.substr(0,path.lastIndexOf('/')+1);
            obj.data.fileName = fileName.substr(0,fileName.lastIndexOf('.'));
            obj.data.extension = fileName.substr(fileName.lastIndexOf('.')+1);
            $.when(_COMMON.fileStat(path),_COMMON.getMd5(path),_DB.getMaxTPSort(obj.data)).done(function (stat,md5,sort) {
                obj.data.md5 = md5;
                obj.data.createTime = stat.ctime;
                obj.data.modifyTime = stat.mtime;
                if (obj.data.sort && !isNaN(Number(obj.data.sort))) {
                    obj.data.sort = Number(obj.data.sort);
                } else {
                    obj.data.sort = sort;
                }
                if(obj.data.uuid&&obj.data.uuid!=''){
                    obj.data.path = obj.data.pathDir+obj.data.fileName+'.'+obj.data.mime;
                    _DB.insertTPFile(obj.data,cb);
                }else {
                    var uuid = _COMMON.guid();
                    obj.data.uuid = uuid;
                    var newPath = BP+obj.data.userName+'/books/'+obj.data.bookCode+'/'+uuid;
                    obj.data.path = newPath+'/'+obj.data.fileName+'.'+obj.data.extension;
                    _COMMON.mkdir(newPath).done(function () {
                        _COMMON.copyFile(stat.path,obj.data.path).done(function () {
                            _DB.insertTPFile(obj.data,cb);
                        })
                    })
                }

            }).fail(function (e) {
                cb&&cb({
                    code:-1,
                    error:e
                });
            });
        });
        
    };
    /**
     * 根据书本目录增加授课包
     * @param obj = {
     *          method:'addMTBKFile',
     *          data:{
     *              userName:'',
     *              bookCode:'',
     *              path:'c:/demo/example.mtbk'文件路径的绝对地址
     *              fileName:'example.mtbk' 带后缀的文件名称
     *              unit1:'',
     *              unit2:'',
     *              unit3:'',
     *              unit4:'',
     *              uuid:''如果文件已经在已生成的uuid目录下面，则传此字段，否则，忽略此字段，主要用于下载和导入的区分使用
     *              title:'',
     *              pageCode:'',
     *              pageIndex:'',
     *              position:'',格式化的JSON字符串
     *              creator:'',
     *              uploader:'',
     *              description:'',
     *              widgetId:'',
     *              widgetType:'',
     *              resId:'',
     *              fid:'',
     *              source:'',
     *              resFrom:''
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.addMTBKFile = function (obj,cb) {
        _FILE.checkBook(obj.data.userName,obj.data.bookCode).done(function () {
            var path = obj.data.path.replace('/\\/g','/').replace('file:///','');
            var fileName = path.substr(path.lastIndexOf('/')+1);
            obj.data.pathDir = path.substr(0,path.lastIndexOf('/')+1);
            obj.data.fileName = fileName.substr(0,fileName.lastIndexOf('.'));
            obj.data.extension = fileName.substr(fileName.lastIndexOf('.')+1);
            $.when(_COMMON.fileStat(path),_COMMON.getMd5(path),_DB.getMTBKNames(obj.data)).done(function (stat,md5,names) {
                obj.data.md5 = md5;
                obj.data.createTime = stat.ctime;
                obj.data.modifyTime = stat.mtime;
                var oldName = obj.data.fileName;
                obj.data.fileName = _FILE.checkName(obj.data.fileName,names);
                if(obj.data.uuid&&obj.data.uuid!=''){
                    obj.data.path = obj.data.pathDir+obj.data.fileName+'.'+obj.data.extension;
                    if(oldName==obj.data.fileName){
                        _DB.insertTPFile(obj.data,cb);
                    }else {
                        _COMMON.renameFile(stat.path,obj.data.path).done(function () {
                            _DB.insertTPFile(obj.data,cb);
                        })
                    }
                }else {
                    var uuid = _COMMON.guid();
                    obj.data.uuid = uuid;
                    var newPath = BP+obj.data.userName+'/books/'+obj.data.bookCode+'/'+uuid;
                    obj.data.path = newPath+'/'+obj.data.fileName+'.'+obj.data.extension;
                    _COMMON.mkdir(newPath).done(function () {
                        _COMMON.copyFile(stat.path,obj.data.path).done(function () {
                            _DB.insertTPFile(obj.data,cb);
                        })
                    })
                }


            }).fail(function (e) {
                cb&&cb({
                    code:-1,
                    error:e
                });
            });
        });
    };
    /**
     * 批量更新授课文件的位置信息
     * @param obj = {
     *          method:'updateTPP',
     *          data:{
     *              userName:'',
     *              list:[{    //JSON数组
     *                  unit1:'', //新的目录
     *                  unit2:'',
     *                  unit3:'',
     *                  unit4:'',
     *                  uuid:'',
     *                  sort:1,  //排序字段
     *                  pageCode:'',
     *                  pageIndex:'',
     *                  position:'',JSON字符串
     *                  widgetId:'',
     *                  widgetType:'',
     *                  resId:'',
     *                  reserve1:''JSON字符串
     *              }]
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.updateTPP = function (obj,cb) {
        var arr = [];
        var list = obj.data.list;
        for(var i=0,len=list.length;i<len;i++){
            arr.push({
                userName:obj.data.userName,
                unit1:list[i].unit1||'',
                unit2:list[i].unit2||'',
                unit3:list[i].unit3||'',
                unit4:list[i].unit4||'',
                pageCode:list[i].pageCode||'',
                pageIndex:list[i].pageIndex||'',
                position:typeof list[i].position == 'string' ? list[i].position : JSON.stringify(list[i].position)||'',
                sort:list[i].sort||'',
                uuid:list[i].uuid,
                widgetId:list[i].widgetId||'',
                widgetType:list[i].widgetType||'',
                resId:list[i].resId||'',
                reserve1:list[i].reserve1||''
            })
        }
        win.global_queue(arr,_DB.updateTPPSingle).done(function () {
            cb&&cb({
                code:1,
                message:'success'
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        })
    };
    /**
     * 批量更新授课文件的名称和描述
     * @param obj = {
     *          method:'updateTPE',
     *          data:{
     *              userName:'',
     *              list:[{    //JSON数组
     *                  title:'',
     *                  description:'',
     *                  uuid:''
     *              }]
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.updateTPE = function (obj,cb) {
        var arr = [];
        var list = obj.data.list;
        for(var i=0,len=list.length;i<len;i++){
            arr.push({
                userName:obj.data.userName,
                title:list[i].title||'',
                description:list[i].description||'',
                uuid:list[i].uuid
            })
        }
        win.global_queue(arr,_DB.updateTPESingle).done(function () {
            cb&&cb({
                code:1,
                message:'success'
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        })
    };
    /**
     * 批量更新授课文件的名称、描述和资源Id,资源resFrom
     * @param obj = {
     *          method:'updateTPER',
     *          data:{
     *              userName:'',
     *              list:[{    //JSON数组
     *                  title:'',
     *                  description:'',
     *                  uuid:'',
     *                  resId:'',
     *                  resFrom:''
     *              }]
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.updateTPER = function (obj,cb) {
        var arr = [];
        var list = obj.data.list;
        for(var i=0,len=list.length;i<len;i++){
            arr.push({
                userName:obj.data.userName,
                title:list[i].title||'',
                description:list[i].description||'',
                uuid:list[i].uuid,
                resId:list[i].resId||'',
                resFrom:list[i].resFrom||''
            })
        }
        win.global_queue(arr,_DB.updateTPERSingle).done(function () {
            cb&&cb({
                code:1,
                message:'success'
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        })
    };
    /**
     * 根据uuid批量删除授课文件和授课包
     * @param obj = {
     *          method:'deleteTPUuids',
     *          data:{
     *              userName:'',
     *              bookCode:'',
     *              list:['****','*****']  uuid的字符串数组
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.deleteTPUuids = function (obj,cb) {
        var arr = [];
        var list = obj.data.list;
        for(var i=0,len=list.length;i<len;i++){
            arr.push({
                userName:obj.data.userName,
                bookCode:obj.data.bookCode,
                uuid:list[i]
            });
        }
        win.global_queue(arr,_DB.deleteTPbyUUid).done(function () {
            cb&&cb({
                code:1,
                message:'success'
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        })
    };
    /**
     * 根据unit批量删除授课文件和授课包
     * @param obj = {
     *          method:'deleteTPUnit',
     *          data:{
     *              userName:'',
     *              bookCode:'',
     *              unit1:'',
     *              unit2:'',
     *              unit3:'',
     *              unit4:'',
     *              mtbk:true or false BOOL值  用于表明是否为mtbk文件
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.deleteTPUnit = function (obj,cb) {
        _DB.getTPByUnit(obj.data).done(function (list) {
            var arr = [];
            for(var i=0,len=list.length;i<len;i++){
                arr.push({
                    userName:obj.data.userName,
                    bookCode:obj.data.bookCode,
                    uuid:list[i].uuid
                });
            }
            win.global_queue(arr,_DB.deleteTPbyUUid).done(function () {
                cb&&cb({
                    code:1,
                    message:'success'
                })
            }).fail(function (e) {
                cb&&cb({
                    code:-1,
                    error:e
                })
            })

        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        })
    };
    /**
     * 根据unit查询授课文件和授课包
     * @param obj = {
     *          method:'getTPUnit',
     *          data:{
     *              userName:'',
     *              bookCode:'',
     *              unit1:'',
     *              unit2:'',
     *              unit3:'',
     *              unit4:'',
     *              mtbk:true or false BOOL值  用于表明是否为mtbk文件
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.getTPUnit = function (obj,cb) {
        _DB.getTPByUnit(obj.data).done(function (list) {
            cb&&cb({
                code:1,
                data:list
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        })
    };
    /**
     * 根据pageIndex查询授课文件和授课包
     * @param obj = {
     *          method:'getTPIndex',
     *          data:{
     *              userName:'',
     *              bookCode:'',
     *              pageIndex:[],//字符串数组
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.getTPIndex = function (obj,cb) {
        _DB.getTPByPageIndex(obj.data).done(function (list) {
            cb&&cb({
                code:1,
                data:list
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        })
    };
    /**
     * 根据bookCode批量获取授课文件和授课包
     * @param obj = {
     *          method:'getTPBook',
     *          data:{
     *              userName:'',
     *              bookCode:'',
     *              mtbk:true or false BOOL值  用于表明是否为mtbk文件
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.getTPBook = function (obj,cb) {
        _DB.getTPByBookCode(obj.data).done(function (list) {
            cb&&cb({
                code:1,
                data:list
            })
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        })
    };
    /**
     * 根据bookCode批量删除授课文件和授课包
     * @param obj = {
     *          method:'deleteTPBook',
     *          data:{
     *              userName:'',
     *              bookCode:'',
     *              mtbk:true or false BOOL值  用于表明是否为mtbk文件
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.deleteTPBook = function (obj,cb) {
        _DB.getTPByBookCode(obj.data).done(function (list) {
            _DB.deleteTPDBByBookCode(obj.data).done(function () {
                cb&&cb({
                    code:1,
                    message:'success'
                });
                for(var i=0,len=list.length;i<len;i++){
                    _FILE.deleteFolder(obj.data.userName,obj.data.bookCode,list[i].uuid);
                }
            }).fail(function (e) {
                cb&&cb({
                    code:-1,
                    error:e
                })
            });

        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        })
    };
    /**
     * 根据pageIndex批量删除授课文件
     * @param obj = {
     *          method:'deleteTPIndex',
     *          data:{
     *              userName:'',
     *              bookCode:'',
     *              pageIndex:[],//字符串数组
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.deleteTPIndex = function (obj,cb) {
        _DB.getTPByPageIndex(obj.data).done(function (list) {
            var arr = [];
            for(var i=0,len=list.length;i<len;i++){
                arr.push(list[i].uuid);
            }
            _DB.deleteTPDBByPageIndex(obj.data).done(function () {
                cb&&cb({
                    code:1,
                    message:'success'
                });
                _FILE.deleteFolderBat(obj.data.userName,obj.data.bookCode,arr);
            }).fail(function (e) {
                cb&&cb({
                    code:-1,
                    error:e
                });
            });

        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            })
        })
    }
    /**
     * mtbk导出
     * @param obj = {
     *          method:'exportMtbk',
     *          data:{
     *              userName:'',
     *              bookCode:'',
     *              dbfiles:[],//导出的数据集合
     *              fileName //导出的mtbk名称，不加后缀
     *          }
     * }
     * @param cb
     */
     _CALLFun.prototype.exportMtbk = function(obj,cb){
        var data = $.extend({},obj.data);
        _ExportMtbk.initExport(data.userName,data.bookCode,data.dbfiles,data.fileName,data.path).done(function(ret){
            cb && cb({code:1,data:ret});
        }).fail(function(e){
            cb && cb({code:-1,error:e});
        });
     }
    /**
     * 批量更新授课包TP的MD5
     * @param obj = {
     *          method:'updateTPMd5',
     *          data:{
     *              userName:'',
     *              list:[{
     *                 uuid:'',
     *                 md5:''
     *              }],//对象数组
     *          }
     * }
     * @param cb
     */
    _CALLFun.prototype.updateTPMd5 = function (obj,cb) {
        var arr=[];
        for(var i=0,len=obj.data.list.length;i<len;i++){
            arr.push({
                userName:obj.data.userName,
                uuid:obj.data.list[i].uuid,
                md5:obj.data.list[i].md5
            })
        }
        global_queue(arr,_DB.updateTPMd5).done(function () {
            cb&&cb({
                code:1,
                message:'success'
            });
        }).fail(function (e) {
            cb&&cb({
                code:-1,
                error:e
            });
        })

    }

})(window);

