// ==UserScript==
// @name         自动隐藏b站视频内内嵌三连窗口
// @namespace    kuubee
// @version      0.1.2
// @description  自动隐藏bilibili视频内内嵌三连窗口
// @author       kuubee
// @include      *://www.bilibili.com/video/av*
// @include      *://www.bilibili.com/video/BV*
// @include      *://www.bilibili.com/medialist/play/watchlater/*
// @run-at       document-body
// @grant        none
// ==/UserScript==

(function () {
  "use strict";
  window.onload = () => {
    const timer = setInterval(() => {
      main();
    }, 100);
    function main() {
      // 视频根
      const watchRootDom = document.querySelector("#bilibili-player");
      // 弹出层
      const watchPopupDom = document.querySelector(
        ".bilibili-player-video-popup"
      );
      if (!watchRootDom || !watchPopupDom) return;
      if (timer) clearInterval(timer);
      const rootObs = new MutationObserver(rootCallback);
      const popupObs = new MutationObserver(popupCallback);
      function startRootObs() {
        rootObs.observe(watchRootDom, {
          childList: true,
          attributes: false,
          subtree: false
        });
      }
      function startPopupObs(target = watchPopupDom) {
        popupObs.observe(target, {
          childList: true,
          attributes: true,
          subtree: true
        });
      }
      function restartPopupObs() {
        const watchPopupDom = document.querySelector(
          ".bilibili-player-video-popup"
        );
        if (!watchPopupDom) {
          setTimeout(() => {
            restartPopupObs();
          }, 100);
        }
        startPopupObs(watchPopupDom);
      }
      function rootCallback() {
        // 每当视频根切换时
        // 重启弹出层监听
        popupObs.disconnect();
        restartPopupObs();
      }
      function popupCallback(mutations, _observer) {
        if (!mutations[0]) return;
        const targetDom = mutations[0].target;
        targetDom.style.display = "none";
      }
      startRootObs();
      startPopupObs();
      console.log("注入成功");
    }
  };
})();
