/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.opensoundcontrol.OscAddressSpace;
import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscMethod;
import com.bitwig.extension.api.opensoundcontrol.OscModule;
import com.bitwig.extension.controller.api.Application;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.ClipLauncherSlot;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.extension.controller.api.Transport;
import java.io.IOException;

public class mja {
    private final OscAddressSpace CwM;
    private final ControllerHost Opd;
    private final Transport OqD;
    private final OscConnection m2i;
    private final MasterTrack hFR;
    private final TrackBank LTX;
    private final TrackBank uwB;
    private final Application dhb;
    private final Clip aMy;
    private final Clip alk;
    private final CursorTrack EuM;

    public mja(ControllerHost controllerHost) {
        this.Opd = controllerHost;
        this.dhb = controllerHost.createApplication();
        this.OqD = controllerHost.createTransport();
        this.OqD.tempo().markInterested();
        this.OqD.isMetronomeEnabled().markInterested();
        this.OqD.isMetronomeEnabled().addValueObserver(this::CwM);
        this.OqD.isPlaying().markInterested();
        this.OqD.isPlaying().addValueObserver(this::Opd);
        this.OqD.isArrangerRecordEnabled().markInterested();
        this.OqD.isArrangerRecordEnabled().addValueObserver(this::OqD);
        this.OqD.isClipLauncherOverdubEnabled().markInterested();
        this.OqD.isClipLauncherOverdubEnabled().addValueObserver(this::m2i);
        this.OqD.isClipLauncherAutomationWriteEnabled().markInterested();
        this.OqD.isClipLauncherAutomationWriteEnabled().addValueObserver(this::hFR);
        this.OqD.isArrangerLoopEnabled().markInterested();
        this.OqD.isArrangerLoopEnabled().addValueObserver(this::LTX);
        this.EuM = this.Opd.createCursorTrack(0, 0);
        this.EuM.position().addValueObserver(n2 -> this.hFR());
        this.EuM.trackType().markInterested();
        this.hFR = this.Opd.createMasterTrack(100);
        this.LTX = this.Opd.createMainTrackBank(100, 20, 100);
        this.uwB = this.Opd.createEffectTrackBank(20, 100);
        this.LTX.itemCount().markInterested();
        this.LTX.sceneBank().itemCount().markInterested();
        this.uwB.itemCount().markInterested();
        for (int i2 = 0; i2 < this.LTX.getSizeOfBank(); ++i2) {
            int n3 = i2;
            Track track = (Track)this.LTX.getItemAt(i2);
            track.trackType().markInterested();
            track.mute().addValueObserver(bl2 -> this.CwM(track, n3));
            track.arm().addValueObserver(bl2 -> this.Opd(track, n3));
            track.solo().addValueObserver(bl2 -> this.OqD(track, n3));
            track.volume().value().addValueObserver(d2 -> this.m2i(track, n3));
            track.pan().value().addValueObserver(d2 -> this.hFR(track, n3));
        }
        this.aMy = this.Opd.createArrangerCursorClip(1, 1);
        this.alk = this.Opd.createLauncherCursorClip(1, 1);
        OscModule oscModule = this.Opd.getOscModule();
        this.CwM = oscModule.createAddressSpace();
        this.CwM.registerObjectMethods("/dawctrl", this);
        this.m2i = oscModule.connectToUdpServer("localhost", 7577, this.CwM);
        oscModule.createUdpServer(7578, this.CwM);
    }

    public void CwM() {
        this.uwB();
    }

    private int CwM(Track track) {
        String string;
        switch (string = track.trackType().get()) {
            case "Group": {
                return 3;
            }
            case "Instrument": {
                return 2;
            }
            case "Audio": {
                return 1;
            }
            case "Hybrid": {
                return 0;
            }
            case "Effect": {
                return 4;
            }
            case "Master": {
                return 5;
            }
        }
        return 0;
    }

    private void CwM(String string, Object ... objectArray) {
        try {
            this.m2i.sendMessage(string, objectArray);
        }
        catch (IOException iOException) {
            this.Opd.println("Error while sending OSC message to: " + string + "\n" + iOException.getMessage() + "\n");
        }
    }

    private void Opd() {
        this.m2i();
        this.hFR();
        this.LTX();
        this.m2i(this.hFR, 0);
        this.hFR(this.hFR, 0);
        this.hFR(this.OqD.isClipLauncherAutomationWriteEnabled().get());
        this.LTX(this.OqD.isArrangerLoopEnabled().get());
        this.CwM(this.OqD.isMetronomeEnabled().get());
    }

    private void OqD() {
        this.CwM("/dawctrl/pong", new Object[0]);
    }

    private void CwM(boolean bl2) {
        this.CwM("/dawctrl/metronome", bl2 ? 1 : 0);
    }

    private void Opd(boolean bl2) {
        this.CwM("/dawctrl/play", bl2 ? 1 : 0);
    }

    private void OqD(boolean bl2) {
        this.CwM("/dawctrl/record", bl2 ? 1 : 0);
    }

    private void m2i(boolean bl2) {
        this.CwM("/dawctrl/session_record", bl2 ? 1 : 0);
    }

    private void hFR(boolean bl2) {
        this.CwM("/dawctrl/session_automation_record", bl2 ? 1 : 0);
    }

    private void LTX(boolean bl2) {
        this.CwM("/dawctrl/loop", bl2 ? 1 : 0);
    }

    private void m2i() {
        this.CwM("/dawctrl/size", this.LTX.itemCount().get(), this.LTX.sceneBank().itemCount().get(), this.uwB.itemCount().get());
    }

    private void hFR() {
        int n2 = this.EuM.position().get();
        int n3 = this.CwM(this.EuM);
        this.CwM("/dawctrl/track", n3, n2, "");
    }

    private void LTX() {
        this.CwM("/dawctrl/scene", 0, "");
    }

    private void CwM(Track track, int n2) {
        int n3 = this.CwM(track);
        boolean bl2 = track.mute().get();
        this.CwM("/dawctrl/track/mute", n3, n2, bl2 ? 1 : 0);
    }

    private void Opd(Track track, int n2) {
        int n3 = this.CwM(track);
        boolean bl2 = track.arm().get();
        this.CwM("/dawctrl/track/arm", n3, n2, bl2 ? 1 : 0);
    }

    private void OqD(Track track, int n2) {
        int n3 = this.CwM(track);
        boolean bl2 = track.solo().get();
        this.CwM("/dawctrl/track/solo", n3, n2, bl2 ? 1 : 0);
    }

    private void m2i(Track track, int n2) {
        int n3 = this.CwM(track);
        float f4 = (float)track.volume().get();
        this.CwM("/dawctrl/track/solo", n3, n2, Float.valueOf(f4));
    }

    private void hFR(Track track, int n2) {
        int n3 = this.CwM(track);
        float f4 = (float)track.pan().get();
        this.CwM("/dawctrl/track/pan", n3, n2, Float.valueOf(f4));
    }

    private void uwB() {
        this.CwM("/dawctrl/shutdown", new Object[0]);
    }

    @OscMethod(address="/init")
    public void handleInit() {
        this.Opd();
    }

    @OscMethod(address="/ping")
    public void handlePing() {
        this.OqD();
    }

    @OscMethod(address="/stop/all_clips")
    public void handleStopAllClips() {
        this.hFR.stop();
    }

    @OscMethod(address="/stop/track")
    public void handleStopTrack(int n2) {
        this.LTX.getChannel(n2).stop();
    }

    @OscMethod(address="/play/scene")
    public void handlePlayScene(int n2) {
        ((ClipLauncherSlot)this.hFR.clipLauncherSlotBank().getItemAt(n2)).launch();
    }

    @OscMethod(address="/play/clip")
    public void handlePlayClip(int n2, int n3) {
        ((ClipLauncherSlot)this.LTX.getChannel(n2).clipLauncherSlotBank().getItemAt(n3)).launch();
    }

    @OscMethod(address="/stop/clip")
    public void handleStopClip(int n2, int n3) {
        this.LTX.getChannel(n2).stop();
    }

    @OscMethod(address="/undo")
    public void handleUndo() {
        this.dhb.undo();
    }

    @OscMethod(address="/redo")
    public void handleRedo() {
        this.dhb.redo();
    }

    @OscMethod(address="/loop")
    public void handleLoop(int n2) {
        this.OqD.isArrangerLoopEnabled().set(n2 != 0);
    }

    @OscMethod(address="/play")
    public void handlePlay() {
        this.OqD.play();
    }

    @OscMethod(address="/record")
    public void handleRecord(int n2) {
        this.OqD.isArrangerRecordEnabled().set(n2 != 0);
    }

    @OscMethod(address="/session_record")
    public void handleSessionRecord(int n2) {
        this.OqD.isClipLauncherOverdubEnabled().set(n2 != 0);
        this.OqD.isClipLauncherAutomationWriteEnabled().set(n2 != 0);
    }

    @OscMethod(address="/metronome")
    public void handleMetronome(int n2) {
        this.OqD.isMetronomeEnabled().set(n2 != 0);
    }

    @OscMethod(address="/stop")
    public void handleStop() {
        this.OqD.stop();
    }

    @OscMethod(address="/scrub")
    public void handleScrub(float f4) {
    }

    @OscMethod(address="/automation")
    public void handleAutomation(int n2) {
        this.OqD.isArrangerAutomationWriteEnabled().set(n2 != 0);
    }

    private Track CwM(int n2, int n3) {
        switch (n2) {
            case 0: {
                return this.LTX.getChannel(n3);
            }
            case 1: {
                return this.LTX.getChannel(n3);
            }
            case 2: {
                return this.LTX.getChannel(n3);
            }
            case 3: {
                return this.LTX.getChannel(n3);
            }
            case 4: {
                return this.uwB.getChannel(n3);
            }
            case 5: {
                return this.hFR;
            }
            case 6: {
                return this.LTX.getChannel(n3);
            }
        }
        this.Opd.println("Received invalid track type: " + n2);
        return null;
    }

    @OscMethod(address="/track/arm")
    public void handleTrackArm(int n2, int n3, int n4) {
        this.CwM(n2, n3).getArm().set(n4 != 0);
    }

    @OscMethod(address="/track/mute")
    public void handleTrackMute(int n2, int n3, int n4) {
        this.CwM(n2, n3).getMute().set(n4 != 0);
    }

    @OscMethod(address="/track/solo")
    public void handleTrackSolo(int n2, int n3, int n4) {
        this.CwM(n2, n3).getSolo().set(n4 != 0);
    }

    @OscMethod(address="/track/volume")
    public void handleTrackVolume(int n2, int n3, float f4) {
        this.CwM(n2, n3).getVolume().set(f4);
    }

    @OscMethod(address="/track/pan")
    public void handleTrackPan(int n2, int n3, float f4) {
        this.CwM(n2, n3).getPan().set(f4);
    }

    @OscMethod(address="/tap_tempo")
    public void handleTapTempo() {
        this.OqD.tapTempo();
    }

    @OscMethod(address="/clip/quantize")
    public void handleClipQuantize() {
        this.aMy.quantize(1.0);
        this.alk.quantize(1.0);
    }

    @OscMethod(address="/scene/view")
    public void handleSceneView() {
    }

    @OscMethod(address="/track/view")
    public void handleTrackView() {
    }

    @OscMethod(address="/midi_arm_exclusive")
    public void handleMidiArmExclusive() {
        this.EuM.getArm().set(true);
    }

    @OscMethod(address="/track/info")
    public void handleTrackInfo() {
    }
}

