/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.MidiOut;
import com.bitwig.extension.controller.api.NoteInput;

public class int
extends ControllerExtension {
    private NoteInput CwM;
    private int Opd;
    private int OqD;
    private int m2i;
    private int hFR;
    private boolean LTX;
    private int uwB;
    private int dhb;
    private int aMy;
    private double alk;

    public int(gIR gIR2, ControllerHost controllerHost) {
        super(gIR2, controllerHost);
    }

    @Override
    public void init() {
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        MidiIn midiIn = controllerHost.getMidiInPort(1);
        this.CwM = midiIn.createNoteInput("Notes", new String[0]);
        MidiIn midiIn2 = controllerHost.getMidiInPort(0);
        midiIn2.setMidiCallback(this::CwM);
        MidiOut midiOut = this.getMidiOutPort(0);
        controllerHost.scheduleTask(this::CwM, this.Opd());
    }

    void CwM() {
        double d2 = (double)this.m2i * 6.103888176768602E-5;
        double d3 = 4096.0;
        double d4 = Math.max(-4096.0, Math.min(4096.0, (double)(8192 - this.Opd)));
        double d5 = (double)(this.OqD - 8192) + d4;
        double d6 = 2000.0 + d2 * 5000.0;
        this.alk = Math.max(this.alk - d6, Math.min(this.alk + d6, this.LTX ? d5 : 0.0));
        int n2 = (int)Math.abs(d5);
        this.Opd = Math.max(this.Opd - n2, Math.min(this.Opd + n2, 8192));
        int n3 = Math.max(0, Math.min(16383, (int)this.alk + 8192));
        if (n3 != this.uwB) {
            this.CwM.sendRawMidiEvent(224, n3 & 0x7F, n3 >> 7);
        }
        if (this.m2i >> 7 != this.dhb) {
            this.CwM.sendRawMidiEvent(176, 2, this.m2i >> 7);
        }
        if (this.hFR >> 7 != this.aMy) {
            this.CwM.sendRawMidiEvent(176, 1, this.hFR >> 7);
        }
        ((ControllerHost)this.getHost()).scheduleTask(this::CwM, this.Opd());
        this.uwB = n3;
        this.dhb = this.m2i >> 7;
        this.aMy = this.hFR >> 7;
    }

    private long Opd() {
        return 10L;
    }

    private void CwM(int n2, int n3, int n4) {
        if (n2 == 144) {
            this.Opd = -1;
            this.LTX = true;
        } else if (n2 == 128) {
            this.LTX = false;
        } else if (n2 == 224) {
            this.OqD = n4 << 7 | n3;
            if (this.Opd == -1) {
                this.Opd = this.OqD;
            }
        } else if (n2 == 176 && n3 == 1) {
            this.m2i = this.m2i & 0x7F | n4 << 7;
        } else if (n2 == 176 && n3 == 33) {
            this.m2i = this.m2i & 0x3F80 | n4;
        } else if (n2 == 176 && n3 == 2) {
            this.hFR = this.hFR & 0x7F | n4 << 7;
        } else if (n2 == 176 && n3 == 34) {
            this.hFR = this.hFR & 0x3F80 | n4;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void exit() {
    }
}

