/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.win32_windowing_system;

import com.bitwig.base.geom.pNN;
import com.bitwig.win32_windowing_system.Win32Display;
import com.bitwig.win32_windowing_system.Win32TopLevelWindowHandle;
import com.bitwig.windowing_system.HkC;
import com.bitwig.windowing_system.TQn;
import java.util.Objects;

class Win32TextInputSession
implements TQn {
    private final Win32Display mDisplay;
    private final HkC mTextInputTarget;
    private final Win32TopLevelWindowHandle mWindowHandle;
    private int mImmWindowX;
    private int mImmWindowY;
    private char mHighSurrogate = '\u0000';
    private dnS mScanCodesToIgnoreForKeyUpEvents = new dnu(3);
    private String mCompositionText;
    private int mCompositionCursorPos;
    private int mCompositionReplaceStart;
    private int mCompositionReplaceLength;
    private String mLastSentCompositionText;
    private int mLastSentCompositionCursorPos;
    private int mLastSentCompositionReplaceStart;
    private int mLastSentCompositionReplacLength;
    private boolean mHasScheduledUpdateToImmWindowPos;
    private boolean mIsImmWindowPositionValid;

    public Win32TextInputSession(Win32Display win32Display, HkC hkC) {
        assert (bCM.Opd(win32Display.khV()));
        this.mDisplay = win32Display;
        this.mTextInputTarget = hkC;
        this.mWindowHandle = (Win32TopLevelWindowHandle)hkC.CwM();
    }

    @Override
    public HkC getTextInputTarget() {
        return this.mTextInputTarget;
    }

    public Win32TopLevelWindowHandle getWindowHandle() {
        return this.mWindowHandle;
    }

    @Override
    public void cursorPositionChanged() {
        assert (bCM.Opd(this.mDisplay.khV()));
        this.invalidateImmWindowPosition();
    }

    @Override
    public void areaOnScreenChanged() {
        assert (bCM.Opd(this.mDisplay.khV()));
        this.invalidateImmWindowPosition();
    }

    @Override
    public void cancelComposition() {
        assert (bCM.Opd(this.mDisplay.khV()));
        assert (bCM.Opd(this.isActive()));
        this.mDisplay.CwM(this::cancelCompositionOnNativeThread);
    }

    void cancelCompositionOnNativeThread() {
        assert (bCM.Opd(this.mDisplay.Opd()));
        if (this.isComposing()) {
            long l2 = this.mWindowHandle.Opd();
            assert (bCM.Opd(l2 != 0L));
            if (l2 != 0L) {
                Win32Display.cancelComposition(l2);
            }
        }
        assert (bCM.Opd(!this.isComposing()));
    }

    private void invalidateImmWindowPosition() {
        assert (bCM.Opd(this.mDisplay.khV()));
        if (!this.mHasScheduledUpdateToImmWindowPos) {
            this.mHasScheduledUpdateToImmWindowPos = true;
            this.mDisplay.OqD(() -> {
                this.mHasScheduledUpdateToImmWindowPos = false;
                if (this.isActive()) {
                    this.updateImmWindowPosition();
                }
            });
        }
    }

    void updateImmWindowPosition() {
        assert (bCM.Opd(this.mDisplay.khV()));
        int n2 = this.mTextInputTarget.Opd() ? this.mTextInputTarget.OqD().getOffset() : this.mTextInputTarget.m2i();
        pNN pNN2 = this.mTextInputTarget.CwM(n2);
        int n3 = (int)(pNN2.OqD() - (long)this.mWindowHandle.dhb());
        int n4 = (int)(pNN2.m2i() + pNN2.LTX() - (long)this.mWindowHandle.uwB());
        if (!this.mIsImmWindowPositionValid || n3 != this.mImmWindowX || n4 != this.mImmWindowY) {
            this.mImmWindowX = n3;
            this.mImmWindowY = n4;
            this.mIsImmWindowPositionValid = true;
            this.mDisplay.CwM(() -> {
                assert (bCM.Opd(this.mDisplay.Opd()));
                assert (bCM.Opd(this.mDisplay.UHd() == this));
                if (this.mDisplay.UHd() != this) {
                    return;
                }
                long l2 = this.mWindowHandle.Opd();
                assert (bCM.Opd(l2 != 0L));
                if (l2 != 0L) {
                    if (bCM.m2i.Opd()) {
                        bCM.m2i.CwM("setImmWindowPosition(" + n3 + ", " + n4 + ")");
                    }
                    this.mDisplay.setImmWindowPosition(l2, n3 - 1, n4);
                    this.mDisplay.setImmWindowPosition(l2, n3, n4);
                }
            });
        }
    }

    private void insertChar(char c3) {
        String string;
        boolean bl2;
        assert (bCM.Opd(this.mDisplay.Opd()));
        assert (bCM.Opd(c3 != '\u0000'));
        assert (bCM.Opd(Character.isDefined(c3)));
        boolean bl3 = c3 == '\u200d';
        boolean bl4 = bl2 = c3 >= '\ufe00' && c3 <= '\ufe0f';
        if (c3 == '\u0000' || !Character.isDefined(c3) || bl3 || bl2) {
            this.mHighSurrogate = '\u0000';
            return;
        }
        if (Character.isHighSurrogate(c3)) {
            assert (bCM.Opd(this.mHighSurrogate == '\u0000'));
            this.mHighSurrogate = c3;
            return;
        }
        if (this.mHighSurrogate != '\u0000') {
            assert (bCM.Opd(Character.isLowSurrogate(c3)));
            char c4 = this.mHighSurrogate;
            this.mHighSurrogate = '\u0000';
            string = Character.isLowSurrogate(c3) ? String.valueOf(new char[]{c4, c3}) : String.valueOf(c3);
        } else {
            if (Character.isLowSurrogate(c3)) {
                return;
            }
            string = String.valueOf(c3);
        }
        if (!string.isEmpty()) {
            bCM.m2i.CwM("insertChar(" + string + ")");
            this.mDisplay.OqD(() -> {
                if (this.isActive()) {
                    this.mTextInputTarget.CwM(string);
                }
            });
        }
    }

    private void insertText(String string) {
        assert (bCM.Opd(this.mDisplay.Opd()));
        bCM.m2i.CwM("insertText(" + string + ")");
        this.mCompositionText = null;
        this.mLastSentCompositionText = null;
        this.mDisplay.OqD(() -> {
            if (this.isActive()) {
                this.mTextInputTarget.CwM(string);
            }
        });
        assert (bCM.Opd(!this.isComposing()));
    }

    boolean isComposing() {
        assert (bCM.Opd(this.mDisplay.Opd()));
        return this.mCompositionText != null;
    }

    private void conversionModeChanged() {
        assert (bCM.Opd(this.mDisplay.Opd()));
        bCM.m2i.CwM("conversionModeChanged");
    }

    private void startComposition() {
        assert (bCM.Opd(this.mDisplay.Opd()));
        assert (bCM.Opd(!this.isComposing()));
        bCM.m2i.CwM("startComposition");
        this.mCompositionText = "";
        assert (bCM.Opd(this.isComposing()));
    }

    private void setCompositionText(String string) {
        assert (bCM.Opd(this.mDisplay.Opd()));
        bCM.m2i.CwM("setCompositionText(" + string + ")");
        this.mCompositionText = string;
        assert (bCM.Opd(this.isComposing()));
    }

    private void setCompositionCursorPosition(int n2) {
        assert (bCM.Opd(this.mDisplay.Opd()));
        assert (bCM.Opd(n2 >= 0));
        bCM.m2i.CwM("setCompositionCursorPosition(" + n2 + ")");
        this.mCompositionCursorPos = n2;
    }

    private void setCompositionReplaceRange(int n2, int n3) {
        assert (bCM.Opd(this.mDisplay.Opd()));
        assert (bCM.Opd(n2 >= 0));
        assert (bCM.Opd(n3 >= 0));
        bCM.m2i.CwM("setCompositionReplaceRange(" + n2 + ", " + n3 + ")");
        this.mCompositionReplaceStart = n2;
        this.mCompositionReplaceLength = n3;
    }

    private void endComposition() {
        assert (bCM.Opd(this.mDisplay.Opd()));
        bCM.m2i.CwM("endComposition");
        this.mCompositionText = null;
        this.sendCompositionState();
        assert (bCM.Opd(!this.isComposing()));
    }

    private void sendCompositionState() {
        assert (bCM.Opd(this.mDisplay.Opd()));
        bCM.m2i.CwM("sendCompositionState");
        if (!Objects.equals(this.mLastSentCompositionText, this.mCompositionText) || this.mLastSentCompositionCursorPos != this.mCompositionCursorPos || this.mLastSentCompositionReplaceStart != this.mCompositionReplaceLength || this.mLastSentCompositionReplacLength != this.mCompositionReplaceLength) {
            if (this.mCompositionText != null) {
                String string = this.mCompositionText;
                int n2 = (int)string.codePoints().count();
                assert (bCM.Opd(this.mCompositionCursorPos >= 0 && this.mCompositionCursorPos <= n2));
                assert (bCM.Opd(this.mCompositionReplaceStart >= 0 && this.mCompositionReplaceStart <= n2));
                assert (bCM.Opd(this.mCompositionReplaceLength >= 0));
                assert (bCM.Opd(this.mCompositionReplaceLength + this.mCompositionReplaceStart <= n2));
                int n3 = f2f.CwM(this.mCompositionCursorPos, 0, n2);
                int n4 = f2f.CwM(this.mCompositionReplaceStart, 0, n2);
                int n5 = f2f.CwM(this.mCompositionReplaceLength, 0, n2 - n4);
                if (bCM.m2i.Opd()) {
                    bCM.m2i.CwM("setCompositionText(" + string + ", " + n3 + ", " + n4 + ", " + n5 + ")");
                }
                this.mDisplay.OqD(() -> {
                    if (this.isActive()) {
                        this.mTextInputTarget.CwM(string, n3, n4, n5);
                        this.mIsImmWindowPositionValid = false;
                        this.invalidateImmWindowPosition();
                    }
                });
            } else if (this.mLastSentCompositionText != null) {
                bCM.m2i.CwM("deleteCompositionText");
                this.mDisplay.OqD(() -> {
                    if (this.isActive()) {
                        this.mTextInputTarget.hFR();
                    }
                });
            }
            this.mLastSentCompositionText = this.mCompositionText;
            this.mLastSentCompositionCursorPos = this.mCompositionCursorPos;
            this.mLastSentCompositionReplaceStart = this.mCompositionReplaceStart;
            this.mLastSentCompositionReplacLength = this.mCompositionReplaceLength;
        }
    }

    private boolean isActive() {
        assert (bCM.Opd(this.mDisplay.khV()));
        return this.mDisplay.eSp() == this;
    }

    public void ignoreNextKeyUpEventForScanCode(int n2) {
        assert (bCM.Opd(this.mDisplay.Opd()));
        this.mScanCodesToIgnoreForKeyUpEvents.m2i(n2);
    }

    public boolean shouldIgnoreKeyUpEventForScanCode(int n2) {
        assert (bCM.Opd(this.mDisplay.Opd()));
        boolean bl2 = this.mScanCodesToIgnoreForKeyUpEvents.LTX(n2);
        return bl2;
    }
}

