/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.win32_windowing_system;

import com.bitwig.base.geom.VOl;
import com.bitwig.graphics.Hub;
import com.bitwig.graphics.LHZ;
import com.bitwig.win32_windowing_system.Win32DIBSectionMemoryBlock;
import com.bitwig.win32_windowing_system.Win32TopLevelWindowHandle;
import com.bitwig.win32_windowing_system.qrx;
import com.bitwig.win32_windowing_system.vWk;
import java.util.List;

class Win32DoubleBuffer
extends qrx {
    private final long dhb;
    private final vWk aMy;
    private final Win32DIBSectionMemoryBlock alk;

    public Win32DoubleBuffer(Win32TopLevelWindowHandle win32TopLevelWindowHandle) {
        super(win32TopLevelWindowHandle);
        long l2 = win32TopLevelWindowHandle.Opd();
        this.alk = Win32DIBSectionMemoryBlock.CwM(l2, this.Opd, this.OqD);
        this.dhb = this.alk.hFR();
        this.aMy = new vWk(this.alk.m2i(), win32TopLevelWindowHandle.Xb, this.Opd, this.OqD, win32TopLevelWindowHandle.LTX() ? LHZ.CwM : LHZ.Opd, false);
    }

    @Override
    public void m2i() {
        this.aMy.m2i();
        this.alk.OqD();
    }

    @Override
    public Hub Opd() {
        return this.aMy.CwM();
    }

    @Override
    public void CwM(List list, boolean bl2) {
        assert (bCM.CwM(!list.isEmpty()));
        if (this.CwM.LTX()) {
            Win32DoubleBuffer.blitToScreenWithAlphaNative(this.dhb, this.CwM.Opd(), 0, 0, this.CwM.jz_(), this.CwM.jy_());
        } else {
            int[] nArray = new int[4 * list.size()];
            int n2 = 0;
            for (VOl vOl : list) {
                assert (bCM.CwM(vOl != null));
                assert (bCM.Opd(!vOl.Opd()));
                nArray[n2 * 4] = vOl.Uft();
                nArray[n2 * 4 + 1] = vOl.pqS();
                nArray[n2 * 4 + 2] = vOl.fn();
                nArray[n2 * 4 + 3] = vOl.IwJ();
                ++n2;
            }
            Win32DoubleBuffer.blitToScreenNative(this.dhb, this.CwM.Opd(), nArray);
        }
    }

    @Override
    public void CwM(int n2, int n3, int n4, int n5) {
        this.Opd(n2, n3, n4, n5);
    }

    private void Opd(int n2, int n3, int n4, int n5) {
        assert (bCM.Opd(n2 >= 0));
        assert (bCM.Opd(n3 >= 0));
        assert (bCM.Opd(n2 + n4 <= this.m2i));
        assert (bCM.CwM(n3 + n5 <= this.hFR));
        int[] nArray = new int[]{n2, n3, n4, n5};
        Win32DoubleBuffer.blitToScreenNative(this.dhb, this.CwM.Opd(), nArray);
    }

    private static native void blitToScreenNative(long var0, long var2, int[] var4);

    private static native void blitToScreenWithAlphaNative(long var0, long var2, int var4, int var5, int var6, int var7);
}

