/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.win32_windowing_system;

import com.bitwig.base.platform.Bmg;
import com.bitwig.base.platform.LHZ;
import com.bitwig.base.platform.NativeMemoryBlock;

class Win32DIBSectionMemoryBlock
extends LHZ {
    private static final Bmg m2i = new Bmg("Windows DIB");
    private long hFR;
    private NativeMemoryBlock LTX;

    private Win32DIBSectionMemoryBlock(long l2, long l3, int n2, int n3, NativeMemoryBlock nativeMemoryBlock) {
        super(nativeMemoryBlock.CwM());
        this.hFR = l2;
        this.LTX = nativeMemoryBlock;
    }

    public static Win32DIBSectionMemoryBlock CwM(long l2, int n2, int n3) {
        int n4 = Win32DIBSectionMemoryBlock.CwM(n2, n3);
        long[] lArray = Win32DIBSectionMemoryBlock.Opd(l2, n2, n3);
        assert (bCM.Opd(lArray.length == 2));
        long l3 = lArray[0];
        long l4 = lArray[1];
        NativeMemoryBlock nativeMemoryBlock = m2i.CwM(l4, n4, false);
        return new Win32DIBSectionMemoryBlock(l3, l2, n2, n3, nativeMemoryBlock);
    }

    @Override
    public void OqD() {
        assert (bCM.CwM(!this.Opd()));
        if (this.LTX != null) {
            this.LTX.OqD();
            this.LTX = null;
            Win32DIBSectionMemoryBlock.releaseNative(this.hFR);
            super.OqD();
            this.hFR = 0L;
            assert (bCM.CwM(this.LTX == null));
        }
        assert (bCM.CwM(this.hFR == 0L));
    }

    public NativeMemoryBlock m2i() {
        assert (bCM.Opd(this.LTX != null));
        return this.LTX;
    }

    private static int CwM(int n2, int n3) {
        return n2 * n3 * 4;
    }

    private static long[] Opd(long l2, int n2, int n3) {
        long[] lArray = Win32DIBSectionMemoryBlock.createNative(l2, n2, n3);
        if (lArray == null) {
            throw new OutOfMemoryError("Could not allocate native memory block");
        }
        assert (bCM.Opd(lArray.length == 2));
        return lArray;
    }

    public long hFR() {
        return this.hFR;
    }

    private static native long[] createNative(long var0, int var2, int var3);

    private static native void releaseNative(long var0);
}

