/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.widget.tests;

import com.bitwig.base.testing.AnnotationBasedTest;
import com.bitwig.base.testing.GroupTest;
import com.bitwig.base.testing.XOl;
import com.bitwig.base.testing.acS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class LocalizationFileTest
extends AnnotationBasedTest {
    private final yhW mLocalizationFileSystem;
    private final String mResourceName;
    private final String mLanguageCode;

    public static XOl createTestNode(String string, yhW yhW2, Collection collection, String[] stringArray) {
        GroupTest groupTest = new GroupTest(string);
        for (String string2 : stringArray) {
            GroupTest groupTest2 = new GroupTest(string2);
            groupTest.addTest(groupTest2);
            for (String string3 : collection) {
                groupTest2.addTest(new LocalizationFileTest(yhW2, string3, string2));
            }
        }
        return groupTest;
    }

    public static XOl createTestNode(String string, yhW yhW2, bRe bRe2, String[] stringArray) {
        GroupTest groupTest = new GroupTest(string);
        for (String string2 : stringArray) {
            GroupTest groupTest2 = new GroupTest(string2);
            groupTest.addTest(groupTest2);
            for (bRf bRf2 : bRe2.LTX()) {
                String string3 = bRf2.UOJ();
                skj skj2 = new skj(yhW2, UU.Opd(string3));
                if (skj2.EuM()) {
                    groupTest2.addTest(new LocalizationFileTest(yhW2, string3, string2));
                    continue;
                }
                LOG.m2i("Default localization file for module " + string3 + " not found: " + skj2.Ugn());
            }
        }
        return groupTest;
    }

    public LocalizationFileTest(yhW yhW2, String string, String string2) {
        this.mLocalizationFileSystem = yhW2;
        this.mResourceName = string;
        this.mLanguageCode = string2;
    }

    @Override
    protected String getMethodNodeName() {
        return this.mResourceName;
    }

    @acS
    public void testTranslation() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = UU.Opd(this.mResourceName);
        skj skj2 = new skj(this.mLocalizationFileSystem, string);
        this.check("Default localization file exists", skj2).m2i().uwB();
        try {
            Map map = UU.CwM(skj2);
            this.check(map).IkS();
            this.check(!map.isEmpty());
            String string2 = UU.CwM(this.mResourceName, this.mLanguageCode);
            skj skj3 = new skj(this.mLocalizationFileSystem, string2);
            this.check(skj3).m2i().uwB();
            Map map2 = UU.CwM(skj3);
            this.check(map2).IkS();
            this.check(!map2.isEmpty());
            ArrayList arrayList = new ArrayList(map.keySet());
            Collections.sort(arrayList);
            for (String string3 : arrayList) {
                String string4 = (String)map.get(string3);
                this.checkAllCodePointsAreValid(string3, string4, stringBuilder);
                String string5 = (String)map2.get(string3);
                if (string5 == null) {
                    LocalizationFileTest.addError(stringBuilder, string3, "No translation exists");
                    continue;
                }
                if (string5.isEmpty()) {
                    if (string4.isEmpty()) continue;
                    LocalizationFileTest.addError(stringBuilder, string3, "Translation is empty");
                    continue;
                }
                this.checkAllCodePointsAreValid(string3, string5, stringBuilder);
                if (string5.equals(string4) && !string4.equals("{0}")) {
                    LocalizationFileTest.addError(stringBuilder2, string3, "Translated text is the same as default text \"" + string4 + "\"");
                }
                for (int i2 = 0; i2 < 10; ++i2) {
                    String string6 = "{" + i2 + "}";
                    if (string4.contains(string6)) {
                        if (string5.contains(string6)) continue;
                        LocalizationFileTest.addError(stringBuilder, string3, "Translated text does not have parameter " + string6);
                        continue;
                    }
                    if (!string5.contains(string6)) continue;
                    LocalizationFileTest.addError(stringBuilder, string3, "Translated text has parameter " + string6 + " but it shouldn't");
                }
            }
            if (stringBuilder2.length() > 0) {
                this.warning(stringBuilder2.toString());
            }
            if (stringBuilder.length() > 0) {
                this.fail(stringBuilder.toString());
            }
        }
        catch (IOException iOException) {
            this.fail("Loading localization file", iOException);
        }
    }

    private static void addError(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append('\n');
        stringBuilder.append("Key \"");
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
    }

    private void checkAllCodePointsAreValid(String string, String string2, StringBuilder stringBuilder) {
        int[] nArray;
        for (int n2 : nArray = string2.codePoints().toArray()) {
            if (n2 == 0) {
                LocalizationFileTest.addError(stringBuilder, string, "Found 0 code point");
            }
            if (Character.isDefined(n2)) continue;
            LocalizationFileTest.addError(stringBuilder, string, "Found undefined code point " + Integer.toHexString(n2));
        }
    }
}

