/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.widget.core.timeline.interaction;

import com.bitwig.flt.document.core.iface.oGX;
import com.bitwig.flt.widget.core.timeline.cBc;
import com.bitwig.flt.widget.core.timeline.interaction.EAY;
import com.bitwig.windowing_system.Hub;
import com.bitwig.windowing_system.mVc;
import java.util.List;

public abstract class AbstractFadeCurveDragAction
extends EAY {
    private final cBc mWidget;
    private final ace mSelection;
    private List mEvents;
    private Object mReferenceEvent;
    private double mValueDelta;
    private final double mNormalizedMovementPerPixel;

    public AbstractFadeCurveDragAction(cBc cBc2, ace ace2) {
        assert (bCi.hFR(cBc2 != null));
        assert (bCi.hFR(ace2 != null));
        this.mWidget = cBc2;
        this.mSelection = ace2;
        this.mNormalizedMovementPerPixel = 0.01;
    }

    protected abstract void adjustFadeCurve(L2P var1, List var2, Object var3, double var4);

    protected abstract void previewAdjustFadeCurve(L2P var1, List var2, Object var3, double var4);

    @Override
    public Hub getMouseDragCursorStyle() {
        return mVc.m2i;
    }

    @Override
    protected boolean wantsToAdjustMouseMoveSpeed() {
        return true;
    }

    @Override
    protected double calculateMouseMoveDeltaX(cwo cwo2) {
        return 0.0;
    }

    @Override
    protected double calculateMouseMoveDeltaY(cwo cwo2) {
        return super.calculateMouseMoveDeltaY(cwo2);
    }

    @Override
    protected double validateMouseMoveX(double d2) {
        return super.validateMouseMoveX(d2);
    }

    @Override
    protected double validateMouseMoveY(double d2) {
        return super.validateMouseMoveY(d2);
    }

    @Override
    public void beginEventEditing(cwk cwk2, Object object, List list) {
        this.mEvents = list;
        this.mReferenceEvent = object;
    }

    @Override
    public void finishEventEditing() {
        L2P l2P = this.getSelection().LTX();
        this.adjustFadeCurve(l2P, this.mEvents, this.mReferenceEvent, this.mValueDelta);
        this.mEvents = null;
        this.mReferenceEvent = null;
    }

    @Override
    public void cancelEventEditing() {
        L2P l2P = this.getSelection().LTX();
        oGX oGX2 = l2P.i1l();
        oGX2.cO2();
        this.mEvents = null;
        this.mReferenceEvent = null;
    }

    @Override
    public void updateEditEvents(cwo cwo2) {
        double d2 = this.calculateValueDelta(cwo2.BaN());
        this.continueEventEditing(d2);
    }

    protected void continueEventEditing(double d2) {
        this.mValueDelta += d2;
        this.previewAdjustFadeCurve(this.getSelection().LTX(), this.mEvents, this.mReferenceEvent, this.mValueDelta);
        this.getWidget().eob();
    }

    protected double calculateValueDelta(double d2) {
        return -d2 * this.mNormalizedMovementPerPixel;
    }

    public static double calculateNormalizedMovementPerPixel(UAH uAH, long l2) {
        double d2 = 0.01;
        if (uAH instanceof cd3) {
            cd3 cd32 = (cd3)uAH;
            double d3 = cd32.LTX() - cd32.OqD();
            if (cd32.AaH() > 0.0 && d3 > 0.0) {
                d2 = cd32.AaH() / d3;
            }
        }
        d2 = Math.min(d2, 1.5 / (double)l2);
        return d2;
    }

    public static double calculateScaleFactor(cwk cwk2) {
        return cwk2.uwB().CwM() ? 0.1 : 1.0;
    }

    public cBc getWidget() {
        return this.mWidget;
    }

    public ace getSelection() {
        return this.mSelection;
    }
}

