/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.document.api.document;

import com.bitwig.base.geom.kLR;
import com.bitwig.base.io.XRe;
import com.bitwig.base.serial.SerializationException;
import com.bitwig.dawproject.BoolParameter;
import com.bitwig.dawproject.ExpressionType;
import com.bitwig.dawproject.FileReference;
import com.bitwig.dawproject.FolderTrack;
import com.bitwig.dawproject.Interpolation;
import com.bitwig.dawproject.MixerRole;
import com.bitwig.dawproject.Parameter;
import com.bitwig.dawproject.Project;
import com.bitwig.dawproject.RealParameter;
import com.bitwig.dawproject.Scene;
import com.bitwig.dawproject.Send;
import com.bitwig.dawproject.TimeSignatureParameter;
import com.bitwig.dawproject.Track;
import com.bitwig.dawproject.TrackOrFolder;
import com.bitwig.dawproject.Unit;
import com.bitwig.dawproject.device.Device;
import com.bitwig.dawproject.device.EqBand;
import com.bitwig.dawproject.device.Equalizer;
import com.bitwig.dawproject.device.Vst2Plugin;
import com.bitwig.dawproject.device.Vst3Plugin;
import com.bitwig.dawproject.timeline.Audio;
import com.bitwig.dawproject.timeline.BoolPoint;
import com.bitwig.dawproject.timeline.Clip;
import com.bitwig.dawproject.timeline.ClipSlot;
import com.bitwig.dawproject.timeline.Clips;
import com.bitwig.dawproject.timeline.Lanes;
import com.bitwig.dawproject.timeline.Marker;
import com.bitwig.dawproject.timeline.Markers;
import com.bitwig.dawproject.timeline.Note;
import com.bitwig.dawproject.timeline.Notes;
import com.bitwig.dawproject.timeline.Point;
import com.bitwig.dawproject.timeline.Points;
import com.bitwig.dawproject.timeline.RealPoint;
import com.bitwig.dawproject.timeline.TimeSignaturePoint;
import com.bitwig.dawproject.timeline.Timebase;
import com.bitwig.dawproject.timeline.Timeline;
import com.bitwig.dawproject.timeline.Warp;
import com.bitwig.dawproject.timeline.Warps;
import com.bitwig.flt.device.InvalidDeviceIdException;
import com.bitwig.flt.device.LHZ;
import com.bitwig.flt.device.XOl;
import com.bitwig.flt.device.acS;
import com.bitwig.flt.document.api.document.ApiDawProjectImporter$FolderConsumer;
import com.bitwig.flt.document.api.document.ApiDawProjectImporter$TrackConsumer;
import com.bitwig.flt.document.core.iface.eac;
import com.bitwig.flt.document.core.master.device.Jp;
import com.bitwig.flt.document.core.master.device.LqD;
import com.bitwig.flt.document.core.master.device.Mnd;
import com.bitwig.flt.document.core.master.device.uMF;
import com.bitwig.flt.document.file.Hub;
import com.bitwig.ramona.core.JBA;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;

public class ApiDawProjectImporter {
    private final cwN mProject;
    private final Project mDawProject;
    private final Function mStreamProvider;
    private final Map mTrackTrackMap = new HashMap();
    private final Map mFolderTrackGroupTrackMap = new HashMap();
    private Zia mAudioNoteClipEvent;
    private wE mInstrumentNoteClipEvent;
    private final Stack mClipRange = new Stack();
    private final Stack mDawClip = new Stack();
    private final Stack mTrack = new Stack();
    private final Stack mTimebase = new Stack();
    private final Map mParameterMap = new HashMap();
    private final Stack mWarps = new Stack();
    private DxB mScene;
    private KNg mInstrumentNoteEvent;
    private final Hub mProjectDir;
    private static sBm PLUGIN_VALUE_TYPE = sBm.Opd(0.0, 1.0, 0.0);

    public ApiDawProjectImporter(cwN cwN2, Project project, Function function) {
        this.mProject = cwN2;
        this.mDawProject = project;
        this.mStreamProvider = function;
        this.mProjectDir = this.mProject.aMy();
        assert (bCe.OqD(this.mProjectDir.CwM().isDirectory()));
    }

    public void convertPhase1() {
        this.importTransport();
        this.createScenes();
        this.importTracks();
    }

    public void convertPhase2() {
        this.forEachFolder(this::importFolderTrackSettings);
        this.forEachTrack(this::importTrackSettings);
        this.forEachTrack(this::importTrackDevices);
        this.importArrangement();
        this.importScenes();
    }

    private void importTransport() {
        KeZ keZ = this.mProject.hmY();
        this.importParameter(keZ.QeG(), (Parameter)this.mDawProject.transport.tempo);
        this.importParameter(keZ.aBO(), (Parameter)this.mDawProject.transport.timeSignature);
    }

    private void importTracks() {
        this.importTracks(this.mDawProject.tracks, this.mProject.pMu());
        this.mProject.UkY();
    }

    private void forEachTrack(ApiDawProjectImporter$TrackConsumer apiDawProjectImporter$TrackConsumer) {
        for (Map.Entry entry : this.mTrackTrackMap.entrySet()) {
            apiDawProjectImporter$TrackConsumer.accept((Track)entry.getKey(), (cRC)entry.getValue());
        }
    }

    private void forEachFolder(ApiDawProjectImporter$FolderConsumer apiDawProjectImporter$FolderConsumer) {
        for (Map.Entry entry : this.mFolderTrackGroupTrackMap.entrySet()) {
            apiDawProjectImporter$FolderConsumer.accept((FolderTrack)entry.getKey(), (Pt1)entry.getValue());
        }
    }

    private void importTracks(List list, Pt1 pt1) {
        for (TrackOrFolder trackOrFolder : list) {
            this.importTrackToTrackGroup(trackOrFolder, pt1);
        }
    }

    private void importTrackToTrackGroup(TrackOrFolder trackOrFolder, Pt1 pt1) {
        if (trackOrFolder instanceof FolderTrack) {
            FolderTrack folderTrack = (FolderTrack)trackOrFolder;
            Pt1 pt12 = this.createGroupTrack(folderTrack);
            pt1.m2i(Collections.singletonList(pt12), pt1.sWv(), false, null);
            this.assignTrackGroupToResulting(pt12, folderTrack);
            this.importTracks(folderTrack.tracks, pt12);
        } else if (trackOrFolder instanceof Track) {
            Track track = (Track)trackOrFolder;
            if (track.mixerRole == MixerRole.master) {
                this.assignTrackToResulting(pt1.DRS(), track);
                return;
            }
            if (track.mixerRole == MixerRole.returnTrack) {
                cRC cRC2 = this.createTrack(track);
                pt1.Opd((List)Collections.singletonList(cRC2), pt1.XSQ(), false, (wp)null);
            } else if (track.mixerRole != MixerRole.vca) {
                cRC cRC3 = this.createTrack(track);
                pt1.m2i(Collections.singletonList(cRC3), pt1.sWv(), false, null);
            }
        }
    }

    private cRC createTrack(Track track) {
        cRC cRC2 = cRC.MOE();
        this.assignTrackToResulting(cRC2, track);
        return cRC2;
    }

    private Pt1 createGroupTrack(FolderTrack folderTrack) {
        Pt1 pt1 = Pt1.wKO();
        return pt1;
    }

    private void assignTrackToResulting(cRC cRC2, Track track) {
        this.mTrackTrackMap.put(track, cRC2);
    }

    private void assignTrackGroupToResulting(Pt1 pt1, FolderTrack folderTrack) {
        this.mFolderTrackGroupTrackMap.put(folderTrack, pt1);
    }

    private void importFolderTrackSettings(FolderTrack folderTrack, Pt1 pt1) {
        if (folderTrack.name != null) {
            pt1.b_(folderTrack.name);
        }
        if (folderTrack.color != null) {
            pt1.CwM(this.convertColor(folderTrack.color));
        }
    }

    private void importTrackSettings(Track track, cRC cRC2) {
        if (track.name != null) {
            cRC2.b_(track.name);
        }
        if (track.color != null) {
            cRC2.CwM(this.convertColor(track.color));
        }
        if (track.loaded != null) {
            cRC2.AaH(track.loaded);
        }
        this.importParameter(cRC2.Nhe().bQS(), (Parameter)track.volume);
        this.importParameter(cRC2.Nhe().CZs(), (Parameter)track.pan);
        this.importParameter(cRC2.Nhe().mFR(), (Parameter)track.mute);
        if (track.sends != null) {
            int n2 = 0;
            for (Send send : track.sends) {
                Frx frx = cRC2.Nhe().m2i(n2++);
                this.importParameter(frx.oGr(), (Parameter)send);
            }
        }
        if (track.destination != null) {
            cRC cRC3 = (cRC)this.mTrackTrackMap.get(track.destination);
            cRC2.qMD().hFR(cRC3.mKI());
        }
    }

    private void importTrackDevices(Track track, cRC cRC2) {
        if (track.devices == null) {
            return;
        }
        for (Device device : track.devices) {
            uMF uMF2 = this.importDevice(device);
            if (uMF2 == null) continue;
            cRC2.OwQ().Opd(uMF2);
        }
    }

    private uMF importDevice(Device device) {
        if (device instanceof Vst3Plugin) {
            return this.createVst3Plugin((Vst3Plugin)device);
        }
        if (device instanceof Vst2Plugin) {
            return this.createVst2Plugin((Vst2Plugin)device);
        }
        if (device instanceof Equalizer) {
            return this.createEqualizer((Equalizer)device);
        }
        return null;
    }

    private YFa create(Audio audio) {
        if (audio.file != null) {
            InputStream inputStream;
            File file = this.mProject.aMy().Opd(audio.file.path);
            if (!file.exists() && (inputStream = (InputStream)this.mStreamProvider.apply(audio.file.path)) != null) {
                this.copyFileToProjectDir(inputStream, file);
            }
            if (file.exists()) {
                return this.createSampleReference(file);
            }
        }
        return null;
    }

    private Mnd createVst3Plugin(Vst3Plugin vst3Plugin) {
        if (vst3Plugin.id == null) {
            return null;
        }
        if (vst3Plugin.state == null) {
            return null;
        }
        try {
            acS acS2 = (acS)LHZ.CwM("vst3:" + vst3Plugin.deviceID);
            String string = new File(vst3Plugin.state.path).getName();
            File file = new File(Xc2.eSp(), string);
            if (!file.exists()) {
                this.copyFileToProjectDir(this.resolve(vst3Plugin.state), file);
            }
            String string2 = vst3Plugin.deviceName != null ? vst3Plugin.deviceName : "";
            String string3 = vst3Plugin.pluginVersion != null ? vst3Plugin.pluginVersion : "";
            Mnd mnd = Mnd.CwM(string2, acS2, string3, file);
            for (Parameter parameter : vst3Plugin.automatedParameters) {
                String string4 = "CONTENTS/PID" + parameter.parameterID;
                TcZ tcZ = TcZ.CwM(mnd, string4, PLUGIN_VALUE_TYPE);
                this.mParameterMap.put(parameter, tcZ);
            }
            return mnd;
        }
        catch (InvalidDeviceIdException invalidDeviceIdException) {
            throw new IOException(invalidDeviceIdException);
        }
    }

    private LqD createVst2Plugin(Vst2Plugin vst2Plugin) {
        if (vst2Plugin.id == null) {
            return null;
        }
        if (vst2Plugin.state == null) {
            return null;
        }
        try {
            XOl xOl = (XOl)LHZ.CwM("vst:" + vst2Plugin.deviceID);
            String string = new File(vst2Plugin.state.path).getName();
            File file = new File(Xc2.eSp(), string);
            if (!file.exists()) {
                this.copyFileToProjectDir(this.resolve(vst2Plugin.state), file);
            }
            String string2 = vst2Plugin.deviceName != null ? vst2Plugin.deviceName : "";
            int n2 = vst2Plugin.pluginVersion != null ? Integer.parseInt(vst2Plugin.pluginVersion) : 0;
            LqD lqD = LqD.CwM(string2, xOl, n2, file);
            for (Parameter parameter : vst2Plugin.automatedParameters) {
                String string3 = "CONTENTS/PARAM" + parameter.parameterID;
                TcZ tcZ = TcZ.CwM(lqD, string3, PLUGIN_VALUE_TYPE);
                this.mParameterMap.put(parameter, tcZ);
            }
            return lqD;
        }
        catch (SerializationException | InvalidDeviceIdException ul2) {
            throw new IOException(ul2);
        }
    }

    private Jp createEqualizer(Equalizer equalizer) {
        try {
            Jp jp2 = Jp.uwB(com.bitwig.flt.packaging.core.kLR.nce);
            int n2 = 1;
            for (EqBand eqBand : equalizer.bands) {
                cNN cNN2 = this.getFilterType(eqBand);
                if (cNN2 == null) continue;
                if (eqBand.freq != null) {
                    this.importParameter(jp2, "FREQ" + n2, (Parameter)eqBand.freq);
                }
                if (eqBand.gain != null) {
                    this.importParameter(jp2, "GAIN" + n2, (Parameter)eqBand.gain);
                }
                if (eqBand.Q != null) {
                    this.importParameter(jp2, "Q" + n2, (Parameter)eqBand.Q);
                }
                if (eqBand.enabled != null) {
                    this.importParameter(jp2, "ENABLE" + n2, (Parameter)eqBand.enabled);
                }
                rUO rUO2 = (rUO)jp2.XSQ("CONTENTS/TYPE" + n2);
                rUO2.CwM(cNN2.Opd());
                if (++n2 <= 8) continue;
                break;
            }
            return jp2;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private cNN getFilterType(EqBand eqBand) {
        switch (eqBand.type) {
            case highPass: {
                if (eqBand.order >= 8) {
                    return cNN.EuM;
                }
                if (eqBand.order >= 6) {
                    return cNN.alk;
                }
                if (eqBand.order >= 4) {
                    return cNN.aMy;
                }
                if (eqBand.order == 1) {
                    return cNN.dhb;
                }
                return cNN.uwB;
            }
            case lowPass: {
                if (eqBand.order >= 8) {
                    return cNN.hFR;
                }
                if (eqBand.order >= 6) {
                    return cNN.m2i;
                }
                if (eqBand.order >= 4) {
                    return cNN.OqD;
                }
                if (eqBand.order == 1) {
                    return cNN.LTX;
                }
                return cNN.Opd;
            }
            case highShelf: {
                return cNN.gav;
            }
            case lowShelf: {
                return cNN.nSA;
            }
            case bell: {
                return cNN.WW1;
            }
            case notch: {
                return cNN.urx;
            }
        }
        return null;
    }

    private void importParameter(uMF uMF2, String string, Parameter parameter) {
        xM2 xM22 = (xM2)uMF2.XSQ("CONTENTS/" + string);
        assert (bCe.OqD(xM22 != null));
        this.importParameter(xM22, parameter);
    }

    private void importParameter(xM2 xM22, Parameter parameter) {
        if (parameter == null) {
            return;
        }
        if (xM22 instanceof hRe && parameter instanceof BoolParameter) {
            this.importBoolParameter((hRe)xM22, (BoolParameter)parameter);
        } else if (xM22 instanceof ncs && parameter instanceof RealParameter) {
            this.importRealParameter((ncs)xM22, (RealParameter)parameter);
        } else if (xM22 instanceof RIV && parameter instanceof TimeSignatureParameter) {
            this.importTimeSignatureParameter((RIV)xM22, (TimeSignatureParameter)parameter);
        }
        this.mParameterMap.put(parameter, PJh.CwM(xM22));
    }

    private void importBoolParameter(hRe hRe2, BoolParameter boolParameter) {
        if (boolParameter.value != null) {
            hRe2.CwM(boolParameter.value);
        }
    }

    private void importRealParameter(ncs ncs2, RealParameter realParameter) {
        if (realParameter.value != null) {
            ncs2.WW1(this.convertRealValue(realParameter.value, realParameter.unit, ncs2.ovL()));
        }
    }

    private void importTimeSignatureParameter(RIV rIV, TimeSignatureParameter timeSignatureParameter) {
        if (timeSignatureParameter.numerator != null && timeSignatureParameter.denominator != null) {
            int n2 = fnx.CwM(timeSignatureParameter.numerator, timeSignatureParameter.denominator, 16);
            rIV.WW1(n2);
        }
    }

    private double convertRealValue(double d2, Unit unit, sBm sBm2) {
        double d3 = Maj.CwM(d2, this.convertUnit(unit), sBm2.alk());
        return f2f.Opd(d3, sBm2.OqD(), sBm2.LTX());
    }

    private Rz3 convertUnit(Unit unit) {
        if (unit == null) {
            return Rz3.CwM;
        }
        switch (unit) {
            case linear: {
                return Rz3.CwM;
            }
            case normalized: {
                return Rz3.OqD;
            }
            case percent: {
                return Rz3.Opd;
            }
            case decibel: {
                return Rz3.m2i;
            }
            case hertz: {
                return Rz3.uwB;
            }
            case semitones: {
                return Rz3.dhb;
            }
            case seconds: {
                return Rz3.hFR;
            }
            case beats: {
                return Rz3.IkS;
            }
            case bpm: {
                return Rz3.EuM;
            }
        }
        return Rz3.CwM;
    }

    private void importArrangement() {
        if (this.mDawProject.arrangement != null) {
            this.importTimeline(this.mDawProject.arrangement.content);
        }
    }

    protected void createScenes() {
        if (this.mDawProject.scenes == null) {
            return;
        }
        this.mProject.pMu().khV(this.mDawProject.scenes.size());
    }

    private void importScenes() {
        if (this.mDawProject.scenes == null) {
            return;
        }
        int n2 = 0;
        for (Scene scene : this.mDawProject.scenes) {
            this.importScene(scene, this.mProject.pMu().bBu(n2++));
        }
    }

    private void importScene(Scene scene, DxB dxB2) {
        if (scene.name != null) {
            dxB2.Opd(scene.name);
        }
        if (scene.color != null) {
            dxB2.m2i(this.convertColor(scene.color));
        }
        this.mScene = dxB2;
        this.importTimeline(scene.content);
        this.mScene = null;
    }

    private void importTimeline(Timeline timeline) {
        if (timeline.timebase != null) {
            this.mTimebase.push(timeline.timebase);
        }
        if (timeline.track != null) {
            this.mTrack.push((cRC)this.mTrackTrackMap.get(timeline.track));
        }
        if (timeline instanceof Lanes) {
            this.importLanes((Lanes)timeline);
        } else if (timeline instanceof Clips) {
            this.importClips((Clips)timeline);
        } else if (timeline instanceof Markers) {
            this.importMarkers((Markers)timeline);
        } else if (timeline instanceof Warps) {
            this.importWarps((Warps)timeline);
        } else if (timeline instanceof Notes) {
            this.importNotes((Notes)timeline);
        } else if (timeline instanceof Audio) {
            this.importAudio((Audio)timeline);
        } else if (timeline instanceof Points) {
            this.importPoints((Points)timeline);
        } else if (timeline instanceof ClipSlot) {
            this.importClipSlot((ClipSlot)timeline);
        }
        if (timeline.track != null) {
            this.mTrack.pop();
        }
        if (timeline.timebase != null) {
            this.mTimebase.pop();
        }
    }

    private void importLanes(Lanes lanes) {
        for (Timeline timeline : lanes.lanes) {
            this.importTimeline(timeline);
        }
    }

    private void importClipSlot(ClipSlot clipSlot) {
        xYE xYE2;
        cRC cRC2 = (cRC)this.mTrack.peek();
        xYE xYE3 = xYE2 = this.mScene != null && cRC2 != null ? cRC2.OqD(this.mScene.khV()) : null;
        if (xYE2 != null) {
            if (clipSlot.hasStop != null) {
                xYE2.d_(clipSlot.hasStop);
            }
            if (clipSlot.clip != null) {
                this.importClip(clipSlot.clip);
            }
        }
    }

    private void importClips(Clips clips) {
        for (Clip clip : clips.clips) {
            this.importClip(clip);
        }
    }

    private void importClip(Clip clip) {
        Timeline timeline;
        this.mDawClip.push(clip);
        if (this.mDawClip.size() > 1) {
            timeline = this.mClipRange.isEmpty() ? null : (kLR)this.mClipRange.peek();
            kLR kLR2 = timeline != null ? new kLR(Math.max(clip.time, timeline.CwM()), Math.min(clip.time + clip.duration, timeline.Opd())) : new kLR(clip.time, clip.time + clip.duration);
            this.mClipRange.push(kLR2);
        }
        Timeline timeline2 = timeline = clip.content != null ? clip.content : clip.reference;
        if (timeline != null) {
            this.importTimeline(timeline);
        }
        if (this.mDawClip.size() > 1) {
            this.mClipRange.pop();
        }
        this.mDawClip.pop();
        if (this.mDawClip.isEmpty()) {
            this.mAudioNoteClipEvent = null;
            this.mInstrumentNoteClipEvent = null;
        }
    }

    private void importMarkers(Markers markers) {
        JRh jRh2 = this.mProject.pMu().jyg().ynG();
        for (Marker marker : markers.markers) {
            dkQ dkQ2 = dkQ.m2i(marker.time);
            if (marker.name != null) {
                dkQ2.CwM(marker.name);
            }
            if (marker.color != null) {
                dkQ2.CwM(this.convertColor(marker.color));
            }
            jRh2.OqD(dkQ2);
        }
    }

    private void importWarps(Warps warps) {
        this.mWarps.push(warps);
        this.importTimeline(warps.content);
        this.mWarps.pop();
    }

    private void importAudio(Audio audio) {
        double d2;
        Object object;
        if (this.mDawClip.size() < 1) {
            return;
        }
        if (this.mAudioNoteClipEvent == null) {
            object = (Clip)this.mDawClip.get(0);
            this.mAudioNoteClipEvent = Zia.CwM(((Clip)object).time, ((Clip)object).duration);
            this.importClipSettings((Clip)object, this.mAudioNoteClipEvent);
            this.addClipToTimelineOrScene(this.mAudioNoteClipEvent);
        }
        object = this.mAudioNoteClipEvent.oe1().CwM(true);
        YFa yFa = this.createSampleReference(audio);
        if (yFa == null) {
            return;
        }
        Warps warps = this.mWarps.isEmpty() ? null : (Warps)this.mWarps.peek();
        kLR kLR2 = (kLR)this.mClipRange.peek();
        double d3 = kLR2 != null ? kLR2.CwM() : 0.0;
        double d4 = d2 = kLR2 != null ? kLR2.hFR() : this.mAudioNoteClipEvent.g3A();
        if (warps != null) {
            d2 = Math.min(d2, ((Warp)warps.events.get((int)(warps.events.size() - 1))).time);
        }
        zKD zKD2 = zKD.CwM(d3, d2, yFa);
        if (warps != null) {
            bVx bVx2 = new bVx(warps.events.size());
            for (Warp warp : warps.events) {
                bVx2.CwM(warp.time, warp.warped);
            }
            zKD2.lMH().CwM(bVx2);
            zKD2.CwM(DPB.Opd);
        } else {
            zKD2.CwM(DPB.CwM);
        }
        ((yPy)object).OqD(zKD2);
    }

    private YFa createSampleReference(Audio audio) {
        if (audio.file != null) {
            InputStream inputStream;
            File file = this.mProject.aMy().Opd(audio.file.path);
            if (!file.exists() && (inputStream = this.resolve(audio.file)) != null) {
                this.copyFileToProjectDir(inputStream, file);
            }
            if (file.exists()) {
                return this.createSampleReference(file);
            }
        }
        return null;
    }

    InputStream resolve(FileReference fileReference) {
        return (InputStream)this.mStreamProvider.apply(fileReference.path);
    }

    private void copyFileToProjectDir(InputStream inputStream, File file) {
        assert (bCe.OqD(this.mProject.aMy().CwM().exists()));
        assert (bCe.OqD(!file.exists()));
        file.getParentFile().mkdirs();
        Files.copy(inputStream, file.toPath(), new CopyOption[0]);
        inputStream.close();
    }

    private YFa createSampleReference(File file) {
        return YFa.CwM(new XRe(file));
    }

    private void importNotes(Notes notes) {
        if (this.mDawClip.size() < 1) {
            return;
        }
        if (this.mInstrumentNoteClipEvent == null) {
            Clip clip = (Clip)this.mDawClip.get(0);
            this.mInstrumentNoteClipEvent = wE.CwM(clip.time, clip.duration);
            this.importClipSettings(clip, this.mInstrumentNoteClipEvent);
            this.addClipToTimelineOrScene(this.mInstrumentNoteClipEvent);
        }
        for (Note note : notes.notes) {
            this.importNote(note);
        }
    }

    private void importNote(Note note) {
        KNg kNg = KNg.m2i(note.time, note.duration);
        if (note.velocity != null) {
            kNg.CwM(note.velocity);
        }
        if (note.releaseVelocity != null) {
            kNg.Opd(note.releaseVelocity);
        }
        this.mInstrumentNoteEvent = kNg;
        if (note.content != null) {
            this.importTimeline(note.content);
        }
        this.mInstrumentNoteEvent = null;
        this.mInstrumentNoteClipEvent.Opd(kNg, null, note.channel, note.key);
    }

    private void addClipToTimelineOrScene(eLk eLk2) {
        cRC cRC2 = (cRC)this.mTrack.peek();
        if (cRC2 != null) {
            if (this.mScene != null) {
                cRC2.OqD(this.mScene.khV()).Opd((cKu)eLk2);
            } else {
                cRC2.MG().JWq().OqD(eLk2);
            }
        }
    }

    private CyD getArrangement() {
        return this.mProject.pMu().jyg();
    }

    private void importClipSettings(Clip clip, eLk eLk2) {
        if (clip.name != null) {
            eLk2.CwM(clip.name);
        }
        if (clip.color != null) {
            eLk2.OqD(this.convertColor(clip.color));
        }
        if (clip.playStart != null) {
            eLk2.ht(clip.playStart);
        }
        if (clip.loopStart != null) {
            eLk2.yC3().AaH(clip.loopStart);
        }
        if (clip.loopEnd != null) {
            eLk2.yC3().WW1(clip.loopEnd);
        }
        if (clip.loopStart != null && clip.loopEnd != null) {
            eLk2.zdJ(true);
        }
        if (eLk2 instanceof Zia) {
            Zia zia = (Zia)eLk2;
            if (clip.fadeInTime != null) {
                zia.CwM(clip.fadeInTime);
            }
            if (clip.fadeOutTime != null) {
                zia.OqD(clip.fadeOutTime);
            }
        }
    }

    private void importPoints(Points points) {
        KNg kNg = this.mInstrumentNoteEvent;
        if (points.target.expression != null) {
            if (kNg != null) {
                this.importNoteExpression(points, kNg);
            }
        } else if (points.target.parameter != null) {
            this.importAutomation(points);
        }
    }

    private void importNoteExpression(Points points, Owx owx) {
        String string = this.getExpressionName(points.target.expression);
        if (string == null) {
            return;
        }
        SDO sDO = owx.PwV().Opd(string, true);
        this.insertPoints(points, sDO);
    }

    private void importAutomation(Points points) {
        PJh pJh = (PJh)this.mParameterMap.get(points.target.parameter);
        if (pJh == null) {
            return;
        }
        this.importAutomationForAtom(pJh, points);
    }

    private h1m createRealEvent(double d2, double d3, sBm sBm2) {
        if (sBm2 instanceof pk1) {
            return kfj.OqD(d2, d3);
        }
        return h1m.CwM(d2, d3);
    }

    private void insertPoints(Points points, rmR rmR2) {
        Double d2 = null;
        double d3 = 0.0;
        Fmg fmg = rmR2.ai_();
        for (Point point : points.points) {
            JBA jBA;
            RealPoint realPoint;
            if (point instanceof RealPoint && fmg instanceof sBm) {
                realPoint = (RealPoint)point;
                Unit unit = points.unit != null ? points.unit : (points.target.parameter instanceof RealParameter ? ((RealParameter)points.target.parameter).unit : null);
                jBA = (sBm)fmg;
                double d4 = this.convertRealValue(realPoint.value, unit, (sBm)jBA);
                if (points.interpolation == Interpolation.hold && d2 != null && point.time > d3) {
                    rmR2.OqD(this.createRealEvent(point.time, d2, (sBm)jBA));
                }
                rmR2.OqD(this.createRealEvent(point.time, d4, (sBm)jBA));
                d2 = d4;
                d3 = point.time;
                continue;
            }
            if (point instanceof TimeSignaturePoint && fmg instanceof uYy) {
                realPoint = (TimeSignaturePoint)point;
                int n2 = fnx.CwM(realPoint.numerator, realPoint.denominator, 16);
                jBA = MIE.CwM(point.time, n2);
                rmR2.OqD((FtX)jBA);
                continue;
            }
            if (!(point instanceof BoolPoint)) continue;
            realPoint = (BoolPoint)point;
            rmR2.CwM((double)point.time, realPoint.value != false ? 1.0 : 0.0, 0.0, -1, (L2P)null);
        }
    }

    private void importAutomationForAtom(PJh pJh, Points points) {
        cRC cRC2;
        eLk eLk2 = this.getCurrentClip();
        cRC cRC3 = cRC2 = this.mTrack.isEmpty() ? pJh.YHh() : (cRC)this.mTrack.peek();
        if (eLk2 != null) {
            double[] dArray = new double[points.points.size()];
            double[] dArray2 = new double[points.points.size()];
            int n2 = 0;
            for (Point point : points.points) {
                dArray[n2] = point.time;
                if (point instanceof RealPoint) {
                    dArray2[n2] = this.convertRealValue(((RealPoint)point).value, points.unit, (sBm)pJh.ai_());
                }
                ++n2;
            }
            cRC2.Opd(pJh, pSb.CwM, (Wly)eLk2, dArray, dArray2, null, null);
        } else {
            cRC2.Opd(pJh, pSb.CwM, false);
            Abs abs2 = cRC2.Opd((eac)pJh);
            LW3 lW3 = abs2.GYe().JWq();
            lW3.SF();
            this.insertPoints(points, lW3);
        }
    }

    private eLk getCurrentClip() {
        if (this.mInstrumentNoteClipEvent != null) {
            return this.mInstrumentNoteClipEvent;
        }
        return this.mAudioNoteClipEvent;
    }

    private String getExpressionName(ExpressionType expressionType) {
        switch (expressionType) {
            case gain: {
                return "amplitude";
            }
            case pan: {
                return "panning";
            }
            case transpose: {
                return "transpose";
            }
            case timbre: {
                return "timbre";
            }
            case formant: {
                return "formant";
            }
            case pressure: {
                return "pressure";
            }
        }
        return null;
    }

    private Timebase getTimebase() {
        try {
            return (Timebase)this.mTimebase.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    private cRC getTrack() {
        try {
            return (cRC)this.mTrack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    private HkO convertColor(String string) {
        try {
            return HkO.CwM(string);
        }
        catch (Lox lox) {
            lox.printStackTrace();
            return HkO.EuM;
        }
    }
}

