/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.document.api.document;

import com.bitwig.dawproject.Arrangement;
import com.bitwig.dawproject.BoolParameter;
import com.bitwig.dawproject.EnumParameter;
import com.bitwig.dawproject.ExpressionType;
import com.bitwig.dawproject.FileReference;
import com.bitwig.dawproject.FolderTrack;
import com.bitwig.dawproject.IntegerParameter;
import com.bitwig.dawproject.Interpolation;
import com.bitwig.dawproject.MixerRole;
import com.bitwig.dawproject.Parameter;
import com.bitwig.dawproject.Project;
import com.bitwig.dawproject.RealParameter;
import com.bitwig.dawproject.Referencable;
import com.bitwig.dawproject.Scene;
import com.bitwig.dawproject.Send;
import com.bitwig.dawproject.SendType;
import com.bitwig.dawproject.TimeSignatureParameter;
import com.bitwig.dawproject.TimelineRole;
import com.bitwig.dawproject.Track;
import com.bitwig.dawproject.Transport;
import com.bitwig.dawproject.Unit;
import com.bitwig.dawproject.device.BuiltinDevice;
import com.bitwig.dawproject.device.Device;
import com.bitwig.dawproject.device.EqBand;
import com.bitwig.dawproject.device.EqBandType;
import com.bitwig.dawproject.device.Equalizer;
import com.bitwig.dawproject.device.Plugin;
import com.bitwig.dawproject.device.Vst2Plugin;
import com.bitwig.dawproject.device.Vst3Plugin;
import com.bitwig.dawproject.timeline.Audio;
import com.bitwig.dawproject.timeline.BoolPoint;
import com.bitwig.dawproject.timeline.Clip;
import com.bitwig.dawproject.timeline.ClipSlot;
import com.bitwig.dawproject.timeline.Clips;
import com.bitwig.dawproject.timeline.EnumPoint;
import com.bitwig.dawproject.timeline.IntegerPoint;
import com.bitwig.dawproject.timeline.Lanes;
import com.bitwig.dawproject.timeline.Marker;
import com.bitwig.dawproject.timeline.Markers;
import com.bitwig.dawproject.timeline.Note;
import com.bitwig.dawproject.timeline.Notes;
import com.bitwig.dawproject.timeline.Points;
import com.bitwig.dawproject.timeline.RealPoint;
import com.bitwig.dawproject.timeline.TimeSignaturePoint;
import com.bitwig.dawproject.timeline.Timebase;
import com.bitwig.dawproject.timeline.Timeline;
import com.bitwig.dawproject.timeline.Warp;
import com.bitwig.dawproject.timeline.Warps;
import com.bitwig.flt.document.core.master.device.ACV;
import com.bitwig.flt.document.core.master.device.CtA;
import com.bitwig.flt.document.core.master.device.Jp;
import com.bitwig.flt.document.core.master.device.LqD;
import com.bitwig.flt.document.core.master.device.Mnd;
import com.bitwig.flt.document.core.master.device.YjJ;
import com.bitwig.flt.document.core.master.device.uMF;
import com.bitwig.flt.packaging.core.kLR;
import com.bitwig.ramona.core.XBP;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ApiDawProjectExporter {
    private final Map mEmbeddedFiles;
    private final cwN mSourceProject;
    private Project mProject;
    private final List mAllTracks = new ArrayList();
    private final Map mTrackToTrackMap = new HashMap();
    private Map mAtomReferences = new HashMap();

    public ApiDawProjectExporter(cwN cwN2, Map map) {
        this.mSourceProject = cwN2;
        this.mEmbeddedFiles = map;
    }

    public Project convert() {
        Referencable.resetID();
        this.mProject = new Project();
        this.mProject.application.name = "Bitwig Studio";
        this.mProject.application.version = "4.0.1";
        this.createTransport();
        this.createRootTracks();
        this.routeTracks();
        this.createArrangement();
        this.createScenes();
        return this.mProject;
    }

    private void createScenes() {
        for (DxB dxB2 : this.mSourceProject.pMu().Fnc()) {
            this.mProject.scenes.add(this.createScene(dxB2));
        }
    }

    private void createTransport() {
        KeZ keZ = this.mSourceProject.hmY();
        this.mProject.transport = new Transport();
        this.mProject.transport.tempo = (RealParameter)this.createParameter(keZ.QeG());
        RIV rIV = keZ.aBO();
        this.mProject.transport.timeSignature = (TimeSignatureParameter)this.createParameter(rIV);
    }

    private void createRootTracks() {
        Pt1 pt1 = this.mSourceProject.pMu();
        List list = this.mProject.tracks;
        for (YJb yJb2 : pt1.cmM()) {
            Track track;
            if (yJb2 instanceof cRC) {
                track = this.createTrack((cRC)yJb2);
                list.add(track);
                continue;
            }
            if (yJb2 instanceof Pt1) {
                track = this.createFolderTrack((Pt1)yJb2);
                list.add(track);
                continue;
            }
            throw new IllegalStateException();
        }
        for (YJb yJb2 : pt1.g3A()) {
            list.add(this.createTrack((cRC)yJb2));
        }
        list.add(this.createTrack(pt1.DRS()));
    }

    private FolderTrack createFolderTrack(Pt1 pt1) {
        FolderTrack folderTrack = new FolderTrack();
        folderTrack.name = pt1.nce();
        folderTrack.color = this.getColor(pt1.YHh());
        List list = folderTrack.tracks;
        for (YJb yJb2 : pt1.cmM()) {
            Track track;
            if (yJb2 instanceof cRC) {
                track = this.createTrack((cRC)yJb2);
                list.add(track);
                continue;
            }
            if (yJb2 instanceof Pt1) {
                track = this.createFolderTrack((Pt1)yJb2);
                list.add(track);
                continue;
            }
            throw new IllegalStateException();
        }
        for (YJb yJb2 : pt1.g3A()) {
            list.add(this.createTrack((cRC)yJb2));
        }
        Track track = this.createTrack(pt1.DRS());
        list.add(track);
        assert (bCe.OqD(track.mixerRole == MixerRole.master));
        return folderTrack;
    }

    private Track createTrack(cRC cRC2) {
        TimelineRole[] timelineRoleArray2;
        Track track = new Track();
        this.mTrackToTrackMap.put(cRC2, track);
        this.mAllTracks.add(cRC2);
        track.name = cRC2.nce();
        track.color = this.getColor(cRC2.YHh());
        track.loaded = cRC2.nGB();
        oHX oHX2 = cRC2.Nhe();
        track.name = cRC2.nce();
        track.color = this.getColor(cRC2.YHh());
        track.volume = (RealParameter)this.createParameter(oHX2.bQS());
        track.pan = (RealParameter)this.createParameter(oHX2.CZs());
        track.mute = (BoolParameter)this.createParameter(oHX2.mFR());
        if (cRC2.lMH()) {
            track.mixerRole = MixerRole.master;
        } else if (cRC2.KKJ()) {
            track.mixerRole = MixerRole.returnTrack;
        } else if (cRC2.KKJ()) {
            track.mixerRole = MixerRole.regular;
        }
        for (TimelineRole[] timelineRoleArray2 : cRC2.OwQ().aMy()) {
            if (track.devices == null) {
                track.devices = new ArrayList();
            }
            track.devices.add(this.createDevice((uMF)timelineRoleArray2));
        }
        TimelineRole[] timelineRoleArray3 = new TimelineRole[]{TimelineRole.notes};
        timelineRoleArray2 = new TimelineRole[]{TimelineRole.audio};
        TimelineRole[] timelineRoleArray4 = new TimelineRole[]{TimelineRole.audio, TimelineRole.notes};
        switch (cRC2.EuM()) {
            case CwM: {
                track.timelineRole = timelineRoleArray3;
                break;
            }
            case Opd: {
                track.timelineRole = timelineRoleArray2;
                break;
            }
            case OqD: {
                track.timelineRole = timelineRoleArray4;
            }
        }
        return track;
    }

    private void routeTracks() {
        for (cRC cRC2 : this.mAllTracks) {
            this.routeTrack(cRC2);
        }
    }

    private void routeTrack(cRC cRC2) {
        int n2;
        cRC cRC3;
        Track track;
        Track track2 = track = (Track)this.mTrackToTrackMap.get(cRC2);
        yxP yxP2 = cRC2.qMD().YHh();
        cRC cRC4 = cRC3 = yxP2 != null ? yxP2.Dii() : null;
        if (cRC3 != null) {
            Track track3;
            track2.destination = track3 = (Track)this.mTrackToTrackMap.get(cRC3);
        }
        if ((n2 = cRC2.Nhe().ynG()) > 0) {
            track2.sends = new ArrayList();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Frx frx = cRC2.Nhe().m2i(i2);
            Send send = (Send)this.createParameter(frx.oGr());
            cRC cRC5 = frx.b2R().oEn();
            send.destination = (Track)this.mTrackToTrackMap.get(cRC5);
            send.type = this.getEffectiveSendMode(frx);
            track2.sends.add(send);
        }
    }

    Parameter createParameter(xM2 xM22) {
        Parameter parameter = this.createParameterOfType(xM22);
        parameter.name = xM22.b2R();
        this.mAtomReferences.put(xM22, parameter);
        return parameter;
    }

    private Parameter createParameterOfType(xM2 xM22) {
        if (xM22 instanceof hRe) {
            BoolParameter boolParameter = new BoolParameter();
            boolParameter.value = ((hRe)xM22).CwM();
            return boolParameter;
        }
        if (xM22 instanceof FLD) {
            Send send = new Send();
            this.assignUnitAndValue((FLD)xM22, (RealParameter)send);
            return send;
        }
        if (xM22 instanceof ncs) {
            RealParameter realParameter = new RealParameter();
            this.assignUnitAndValue((ncs)xM22, realParameter);
            return realParameter;
        }
        if (xM22 instanceof ACV) {
            RealParameter realParameter = new RealParameter();
            ACV aCV2 = (ACV)xM22;
            realParameter.value = aCV2.SF();
            realParameter.min = 0.0;
            realParameter.max = 1.0;
            realParameter.unit = Unit.normalized;
            realParameter.parameterID = aCV2.OqD();
            return realParameter;
        }
        if (xM22 instanceof rUO) {
            EnumParameter enumParameter = new EnumParameter();
            enumParameter.value = ((rUO)xM22).CwM();
            mLX mLX2 = ((rUO)xM22).JFx();
            enumParameter.count = mLX2.dhb();
            enumParameter.labels = mLX2.IkS();
            return enumParameter;
        }
        if (xM22 instanceof xsi) {
            IntegerParameter integerParameter = new IntegerParameter();
            integerParameter.value = ((xsi)xM22).ovL();
            integerParameter.min = ((xsi)xM22).eGK().CwM();
            integerParameter.max = ((xsi)xM22).eGK().hFR();
            return integerParameter;
        }
        if (xM22 instanceof RIV) {
            TimeSignatureParameter timeSignatureParameter = new TimeSignatureParameter();
            RIV rIV = (RIV)xM22;
            timeSignatureParameter.numerator = rIV.dhb();
            timeSignatureParameter.denominator = rIV.IkS();
            return timeSignatureParameter;
        }
        throw new XBP(xM22.getClass().getName());
    }

    private void assignUnitAndValue(ncs ncs2, RealParameter realParameter) {
        sBm sBm2 = ncs2.ovL();
        switch (sBm2.alk()) {
            case Opd: {
                realParameter.unit = Unit.decibel;
                break;
            }
            case OqD: 
            case dhb: {
                realParameter.unit = Unit.semitones;
                break;
            }
            default: {
                realParameter.unit = Unit.linear;
            }
        }
        if (realParameter.unit == Unit.linear) {
            switch (sBm2.gav()) {
                case IkS: {
                    realParameter.unit = Unit.beats;
                    break;
                }
                case EuM: {
                    realParameter.unit = Unit.bpm;
                    break;
                }
                case hFR: {
                    realParameter.unit = Unit.seconds;
                    break;
                }
                case uwB: {
                    realParameter.unit = Unit.hertz;
                }
            }
        }
        realParameter.value = this.convertValue(ncs2.CwM(), sBm2, realParameter.unit);
        realParameter.min = this.convertValue(sBm2.OqD(), sBm2, realParameter.unit);
        realParameter.max = this.convertValue(sBm2.LTX(), sBm2, realParameter.unit);
    }

    private Rz3 convertUnit(Unit unit) {
        if (unit == null) {
            return Rz3.CwM;
        }
        switch (unit) {
            case linear: {
                return Rz3.CwM;
            }
            case normalized: {
                return Rz3.OqD;
            }
            case percent: {
                return Rz3.Opd;
            }
            case decibel: {
                return Rz3.m2i;
            }
            case hertz: {
                return Rz3.uwB;
            }
            case semitones: {
                return Rz3.dhb;
            }
            case seconds: {
                return Rz3.hFR;
            }
            case beats: {
                return Rz3.IkS;
            }
            case bpm: {
                return Rz3.EuM;
            }
        }
        return null;
    }

    private double convertValue(double d2, sBm sBm2, Unit unit) {
        zxj zxj2 = sBm2.alk();
        Rz3 rz3 = this.convertUnit(unit);
        double d3 = Maj.CwM(d2, zxj2, rz3);
        assert (bCe.OqD(Double.isFinite(d3)));
        return d3;
    }

    private void createArrangement() {
        Arrangement arrangement = new Arrangement();
        Lanes lanes = new Lanes();
        arrangement.content = lanes;
        lanes.timebase = Timebase.beats;
        for (cRC cRC2 : this.mAllTracks) {
            Lanes lanes2 = new Lanes();
            lanes2.track = (Track)this.mTrackToTrackMap.get(cRC2);
            lanes.lanes.add(lanes2);
            Clips clips = new Clips();
            lanes2.lanes.add(clips);
            IH2 iH2 = cRC2.MG();
            for (OMl oMl : iH2.JWq().dS_()) {
                clips.clips.add(this.createArrangerClip((eLk)oMl));
            }
            for (OMl oMl : iH2.FCw()) {
                lanes2.lanes.add(this.createPoints((sac)oMl));
            }
        }
        lanes.lanes.add(this.createCueMarkers());
        this.mProject.arrangement = arrangement;
    }

    private Scene createScene(DxB dxB2) {
        Scene scene = new Scene();
        scene.name = dxB2.CwM();
        scene.color = this.getColor(dxB2.XSQ());
        Lanes lanes = new Lanes();
        scene.content = lanes;
        int n2 = dxB2.khV();
        for (cRC cRC2 : this.mAllTracks) {
            xYE xYE2 = cRC2.OqD(n2);
            ClipSlot clipSlot = new ClipSlot();
            clipSlot.track = (Track)this.mTrackToTrackMap.get(cRC2);
            clipSlot.hasStop = xYE2.aMy();
            lanes.lanes.add(clipSlot);
            eLk eLk2 = xYE2.FDA();
            if (eLk2 == null) continue;
            clipSlot.clip = this.createClip(eLk2);
            this.addClipAutomation(clipSlot.clip, eLk2);
        }
        return scene;
    }

    private Points createPoints(sac sac2) {
        xM2 xM22 = sac2.zdJ();
        if (xM22 instanceof UfF) {
            UfF ufF2 = (UfF)xM22;
            Points points = this.createPoints(sac2.JWq(), Unit.percent);
            switch (ufF2.Fbv()) {
                case OqD: {
                    points.target.expression = ExpressionType.channelController;
                    points.target.controller = ufF2.TEp();
                    break;
                }
                case Opd: {
                    points.target.expression = ExpressionType.channelPressure;
                    break;
                }
                case CwM: {
                    points.target.expression = ExpressionType.pitchBend;
                }
            }
            points.target.channel = ufF2.OqD();
            return points;
        }
        Parameter parameter = this.getParameter(xM22);
        assert (bCe.OqD(parameter != null));
        Points points = this.createPoints(sac2.JWq(), this.getUnit(parameter));
        points.target.parameter = parameter;
        return points;
    }

    private Unit getUnit(Parameter parameter) {
        if (parameter instanceof RealParameter) {
            return ((RealParameter)parameter).unit;
        }
        return null;
    }

    private Points createPoints(rmR rmR2, Unit unit) {
        Points points = new Points();
        Fmg fmg = rmR2.ai_();
        boolean bl2 = fmg instanceof sBm;
        points.interpolation = bl2 ? Interpolation.linear : Interpolation.hold;
        points.unit = unit;
        for (LMb lMb : rmR2.dS_()) {
            Object object;
            Object object2;
            if (lMb instanceof h1m) {
                object2 = new RealPoint();
                ((RealPoint)object2).time = lMb.eOr();
                ((RealPoint)object2).value = this.convertValue(((h1m)lMb).CwM(), (sBm)fmg, unit);
                points.points.add(object2);
                continue;
            }
            if (lMb instanceof Bgu) {
                object2 = new BoolPoint();
                ((BoolPoint)object2).time = lMb.eOr();
                ((BoolPoint)object2).value = ((Bgu)lMb).IkS();
                points.points.add(object2);
                continue;
            }
            if (lMb instanceof DTH) {
                object2 = (DTH)lMb;
                object = new EnumPoint();
                mLX mLX2 = (mLX)((LMb)object2).fn();
                ((EnumPoint)object).time = lMb.eOr();
                ((EnumPoint)object).value = mLX2.Opd(((PAm)object2).IkS());
                points.points.add(object);
                continue;
            }
            if (lMb instanceof wbL) {
                object2 = new IntegerPoint();
                ((IntegerPoint)object2).time = lMb.eOr();
                ((IntegerPoint)object2).value = ((wbL)lMb).pqS();
                points.points.add(object2);
                continue;
            }
            if (!(lMb instanceof MIE)) continue;
            object2 = new TimeSignaturePoint();
            ((TimeSignaturePoint)object2).time = lMb.eOr();
            object = (MIE)lMb;
            ((TimeSignaturePoint)object2).numerator = ((fFQ)object).Ugn();
            ((TimeSignaturePoint)object2).denominator = ((fFQ)object).eSQ();
            points.points.add(object2);
        }
        return points;
    }

    private Parameter getParameter(xM2 xM22) {
        return (Parameter)this.mAtomReferences.get(xM22);
    }

    private Markers createCueMarkers() {
        JRh jRh2 = this.mSourceProject.pMu().jyg().ynG();
        Markers markers = new Markers();
        for (dkQ dkQ2 : jRh2.dS_()) {
            Marker marker = new Marker();
            marker.time = dkQ2.eOr();
            marker.name = dkQ2.CwM();
            marker.color = this.getColor(dkQ2.hFR());
            markers.markers.add(marker);
        }
        return markers;
    }

    private String getColor(HkO hkO) {
        return hkO.AaH() ? null : hkO.IwJ();
    }

    private Clip createArrangerClip(eLk eLk2) {
        return this.createClip(eLk2);
    }

    private Clip createClip(eLk eLk2) {
        Clip clip = new Clip();
        clip.name = eLk2.Uft();
        clip.color = this.getColor(eLk2.HwE());
        clip.time = eLk2.eOr();
        clip.duration = eLk2.g3A();
        clip.playStart = eLk2.yUQ();
        if (eLk2.yfC()) {
            clip.loopStart = eLk2.yC3().eOr();
            clip.loopEnd = eLk2.yC3().QEO();
        }
        if (eLk2 instanceof Zia) {
            Zia zia = (Zia)eLk2;
            clip.fadeInTime = zia.OqD();
            clip.fadeOutTime = zia.LTX();
            clip.content = this.createAudioEventTimeline(zia.oe1());
        } else if (eLk2 instanceof wE) {
            clip.content = this.createNoteTimeline(((wE)eLk2).alk());
        }
        return clip;
    }

    private void addClipAutomation(Clip clip, eLk eLk2) {
        List list = eLk2.uQe().wJM();
        if (list.isEmpty()) {
            return;
        }
        Lanes lanes = new Lanes();
        lanes.lanes.add(clip.content);
        clip.content = lanes;
        for (qPN qPN2 : list) {
            lanes.lanes.add(this.createPoints(qPN2));
        }
    }

    private Notes createNoteTimeline(bi bi2) {
        Notes notes = new Notes();
        bi2.cmM().alk().forEach(owx -> notes.notes.add(this.createNote((KNg)owx)));
        return notes;
    }

    private Clips createAudioEventTimeline(bFX bFX2) {
        mF mF2 = bFX2.jxk();
        if (mF2 == null) {
            return null;
        }
        Clips clips = new Clips();
        for (zKD zKD2 : mF2.dS_()) {
            clips.clips.add(this.createAudioNote(zKD2));
        }
        return clips;
    }

    private Clip createAudioNote(zKD zKD2) {
        Clip clip = new Clip();
        clip.time = zKD2.eOr();
        clip.duration = zKD2.g3A();
        Audio audio = this.createAudio(zKD2);
        Audio audio2 = zKD2.nSA() == DPB.CwM ? audio : this.createWarps(zKD2.lMH(), audio);
        clip.content = this.wrapAudioContentWithExpressions(zKD2, (Timeline)audio2);
        return clip;
    }

    private Timeline wrapAudioContentWithExpressions(zKD zKD2, Timeline timeline) {
        Uws uws2 = zKD2.RgE();
        List list = uws2.FUz();
        if (!list.isEmpty()) {
            Lanes lanes = new Lanes();
            lanes.lanes.add(timeline);
            for (SDO sDO : list) {
                lanes.lanes.add(this.createExpressionTimeline(sDO));
            }
            return lanes;
        }
        return timeline;
    }

    private Audio createAudio(zKD zKD2) {
        Audio audio = new Audio();
        YFa yFa = zKD2.jxk();
        File file = this.getFile(yFa);
        if (!this.mEmbeddedFiles.containsKey(file)) {
            String string = this.getUniquePath("samples/" + file.getName());
            this.embed(string, file);
        }
        audio.file.path = (String)this.mEmbeddedFiles.get(file);
        audio.duration = yFa.EuM();
        audio.samplerate = yFa.alk();
        audio.channels = yFa.IkS();
        audio.algorithm = zKD2.nSA().OqD();
        return audio;
    }

    private File getFile(YFa yFa) {
        File file = yFa.gav();
        if (file != null) {
            return file;
        }
        IoM ioM = yFa.BaN();
        String string = ioM.aMy();
        if (string != null && !string.isEmpty()) {
            return this.mSourceProject.aMy().Opd(string);
        }
        tsK tsK2 = ioM.YHh();
        return new File(tsK2.OqD());
    }

    private Warps createWarps(VAg vAg, Audio audio) {
        int n2 = vAg.fn();
        Warps warps = new Warps();
        warps.timebase = Timebase.seconds;
        warps.content = audio;
        for (int i2 = 0; i2 < n2; ++i2) {
            LJz lJz = vAg.Opd(i2);
            Warp warp = new Warp();
            warp.time = lJz.eOr();
            warp.warped = lJz.OqD();
            warps.events.add(warp);
        }
        return warps;
    }

    private String getUniquePath(String string) {
        for (String string2 : this.mEmbeddedFiles.values()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            int n2 = string.lastIndexOf(".");
            if (n2 == -1) {
                return this.getUniquePath(string + "2");
            }
            return this.getUniquePath(string.substring(0, n2) + "2" + string.substring(n2));
        }
        return string;
    }

    private Note createNote(KNg kNg) {
        Note note = new Note();
        note.time = kNg.eOr();
        note.duration = kNg.g3A();
        note.channel = kNg.nGB();
        note.key = kNg.aD_();
        note.velocity = kNg.LTX();
        note.releaseVelocity = kNg.uwB();
        JEK jEK = kNg.oGr();
        List list = jEK.FUz();
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                note.content = this.createExpressionTimeline((SDO)list.get(0));
            } else {
                Lanes lanes = new Lanes();
                note.content = lanes;
                for (SDO sDO : list) {
                    lanes.lanes.add(this.createExpressionTimeline(sDO));
                }
            }
        }
        return note;
    }

    private Points createExpressionTimeline(SDO sDO) {
        Unit unit = this.getExpressionUnit(sDO.GYe());
        Points points = this.createPoints(sDO, unit);
        points.target.expression = this.getExpression(sDO.GYe());
        points.unit = unit;
        return points;
    }

    private ExpressionType getExpression(String string) {
        if (string.equals("amplitude")) {
            return ExpressionType.gain;
        }
        if (string.equals("panning")) {
            return ExpressionType.pan;
        }
        if (string.equals("transpose")) {
            return ExpressionType.transpose;
        }
        if (string.equals("timbre")) {
            return ExpressionType.timbre;
        }
        if (string.equals("formant")) {
            return ExpressionType.formant;
        }
        if (string.equals("pressure")) {
            return ExpressionType.pressure;
        }
        return null;
    }

    private Unit getExpressionUnit(String string) {
        if (string.equals("amplitude")) {
            return Unit.linear;
        }
        if (string.equals("panning")) {
            return Unit.linear;
        }
        if (string.equals("transpose")) {
            return Unit.semitones;
        }
        if (string.equals("timbre")) {
            return Unit.linear;
        }
        if (string.equals("formant")) {
            return Unit.semitones;
        }
        if (string.equals("pressure")) {
            return Unit.linear;
        }
        return null;
    }

    public SendType getEffectiveSendMode(Frx frx) {
        cEK cEK2 = frx.RjC();
        if (cEK2 == cEK.CwM) {
            BOF bOF2 = frx.b2R();
            cRC cRC2 = bOF2.oEn();
            return cRC2.IMp() ? SendType.pre : SendType.post;
        }
        if (cEK2 == cEK.Opd) {
            return SendType.pre;
        }
        return SendType.post;
    }

    private Device createDevice(uMF uMF2) {
        if (uMF2 instanceof Mnd) {
            return this.createVst3Device((Mnd)uMF2);
        }
        if (uMF2 instanceof LqD) {
            return this.createVst2Device((LqD)uMF2);
        }
        if (uMF2 instanceof Jp) {
            return this.createBuiltinDevice((Jp)uMF2);
        }
        return null;
    }

    private Vst3Plugin createVst3Device(Mnd mnd) {
        Vst3Plugin vst3Plugin = new Vst3Plugin();
        this.initPlugin(mnd, (Plugin)vst3Plugin);
        vst3Plugin.deviceID = mnd.jbV().OqD();
        return vst3Plugin;
    }

    private Vst2Plugin createVst2Device(LqD lqD) {
        Vst2Plugin vst2Plugin = new Vst2Plugin();
        this.initPlugin(lqD, (Plugin)vst2Plugin);
        return vst2Plugin;
    }

    private BuiltinDevice createBuiltinDeviceObject(Jp jp2, ArrayList arrayList) {
        UUID uUID = jp2.CyZ().OqD();
        boolean bl2 = uUID.equals(kLR.nce);
        boolean bl3 = uUID.equals(kLR.YHh);
        boolean bl4 = uUID.equals(kLR.Ugn);
        if (bl2 || bl3) {
            Equalizer equalizer = new Equalizer();
            int n2 = bl2 ? 8 : 5;
            for (int i2 = 0; i2 < n2; ++i2) {
                EqBand eqBand = new EqBand();
                int n3 = i2 + 1;
                eqBand.freq = (RealParameter)this.createParameter(this.getDeviceParameter(jp2, "FREQ" + n3));
                eqBand.gain = (RealParameter)this.createParameter(this.getDeviceParameter(jp2, "GAIN" + n3));
                eqBand.Q = (RealParameter)this.createParameter(this.getDeviceParameter(jp2, "Q" + n3));
                eqBand.enabled = (BoolParameter)this.createParameter((xM2)jp2.XSQ("CONTENTS/ENABLE" + n3));
                cNN cNN2 = cNN.CwM(this.getIndexedValueAtom(jp2, "TYPE" + n3).CwM());
                eqBand.type = this.convertEqType(cNN2);
                eqBand.order = this.convertEqOrder(cNN2);
                if (eqBand.type == null) continue;
                equalizer.bands.add(eqBand);
            }
            return equalizer;
        }
        if (bl4) {
            Equalizer equalizer = new Equalizer();
            String[] stringArray = new String[]{"LO_FREQ", "HI_FREQ"};
            String[] stringArray2 = new String[]{"LO_GAIN", "HI_GAIN"};
            String[] stringArray3 = new String[]{"LO_Q", "HI_Q"};
            String[] stringArray4 = new String[]{"TYPE1", "HI_TYPE"};
            String[] stringArray5 = new String[]{"LO_ENABLE", "HI_ENABLE"};
            for (int i3 = 0; i3 < 2; ++i3) {
                EqBand eqBand = new EqBand();
                eqBand.freq = (RealParameter)this.createParameter(this.getDeviceParameter(jp2, stringArray[i3]));
                eqBand.gain = (RealParameter)this.createParameter(this.getDeviceParameter(jp2, stringArray2[i3]));
                eqBand.Q = (RealParameter)this.createParameter(this.getDeviceParameter(jp2, stringArray3[i3]));
                eqBand.enabled = (BoolParameter)this.createParameter((xM2)jp2.XSQ("CONTENTS/" + stringArray5[i3]));
                cNN cNN3 = cNN.CwM(this.getIndexedValueAtom(jp2, stringArray4[i3]).CwM());
                eqBand.type = this.convertEqType(cNN3);
                eqBand.order = this.convertEqOrder(cNN3);
                if (eqBand.type == null) continue;
                equalizer.bands.add(eqBand);
            }
            return equalizer;
        }
        return new BuiltinDevice();
    }

    private EqBandType convertEqType(cNN cNN2) {
        switch (cNN2) {
            case CwM: {
                return null;
            }
            case Opd: 
            case OqD: 
            case m2i: 
            case hFR: 
            case LTX: {
                return EqBandType.lowPass;
            }
            case uwB: 
            case dhb: 
            case aMy: 
            case alk: 
            case EuM: {
                return EqBandType.highPass;
            }
            case IkS: 
            case AaH: {
                return EqBandType.bandPass;
            }
            case WW1: {
                return EqBandType.bell;
            }
            case urx: {
                return EqBandType.notch;
            }
            case nSA: {
                return EqBandType.lowShelf;
            }
            case gav: {
                return EqBandType.highShelf;
            }
            case Xb: {
                return null;
            }
        }
        return null;
    }

    private int convertEqOrder(cNN cNN2) {
        switch (cNN2) {
            case CwM: 
            case Xb: {
                return 0;
            }
            case LTX: 
            case dhb: {
                return 1;
            }
            case Opd: 
            case uwB: 
            case IkS: 
            case WW1: 
            case urx: 
            case nSA: 
            case gav: {
                return 2;
            }
            case OqD: 
            case aMy: 
            case AaH: {
                return 4;
            }
            case m2i: 
            case alk: {
                return 6;
            }
            case hFR: 
            case EuM: {
                return 8;
            }
        }
        return 0;
    }

    private rUO getIndexedValueAtom(Jp jp2, String string) {
        rUO rUO2 = (rUO)jp2.XSQ("CONTENTS/" + string);
        assert (bCe.OqD(rUO2 != null));
        return rUO2;
    }

    private xM2 getDeviceParameter(Jp jp2, String string) {
        xM2 xM22 = (xM2)jp2.XSQ("CONTENTS/" + string);
        assert (bCe.OqD(xM22 != null));
        return xM22;
    }

    private BuiltinDevice createBuiltinDevice(Jp jp2) {
        ArrayList arrayList = new ArrayList();
        BuiltinDevice builtinDevice = this.createBuiltinDeviceObject(jp2, arrayList);
        this.initDevice(jp2, (Device)builtinDevice);
        builtinDevice.deviceID = jp2.CyZ().OqD().toString();
        jp2.tla().LTX(rEY -> {
            xM2 xM22;
            if (rEY instanceof xM2 && (xM22 = (xM2)rEY).hCF()) {
                builtinDevice.automatedParameters.add(this.createParameter(xM22));
            }
        });
        return builtinDevice;
    }

    private void initDevice(uMF uMF2, Device device) {
        device.name = uMF2.wJM();
        device.deviceName = uMF2.pqS();
        device.enabled = (BoolParameter)this.createParameter(uMF2.AaW());
        device.loaded = uMF2.LrP();
    }

    private void initPlugin(CtA ctA2, Plugin plugin) {
        this.initDevice(ctA2, (Device)plugin);
        plugin.deviceID = ctA2.jbV().OqD();
        YjJ yjJ = ctA2.tla();
        File file = this.getFile(yjJ.ipu());
        if (file.exists()) {
            plugin.state = new FileReference();
            plugin.state.path = "plugins/" + file.getName();
            this.embed(plugin.state.path, file);
        }
        for (ACV aCV2 : yjJ.pqS()) {
            if (!aCV2.hCF()) continue;
            plugin.automatedParameters.add(this.createParameter(aCV2));
        }
    }

    File getFile(String string) {
        return new File(Xc2.eSp(), string);
    }

    void embed(String string, File file) {
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        this.mEmbeddedFiles.put(file, string);
    }
}

