/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ValueChangedCallback;
import com.bitwig.extension.controller.api.Value;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import java.util.ArrayList;
import java.util.List;

public abstract class ValueProxy
extends ControlSurfaceProxy
implements Value {
    protected List mObservers;
    private boolean mIsInterested = this.shouldBeInterestedByDefault();

    protected ValueProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    protected boolean shouldBeInterestedByDefault() {
        return this.getRequiredApiVersion() == 1;
    }

    protected final void checkCanGet() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.newSince(2);
        if (!this.mIsInterested) {
            throw new aRB("Either call markInterested() or add at least one observer in init in order to access the current value");
        }
        if (!this.isSubscribed()) {
            throw new aRB("Trying to get a value while not being subscribed.");
        }
    }

    @Override
    protected boolean isInterested() {
        assert (bCi.CwM(this.mObservers != null ? this.mIsInterested : true));
        return this.mIsInterested;
    }

    @Override
    public void markInterested() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.newSince(2);
        this.checkIsInitializingDriver();
        this.doMarkInterested();
    }

    protected final void doMarkInterested() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInitializingDriver()));
        this.mIsInterested = true;
    }

    protected final void doAddValueObserver(ValueChangedCallback valueChangedCallback) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(valueChangedCallback, "callback");
        this.doMarkInterested();
        if (this.mObservers == null) {
            this.mObservers = new ArrayList(2);
        }
        this.mObservers.add(valueChangedCallback);
        if (this.wantsToSendInitialDefaultValue()) {
            this.queueCallbackFromNonDocumentThread(() -> this.sendDefaultValue(valueChangedCallback));
        }
    }

    protected boolean wantsToSendInitialDefaultValue() {
        return true;
    }

    protected abstract void sendDefaultValue(ValueChangedCallback var1);
}

