/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class StringValueProxy
extends ValueProxy
implements TgC,
StringValue {
    private fcK mValue;
    private final fcK mDefaultValue;

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.mValue = this.mDefaultValue = this.createTruncatableString(string);
    }

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, "");
    }

    @Override
    public Class getTargetType() {
        return qdp.class;
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        assert (bCi.OqD(n2 >= 1));
        return this.mValue.getLimited(n2);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.notNull(stringValueChangedCallback, "callback");
        this.doAddValueObserver(fcK2 -> stringValueChangedCallback.valueChanged(fcK2.get()));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.notNull(stringValueChangedCallback, "callback");
        this.doAddValueObserver(fcK2 -> {
            if (fcK2 == this.mDefaultValue) {
                stringValueChangedCallback.valueChanged(string);
            } else {
                stringValueChangedCallback.valueChanged(fcK2.getLimited(n2));
            }
        });
    }

    protected void sendDefaultValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        controlSurfaceStringValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(qdp qdp2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(qdp2 != null));
        if (qdp2.isObservable()) {
            qdp2.removeListener(this);
        }
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(qdp qdp2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(qdp2 != null));
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(this.isActiveOnDocumentThread()));
        if (qdp2.isObservable()) {
            qdp2.addListener(this);
        }
        this.updateValue();
    }

    public fcK getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(Svx svx) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.getTarget() != null));
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(Objects.equals(svx.CwM(), this.getTarget())));
        this.updateValue();
    }

    private void updateValue() {
        assert (bCi.OqD(this.isDocumentThread()));
        String string = (String)((qdp)this.getTarget()).getValue();
        assert (bCi.OqD(string != null));
        fcK fcK2 = this.createTruncatableString(string);
        assert (bCi.OqD(fcK2 != null));
        this.queueNotifyObservers(fcK2);
    }

    private void queueNotifyObservers(fcK fcK2) {
        assert (bCi.OqD(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(fcK2));
    }

    protected fcK createTruncatableString(String string) {
        assert (bCi.OqD(this.isDocumentThread() || this.isInitializingDriver()));
        if (string.isEmpty()) {
            return fcK.EMPTY;
        }
        return new Pma(string);
    }

    private void notifyObservers(fcK fcK2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInterested()));
        if (!fcK2.equals(this.mValue)) {
            this.mValue = fcK2;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(fcK2);
                }
            }
        }
    }
}

