/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableStringValueProxy;
import com.bitwig.ramona.core.TH1;

public class StringSetting
extends SettableStringValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private TVw mIsEnabled;
    private TVw mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private TH1 mSetting;

    public StringSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String string3) {
        super(controlSurfaceObject, string3);
        this.notEmpty(string, "label");
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(Oc2 oc2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(oc2 != null));
        assert (bCi.hFR(this.mSetting == null));
        this.mSetting = oc2;
        this.setTarget(oc2.alk());
        this.connectEnableAndVisibleValues(oc2.bBu(), oc2.ynG());
    }

    public void disconnectFromSetting(Oc2 oc2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(oc2 != null));
        assert (bCi.hFR(this.mSetting == oc2));
        this.disconnectEnableAndVisibleValues(oc2.bBu(), oc2.ynG());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(h1t h1t2) {
        assert (bCi.hFR(this.mSetting == null));
        this.mSetting = h1t2;
        this.setTarget(h1t2.CwM());
        this.connectEnableAndVisibleValues(h1t2.aMy(), h1t2.alk());
    }

    public void disconnectFromSetting(h1t h1t2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(h1t2 != null));
        assert (bCi.hFR(this.mSetting == h1t2));
        this.disconnectEnableAndVisibleValues(h1t2.aMy(), h1t2.alk());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(TVw tVw, TVw tVw2) {
        this.mIsEnabled = tVw;
        this.mIsVisible = tVw2;
    }

    private void disconnectEnableAndVisibleValues(TVw tVw, TVw tVw2) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public TH1 getSetting() {
        return this.mSetting;
    }
}

