/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ObjectValueChangedCallback;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Arrays;
import java.util.Objects;

public class StringArrayValueProxy
extends ValueProxy
implements TgC,
StringArrayValue {
    private final String[] mDefaultValue;
    private String[] mValue;

    public StringArrayValueProxy(ControlSurfaceObject controlSurfaceObject, String[] stringArray) {
        super(controlSurfaceObject);
        this.mDefaultValue = stringArray;
        this.mValue = stringArray;
    }

    @Override
    public Class getTargetType() {
        return Bg.class;
    }

    @Override
    public String[] get() {
        this.checkCanGet();
        return this.mValue;
    }

    public void addValueObserver(ObjectValueChangedCallback objectValueChangedCallback) {
        this.doAddValueObserver(objectValueChangedCallback);
    }

    protected void sendDefaultValue(ObjectValueChangedCallback objectValueChangedCallback) {
        objectValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void connectToTarget(Bg bg2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(bg2 != null));
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(this.isActiveOnDocumentThread()));
        bg2.addListener(this);
        this.queueNotifyObservers((String[])bg2.getValue());
    }

    protected void disconnectFromTarget(Bg bg2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(bg2 != null));
        bg2.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    public void eventOccurred(Svx svx) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(this.getTarget() != null));
        assert (bCi.OqD(Objects.equals(svx.CwM(), this.getTarget())));
        String[] stringArray = (String[])((Bg)this.getTarget()).getValue();
        this.queueNotifyObservers(stringArray);
    }

    private void queueNotifyObservers(String[] stringArray) {
        assert (bCi.OqD(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(stringArray));
    }

    private void notifyObservers(String[] stringArray) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInterested()));
        if (!Arrays.equals(stringArray, this.mValue)) {
            this.mValue = stringArray;
            if (this.mObservers != null) {
                for (ObjectValueChangedCallback objectValueChangedCallback : this.mObservers) {
                    objectValueChangedCallback.valueChanged(stringArray);
                }
            }
        }
    }
}

