/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SignalProxy;
import com.bitwig.ramona.core.TH1;

public class SignalSetting
extends SignalProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final String mAction;
    private TVw mIsEnabled;
    private TVw mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private TH1 mSetting;

    public SignalSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String string3) {
        super(controlSurfaceObject);
        if (string == null || string.isEmpty()) {
            throw new aRB("Error: label for setting can't be empty.");
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mAction = string3;
    }

    public void connectToSetting(wh wh2) {
        assert (bCi.hFR(this.mSetting == null));
        this.mSetting = wh2;
        this.setTarget(wh2.EuM());
        this.connectEnableAndVisibleValues(wh2.bBu(), wh2.ynG());
    }

    public void disconnectFromSetting(wh wh2) {
        assert (bCi.hFR(this.mSetting == wh2));
        this.disconnectEnableAndVisibleValues(wh2.bBu(), wh2.ynG());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(xoM xoM2) {
        assert (bCi.hFR(this.mSetting == null));
        this.mSetting = xoM2;
        this.setTarget(xoM2.OqD());
        this.connectEnableAndVisibleValues(xoM2.aMy(), xoM2.alk());
    }

    public void disconnectFromSetting(xoM xoM2) {
        assert (bCi.hFR(this.mSetting == xoM2));
        this.disconnectEnableAndVisibleValues(xoM2.aMy(), xoM2.alk());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(TVw tVw, TVw tVw2) {
        this.mIsEnabled = tVw;
        this.mIsVisible = tVw2;
    }

    private void disconnectEnableAndVisibleValues(TVw tVw, TVw tVw2) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public String getAction() {
        return this.mAction;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public TH1 getSetting() {
        return this.mSetting;
    }
}

