/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.EnumValueChangedCallback;
import com.bitwig.extension.controller.api.EnumDefinition;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.EnumDefinitionImpl;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class EnumValueProxy
extends ValueProxy
implements TgC,
SettableEnumValue {
    private String mValue;
    private final String mInitialValue;
    private final String[] mOptions;
    private final EnumDefinitionImpl mEnumDefintion;

    public EnumValueProxy(ControlSurfaceObject controlSurfaceObject, String[] stringArray, String string) {
        super(controlSurfaceObject);
        assert (bCi.OqD(stringArray != null));
        assert (bCi.hFR(stringArray.length > 0));
        this.mOptions = stringArray;
        this.mInitialValue = string;
        this.mValue = string;
        this.mEnumDefintion = new EnumDefinitionImpl(stringArray);
    }

    @Override
    public Class getTargetType() {
        return qdp.class;
    }

    public void addValueObserver(EnumValueChangedCallback enumValueChangedCallback) {
        this.doAddValueObserver(enumValueChangedCallback);
    }

    protected void sendDefaultValue(EnumValueChangedCallback enumValueChangedCallback) {
        enumValueChangedCallback.valueChanged(this.mInitialValue);
    }

    @Override
    public void set(String string) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (string == null) {
            throw new aRB("value cannot be null");
        }
        this.exec(() -> this.doSet(string));
    }

    private void doSet(String string) {
        assert (bCi.OqD(this.isDocumentThread()));
        qdp qdp2 = (qdp)this.getTarget();
        if (qdp2 != null) {
            qdp2.setValue(string);
        }
    }

    protected void disconnectFromTarget(qdp qdp2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(qdp2 != null));
        qdp2.removeListener(this);
        this.queueNotifyObservers(this.mInitialValue);
    }

    protected void connectToTarget(qdp qdp2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(qdp2 != null));
        qdp2.addListener(this);
        this.queueNotifyObservers((String)qdp2.getValue());
    }

    public String[] getOptions() {
        return this.mOptions;
    }

    public String getDefaultValue() {
        return this.mInitialValue;
    }

    public void eventOccurred(Svx svx) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.getTarget() != null));
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(Objects.equals(svx.CwM(), this.getTarget())));
        String string = (String)((qdp)this.getTarget()).getValue();
        this.queueNotifyObservers(string);
    }

    private void queueNotifyObservers(String string) {
        assert (bCi.OqD(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(string));
    }

    private void notifyObservers(String string) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInterested()));
        if (!string.equals(this.mValue)) {
            this.mValue = string;
            if (this.mObservers != null) {
                for (EnumValueChangedCallback enumValueChangedCallback : this.mObservers) {
                    enumValueChangedCallback.valueChanged(string);
                }
            }
        }
    }

    @Override
    public String get() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    @Override
    public EnumDefinition enumDefinition() {
        this.newSince(11);
        return this.mEnumDefintion;
    }
}

