/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.EnumValueProxy;
import com.bitwig.ramona.core.TH1;

public class EnumSetting
extends EnumValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private TVw mIsEnabled;
    private TVw mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private TH1 mSetting;

    public EnumSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String[] stringArray, String string3) {
        super(controlSurfaceObject, stringArray, string3);
        if (string == null || string.isEmpty()) {
            throw new aRB("Error: label for setting can't be empty.");
        }
        if (stringArray.length < 2) {
            throw new aRB("Enum settings should have at least two options.");
        }
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(wtY wtY2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(wtY2 != null));
        assert (bCi.hFR(this.mSetting == null));
        this.mSetting = wtY2;
        this.setTarget(wtY2.alk());
        this.connectEnableAndVisibleValues(wtY2.bBu(), wtY2.ynG());
    }

    public void disconnectFromSetting(wtY wtY2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(wtY2 != null));
        assert (bCi.hFR(this.mSetting == wtY2));
        this.disconnectEnableAndVisibleValues(wtY2.bBu(), wtY2.ynG());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(zAt zAt2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.hFR(this.mSetting == null));
        assert (bCi.OqD(zAt2 != null));
        this.mSetting = zAt2;
        this.setTarget(zAt2.CwM());
        this.connectEnableAndVisibleValues(zAt2.aMy(), zAt2.alk());
    }

    public void disconnectFromSetting(zAt zAt2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(zAt2 != null));
        assert (bCi.hFR(this.mSetting == zAt2));
        this.disconnectEnableAndVisibleValues(zAt2.aMy(), zAt2.alk());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(TVw tVw, TVw tVw2) {
        this.mIsEnabled = tVw;
        this.mIsVisible = tVw2;
    }

    private void disconnectEnableAndVisibleValues(TVw tVw, TVw tVw2) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public TH1 getSetting() {
        return this.mSetting;
    }
}

