/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.flt.control_surface.values.DoubleValueWithValueTypeRangedValueTarget;
import com.bitwig.flt.control_surface.values.RangedValueTarget;
import com.bitwig.ramona.core.CH;

public class DoubleValueRangedValueTarget
extends RangedValueTarget {
    private final String mName;
    private final msk mDoubleValue;
    private final double mMin;
    private final double mMax;

    public static RangedValueTarget createForAttribute(CH cH2) {
        assert (bCi.OqD(cH2 != null));
        UAH uAH = K1.CwM(cH2);
        assert (bCi.OqD(uAH != null ? uAH instanceof cd3 : true));
        if (uAH instanceof cd3) {
            return new DoubleValueWithValueTypeRangedValueTarget(cH2.IkS(), cH2, (cd3)uAH);
        }
        Double d2 = (Double)cH2.getMinValue();
        assert (bCi.OqD(d2 != null));
        Double d3 = (Double)cH2.getMaxValue();
        assert (bCi.OqD(d3 != null));
        return new DoubleValueRangedValueTarget(cH2.IkS(), cH2, d2 != null ? d2 : -1.7976931348623157E308, d3 != null ? d3 : Double.MAX_VALUE);
    }

    public DoubleValueRangedValueTarget(String string, msk msk2, double d2, double d3) {
        assert (bCi.OqD(string != null));
        assert (bCi.OqD(!string.isEmpty()));
        assert (bCi.OqD(msk2 != null));
        this.mName = string;
        this.mDoubleValue = msk2;
        this.mMin = d2;
        this.mMax = d3;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean isSettable() {
        return this.mDoubleValue.isSettable();
    }

    @Override
    public msk getValueChangedEventSource() {
        return this.mDoubleValue;
    }

    @Override
    public double getCurrentValue() {
        return this.mDoubleValue.getDoubleValue();
    }

    @Override
    public void setCurrentValue(double d2) {
        this.mDoubleValue.setDoubleValue(d2);
    }

    @Override
    public double valueToNormalizedValue(double d2) {
        double d3 = (d2 - this.getMinValue()) / (this.getMaxValue() - this.getMinValue());
        assert (bCi.OqD(d3 >= 0.0 && d3 <= 1.0));
        return d3;
    }

    @Override
    public double normalizedValueToValue(double d2) {
        assert (bCi.OqD(d2 >= 0.0 && d2 <= 1.0));
        return this.getMinValue() + d2 * (this.getMaxValue() - this.getMinValue());
    }

    @Override
    public fcK createTruncatableStringForCurrentValue() {
        return this.createTruncatableStringForValue(this.getCurrentValue());
    }

    @Override
    public fcK createTruncatableStringForCurrentModulatedValue() {
        return this.createTruncatableStringForCurrentValue();
    }

    public fcK createTruncatableStringForValue(double d2) {
        String string = String.valueOf(d2);
        return new cdA(string);
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    public double getMinValue() {
        return this.mMin;
    }

    private double getMaxValue() {
        return this.mMax;
    }
}

