/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.controller.api.DoubleValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class DoubleValueProxy
extends ValueProxy
implements TgC,
DoubleValue {
    private double mValue;
    private final double mDefaultValue;

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject, double d2) {
        super(controlSurfaceObject);
        this.mValue = d2;
        this.mDefaultValue = d2;
    }

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0.0);
    }

    @Override
    public Class getTargetType() {
        return msk.class;
    }

    @Override
    public double get() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public double getControlSurfaceValue() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        doubleValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(msk msk2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(msk2 != null));
        msk2.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(msk msk2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(msk2 != null));
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(this.isActiveOnDocumentThread()));
        msk2.addListener(this);
        this.queueNotifyObservers(msk2.getDoubleValue());
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(Svx svx) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.getTarget() != null));
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(Objects.equals(svx.CwM(), this.getTarget())));
        double d2 = ((msk)this.getTarget()).getDoubleValue();
        this.queueNotifyObservers(d2);
    }

    private void queueNotifyObservers(double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(d2));
    }

    private void notifyObservers(double d2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInterested()));
        if (d2 != this.mValue) {
            this.mValue = d2;
            if (this.mObservers != null) {
                for (DoubleValueChangedCallback doubleValueChangedCallback : this.mObservers) {
                    doubleValueChangedCallback.valueChanged(d2);
                }
            }
        }
    }
}

