/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;

public class ComputedStringValue
extends ComputedValue
implements StringValue {
    private fcK mValue;
    private fcK mDocumentValue;
    private final fcK mDefaultValue;

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject, fcK fcK2) {
        super(controlSurfaceObject);
        assert (bCi.OqD(fcK2 != null));
        this.mValue = fcK2;
        this.mDocumentValue = fcK2;
        this.mDefaultValue = fcK2;
    }

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, fcK.EMPTY);
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        return this.mValue.getLimited(n2);
    }

    public String getValue() {
        assert (bCi.OqD(this.isDocumentThread()));
        return this.mDocumentValue.get();
    }

    public void setValue(fcK fcK2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(fcK2 != null));
        if (!fcK2.equals(this.mDocumentValue)) {
            this.mDocumentValue = fcK2;
            if (this.isInterested()) {
                this.queueNotifyObservers(fcK2);
            }
        }
    }

    public final void setValue(String string) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(string != null));
        this.setValue(this.createControlSurfaceStringValue(string));
    }

    public void unassign() {
        assert (bCi.OqD(this.isDocumentThread()));
        this.setValue(this.mDefaultValue);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(fcK2 -> stringValueChangedCallback.valueChanged(fcK2.get()));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(fcK2 -> {
            if (fcK2 == this.mDefaultValue) {
                stringValueChangedCallback.valueChanged(string);
            } else {
                stringValueChangedCallback.valueChanged(fcK2.getLimited(n2));
            }
        });
    }

    protected void sendInitialValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        controlSurfaceStringValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(fcK fcK2) {
        assert (bCi.OqD(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(fcK2));
    }

    private void notifyObservers(fcK fcK2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInterested()));
        if (!fcK2.equals(this.mValue)) {
            this.mValue = fcK2;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(fcK2);
                }
            }
        }
    }

    protected fcK createControlSurfaceStringValue(String string) {
        assert (bCi.OqD(this.isDocumentThread() || this.isInitializingDriver()));
        assert (bCi.OqD(string != null));
        if (string.isEmpty()) {
            return fcK.EMPTY;
        }
        return new Pma(string);
    }

    protected fcK getControlSurfaceString() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.mValue != null));
        return this.mValue;
    }
}

