/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.controller.api.DoubleValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;

public class ComputedDoubleValue
extends ComputedValue
implements DoubleValue {
    private double mValue;
    private final double mDefaultValue;
    private final UAM mDocumentValue;
    private final boolean mCanBeReduced;

    public ComputedDoubleValue(ControlSurfaceObject controlSurfaceObject, double d2, boolean bl2) {
        super(controlSurfaceObject);
        this.mDefaultValue = d2;
        this.mValue = d2;
        this.mDocumentValue = new UAM(d2);
        this.mCanBeReduced = bl2;
    }

    public ComputedDoubleValue(ControlSurfaceObject controlSurfaceObject, double d2) {
        this(controlSurfaceObject, d2, true);
    }

    @Override
    public double get() {
        this.checkCanGet();
        return this.mValue;
    }

    public double getControlSurfaceValue() {
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(this.isControlSurfaceThread()));
        return this.mValue;
    }

    public msk getDocumentValue() {
        return this.mDocumentValue;
    }

    public double getValue() {
        assert (bCi.OqD(this.isDocumentThread()));
        return this.mDocumentValue.getDoubleValue();
    }

    public void setDoubleValue(double d2) {
        this.setDoubleValue(d2, true);
    }

    public void unassigned() {
        this.setDoubleValue(this.mDefaultValue, false);
    }

    private void setDoubleValue(double d2, boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(!bl2 ? d2 == this.mDefaultValue : true));
        if (d2 != this.mDocumentValue.getDoubleValue()) {
            this.mDocumentValue.setDoubleValue(d2);
            if (this.isInterested()) {
                this.queueNotifyObservers(d2, bl2);
            }
        }
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    protected void sendInitialValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        doubleValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(double d2, boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mCanBeReduced) {
            this.queueCallback(this, () -> this.notifyObservers(d2, bl2));
        } else {
            this.queueCallback(() -> this.notifyObservers(d2, bl2));
        }
    }

    private void notifyObservers(double d2, boolean bl2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(!bl2 ? d2 == this.mDefaultValue : true));
        if (d2 != this.mValue) {
            this.mValue = d2;
            if (this.mObservers != null) {
                for (DoubleValueChangedCallback doubleValueChangedCallback : this.mObservers) {
                    doubleValueChangedCallback.valueChanged(d2);
                }
            }
        }
    }
}

