/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.controller.api.ColorValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;

public class ComputedColorValue
extends ComputedValue
implements ColorValue {
    private HkO mValue;
    private HkO mDocumentValue;

    public ComputedColorValue(ControlSurfaceObject controlSurfaceObject, HkO hkO) {
        super(controlSurfaceObject);
        this.mValue = hkO;
        this.mDocumentValue = hkO;
    }

    @Override
    public float red() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        return this.mValue.LTX();
    }

    @Override
    public float green() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        return this.mValue.uwB();
    }

    @Override
    public float blue() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        return this.mValue.dhb();
    }

    @Override
    public float alpha() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.newSince(5);
        return this.mValue.aMy();
    }

    public HkO getValue() {
        assert (bCi.CwM(this.isDocumentThread()));
        return this.mDocumentValue;
    }

    public void setValue(HkO hkO) {
        assert (bCi.CwM(this.isDocumentThread()));
        if (!hkO.CwM(this.mDocumentValue)) {
            this.mDocumentValue = hkO;
            if (this.isInterested()) {
                this.queueNotifyObservers(hkO);
            }
        }
    }

    public void addValueObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.doAddValueObserver(colorValueChangedCallback);
    }

    protected void sendInitialValue(ColorValueChangedCallback colorValueChangedCallback) {
        colorValueChangedCallback.valueChanged(this.mValue.LTX(), this.mValue.uwB(), this.mValue.dhb());
    }

    private void queueNotifyObservers(HkO hkO) {
        assert (bCi.CwM(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(hkO));
    }

    private void notifyObservers(HkO hkO) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        assert (bCi.CwM(this.isInterested()));
        if (!hkO.CwM(this.mValue)) {
            this.mValue = hkO;
            if (this.mObservers != null) {
                for (ColorValueChangedCallback colorValueChangedCallback : this.mObservers) {
                    colorValueChangedCallback.valueChanged(hkO.LTX(), hkO.uwB(), hkO.dhb());
                }
            }
        }
    }
}

