/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.controller.api.ColorValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Objects;

public class ColorValueProxy
extends ValueProxy
implements TgC,
ColorValue {
    private final HkO mDefaultColor;
    private float mRed;
    private float mGreen;
    private float mBlue;
    private float mAlpha;

    public ColorValueProxy(ControlSurfaceObject controlSurfaceObject, float f4, float f5, float f6, float f7) {
        super(controlSurfaceObject);
        this.mDefaultColor = new HkO(f4, f5, f6, f7);
        this.mRed = f4;
        this.mGreen = f5;
        this.mBlue = f6;
        this.mAlpha = f7;
    }

    public ColorValueProxy(ControlSurfaceObject controlSurfaceObject, float f4, float f5, float f6) {
        this(controlSurfaceObject, f4, f5, f6, 1.0f);
    }

    public ColorValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public Class getTargetType() {
        return MEE.class;
    }

    @Override
    protected boolean wantsToSendInitialDefaultValue() {
        return false;
    }

    public void eventOccurred(Svx svx) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(this.isInterested()));
        assert (bCi.CwM(this.getTarget() != null));
        assert (bCi.CwM(Objects.equals(svx.CwM(), this.getTarget())));
        HkO hkO = (HkO)svx.Opd();
        this.queueNotifyObservers(hkO.LTX(), hkO.uwB(), hkO.dhb(), hkO.aMy());
    }

    @Override
    public float red() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mRed;
    }

    @Override
    public float green() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mGreen;
    }

    @Override
    public float blue() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mBlue;
    }

    @Override
    public float alpha() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.newSince(5);
        this.checkCanGet();
        return this.mAlpha;
    }

    public void addValueObserver(ColorValueChangedCallback colorValueChangedCallback) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.doAddValueObserver(colorValueChangedCallback);
    }

    protected void sendDefaultValue(ColorValueChangedCallback colorValueChangedCallback) {
        colorValueChangedCallback.valueChanged(this.mDefaultColor.LTX(), this.mDefaultColor.uwB(), this.mDefaultColor.dhb());
    }

    protected void connectToTarget(MEE mEE) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(mEE != null));
        assert (bCi.CwM(this.isInterested()));
        assert (bCi.CwM(this.isActiveOnDocumentThread()));
        mEE.addListener(this);
        HkO hkO = (HkO)mEE.getValue();
        this.queueNotifyObservers(hkO.LTX(), hkO.uwB(), hkO.dhb(), hkO.aMy());
    }

    protected void disconnectFromTarget(MEE mEE) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(mEE != null));
        mEE.removeListener(this);
        this.queueNotifyObservers(this.mDefaultColor.LTX(), this.mDefaultColor.uwB(), this.mDefaultColor.dhb(), this.mDefaultColor.aMy());
    }

    private void queueNotifyObservers(float f4, float f5, float f6, float f7) {
        assert (bCi.CwM(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(f4, f5, f6, f7));
    }

    private void notifyObservers(float f4, float f5, float f6, float f7) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        assert (bCi.CwM(this.isInterested()));
        if (this.mRed != f4 || this.mGreen != f5 || this.mBlue != f6 || this.mAlpha != f7) {
            this.mRed = f4;
            this.mGreen = f5;
            this.mBlue = f6;
            this.mAlpha = f7;
            if (this.mObservers != null) {
                for (ColorValueChangedCallback colorValueChangedCallback : this.mObservers) {
                    colorValueChangedCallback.valueChanged(f4, f5, f6);
                }
            }
        }
    }

    public HkO getDefaultColor() {
        return this.mDefaultColor;
    }
}

