/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.api.Color;
import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.prefs.Rbj;
import com.bitwig.ramona.core.TH1;

public class ColorSetting
extends SettableColorValueProxy
implements Setting {
    private final String mLabel;
    private final String mCategory;
    private TVw mIsEnabled;
    private TVw mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private TH1 mSetting;

    public ColorSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, Color color) {
        super(controlSurfaceObject, (float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(JNm jNm) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(jNm != null));
        assert (bCi.CwM(this.mSetting == null));
        this.mSetting = jNm;
        this.setTarget(jNm.CwM());
        this.connectEnableAndVisibleValues(jNm.aMy(), jNm.alk());
    }

    public void disconnectFromSetting(JNm jNm) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(jNm != null));
        assert (bCi.CwM(this.mSetting == jNm));
        this.disconnectEnableAndVisibleValues(jNm.aMy(), jNm.alk());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(sOB sOB2) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(sOB2 != null));
        assert (bCi.CwM(this.mSetting == null));
        this.mSetting = sOB2;
        this.setTarget(sOB2.alk());
        this.connectEnableAndVisibleValues(sOB2.bBu(), sOB2.ynG());
    }

    public void disconnectFromSetting(Rbj rbj) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(rbj != null));
        assert (bCi.CwM(this.mSetting == rbj));
        this.disconnectEnableAndVisibleValues(rbj.bBu(), rbj.ynG());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(TVw tVw, TVw tVw2) {
        this.mIsEnabled = tVw;
        this.mIsVisible = tVw2;
    }

    private void disconnectEnableAndVisibleValues(TVw tVw, TVw tVw2) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bCi.CwM(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public TH1 getSetting() {
        return this.mSetting;
    }
}

