/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.prefs.MCX;
import com.bitwig.ramona.core.TH1;

public class BooleanSetting
extends SettableBooleanValueProxy
implements Setting {
    private final String mLabel;
    private final String mCategory;
    private TVw mIsEnabled;
    private TVw mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private TH1 mSetting;

    public BooleanSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, boolean bl2) {
        super(controlSurfaceObject, bl2);
        this.mLabel = string;
        this.mCategory = string2;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    public void connectToSetting(iWH iWH2) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(iWH2 != null));
        assert (bCi.CwM(this.mSetting == null));
        this.mSetting = iWH2;
        this.setTarget(iWH2.CwM());
        this.connectEnableAndVisibleValues(iWH2.aMy(), iWH2.alk());
    }

    public void disconnectFromSetting(iWH iWH2) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(iWH2 != null));
        assert (bCi.CwM(this.mSetting == iWH2));
        this.disconnectEnableAndVisibleValues(iWH2.aMy(), iWH2.alk());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(fBv fBv2) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(fBv2 != null));
        assert (bCi.CwM(this.mSetting == null));
        this.mSetting = fBv2;
        this.setTarget(fBv2.alk());
        this.connectEnableAndVisibleValues(fBv2.bBu(), fBv2.ynG());
    }

    public void disconnectFromSetting(MCX mCX) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(mCX != null));
        assert (bCi.CwM(this.mSetting == mCX));
        this.disconnectEnableAndVisibleValues(mCX.bBu(), mCX.ynG());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(TVw tVw, TVw tVw2) {
        this.mIsEnabled = tVw;
        this.mIsVisible = tVw2;
    }

    private void disconnectEnableAndVisibleValues(TVw tVw, TVw tVw2) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        this.exec(() -> this.doSetIsEnabled(bl2));
    }

    private void doSetIsEnabled(boolean bl2) {
        assert (bCi.CwM(this.isDocumentThread()));
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setBoolValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        this.exec(() -> this.doSetIsShown(bl2));
    }

    private void doSetIsShown(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mIsVisible != null) {
            this.mIsVisible.setBoolValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public TH1 getSetting() {
        return this.mSetting;
    }
}

