/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy$IntegerScaledValueObserver;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.RangedValueTarget;
import com.bitwig.flt.control_surface.values.ValueProxy;
import com.bitwig.flt.prefs.wLI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;

public abstract class AbstractRangedValueProxy
extends ValueProxy
implements bmy,
SettableRangedValue {
    public static double TAKEOVER_THRESHOLD = 0.05;
    private double mRawValue;
    private double mNormalizedValue;
    private List mRawValueCallbacks;
    private List mIntegerScaledValueObservers;
    protected final ComputedStringValue mDisplayedValue = this.createDisplayedValue();
    private boolean mHasBeenCaught;
    private boolean mIsSettingValue;
    private double mLastSetNormalizedValue = -1.0;
    private c31 mValueChangedEventSource;
    private double mLastSetControllerValue = -1.0;
    private DoubleConsumer mNormalizedValueChangedListener;

    protected AbstractRangedValueProxy(ControlSurfaceObject controlSurfaceObject, double d2, double d3) {
        super(controlSurfaceObject);
        this.mRawValue = d2;
        this.mNormalizedValue = d3;
    }

    @Override
    public double getRaw() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mRawValue;
    }

    @Override
    public double get() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mNormalizedValue;
    }

    @Override
    public StringValue displayedValue() {
        this.newSince(2);
        return this.mDisplayedValue;
    }

    public ComputedStringValue getDisplayedValue() {
        return this.mDisplayedValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    @Override
    protected boolean wantsToSendInitialDefaultValue() {
        return false;
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (bCi.OqD(false));
        assert (bCi.OqD(this.isControlSurfaceThread()));
    }

    @Override
    public void addValueObserver(int n2, IntegerValueChangedCallback integerValueChangedCallback) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        if (n2 <= 1) {
            throw new aRB("Range must be > 1");
        }
        this.doMarkInterested();
        if (this.mIntegerScaledValueObservers == null) {
            this.mIntegerScaledValueObservers = new ArrayList(2);
        }
        this.mIntegerScaledValueObservers.add(new AbstractRangedValueProxy$IntegerScaledValueObserver(n2, integerValueChangedCallback));
    }

    @Override
    public final void set(Number number, Number number2) {
        double d2;
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (number == null || number2 == null) {
            throw new aRB("Cannot provide null for value or resolution");
        }
        double d3 = number.doubleValue();
        if (d3 > (d2 = number2.doubleValue()) - 1.0) {
            this.getControlSurface().Opd("Value must be <= range - 1. Setting value to range - 1");
        }
        if (d3 < 0.0) {
            this.getControlSurface().Opd("Value must be >= 0. Setting value to 0");
        }
        d3 = f2f.Opd(d3, 0.0, d2 - 1.0);
        assert (bCi.OqD(number != null));
        assert (bCi.OqD(number2 != null));
        double d4 = d2 >= 2.0 ? 1.0 / (d2 - 1.0) : 1.0;
        double d5 = d3 * d4;
        assert (bCi.OqD(d5 >= 0.0 && d5 <= 1.0));
        this.setNormalizedValue(d5, this.shouldSetImmediately());
    }

    @Override
    public final void set(double d2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.inRange(d2, 0.0, 1.0, "value");
        this.setNormalizedValue(d2, this.shouldSetImmediately());
    }

    void updateHasBeenCaughtFromCurrentDistance() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.getTarget() != null) {
            this.mHasBeenCaught = this.mLastSetControllerValue == -1.0 ? false : AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(this.mLastSetControllerValue, this.getCurrentValue());
        }
    }

    private boolean shouldSetImmediately() {
        udo udo2 = this.getControlSurface();
        if (udo2.Uft().ynG()) {
            return !udo2.pqS().Ugn();
        }
        return false;
    }

    @Override
    public void setImmediately(double d2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.newSince(4);
        this.inRange(d2, 0.0, 1.0, "value");
        this.setNormalizedValue(d2, true);
    }

    private void setNormalizedValue(double d2, boolean bl2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(d2 >= 0.0 && d2 <= 1.0));
        this.postEvent(new zDK(this, d2, bl2, this.getTouchId()));
    }

    protected int getTouchId() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        return 0;
    }

    public void doSetNormalizedValueWithTakeOver(double d2, wLI wLI2, diN diN2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(d2 >= 0.0 && d2 <= 1.0));
        assert (bCi.OqD(wLI2 != null));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            boolean bl2;
            boolean bl3 = this.mLastSetControllerValue != -1.0;
            double d3 = d2 - this.mLastSetControllerValue;
            this.mLastSetControllerValue = d2;
            boolean bl4 = bl2 = !rangedValueTarget.isContinuous();
            if (this.mHasBeenCaught || wLI2 == wLI.CwM || bl2) {
                this.doSetNormalizedValueImmediately(d2);
            } else if (wLI2 == wLI.OqD) {
                assert (bCi.Opd(!this.mHasBeenCaught));
                double d4 = ((RangedValueTarget)this.getTarget()).getCurrentNormalizedValue();
                if (AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d2, d4)) {
                    this.doSetNormalizedValueImmediately(d2);
                    return;
                }
                if (bl3) {
                    boolean bl5 = d3 > 0.0;
                    double d5 = bl5 ? 1.0 : 0.0;
                    double d6 = d2 - d5;
                    double d7 = d4 - d5;
                    if (Math.abs(d6) > 0.01) {
                        double d8 = d7 / d6;
                        this.doIncNormalized(d3 * d8);
                    }
                }
                if (rangedValueTarget.shouldShowPopupNotifications()) {
                    this.doShowVisualizations();
                }
            } else {
                assert (bCi.OqD(!this.mHasBeenCaught));
                assert (bCi.OqD(wLI2 != wLI.CwM));
                double d9 = ((RangedValueTarget)this.getTarget()).getCurrentNormalizedValue();
                boolean bl6 = false;
                if (this.mLastSetNormalizedValue != -1.0) {
                    double d10 = diN2 != null ? diN2.alk(0) : d2;
                    bl6 = AbstractRangedValueProxy.shouldBeCaughtByMovement(this.mLastSetNormalizedValue, d10, d9, wLI2);
                }
                if (!bl6 && diN2 != null) {
                    for (int i2 = 0; !bl6 && i2 < diN2.size() - 1; ++i2) {
                        double d11 = diN2.alk(i2);
                        double d13 = diN2.alk(i2 + 1);
                        bl6 = AbstractRangedValueProxy.shouldBeCaughtByMovement(d11, d13, d9, wLI2);
                    }
                    if (!bl6) {
                        double d14 = diN2.alk(diN2.size() - 1);
                        bl6 = AbstractRangedValueProxy.shouldBeCaughtByMovement(d14, d2, d9, wLI2);
                    }
                }
                if (!bl6 && diN2 == null) {
                    bl6 = AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d2, d9);
                }
                if (bl6) {
                    this.doSetNormalizedValueImmediately(d2);
                } else if (rangedValueTarget.shouldShowPopupNotifications()) {
                    this.doShowVisualizations();
                }
            }
        }
    }

    private static boolean shouldBeCaughtByMovement(double d2, double d3, double d4, wLI wLI2) {
        assert (bCi.OqD(d2 >= 0.0 && d2 <= 1.0));
        assert (bCi.OqD(d3 >= 0.0 && d3 <= 1.0));
        assert (bCi.OqD(d4 >= 0.0 && d4 <= 1.0));
        assert (bCi.OqD(wLI2 != null));
        double d5 = Math.min(d2, d3);
        double d6 = Math.max(d2, d3);
        if (d4 >= d5 && d4 <= d6) {
            return true;
        }
        return f2f.OqD(d4, Math.min(d2, d3), Math.max(d2, d3)) || AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d2, d4) || AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d3, d4);
    }

    private static boolean isValueCloseEnoughForTakeOver(double d2, double d3) {
        return Math.abs(d2 - d3) <= TAKEOVER_THRESHOLD;
    }

    public void doSetNormalizedValueImmediately(double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(d2 >= 0.0 && d2 <= 1.0));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            double d3 = this.normalizedValueToValue(d2);
            this.setCurrentValue(d3);
            this.mLastSetNormalizedValue = d2;
            this.mLastSetControllerValue = d2;
            this.mHasBeenCaught = true;
        }
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    @Override
    public final void inc(Number number, Number number2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (number == null) {
            throw new aRB("increment cannot be null");
        }
        if (number2 == null) {
            throw new aRB("range cannot be null");
        }
        if (number2.doubleValue() <= 1.0) {
            throw new aRB("range must be > 1");
        }
        double d2 = number.doubleValue() / (number2.doubleValue() - 1.0);
        this.incNormalized(d2);
    }

    @Override
    public void inc(double d2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.inRange(d2, -1.0, 1.0, "increment");
        this.newSince(2);
        this.incNormalized(d2);
    }

    public void incNormalized(double d2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(d2 >= -1.0 && d2 <= 1.0));
        this.postEvent(new zDK(this, d2, this.getTouchId()));
    }

    public boolean isMappable() {
        return false;
    }

    @Override
    public void addRawValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.notNull(doubleValueChangedCallback, "callback");
        this.checkIsInitializingDriver();
        this.doMarkInterested();
        if (this.mRawValueCallbacks == null) {
            this.mRawValueCallbacks = new ArrayList(2);
        }
        this.mRawValueCallbacks.add(doubleValueChangedCallback);
    }

    @Override
    public void setRaw(double d2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetRaw(d2));
    }

    private void doSetRaw(double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(d2));
        }
    }

    @Override
    public void incRaw(double d2) {
        this.exec(() -> this.doIncRaw(d2));
    }

    private void doIncRaw(double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(this.getCurrentValue() + d2));
        }
    }

    protected double validateRawValue(double d2) {
        return d2;
    }

    protected void connectToTargetAlways(RangedValueTarget rangedValueTarget) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(rangedValueTarget != null));
        assert (bCi.OqD(this.mValueChangedEventSource == null));
        super.connectToTargetAlways(rangedValueTarget);
        this.mValueChangedEventSource = rangedValueTarget.getValueChangedEventSource();
        if (this.mValueChangedEventSource != null) {
            this.mValueChangedEventSource.addListener(this);
        }
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    public void connectToTarget(RangedValueTarget rangedValueTarget) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(rangedValueTarget != null));
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(this.isActiveOnDocumentThread()));
        rangedValueTarget.connected();
        this.targetValueChanged();
    }

    protected void disconnectFromTargetAlways(RangedValueTarget rangedValueTarget) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(rangedValueTarget != null));
        super.disconnectFromTargetAlways(rangedValueTarget);
        if (this.mValueChangedEventSource != null) {
            this.mValueChangedEventSource.removeListener(this);
            this.mValueChangedEventSource = null;
        }
        this.updateHasBeenCaughtFromCurrentDistance();
    }

    public void disconnectFromTarget(RangedValueTarget rangedValueTarget) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(rangedValueTarget != null));
        rangedValueTarget.disconnected();
        this.queueNotifyObservers(0.0, 0.0);
        if (this.mDisplayedValue.isInterested()) {
            this.mDisplayedValue.unassign();
        }
    }

    @Override
    public void eventOccurred(Object object) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.getTarget() != null));
        this.targetValueChanged();
        if (!this.mIsSettingValue) {
            this.updateHasBeenCaughtFromCurrentDistance();
        }
    }

    private void targetValueChanged() {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.getTarget() != null));
        double d2 = this.getCurrentValue();
        double d3 = this.valueToNormalizedValue(d2);
        if (this.isInterested()) {
            this.queueNotifyObserversRaw(d2, d3);
        }
        if (this.mDisplayedValue.isInterested()) {
            fcK fcK2 = this.createTruncatableStringForCurrentValue();
            assert (bCi.OqD(fcK2 != null));
            this.mDisplayedValue.setValue(fcK2);
        }
        if (this.mNormalizedValueChangedListener != null) {
            this.mNormalizedValueChangedListener.accept(d3);
        }
    }

    protected ComputedStringValue createDisplayedValue() {
        return new ComputedStringValue(this);
    }

    protected fcK createTruncatableStringForCurrentValue() {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.getTarget() != null));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget == null) {
            return fcK.EMPTY;
        }
        return rangedValueTarget.createTruncatableStringForCurrentValue();
    }

    protected double getCurrentValue() {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).getCurrentValue();
    }

    protected void setCurrentValue(double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.getTarget() != null));
        assert (bCi.OqD(((RangedValueTarget)this.getTarget()).isSettable()));
        assert (bCi.OqD(!this.mIsSettingValue));
        this.beginSettingValue();
        ((RangedValueTarget)this.getTarget()).setCurrentValue(d2);
        this.endSettingValue();
    }

    protected double valueToNormalizedValue(double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).valueToNormalizedValue(d2);
    }

    protected double normalizedValueToValue(double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).normalizedValueToValue(d2);
    }

    public void doIncNormalized(double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(!this.mIsSettingValue));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.beginSettingValue();
            rangedValueTarget.incrementNormalized(d2);
            this.endSettingValue();
        }
    }

    private void beginSettingValue() {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(!this.mIsSettingValue));
        this.mIsSettingValue = true;
    }

    private void endSettingValue() {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.mIsSettingValue));
        assert (bCi.OqD(this.getTarget() != null));
        assert (bCi.OqD(((RangedValueTarget)this.getTarget()).isSettable()));
        this.mIsSettingValue = false;
        if (((RangedValueTarget)this.getTarget()).shouldShowPopupNotifications()) {
            this.doShowVisualizations();
        }
    }

    public void showVisualizations() {
        assert (bCi.OqD(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable() && rangedValueTarget.shouldShowPopupNotifications()) {
            this.doShowVisualizations();
        }
    }

    private void doShowVisualizations() {
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(rangedValueTarget != null));
        assert (bCi.OqD(rangedValueTarget.isSettable()));
        assert (bCi.OqD(rangedValueTarget.shouldShowPopupNotifications()));
        this.getControlSurface().CwM(this);
    }

    private final void queueNotifyObserversRaw(double d2, double d3) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.isInterested()));
        this.queueNotifyObservers(d2, d3);
    }

    private void queueNotifyObservers(double d2, double d3) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(d3 >= 0.0 && d3 <= 1.0));
        assert (bCi.OqD(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(d2, d3));
    }

    private void notifyObservers(double d2, double d3) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInterested()));
        assert (bCi.OqD(d3 >= 0.0 && d3 <= 1.0));
        double d4 = this.mRawValue;
        double d5 = this.mNormalizedValue;
        this.mRawValue = d2;
        this.mNormalizedValue = d3;
        if (d3 != d5) {
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(d3);
                }
            }
            if (this.mIntegerScaledValueObservers != null) {
                for (Object object : this.mIntegerScaledValueObservers) {
                    IntegerValueChangedCallback integerValueChangedCallback = ((AbstractRangedValueProxy$IntegerScaledValueObserver)object).mCallback;
                    int n2 = ((AbstractRangedValueProxy$IntegerScaledValueObserver)object).mRange;
                    int n3 = f2f.CwM(Math.round((float)d3 * (float)n2 - 0.5f), 0, n2 - 1);
                    integerValueChangedCallback.valueChanged(n3);
                }
            }
        }
        if (d2 != d4 && this.mRawValueCallbacks != null) {
            for (Object object : this.mRawValueCallbacks) {
                object.valueChanged(d2);
            }
        }
    }

    public void doTouch(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
    }

    public boolean hasBeenCaught() {
        assert (bCi.Opd(this.isDocumentThread()));
        return this.mHasBeenCaught;
    }

    public double getLastSetControllerValue() {
        return this.mLastSetControllerValue;
    }

    public void setControllerTakeOverState(double d2, boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        this.mLastSetControllerValue = d2;
        this.mHasBeenCaught = bl2;
    }

    public void setNormalizedValueChangedListener(DoubleConsumer doubleConsumer) {
        assert (bCi.OqD(this.isInitializingDriver()));
        assert (bCi.OqD(doubleConsumer != null));
        assert (bCi.OqD(this.mNormalizedValueChangedListener == null));
        this.mNormalizedValueChangedListener = doubleConsumer;
    }

    public String getLabel() {
        return "";
    }
}

