/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.UsbInterfaceMatcher;
import com.bitwig.extension.controller.api.UsbInterface;
import com.bitwig.extension.controller.api.UsbPipe;
import com.bitwig.flt.control_surface.proxy.UsbBulkInputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbBulkOutputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbDeviceImpl;
import com.bitwig.flt.control_surface.proxy.UsbInterruptInputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbInterruptOutputPipeImpl;
import com.bitwig.flt.control_surface.proxy.UsbPipeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UsbInterfaceImpl
implements UsbInterface {
    private final UsbDeviceImpl mDevice;
    private bXh mClaimedInterface;
    private final tLG mMatchResult;
    private final List mPipes;

    UsbInterfaceImpl(UsbDeviceImpl usbDeviceImpl, tLG tLG2) {
        this.mDevice = usbDeviceImpl;
        this.mMatchResult = tLG2;
        this.mPipes = new ArrayList(tLG2.OqD().size());
        for (EsS esS : tLG2.OqD()) {
            UsbPipeImpl usbPipeImpl = UsbInterfaceImpl.createUsbPipe(usbDeviceImpl, esS);
            this.mPipes.add(usbPipeImpl);
        }
    }

    private static UsbPipeImpl createUsbPipe(UsbDeviceImpl usbDeviceImpl, EsS esS) {
        bXn bXn2 = esS.CwM().OqD();
        boolean bl2 = esS.CwM().m2i();
        switch (bXn2) {
            case OqD: {
                return bl2 ? new UsbBulkOutputPipeImpl(usbDeviceImpl, esS) : new UsbBulkInputPipeImpl(usbDeviceImpl, esS);
            }
            case m2i: {
                return bl2 ? new UsbInterruptOutputPipeImpl(usbDeviceImpl, esS) : new UsbInterruptInputPipeImpl(usbDeviceImpl, esS);
            }
        }
        throw new IllegalStateException("Unknown matcher transfer type " + bXn2);
    }

    @Override
    public UsbInterfaceMatcher interfaceMatcher() {
        return this.mMatchResult.Opd();
    }

    @Override
    public List pipes() {
        return Collections.unmodifiableList(this.mPipes);
    }

    @Override
    public UsbPipe pipe(int n2) {
        return (UsbPipe)this.mPipes.get(n2);
    }

    @Override
    public int pipeCount() {
        return this.mPipes.size();
    }

    void claim() {
        this.mClaimedInterface = this.mDevice.getDeviceHandle().Opd(this.mMatchResult.CwM().OqD);
    }

    void release() {
        if (this.mClaimedInterface != null) {
            this.mClaimedInterface.CwM();
            this.mClaimedInterface = null;
        }
    }
}

