/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IndexedStringValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.ClipLauncherSlotBank;
import com.bitwig.extension.controller.api.CursorDevice;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.InsertionPoint;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.extension.controller.api.SourceSelector;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.flt.control_surface.proxy.AbstractTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.BankItemWithPosition;
import com.bitwig.flt.control_surface.proxy.ChannelBankProxy;
import com.bitwig.flt.control_surface.proxy.ChannelProxy;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotBankProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.CursorDeviceProxy;
import com.bitwig.flt.control_surface.proxy.DirectNoteInput;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.proxy.EffectTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.MainTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.MasterTrackProxy;
import com.bitwig.flt.control_surface.proxy.MonitorModeProxy;
import com.bitwig.flt.control_surface.proxy.SiblingTrackBankProxy;
import com.bitwig.flt.control_surface.proxy.SourceSelectorProxy;
import com.bitwig.flt.control_surface.proxy.TrackBankProxy;
import com.bitwig.flt.control_surface.proxy.TrackProxy$1;
import com.bitwig.flt.control_surface.proxy.TrackProxy$PitchNamesObserver;
import com.bitwig.flt.control_surface.proxy.TracksBankTarget;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.IndexedValueAtomProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.document.core.iface.YEC;
import com.bitwig.flt.document.core.iface.mEu;
import com.bitwig.flt.document.core.iface.oGX;
import com.bitwig.ramona.core.TH1;
import java.util.ArrayList;
import java.util.List;

public class TrackProxy
extends ChannelProxy
implements Track,
BankItemWithPosition {
    private static final int DEFAULT_MIDI_CHANNEL = 0;
    private static final String DEFAULT_CURSOR_DEVICE_ID = "DeviceSelection";
    private final TgC mTrackTypeListener = svx -> this.updateTrackTypeString(this.getChannel());
    private final ComputedStringValue mTrackType;
    protected final SettableBooleanValueProxy mCanHoldNoteData;
    protected final SettableBooleanValueProxy mCanHoldAudioData;
    private final SettableBooleanValueProxy mArm;
    private final MonitorModeProxy mMonitorModeProxy;
    private final BooleanValueProxy mIsMonitoring;
    private final IndexedValueAtomProxy mCrossFadeMode;
    private final BooleanValueProxy mIsMatrixStopped;
    private final BooleanValueProxy mIsMatrixQueuedForStop;
    private final SourceSelectorProxy mSourceSelector;
    private ClipLauncherSlotBankProxy mSlotBank;
    private final ComputedIntegerValue mPosition;
    private TracksBankTarget mBankTargetToUseForPosition;
    private boolean mHasScheduledUpdateToPositionWhenNotInBank;
    private final List mCursorDevices = new ArrayList(3);
    private CursorDeviceProxy mPrimaryDevice;
    private final ComputedBooleanValue mIsGroupValue;
    private final SettableBooleanValueProxy mIsPreFader;
    private final VFC mAfterTrackInsertionPoint = new VFC(this);
    private final d3V mBeforeTrackInsertionPoint = new d3V(this);
    private final List mParentTrackProxies = new ArrayList(1);
    private final List mDirectNoteInputs = new ArrayList();
    private SettableBooleanValueProxy mLegacyMonitorProxy = new SettableBooleanValueProxy((ControlSurfaceObject)this, false);
    private SettableBooleanValueProxy mLegacyAutomonitorProxy = new SettableBooleanValueProxy((ControlSurfaceObject)this, false);

    public TrackProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3, int n4) {
        super(controlSurfaceObject, string, n2, n3);
        this.mTrackType = new ComputedStringValue(this);
        this.mPosition = new ComputedIntegerValue((ControlSurfaceObject)this, -1);
        this.mArm = new SettableBooleanValueProxy(this);
        this.mMonitorModeProxy = new MonitorModeProxy((ControlSurfaceObject)this, MKF.Opd);
        this.mIsMonitoring = new BooleanValueProxy(this);
        this.mIsPreFader = new SettableBooleanValueProxy(this);
        this.mCrossFadeMode = new TrackProxy$1(this, this, Qgc.Opd);
        this.mIsMatrixStopped = new BooleanValueProxy(this);
        this.mIsMatrixQueuedForStop = new BooleanValueProxy(this);
        this.mCanHoldNoteData = new SettableBooleanValueProxy(this);
        this.mCanHoldAudioData = new SettableBooleanValueProxy(this);
        this.mSourceSelector = new SourceSelectorProxy((ControlSurfaceObject)this, this.getKey() + "/SourceSelector");
        this.mIsGroupValue = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.addChild(this.mArm);
        this.addChild(this.mIsMatrixStopped);
        this.addChild(this.mIsMatrixQueuedForStop);
        this.addChild(this.mCanHoldNoteData);
        this.addChild(this.mCanHoldAudioData);
        this.addChild(this.mSourceSelector);
        if (n4 > 0) {
            this.mSlotBank = new ClipLauncherSlotBankProxy((ControlSurfaceObject)this, n4);
            this.addChild(this.mSlotBank);
        }
    }

    @Override
    public ComputedIntegerValue getBankItemPosition() {
        return this.mPosition;
    }

    @Override
    public Class getTargetType() {
        return YEC.class;
    }

    protected oGX getDocumentFromTarget(YEC yEC) {
        return yEC.Qf();
    }

    protected DET getEditorChannelSelection(YEC yEC) {
        oGX oGX2 = yEC.Qf();
        if (oGX2 != null) {
            return oGX2.rH1().OqD();
        }
        return null;
    }

    @Override
    protected String getAutomaticNotificationPrefix() {
        return "Track";
    }

    @Override
    public IntegerValue position() {
        this.newSince(2);
        return this.mPosition;
    }

    @Override
    public void addPositionObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use position() instead");
        this.mPosition.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public ClipLauncherSlotBankProxy getClipLauncher() {
        this.deprecated(1, 2);
        return this.getClipLauncherSlots();
    }

    @Override
    public ClipLauncherSlotBankProxy getClipLauncherSlots() {
        return this.mSlotBank;
    }

    @Override
    public ClipLauncherSlotBank clipLauncherSlotBank() {
        return this.mSlotBank;
    }

    @Override
    public SettableBooleanValue getArm() {
        this.deprecated(1, 5, "Use arm() instead");
        return this.mArm;
    }

    @Override
    public SettableBooleanValue arm() {
        this.newSince(5);
        return this.mArm;
    }

    @Override
    public SettableBooleanValue getMonitor() {
        this.deprecated(1, 5, "Use monitor() instead");
        return this.mLegacyMonitorProxy;
    }

    @Override
    public SettableBooleanValue monitor() {
        this.deprecated(5, 14, "Use isMonitoring or monitorMode instead");
        return this.mLegacyMonitorProxy;
    }

    @Override
    public SettableBooleanValue getAutoMonitor() {
        this.deprecated(1, 14, "Use monitorMode instead");
        return this.mLegacyAutomonitorProxy;
    }

    @Override
    public SettableBooleanValue autoMonitor() {
        this.deprecated(5, 14, "Use monitorMode instead");
        return this.mLegacyAutomonitorProxy;
    }

    @Override
    public SettableEnumValue monitorMode() {
        this.newSince(14);
        return this.mMonitorModeProxy;
    }

    @Override
    public BooleanValue isMonitoring() {
        this.newSince(14);
        return this.mIsMonitoring;
    }

    @Override
    public SettableEnumValue getCrossFadeMode() {
        this.deprecated(1, 5, "Use crossFadeMode() instead");
        return this.mCrossFadeMode;
    }

    @Override
    public SettableEnumValue crossFadeMode() {
        this.newSince(5);
        return this.mCrossFadeMode;
    }

    @Override
    public BooleanValue isStopped() {
        this.newSince(2);
        return this.mIsMatrixStopped;
    }

    @Override
    public BooleanValue getIsMatrixStopped() {
        this.deprecated(1, 2, "Use isStopped() instead");
        return this.mIsMatrixStopped;
    }

    @Override
    public BooleanValue isQueuedForStop() {
        this.newSince(2);
        return this.mIsMatrixQueuedForStop;
    }

    @Override
    public BooleanValue getIsMatrixQueuedForStop() {
        this.deprecated(1, 2, "Use isQueuedForStop() instead");
        return this.mIsMatrixQueuedForStop;
    }

    @Override
    public SourceSelector getSourceSelector() {
        this.deprecated(1, 5, "Use sourceSelector() instead");
        return this.mSourceSelector;
    }

    @Override
    public SourceSelector sourceSelector() {
        this.newSince(5);
        return this.mSourceSelector;
    }

    @Override
    public void stop() {
        this.exec(this::doStop);
    }

    private void doStop() {
        YEC yEC = this.getChannel();
        if (yEC != null) {
            yEC.rH1();
        }
    }

    @Override
    public HardwareActionBindable stopAction() {
        this.newSince(10);
        return new DocumentAction((ControlSurfaceObject)this, this::doStop);
    }

    @Override
    public void returnToArrangement() {
        this.exec(() -> {
            YEC yEC = this.getChannel();
            if (yEC != null) {
                yEC.iht();
            }
        });
    }

    @Override
    public void playNote(int n2, int n3) {
        if (n2 >= 0 && n2 < 128 && n3 >= 0 && n3 < 128) {
            this.exec(() -> {
                if (this.getChannel() instanceof Bzw) {
                    Bzw bzw2 = (Bzw)this.getTarget();
                    bzw2.hCF().CwM(0, n2, GsF.CwM(n3), 0.5f, 100L);
                }
            });
        }
    }

    @Override
    public void startNote(int n2, int n3) {
        if (n2 >= 0 && n2 < 128 && n3 >= 0 && n3 < 128) {
            this.exec(() -> {
                if (this.getTarget() instanceof Bzw) {
                    Bzw bzw2 = (Bzw)this.getTarget();
                    bzw2.hCF().CwM(0, n2, GsF.CwM(n3));
                }
            });
        }
    }

    @Override
    public void stopNote(int n2, int n3) {
        if (n2 >= 0 && n2 < 128 && n3 >= 0 && n3 < 128) {
            this.exec(() -> {
                if (this.getTarget() instanceof Bzw) {
                    Bzw bzw2 = (Bzw)this.getTarget();
                    bzw2.hCF().Opd(0, n2, GsF.CwM(n3));
                }
            });
        }
    }

    @Override
    public void sendMidi(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 127 || n3 < 0 || n3 > 127 || n4 < 0 || n4 > 127) {
            this.exec(() -> {
                if (!(this.getTarget() instanceof Bzw)) {
                    return;
                }
                Bzw bzw2 = (Bzw)this.getTarget();
                bzw2.hCF().CwM(n2, n3, n4);
            });
        }
    }

    @Override
    public CursorDevice createCursorDevice() {
        this.checkIsInitializingDriver();
        return this.createCursorDevice(DEFAULT_CURSOR_DEVICE_ID, this.getNumSends());
    }

    @Deprecated
    public CursorDevice createEditorDeviceSelection(boolean bl2) {
        return this.createCursorDevice();
    }

    protected void connectToTarget(YEC yEC) {
        super.connectToTarget(yEC);
        Bzw bzw2 = yEC.bi_();
        assert (bCi.hFR(bzw2 != null));
        assert (bCi.OqD(this.mBankTargetToUseForPosition == null));
        this.updateParentTrackProxiesTarget(yEC);
        for (Object object : this.mCursorDevices) {
            ((ControlSurfaceProxy)object).setTarget(bzw2);
        }
        this.updateTrackTypeString(yEC);
        boolean bl2 = yEC instanceof mEu;
        this.mIsGroupValue.setBoolValue(bl2);
        this.mArm.setTarget(bzw2.bQS());
        this.mMonitorModeProxy.setTarget(bzw2.mFR());
        this.mIsMonitoring.setTarget(bzw2.CZs());
        this.mIsPreFader.setTarget(bzw2.FMz());
        this.mCrossFadeMode.setTarget(bzw2.Aks().CwM());
        this.mIsMatrixStopped.setTarget(yEC.Eei());
        this.mIsMatrixQueuedForStop.setTarget(yEC.nVF());
        this.mCanHoldNoteData.setTarget(bzw2.eet());
        this.mCanHoldAudioData.setTarget(bzw2.BTB());
        this.mSourceSelector.setTarget(bzw2.P());
        if (this.mSlotBank != null) {
            this.mSlotBank.setTarget(yEC);
        }
        this.addAllNoteSources();
        bzw2.hFR(this.mTrackTypeListener);
        for (ControlSurfaceObject controlSurfaceObject : this.getChildren()) {
            ControlSurfaceDocumentObjectProxy controlSurfaceDocumentObjectProxy;
            Object object;
            if (controlSurfaceObject instanceof SiblingTrackBankProxy) {
                object = (SiblingTrackBankProxy)controlSurfaceObject;
                ((SiblingTrackBankProxy)object).setTrackOrGroup(yEC);
                continue;
            }
            if (!bl2) continue;
            object = (mEu)yEC;
            if (controlSurfaceObject instanceof TrackProxy) {
                controlSurfaceDocumentObjectProxy = (TrackProxy)controlSurfaceObject;
                controlSurfaceDocumentObjectProxy.setTarget(object.elG());
                continue;
            }
            if (!(controlSurfaceObject instanceof AbstractTrackBankProxy)) continue;
            controlSurfaceDocumentObjectProxy = (AbstractTrackBankProxy)controlSurfaceObject;
            ((ChannelBankProxy)controlSurfaceDocumentObjectProxy).setTarget((TH1)object);
        }
        if (!this.isInBank()) {
            Object object;
            object = yEC.RjC();
            if (object != null) {
                this.mBankTargetToUseForPosition = new TracksBankTarget((mEu)object, true, true, true, false);
                this.mBankTargetToUseForPosition.setItemsChangedListener(this::scheduleUpdatePositionWhenNotInBank);
                this.updatePositionWhenNotInBank();
            } else {
                this.mPosition.setIntegerValue(-1);
            }
        }
    }

    private void updateParentTrackProxiesTarget(YEC yEC) {
        mEu mEu2 = yEC != null ? yEC.RjC() : null;
        for (TrackProxy trackProxy : this.mParentTrackProxies) {
            trackProxy.setTarget(mEu2);
        }
    }

    public void disconnectFromTarget(YEC yEC) {
        super.disconnectFromTarget(yEC);
        this.removeAllNoteSources();
        this.updateParentTrackProxiesTarget(null);
        for (Object object : this.getChildren()) {
            if (!(object instanceof ControlSurfaceProxy)) continue;
            ((ControlSurfaceProxy)object).clearTarget();
        }
        this.mIsGroupValue.setBoolValue(false);
        Bzw bzw2 = yEC.bi_();
        assert (bCi.hFR(bzw2 != null));
        bzw2.LTX(this.mTrackTypeListener);
        this.mArm.clearTarget();
        this.mMonitorModeProxy.clearTarget();
        this.mIsMonitoring.clearTarget();
        this.mIsPreFader.clearTarget();
        this.mCrossFadeMode.clearTarget();
        this.mIsMatrixStopped.clearTarget();
        this.mIsMatrixQueuedForStop.clearTarget();
        this.mCanHoldNoteData.clearTarget();
        this.mCanHoldAudioData.clearTarget();
        this.mSourceSelector.clearTarget();
        for (CursorDeviceProxy cursorDeviceProxy : this.mCursorDevices) {
            cursorDeviceProxy.clearTarget();
        }
        if (this.mSlotBank != null) {
            this.mSlotBank.clearTarget();
        }
        this.updateTrackTypeString(null);
        if (this.mBankTargetToUseForPosition != null) {
            this.mBankTargetToUseForPosition.setItemsChangedListener(null);
            this.mBankTargetToUseForPosition = null;
        }
        this.mPosition.setIntegerValue(-1);
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        YEC yEC = (YEC)this.getTarget();
        for (ControlSurfaceObject controlSurfaceObject : this.getChildren()) {
            if (!(controlSurfaceObject instanceof SiblingTrackBankProxy)) continue;
            SiblingTrackBankProxy siblingTrackBankProxy = (SiblingTrackBankProxy)controlSurfaceObject;
            siblingTrackBankProxy.setTrackOrGroup(yEC);
        }
    }

    @Override
    protected void connectObservers(Object object) {
        Bzw bzw2;
        super.connectObservers(object);
        Bzw bzw3 = bzw2 = object instanceof Bzw ? (Bzw)object : null;
        if (bzw2 != null) {
            for (oFt oFt2 : this.getObservers()) {
                if (!(oFt2 instanceof TrackProxy$PitchNamesObserver)) continue;
                bzw2.yBk().CwM((TrackProxy$PitchNamesObserver)oFt2);
            }
        }
    }

    @Override
    protected void disconnectObservers(Object object) {
        Bzw bzw2;
        super.disconnectObservers(object);
        Bzw bzw3 = bzw2 = object instanceof Bzw ? (Bzw)object : null;
        if (bzw2 != null) {
            for (oFt oFt2 : this.getObservers()) {
                if (!(oFt2 instanceof TrackProxy$PitchNamesObserver)) continue;
                bzw2.yBk().Opd((TrackProxy$PitchNamesObserver)oFt2);
            }
        }
    }

    private void updateTrackTypeString(YEC yEC) {
        if (yEC instanceof mEu) {
            this.mTrackType.setValue("Group");
        } else if (yEC instanceof Bzw) {
            Bzw bzw2 = (Bzw)yEC;
            if (bzw2.Dzr()) {
                switch (bzw2.EuM()) {
                    case CwM: {
                        this.mTrackType.setValue("Instrument");
                        break;
                    }
                    case Opd: {
                        this.mTrackType.setValue("Audio");
                        break;
                    }
                    case OqD: {
                        this.mTrackType.setValue("Hybrid");
                    }
                }
            } else if (bzw2.lPz()) {
                this.mTrackType.setValue("Effect");
            } else if (bzw2.lMH()) {
                this.mTrackType.setValue("Master");
            }
        } else {
            this.mTrackType.setValue("");
        }
    }

    @Override
    public void setName(String string) {
        this.exec(() -> {
            if (this.getTarget() instanceof Bzw) {
                ((YEC)this.getTarget()).b_(string);
            }
        });
    }

    @Override
    public SettableBooleanValue getCanHoldNoteData() {
        this.deprecated(1, 5, "Use canHoldNoteData() instead");
        return this.mCanHoldNoteData;
    }

    @Override
    public SettableBooleanValue canHoldNoteData() {
        this.newSince(5);
        return this.mCanHoldNoteData;
    }

    @Override
    public SettableBooleanValue getCanHoldAudioData() {
        this.deprecated(1, 5, "Use canHoldAudioData() instead");
        return this.mCanHoldAudioData;
    }

    @Override
    public SettableBooleanValue canHoldAudioData() {
        this.newSince(5);
        return this.mCanHoldAudioData;
    }

    @Override
    public void addPitchNamesObserver(IndexedStringValueChangedCallback indexedStringValueChangedCallback) {
        this.addObserver(new TrackProxy$PitchNamesObserver(this.getControlSurface(), indexedStringValueChangedCallback));
    }

    @Override
    public StringValue trackType() {
        this.newSince(2);
        return this.mTrackType;
    }

    @Override
    public void addTrackTypeObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.deprecated(1, 2, "Use trackType() instead");
        this.mTrackType.addValueObserver(n2, string, stringValueChangedCallback);
    }

    @Override
    public BooleanValue isGroup() {
        this.newSince(2);
        return this.mIsGroupValue;
    }

    @Override
    public SettableBooleanValue getIsPreFader() {
        this.newSince(10);
        return this.mIsPreFader;
    }

    @Override
    public void addIsGroupObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use isGroup() instead");
        this.mIsGroupValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addIsQueuedForStopObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use isQueuedForStop() instead");
        this.mIsMatrixQueuedForStop.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    protected YEC getChannel() {
        return (YEC)super.getChannel();
    }

    @Override
    public CursorDevice createCursorDevice(String string) {
        return this.createCursorDevice(string, this.getNumSends());
    }

    @Override
    public CursorDevice createCursorDevice(String string, int n2) {
        String string2 = string == null || string.isEmpty() ? DEFAULT_CURSOR_DEVICE_ID : string;
        assert (bCi.OqD(this.getKey() != null));
        assert (bCi.OqD(!this.getKey().isEmpty()));
        CursorDeviceProxy cursorDeviceProxy = new CursorDeviceProxy(this, this.getKey() + "/" + string2, n2);
        this.mCursorDevices.add(cursorDeviceProxy);
        return cursorDeviceProxy;
    }

    @Deprecated
    public CursorDevice createDeviceSelection(String string, boolean bl2) {
        return this.createCursorDevice(string);
    }

    protected String getChannelSelectionName() {
        return null;
    }

    @Override
    @Deprecated
    public Device getPrimaryInstrument() {
        this.deprecated(1, 2);
        return this.getPrimaryDevice();
    }

    @Override
    public Device getPrimaryDevice() {
        this.deprecatedFail(1, 2, "Use createCursorDevice instead");
        this.checkIsInitializingDriver();
        if (this.mPrimaryDevice == null) {
            this.mPrimaryDevice = new CursorDeviceProxy(this, this.getKey() + " / Primary Device", this.getNumSends());
            this.mCursorDevices.add(this.mPrimaryDevice);
        }
        assert (bCi.OqD(this.mPrimaryDevice != null));
        return this.mPrimaryDevice;
    }

    @Override
    public AbstractTrackBankProxy createTrackBank(int n2, int n3, int n4, boolean bl2) {
        TrackBankProxy trackBankProxy = new TrackBankProxy(this, "TrackBank", n2, n3, n4, bl2);
        this.addChild(trackBankProxy);
        return trackBankProxy;
    }

    @Override
    public AbstractTrackBankProxy createMainTrackBank(int n2, int n3, int n4, boolean bl2) {
        MainTrackBankProxy mainTrackBankProxy = new MainTrackBankProxy(this, "MainTrackBank", n2, n3, n4, bl2);
        this.addChild(mainTrackBankProxy);
        return mainTrackBankProxy;
    }

    @Override
    public AbstractTrackBankProxy createEffectTrackBank(int n2, int n3, boolean bl2) {
        EffectTrackBankProxy effectTrackBankProxy = new EffectTrackBankProxy(this, "EffectTrackBank", n2, n3, bl2);
        this.addChild(effectTrackBankProxy);
        return effectTrackBankProxy;
    }

    @Override
    public MasterTrackProxy createMasterTrack(int n2) {
        MasterTrackProxy masterTrackProxy = new MasterTrackProxy((ControlSurfaceObject)this, n2);
        this.addChild(masterTrackProxy);
        return masterTrackProxy;
    }

    @Override
    public TrackBank createSiblingsTrackBank(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        SiblingTrackBankProxy siblingTrackBankProxy = new SiblingTrackBankProxy(this, "SiblingTrackBank", n2, n3, n4, bl2, bl3);
        this.addChild(siblingTrackBankProxy);
        return siblingTrackBankProxy;
    }

    @Override
    public InsertionPoint afterTrackInsertionPoint() {
        return this.mAfterTrackInsertionPoint;
    }

    @Override
    public InsertionPoint beforeTrackInsertionPoint() {
        return this.mBeforeTrackInsertionPoint;
    }

    public chL createNotificationWidget() {
        Object object;
        assert (bCi.CwM(this.isDocumentThread()));
        cJd cJd2 = cJd.m2i(12);
        che che2 = che.hFR(this.getName());
        che2.uwB(0.5f);
        che2.CwM((cWv)che2.fh_().FVz().Uft());
        cJd2.IwJ(che2);
        if (this.mCursorDevices != null) {
            for (CursorDeviceProxy cursorDeviceProxy : this.mCursorDevices) {
                chL chL2 = cursorDeviceProxy.createNotificationWidget();
                cJd2.IwJ(chL2);
            }
        }
        if (this.mSendBankProxy != null) {
            object = this.mSendBankProxy.createNotificationWidget();
            cJd2.IwJ((chL)object);
        }
        if (this.mPan.shouldIndicate()) {
            object = this.mPan.createVisualizationWidget();
            cJd2.IwJ((chL)object);
        }
        if (this.mVolume.shouldIndicate()) {
            object = this.mVolume.createVisualizationWidget();
            cJd2.IwJ((chL)object);
        }
        return cJd2;
    }

    @Override
    public Track createParentTrack(int n2, int n3) {
        this.newSince(10);
        TrackProxy trackProxy = new TrackProxy(this, this.getKey() + "/parent", -1, n2, n3);
        this.addChild(trackProxy);
        this.mParentTrackProxies.add(trackProxy);
        return trackProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNoteSource(NoteInput noteInput) {
        this.newSince(10);
        this.notNull(noteInput, "noteInput");
        DirectNoteInput directNoteInput = (DirectNoteInput)noteInput;
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            if (this.mDirectNoteInputs.contains(directNoteInput)) {
                return;
            }
            this.mDirectNoteInputs.add(directNoteInput);
        }
        this.exec(() -> this.doAddNoteSource(directNoteInput));
    }

    private void doAddNoteSource(DirectNoteInput directNoteInput) {
        assert (bCi.CwM(this.isDocumentThread()));
        YEC yEC = (YEC)this.getTarget();
        if (yEC == null) {
            return;
        }
        Bzw bzw2 = yEC.bi_();
        CAf cAf2 = bzw2.RWz();
        Ni3 ni3 = directNoteInput.getNoteSource();
        assert (bCi.CwM(ni3 != null));
        if (!cAf2.OqD().contains(ni3)) {
            cAf2.CwM(ni3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNoteSource(NoteInput noteInput) {
        this.newSince(10);
        this.notNull(noteInput, "noteInput");
        DirectNoteInput directNoteInput = (DirectNoteInput)noteInput;
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            if (!this.mDirectNoteInputs.contains(directNoteInput)) {
                return;
            }
            this.mDirectNoteInputs.remove(directNoteInput);
        }
        this.exec(() -> this.doRemoveNoteSource(directNoteInput));
    }

    private void doRemoveNoteSource(DirectNoteInput directNoteInput) {
        assert (bCi.CwM(this.isDocumentThread()));
        YEC yEC = (YEC)this.getTarget();
        if (yEC == null) {
            return;
        }
        Bzw bzw2 = yEC.bi_();
        CAf cAf2 = bzw2.RWz();
        Ni3 ni3 = directNoteInput.getNoteSource();
        assert (bCi.CwM(ni3 != null));
        if (cAf2.OqD().contains(ni3)) {
            cAf2.Opd(ni3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllNoteSources() {
        assert (bCi.CwM(this.isDocumentThread()));
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            for (DirectNoteInput directNoteInput : this.mDirectNoteInputs) {
                this.doRemoveNoteSource(directNoteInput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllNoteSources() {
        assert (bCi.CwM(this.isDocumentThread()));
        List list = this.mDirectNoteInputs;
        synchronized (list) {
            for (DirectNoteInput directNoteInput : this.mDirectNoteInputs) {
                this.doAddNoteSource(directNoteInput);
            }
        }
    }

    @Override
    public void selectSlot(int n2) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.exec(() -> this.doSelectSlot(n2));
    }

    private void doSelectSlot(int n2) {
        assert (bCi.CwM(this.isDocumentThread()));
        YEC yEC = (YEC)this.getTarget();
        if (yEC == null) {
            return;
        }
        if (n2 >= yEC.lDH()) {
            return;
        }
        mc mc2 = this.getDocumentGUIWrapper();
        if (mc2 == null) {
            return;
        }
        aco aco2 = mc2.lIs();
        aco2.hFR(yEC.uwB(n2));
        aco2.yfC();
    }

    @Override
    public void recordNewLauncherClip(int n2) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.exec(() -> this.doRecordNewLauncherClip(n2, true));
    }

    int doRecordNewLauncherClip(int n2, boolean bl2) {
        assert (bCi.CwM(this.isDocumentThread()));
        YEC yEC = (YEC)this.getTarget();
        if (yEC == null) {
            return -1;
        }
        this.ensureSceneCount(n2);
        kKu kKu2 = this.findOrCreateFreeSlot(n2);
        if (!(kKu2 instanceof JcJ)) {
            return -1;
        }
        yEC.bi_().CwM(true);
        JcJ jcJ = (JcJ)kKu2;
        jcJ.AaH();
        jcJ.Opd(true);
        if (bl2) {
            int n3 = jcJ.khV();
            this.doSelectSlot(n3);
        }
        return jcJ.khV();
    }

    @Override
    public void createNewLauncherClip(int n2, int n3) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.atLeast(n3, 1, "lengthInBeats");
        this.exec(() -> this.doCreateNewLauncherClip(n2, n3, true));
    }

    @Override
    public void createNewLauncherClip(int n2) {
        this.newSince(10);
        this.greaterThan(n2, -1, "slotIndex");
        this.exec(() -> this.doCreateNewLauncherClip(n2, -1, true));
    }

    cKu doCreateNewLauncherClip(int n2, int n3, boolean bl2) {
        assert (bCi.CwM(this.isDocumentThread()));
        YEC yEC = (YEC)this.getTarget();
        if (yEC == null) {
            return null;
        }
        this.ensureSceneCount(n2);
        kKu kKu2 = this.findOrCreateFreeSlot(n2);
        if (!(kKu2 instanceof JcJ)) {
            return null;
        }
        JcJ jcJ = (JcJ)kKu2;
        if (n3 > 0) {
            jcJ.CwM(n3);
        } else {
            jcJ.IkS();
        }
        if (bl2) {
            int n4 = jcJ.khV();
            this.doSelectSlot(n4);
        }
        return jcJ.CwM();
    }

    private kKu findOrCreateFreeSlot(int n2) {
        YEC yEC = (YEC)this.getTarget();
        assert (bCi.CwM(yEC != null));
        int n3 = yEC.lDH();
        for (int i2 = n2; i2 < n3; ++i2) {
            kKu kKu2 = yEC.uwB(i2);
            if (!kKu2.HwE()) continue;
            return kKu2;
        }
        mEu mEu2 = this.getDocument().kBg();
        mEu2.OqD(n3, null);
        return yEC.uwB(n3);
    }

    private void ensureSceneCount(int n2) {
        YEC yEC = (YEC)this.getTarget();
        assert (bCi.CwM(yEC != null));
        int n3 = yEC.lDH();
        if (n3 < n2) {
            oGX oGX2 = this.getDocument();
            mEu mEu2 = oGX2.kBg();
            for (int i2 = n3; i2 < n2; ++i2) {
                mEu2.OqD(i2, null);
            }
        }
    }

    public boolean isInBank() {
        return false;
    }

    private void scheduleUpdatePositionWhenNotInBank() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateToPositionWhenNotInBank) {
            this.mHasScheduledUpdateToPositionWhenNotInBank = true;
            this.runAtEndOfEvent(this::updatePositionWhenNotInBank);
        }
    }

    private void updatePositionWhenNotInBank() {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(!this.isInBank()));
        assert (bCi.OqD(this.mBankTargetToUseForPosition != null));
        this.mHasScheduledUpdateToPositionWhenNotInBank = false;
        int n2 = -1;
        if (this.mBankTargetToUseForPosition != null) {
            YEC yEC = (YEC)this.getTarget();
            assert (bCi.OqD(yEC != null));
            if (yEC != null) {
                List list = this.mBankTargetToUseForPosition.listItems();
                n2 = list.indexOf(yEC);
            }
        }
        this.mPosition.setIntegerValue(n2);
    }
}

