/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SpecificBitwigDevice;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.DeviceProxy;
import com.bitwig.flt.control_surface.proxy.SpecificBitwigIntegerOutputValueProxy;
import com.bitwig.flt.control_surface.proxy.SpecificBitwigOutputValueProxy;
import com.bitwig.flt.control_surface.proxy.SpecificBitwigParameterProxy;
import com.bitwig.flt.control_surface.proxy.SpecificDeviceProxy;
import com.bitwig.flt.control_surface.values.ParameterProxy;
import com.bitwig.flt.document.core.iface.InvalidPresetIdentifierException;
import com.bitwig.flt.document.core.iface.Rbj;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SpecificBitwigDeviceProxy
extends SpecificDeviceProxy
implements SpecificBitwigDevice {
    private final UUID mDeviceId;
    private final List mParameters = new ArrayList();
    private final List mOutputValues = new ArrayList(3);

    protected SpecificBitwigDeviceProxy(DeviceProxy deviceProxy, UUID uUID) {
        super(deviceProxy);
        this.mDeviceId = uUID;
    }

    @Override
    public SpecificBitwigParameterProxy createParameter(String string) {
        SpecificBitwigParameterProxy specificBitwigParameterProxy = new SpecificBitwigParameterProxy(this, string);
        this.mParameters.add(specificBitwigParameterProxy);
        return specificBitwigParameterProxy;
    }

    @Override
    public IntegerValue createIntegerOutputValue(String string) {
        SpecificBitwigIntegerOutputValueProxy specificBitwigIntegerOutputValueProxy = new SpecificBitwigIntegerOutputValueProxy(this, string);
        this.mOutputValues.add(specificBitwigIntegerOutputValueProxy);
        return specificBitwigIntegerOutputValueProxy;
    }

    @Override
    public boolean isCorrectDevice(llf llf2) {
        if (llf2 instanceof Uo3) {
            Uo3 uo3 = (Uo3)llf2;
            return uo3.JWq() != null && uo3.uwB().equals(this.mDeviceId);
        }
        return false;
    }

    @Override
    public Class getTargetType() {
        return Uo3.class;
    }

    protected void connectToTarget(Uo3 uo3) {
        assert (bCi.OqD(this.isCorrectDevice(uo3)));
        tRo tRo2 = uo3.JWq();
        for (ControlSurfaceDocumentObjectProxy controlSurfaceDocumentObjectProxy : this.mParameters) {
            String string = ((SpecificBitwigParameterProxy)controlSurfaceDocumentObjectProxy).getPresetIdentifier();
            try {
                Rbj rbj = tRo2.CwM(string);
                if (rbj instanceof Zfu) {
                    ((ParameterProxy)controlSurfaceDocumentObjectProxy).setTargetAtom((Zfu)rbj);
                    continue;
                }
                controlSurfaceDocumentObjectProxy.clearTarget();
            }
            catch (InvalidPresetIdentifierException invalidPresetIdentifierException) {
                bCi.m2i.OqD("Could not find specific parameter", invalidPresetIdentifierException);
            }
        }
        for (ControlSurfaceDocumentObjectProxy controlSurfaceDocumentObjectProxy : this.mOutputValues) {
            ((SpecificBitwigOutputValueProxy)controlSurfaceDocumentObjectProxy).connectToDeviceContents(tRo2);
        }
    }

    protected void disconnectFromTarget(Uo3 uo3) {
        for (ControlSurfaceDocumentObjectProxy controlSurfaceDocumentObjectProxy : this.mParameters) {
            controlSurfaceDocumentObjectProxy.clearTarget();
        }
        for (ControlSurfaceDocumentObjectProxy controlSurfaceDocumentObjectProxy : this.mOutputValues) {
            controlSurfaceDocumentObjectProxy.clearTarget();
        }
    }
}

