/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IndexedStringValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.Scene;
import com.bitwig.extension.controller.api.SceneBank;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.CurrentDocumentListener;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.proxy.SceneProxy;
import com.bitwig.flt.document.core.iface.oGX;

public class SceneBankProxy
extends ControlSurfaceDocumentObjectProxy
implements SceneBank,
CurrentDocumentListener,
yfM {
    private final int mNumScenes;
    private final BankItemTargetUpdater mBankUpdater;
    private final SceneProxy[] mSceneProxies;

    protected SceneBankProxy(ControlSurfaceObject controlSurfaceObject, int n2) {
        super(controlSurfaceObject);
        this.setKey("Scene Bank");
        if (n2 < 1) {
            throw new aRB("At least 1 scene is required.");
        }
        this.mNumScenes = n2;
        this.mSceneProxies = new SceneProxy[this.mNumScenes];
        for (int i2 = 0; i2 < this.mNumScenes; ++i2) {
            this.mSceneProxies[i2] = new SceneProxy((ControlSurfaceObject)this, this.getKey() + " / Scene " + i2);
        }
        this.mBankUpdater = new BankItemTargetUpdater((ControlSurfaceObject)this, this.mSceneProxies);
    }

    @Override
    public int getSizeOfBank() {
        return this.mBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n2) {
        this.mBankUpdater.setSizeOfBank(n2);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mBankUpdater.getCapacityOfBank();
    }

    @Override
    public IntegerValue itemCount() {
        return this.mBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mBankUpdater.getCursorIndex();
    }

    @Override
    public Scene getItemAt(int n2) {
        return (Scene)((Object)this.mBankUpdater.getItemAt(n2));
    }

    @Override
    public Class getTargetType() {
        return SXr.class;
    }

    protected oGX getDocumentFromTarget(SXr sXr) {
        return (oGX)sXr.hFR(oGX.class);
    }

    @Override
    public void launchScene(int n2) {
        if (n2 >= 0 && n2 < this.mNumScenes) {
            this.mSceneProxies[n2].launch();
        }
    }

    @Override
    public void setIndication(boolean bl2) {
        this.newSince(10);
        for (SceneProxy sceneProxy : this.mSceneProxies) {
            sceneProxy.setIndication(bl2);
        }
    }

    @Override
    public void scrollPageUp() {
        this.deprecated(1, 4);
        this.mBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageBackwards() {
        this.mBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageForwards() {
        this.mBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollPageDown() {
        this.deprecated(1, 4);
        this.mBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollBackwards() {
        this.mBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollUp() {
        this.deprecated(1, 4);
        this.mBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollDown() {
        this.deprecated(1, 4);
        this.mBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollForwards() {
        this.mBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollTo(int n2) {
        this.deprecated(1, 4);
        this.mBankUpdater.scrollIntoView(n2);
    }

    @Override
    public void scrollBy(int n2) {
        this.mBankUpdater.scrollBy(n2);
    }

    @Override
    public void doStepForwards() {
        this.mBankUpdater.doScrollForwards();
    }

    @Override
    public void doStepBackwards() {
        this.mBankUpdater.doScrollBackwards();
    }

    @Override
    public void scrollByPages(int n2) {
        this.mBankUpdater.scrollByPages(n2);
    }

    @Override
    public Scene getScene(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        return (Scene)((Object)this.mBankUpdater.getItemAt(n2));
    }

    @Override
    public void setCurrentDocument(oGX oGX2) {
        if (oGX2 != this.getDocument()) {
            if (oGX2 != null) {
                this.setTarget(oGX2.kBg().FbZ());
            } else {
                this.setTarget(null);
            }
        }
    }

    protected void connectToTarget(SXr sXr) {
        assert (bCi.hFR(sXr != null));
        this.mBankUpdater.setTarget(sXr.CwM());
    }

    protected void disconnectFromTarget(SXr sXr) {
        this.mBankUpdater.clearTarget();
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        this.newSince(2);
        return this.mBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n2) {
        this.newSince(7);
        this.mBankUpdater.scrollIntoView(n2);
    }

    @Override
    public void addScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        this.deprecated(1, 2, "Use scrollPosition() instead");
        this.mBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback, n2);
    }

    @Override
    public BooleanValue canScrollBackwards() {
        this.newSince(2);
        return this.mBankUpdater.getCanScrollBackwards();
    }

    @Override
    public void addCanScrollUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollBackwards() instead");
        this.mBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mBankUpdater.getCanScrollForwards();
    }

    @Override
    public void addCanScrollDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollForwards() instead");
        this.mBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addSceneCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use sceneCount() instead");
        this.mBankUpdater.getListItemCount().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public HardwareActionBindable scrollBackwardsAction() {
        return this.mBankUpdater.scrollBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollForwardsAction() {
        return this.mBankUpdater.scrollForwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageBackwardsAction() {
        return this.mBankUpdater.scrollPageBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageForwardsAction() {
        return this.mBankUpdater.scrollPageForwardsAction();
    }

    @Override
    public void addNameObserver(IndexedStringValueChangedCallback indexedStringValueChangedCallback) {
        for (int i2 = 0; i2 < this.mSceneProxies.length; ++i2) {
            int n2 = i2;
            this.mSceneProxies[i2].name().addValueObserver(string -> indexedStringValueChangedCallback.valueChanged(n2, (String)string));
        }
    }

    @Override
    public void returnToArrangement() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(this::doReturnToArrangement);
    }

    private void doReturnToArrangement() {
        assert (bCi.OqD(this.isDocumentThread()));
        SXr sXr = (SXr)this.getTarget();
        if (sXr != null) {
            sXr.uwB();
        }
    }

    @Override
    public void launch(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (this.validSceneIndex(n2)) {
            this.mSceneProxies[n2].launch();
        }
    }

    private boolean validSceneIndex(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (n2 >= 0 && n2 < this.mSceneProxies.length) {
            return true;
        }
        if (this.getRequiredApiVersion() == 1) {
            return false;
        }
        throw new aRB("Invalid scene index: " + n2);
    }

    @Override
    public void stop() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(this::doStop);
    }

    @Override
    public HardwareActionBindable stopAction() {
        this.newSince(10);
        return new DocumentAction((ControlSurfaceObject)this, this::doStop);
    }

    private void doStop() {
        SXr sXr = (SXr)this.getTarget();
        if (sXr != null) {
            sXr.LTX();
        }
    }

    public BankItemTargetUpdater getBankUpdater() {
        return this.mBankUpdater;
    }

    @Override
    public void setSkipDisabledItems(boolean bl2) {
    }
}

