/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.NoteOccurrence;
import com.bitwig.extension.controller.api.NoteStep$State;
import com.bitwig.flt.control_surface.proxy.ClipProxy;
import java.util.Objects;

final class NoteStep
implements com.bitwig.extension.controller.api.NoteStep {
    private final ClipProxy mClipProxy;
    private final int mX;
    private final int mY;
    private final int mChannel;
    private int mCachedNoteState;
    private boolean mCachedIsSelected;
    private double mCachedPan = 0.0;
    private double mCachedTimbre = 0.0;
    private double mCachedPressure = 0.0;
    private double mCachedGain = 0.0;
    private double mCachedVelocity = 0.0;
    private double mCachedReleaseVelocity = 0.0;
    private double mCachedDuration = 0.0;
    private double mCachedTranspose = 0.0;
    private boolean mCachedEnableChance = false;
    private double mCachedChance = 0.0;
    private double mCachedVelocitySpread = 0.0;
    private boolean mCachedEnableOccurrence = false;
    private NoteOccurrence mCachedOccurrence = NoteOccurrence.FIRST;
    private boolean mCachedEnableRecurrence = false;
    private int mCachedRecurrence = 0;
    private boolean mCachedEnableRepeat = true;
    private int mCachedRepeatCount = 0;
    private double mCachedRepeatCurve = 0.0;
    private double mCachedRepeatVelocityEnd = 0.0;
    private double mCachedRepeatVelocityCurve = 0.0;
    private boolean mCachedIsMuted = false;

    void copy(NoteStep noteStep) {
        this.mCachedIsSelected = noteStep.mCachedIsSelected;
        this.mCachedPan = noteStep.mCachedPan;
        this.mCachedTimbre = noteStep.mCachedTimbre;
        this.mCachedPressure = noteStep.mCachedPressure;
        this.mCachedGain = noteStep.mCachedGain;
        this.mCachedVelocity = noteStep.mCachedVelocity;
        this.mCachedReleaseVelocity = noteStep.mCachedReleaseVelocity;
        this.mCachedDuration = noteStep.mCachedDuration;
        this.mCachedTranspose = noteStep.mCachedTranspose;
        this.mCachedEnableChance = noteStep.mCachedEnableChance;
        this.mCachedChance = noteStep.mCachedChance;
        this.mCachedVelocitySpread = noteStep.mCachedVelocitySpread;
        this.mCachedEnableOccurrence = noteStep.mCachedEnableOccurrence;
        this.mCachedOccurrence = noteStep.mCachedOccurrence;
        this.mCachedEnableRecurrence = noteStep.mCachedEnableRecurrence;
        this.mCachedRecurrence = noteStep.mCachedRecurrence;
        this.mCachedEnableRepeat = noteStep.mCachedEnableRepeat;
        this.mCachedRepeatCount = noteStep.mCachedRepeatCount;
        this.mCachedRepeatCurve = noteStep.mCachedRepeatCurve;
        this.mCachedRepeatVelocityEnd = noteStep.mCachedRepeatVelocityEnd;
        this.mCachedRepeatVelocityCurve = noteStep.mCachedRepeatVelocityCurve;
        this.mCachedIsMuted = noteStep.mCachedIsMuted;
    }

    public int hashCode() {
        return Objects.hash(this.mX, this.mY, this.mChannel);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NoteStep noteStep = (NoteStep)object;
        return this.mX == noteStep.mX && this.mY == noteStep.mY && this.mChannel == noteStep.mChannel && this.mCachedNoteState == noteStep.mCachedNoteState && this.mCachedIsSelected == noteStep.mCachedIsSelected && Double.compare(noteStep.mCachedPan, this.mCachedPan) == 0 && Double.compare(noteStep.mCachedTimbre, this.mCachedTimbre) == 0 && Double.compare(noteStep.mCachedPressure, this.mCachedPressure) == 0 && Double.compare(noteStep.mCachedGain, this.mCachedGain) == 0 && Double.compare(noteStep.mCachedVelocity, this.mCachedVelocity) == 0 && Double.compare(noteStep.mCachedReleaseVelocity, this.mCachedReleaseVelocity) == 0 && Double.compare(noteStep.mCachedDuration, this.mCachedDuration) == 0 && Double.compare(noteStep.mCachedTranspose, this.mCachedTranspose) == 0 && Double.compare(noteStep.mCachedChance, this.mCachedChance) == 0 && noteStep.mCachedEnableChance == this.mCachedEnableChance && Double.compare(noteStep.mCachedVelocitySpread, this.mCachedVelocitySpread) == 0 && noteStep.mCachedEnableOccurrence == this.mCachedEnableOccurrence && noteStep.mCachedOccurrence == this.mCachedOccurrence && noteStep.mCachedEnableRecurrence == this.mCachedEnableRecurrence && noteStep.mCachedRecurrence == this.mCachedRecurrence && noteStep.mCachedEnableRepeat == this.mCachedEnableRepeat && this.mCachedRepeatCount == noteStep.mCachedRepeatCount && Double.compare(this.mCachedRepeatCurve, noteStep.mCachedRepeatCurve) == 0 && Double.compare(this.mCachedRepeatVelocityEnd, noteStep.mCachedRepeatVelocityEnd) == 0 && Double.compare(this.mCachedRepeatVelocityCurve, noteStep.mCachedRepeatVelocityCurve) == 0 && this.mCachedIsMuted == noteStep.mCachedIsMuted;
    }

    void setCachedNoteState(int n2) {
        NoteStep$State noteStep$State = NoteStep.convertState(n2);
        if (noteStep$State == NoteStep$State.Empty) {
            this.clear();
        }
        this.mCachedNoteState = n2;
    }

    static NoteStep$State convertState(int n2) {
        switch (n2) {
            case 0: {
                return NoteStep$State.Empty;
            }
            case 1: {
                return NoteStep$State.NoteSustain;
            }
            case 2: {
                return NoteStep$State.NoteOn;
            }
        }
        return null;
    }

    void clear() {
        this.mCachedNoteState = 0;
        this.mCachedIsSelected = false;
        this.mCachedTranspose = 0.0;
        this.mCachedVelocity = 0.0;
        this.mCachedReleaseVelocity = 0.0;
        this.mCachedGain = 0.0;
        this.mCachedPan = 0.0;
        this.mCachedPressure = 0.0;
        this.mCachedTimbre = 0.0;
        this.mCachedDuration = 0.0;
        this.mCachedChance = 0.0;
    }

    void setCachedIsSelected(boolean bl2) {
        if (this.mCachedIsSelected != bl2) {
            this.mCachedIsSelected = bl2;
        }
    }

    void setCachedVelocity(double d2) {
        assert (bCi.CwM(d2 >= 0.0 && d2 <= 1.0));
        this.mCachedVelocity = d2;
    }

    void setCachedReleaseVelocity(double d2) {
        assert (bCi.CwM(d2 >= 0.0 && d2 <= 1.0));
        this.mCachedReleaseVelocity = d2;
    }

    void setCachedChance(double d2) {
        assert (bCi.CwM(d2 >= 0.0 && d2 <= 1.0));
        this.mCachedChance = d2;
    }

    void setCachedEnableChance(boolean bl2) {
        this.mCachedEnableChance = bl2;
    }

    void setCachedVelocitySpread(double d2) {
        assert (bCi.CwM(this.mCachedVelocitySpread >= 0.0 && this.mCachedVelocitySpread <= 1.0));
        this.mCachedVelocitySpread = d2;
    }

    void setCachedEnableOccurrence(boolean bl2) {
        this.mCachedEnableOccurrence = bl2;
    }

    void setCachedOccurrence(NoteOccurrence noteOccurrence) {
        this.mCachedOccurrence = noteOccurrence;
    }

    void setCachedEnableRecurrence(boolean bl2) {
        this.mCachedEnableRecurrence = bl2;
    }

    void setCachedRecurrence(int n2) {
        this.mCachedRecurrence = n2;
    }

    void setCachedEnableRepeat(boolean bl2) {
        this.mCachedEnableRepeat = bl2;
    }

    void setCachedRepeatCount(int n2) {
        this.mCachedRepeatCount = n2;
    }

    void setCachedRepeatCurve(double d2) {
        this.mCachedRepeatCurve = d2;
    }

    void setCachedRepeatVelocityEnd(double d2) {
        this.mCachedRepeatVelocityEnd = d2;
    }

    void setCachedRepeatVelocityCurve(double d2) {
        this.mCachedRepeatVelocityCurve = d2;
    }

    void setCachedDuration(double d2) {
        this.mCachedDuration = d2;
    }

    void setCachedPan(double d2) {
        this.mCachedPan = d2;
    }

    void setCachedTranspose(double d2) {
        this.mCachedTranspose = d2;
    }

    void setCachedTimbre(double d2) {
        this.mCachedTimbre = d2;
    }

    void setCachedPressure(double d2) {
        this.mCachedPressure = d2;
    }

    void setCachedGain(double d2) {
        this.mCachedGain = d2;
    }

    public void setCachedIsMuted(boolean bl2) {
        this.mCachedIsMuted = bl2;
    }

    @Override
    public int x() {
        return this.mX;
    }

    @Override
    public int y() {
        return this.mY;
    }

    @Override
    public int channel() {
        return this.mChannel;
    }

    @Override
    public NoteStep$State state() {
        return NoteStep.convertState(this.mCachedNoteState);
    }

    @Override
    public double velocity() {
        return this.mCachedVelocity;
    }

    @Override
    public void setVelocity(double d2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedVelocity == d2) {
            return;
        }
        this.mClipProxy.updateStepVelocity(this, d2);
        this.mCachedVelocity = d2;
    }

    @Override
    public double releaseVelocity() {
        return this.mCachedReleaseVelocity;
    }

    @Override
    public void setReleaseVelocity(double d2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedReleaseVelocity == d2) {
            return;
        }
        this.mClipProxy.updateStepReleaseVelocity(this, d2);
        this.mCachedReleaseVelocity = d2;
    }

    @Override
    public double velocitySpread() {
        return this.mCachedVelocitySpread;
    }

    @Override
    public void setVelocitySpread(double d2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedVelocitySpread == d2) {
            return;
        }
        this.mClipProxy.updateStepVelocitySpread(this, d2);
        this.mCachedVelocitySpread = d2;
    }

    @Override
    public double duration() {
        return this.mCachedDuration;
    }

    @Override
    public void setDuration(double d2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedDuration == d2) {
            return;
        }
        this.mClipProxy.updateStepDuration(this, d2);
        this.mCachedDuration = d2;
    }

    @Override
    public double pan() {
        return this.mCachedPan;
    }

    @Override
    public void setPan(double d2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedPan == d2) {
            return;
        }
        this.mClipProxy.updateStepPan(this, d2);
        this.mCachedPan = d2;
    }

    @Override
    public double timbre() {
        return this.mCachedTimbre;
    }

    @Override
    public void setTimbre(double d2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedTimbre == d2) {
            return;
        }
        this.mClipProxy.updateStepTimbre(this, d2);
        this.mCachedTimbre = d2;
    }

    @Override
    public double pressure() {
        return this.mCachedPressure;
    }

    @Override
    public void setPressure(double d2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedPressure == d2) {
            return;
        }
        this.mClipProxy.updateStepPressure(this, d2);
        this.mCachedPressure = d2;
    }

    @Override
    public double gain() {
        return this.mCachedGain;
    }

    @Override
    public void setGain(double d2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedGain == d2) {
            return;
        }
        this.mClipProxy.updateStepGain(this, d2);
        this.mCachedGain = d2;
    }

    @Override
    public double transpose() {
        return this.mCachedTranspose;
    }

    @Override
    public void setTranspose(double d2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedTranspose == d2) {
            return;
        }
        this.mClipProxy.updateStepTranspose(this, d2);
        this.mCachedTranspose = d2;
    }

    @Override
    public boolean isIsSelected() {
        return this.mCachedIsSelected;
    }

    @Override
    public double chance() {
        return this.mCachedChance;
    }

    @Override
    public void setChance(double d2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedChance == d2) {
            return;
        }
        this.mClipProxy.updateStepChance(this, d2);
        this.mCachedChance = d2;
    }

    @Override
    public boolean isChanceEnabled() {
        return this.mCachedEnableChance;
    }

    @Override
    public void setIsChanceEnabled(boolean bl2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedEnableChance == bl2) {
            return;
        }
        this.mClipProxy.updateStepEnableChance(this, bl2);
        this.mCachedEnableChance = bl2;
    }

    @Override
    public boolean isOccurrenceEnabled() {
        return this.mCachedEnableOccurrence;
    }

    @Override
    public void setIsOccurrenceEnabled(boolean bl2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedEnableOccurrence == bl2) {
            return;
        }
        this.mClipProxy.updateStepEnableOccurrence(this, bl2);
        this.mCachedEnableOccurrence = bl2;
    }

    @Override
    public NoteOccurrence occurrence() {
        return this.mCachedOccurrence;
    }

    @Override
    public void setOccurrence(NoteOccurrence noteOccurrence) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedOccurrence == noteOccurrence) {
            return;
        }
        this.mClipProxy.updateStepOccurrence(this, noteOccurrence);
        this.mCachedOccurrence = noteOccurrence;
    }

    @Override
    public boolean isRecurrenceEnabled() {
        return this.mCachedEnableRecurrence;
    }

    @Override
    public void setIsRecurrenceEnabled(boolean bl2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedEnableRecurrence == bl2) {
            return;
        }
        this.mClipProxy.updateStepEnableRecurrence(this, bl2);
        this.mCachedEnableRecurrence = bl2;
    }

    @Override
    public int recurrenceLength() {
        return (this.mCachedRecurrence & 7) + 1;
    }

    @Override
    public int recurrenceMask() {
        return 0xFF & this.mCachedRecurrence >> 3;
    }

    @Override
    public void setRecurrence(int n2, int n3) {
        pXo.inRange(n2, 1, 8, "length");
        pXo.inRange(n3, 0, 255, "mask");
        int n4 = n2 - 1 | n3 << 3;
        if (this.state() != NoteStep$State.NoteOn || this.mCachedRecurrence == n4) {
            return;
        }
        this.mClipProxy.updateStepRecurrence(this, n4);
        this.mCachedRecurrence = n4;
    }

    @Override
    public boolean isRepeatEnabled() {
        return this.mCachedEnableRepeat;
    }

    @Override
    public void setIsRepeatEnabled(boolean bl2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedEnableRepeat == bl2) {
            return;
        }
        this.mClipProxy.updateStepEnableRepeat(this, bl2);
        this.mCachedEnableRepeat = bl2;
    }

    @Override
    public int repeatCount() {
        return this.mCachedRepeatCount;
    }

    @Override
    public void setRepeatCount(int n2) {
        pXo.inRange(n2, -127, 127, "count");
        if (this.state() != NoteStep$State.NoteOn || this.mCachedRepeatCount == n2) {
            return;
        }
        this.mClipProxy.updateStepRepeatCount(this, n2);
        this.mCachedRepeatCount = n2;
    }

    @Override
    public double repeatCurve() {
        return this.mCachedRepeatCurve;
    }

    @Override
    public void setRepeatCurve(double d2) {
        pXo.inRange(d2, -1.0, 1.0, "curve");
        if (this.state() != NoteStep$State.NoteOn || this.mCachedRepeatCurve == d2) {
            return;
        }
        this.mClipProxy.updateStepRepeatCurve(this, d2);
        this.mCachedRepeatCurve = d2;
    }

    @Override
    public double repeatVelocityEnd() {
        return this.mCachedRepeatVelocityEnd;
    }

    @Override
    public void setRepeatVelocityEnd(double d2) {
        pXo.inRange(d2, -1.0, 1.0, "velocityEnd");
        if (this.state() != NoteStep$State.NoteOn || this.mCachedRepeatVelocityEnd == d2) {
            return;
        }
        this.mClipProxy.updateStepRepeatVelocityEnd(this, d2);
        this.mCachedRepeatVelocityEnd = d2;
    }

    @Override
    public double repeatVelocityCurve() {
        return this.mCachedRepeatVelocityCurve;
    }

    @Override
    public void setRepeatVelocityCurve(double d2) {
        pXo.inRange(d2, -1.0, 1.0, "curve");
        if (this.state() != NoteStep$State.NoteOn || this.mCachedRepeatVelocityCurve == d2) {
            return;
        }
        this.mClipProxy.updateStepRepeatVelocityCurve(this, d2);
        this.mCachedRepeatVelocityCurve = d2;
    }

    @Override
    public boolean isMuted() {
        return this.mCachedIsMuted;
    }

    @Override
    public void setIsMuted(boolean bl2) {
        if (this.state() != NoteStep$State.NoteOn || this.mCachedIsMuted == bl2) {
            return;
        }
        this.mClipProxy.updateStepIsMuted(this, bl2);
        this.mCachedIsMuted = bl2;
    }

    int noteState() {
        return this.mCachedNoteState;
    }

    boolean checkBounds(int n2, int n3) {
        return this.mX >= 0 && this.mY >= 0 && this.mChannel >= 0 && this.mX < n2 && this.mY < n3 && this.mChannel < 16;
    }

    NoteStep(int n2, int n3, int n4, ClipProxy clipProxy) {
        this.mClipProxy = clipProxy;
        this.mX = n2;
        this.mY = n3;
        this.mChannel = n4;
    }
}

