/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.ShortMidiDataReceivedCallback;
import com.bitwig.extension.callback.SysexMidiDataReceivedCallback;
import com.bitwig.extension.controller.api.AbsoluteHardwareValueMatcher;
import com.bitwig.extension.controller.api.HardwareActionMatcher;
import com.bitwig.extension.controller.api.MidiExpressions;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.RelativeHardwareValueMatcher;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject$AllowedCreationTime;
import java.io.IOException;

public class MidiInPort
extends ControlSurfaceObject
implements MidiIn {
    private final int mIndex;

    public MidiInPort(ControlSurfaceObject controlSurfaceObject, int n2) {
        super(controlSurfaceObject, ControlSurfaceObject$AllowedCreationTime.DRIVER_SETUP);
        this.mIndex = n2;
    }

    @Override
    public void setMidiCallback(ShortMidiDataReceivedCallback shortMidiDataReceivedCallback) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.getControlSurface().CwM(this.mIndex, shortMidiDataReceivedCallback);
    }

    @Override
    public void setSysexCallback(SysexMidiDataReceivedCallback sysexMidiDataReceivedCallback) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.getControlSurface().CwM(this.mIndex, sysexMidiDataReceivedCallback);
    }

    @Override
    public NoteInput createNoteInput(String string, String ... stringArray) {
        String[] stringArray2 = new String[]{"8?????", "9?????", "B?01??", "B?0B??", "B?40??", "D?????", "E?????"};
        try {
            if (stringArray.length == 0) {
                return this.getControlSurface().CwM(this.getHost(), this.mIndex, string, stringArray2);
            }
            return this.getControlSurface().CwM(this.getHost(), this.mIndex, string, stringArray);
        }
        catch (IOException iOException) {
            throw new TLt("Could not create note input", iOException);
        }
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsolutePitchBendValueMatcher(int n2) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsPitchBendExpression(n2), "data2 << 7 | data1", 14);
    }

    @Override
    public AbsoluteHardwareValueMatcher createSequencedValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher2, boolean bl2) {
        this.checkMatcherIsForThisMidiIn("firstValueMatcher", absoluteHardwareValueMatcher);
        this.checkMatcherIsForThisMidiIn("secondValueMatcher", absoluteHardwareValueMatcher2);
        return new h2y((mgY)((Object)absoluteHardwareValueMatcher), (mgY)((Object)absoluteHardwareValueMatcher2), bl2);
    }

    @Override
    public PB2 createAbsoluteValueMatcher(String string, String string2, int n2) {
        return new PB2(this.createActionMatcher(string), this.parseExpression(string2), n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeValueMatcher(String string, double d2) {
        return new YPp(this, this.parseExpression(string), d2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelativeSignedBitValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new peQ((HrH)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2ValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelativeSignedBit2ValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2ValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new ufv((HrH)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelativeBinOffsetValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new Wwv((HrH)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementValueMatcher(String string, String string2, int n2, int n3) {
        return this.createRelative2sComplementValueMatcher(this.createAbsoluteValueMatcher(string, string2, n2), n3);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementValueMatcher(AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher, int n2) {
        this.checkMatcherIsForThisMidiIn("valueMatcher", absoluteHardwareValueMatcher);
        return new zfm((HrH)absoluteHardwareValueMatcher, n2);
    }

    @Override
    public P1j createActionMatcher(String string) {
        return new P1j(this, this.parseExpression(string));
    }

    @Override
    public HardwareActionMatcher createCCActionMatcher(int n2, int n3, int n4) {
        return this.createActionMatcher(this.midiExpressions().createIsCCValueExpression(n2, n3, n4));
    }

    @Override
    public HardwareActionMatcher createCCActionMatcher(int n2, int n3) {
        return this.createActionMatcher(this.midiExpressions().createIsCCExpression(n2, n3));
    }

    @Override
    public HardwareActionMatcher createNoteOnActionMatcher(int n2, int n3) {
        return this.createActionMatcher(this.midiExpressions().createIsNoteOnExpression(n2, n3));
    }

    @Override
    public AbsoluteHardwareValueMatcher createNoteOnVelocityValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsNoteOnExpression(n2, n3), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createNoteOffVelocityValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsNoteOffExpression(n2, n3), "data2", 7);
    }

    @Override
    public HardwareActionMatcher createNoteOffActionMatcher(int n2, int n3) {
        return this.createActionMatcher(this.midiExpressions().createIsNoteOffExpression(n2, n3));
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsoluteCCValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createAbsoluteCCValueMatcher(int n2) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsCCExpression(n2), "data2", 7);
    }

    @Override
    public AbsoluteHardwareValueMatcher createPolyAftertouchValueMatcher(int n2, int n3) {
        return this.createAbsoluteValueMatcher(this.midiExpressions().createIsPolyAftertouch(n2, n3), "data2", 7);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBitCCValueMatcher(int n2, int n3, int n4) {
        return this.createRelativeSignedBitValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeSignedBit2CCValueMatcher(int n2, int n3, int n4) {
        return this.createRelativeSignedBit2ValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelativeBinOffsetCCValueMatcher(int n2, int n3, int n4) {
        return this.createRelativeBinOffsetValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    @Override
    public RelativeHardwareValueMatcher createRelative2sComplementCCValueMatcher(int n2, int n3, int n4) {
        return this.createRelative2sComplementValueMatcher(this.midiExpressions().createIsCCExpression(n2, n3), "data2", 7, n4);
    }

    private pZs parseExpression(String string) {
        try {
            return pZs.Opd(string);
        }
        catch (yBG yBG2) {
            throw new aRB("Invalid MIDI event expression", yBG2);
        }
    }

    public int getIndex() {
        return this.mIndex;
    }

    public jTN getMidiReceiver() {
        return (jTN)this.getControlSurface().UHd().get(this.mIndex);
    }

    private MidiExpressions midiExpressions() {
        return this.getHost().midiExpressions();
    }

    private void checkMatcherIsForThisMidiIn(String string, AbsoluteHardwareValueMatcher absoluteHardwareValueMatcher) {
        if (!(absoluteHardwareValueMatcher instanceof HrH)) {
            throw new aRB(string + " is not a MIDI value matcher for this MidiIn");
        }
        if (((HrH)absoluteHardwareValueMatcher).Opd() != this) {
            throw new aRB(string + " is not a MIDI value matcher for this MidiIn");
        }
    }
}

