/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

class MIDIEventFilter {
    private int mCheckMask;
    private int mMatchMask;

    MIDIEventFilter(String string) {
        if (string.length() != 6) {
            throw new aRB("Invalid filter");
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            char c3 = string.charAt(i2);
            int n2 = i2 / 2;
            int n3 = i2 & 1;
            int n4 = n2 * 8 + (1 - n3) * 4;
            if (c3 == '?') continue;
            this.mCheckMask |= 15 << n4;
            int n5 = Integer.parseInt(String.valueOf(c3), 16);
            this.mMatchMask |= (n5 & 0xF) << n4;
        }
    }

    public boolean matches(bnl bnl2) {
        return this.matches(bnl2.gav());
    }

    public boolean matches(int n2) {
        return ((n2 ^ this.mMatchMask) & this.mCheckMask) == 0;
    }

    int getCheckMask() {
        return this.mCheckMask;
    }

    int getMatchMask() {
        return this.mMatchMask;
    }

    public boolean isMatchAll() {
        return this.mCheckMask == 0;
    }
}

