/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.DrumPadBank;
import com.bitwig.flt.control_surface.proxy.BankTarget;
import com.bitwig.flt.control_surface.proxy.ChannelBankProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.DrumPadProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.document.core.iface.oGX;
import java.util.ArrayList;
import java.util.List;

public class DrumPadBankProxy
extends ChannelBankProxy
implements DrumPadBank {
    private final boolean mIsIndicating = true;
    private final int mNumLanes;
    private final List mPads;
    private final BooleanValueProxy mHasMutedPads;
    private final BooleanValueProxy mHasSoloedPads;

    public DrumPadBankProxy(ControlSurfaceObject controlSurfaceObject, int n2, int n3) {
        super(controlSurfaceObject, "DrumPadBank-" + n2, n2, n3);
        if (n2 < 1) {
            throw new aRB("At least 1 track is required.");
        }
        this.mNumLanes = n2;
        this.mPads = new ArrayList(n2);
        this.mChannelScrollStepSize = 4;
        this.mHasMutedPads = new BooleanValueProxy((ControlSurfaceObject)this, false);
        this.mHasSoloedPads = new BooleanValueProxy((ControlSurfaceObject)this, false);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getKey() + "/Pad" + i2;
            DrumPadProxy drumPadProxy = new DrumPadProxy(this, string, i2, n3, true);
            this.mPads.add(drumPadProxy);
            this.addChild(drumPadProxy);
        }
        this.initChannelProxies();
    }

    @Override
    public Class getTargetType() {
        return Djn.class;
    }

    protected oGX getDocumentFromTarget(Djn djn2) {
        return djn2.Qf();
    }

    @Override
    public void setIndication(boolean bl2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetIndication(bl2));
    }

    private void doSetIndication(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            DrumPadProxy drumPadProxy = (DrumPadProxy)controlSurfaceProxy;
            drumPadProxy.setIndicating(bl2);
        }
    }

    @Override
    protected int getScrollPositionThatPageShouldAlignTo() {
        return 36;
    }

    @Override
    protected DrumPadProxy createChannelProxy(int n2, int n3, String string) {
        return new DrumPadProxy(this, string + n3, n3, n2, true);
    }

    protected BankTarget createBankTarget(Djn djn2, boolean bl2) {
        return BankTarget.create(djn2.CwM());
    }

    protected void connectToTarget(Djn djn2) {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (bXE bXE2 : djn2.Uft()) {
            int n4 = bXE2.uTQ().LTX();
            n2 = Math.min(n4, n2);
            n3 = Math.max(n4, n3);
        }
        int n5 = this.mChannelBankUpdater.getScrollPositionValue();
        if (n3 >= 0 && (n5 < n2 || n5 > n3)) {
            int n6 = n2 / 4;
            this.mChannelBankUpdater.doScrollTo(4 * n6, true);
        } else {
            this.mChannelBankUpdater.doScrollTo(36, true);
        }
        this.mHasMutedPads.setTarget(djn2.nGB());
        this.mHasSoloedPads.setTarget(djn2.eSQ());
    }

    protected void disconnectFromTarget(Djn djn2) {
        this.mHasMutedPads.clearTarget();
        this.mHasSoloedPads.clearTarget();
    }

    @Override
    public void clearMutedPads() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.newSince(10);
        this.exec(this::doClearMute);
    }

    private void doClearMute() {
        assert (bCi.CwM(this.isDocumentThread()));
        Djn djn2 = (Djn)this.getTarget();
        if (djn2 == null) {
            return;
        }
        djn2.tuW();
    }

    @Override
    public void clearSoloedPads() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.newSince(10);
        this.exec(this::doClearSolo);
    }

    private void doClearSolo() {
        assert (bCi.CwM(this.isDocumentThread()));
        Djn djn2 = (Djn)this.getTarget();
        if (djn2 == null) {
            return;
        }
        djn2.b2R();
    }

    @Override
    public BooleanValue hasMutedPads() {
        this.newSince(10);
        return this.mHasMutedPads;
    }

    @Override
    public BooleanValue hasSoloedPads() {
        this.newSince(10);
        return this.mHasSoloedPads;
    }
}

