/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.Arpeggiator;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.NoteInput$NoteExpression;
import com.bitwig.extension.controller.api.NoteLatch;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.flt.control_surface.proxy.ArpeggiatorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject$AllowedCreationTime;
import com.bitwig.flt.control_surface.proxy.MIDIEventFilter;
import com.bitwig.flt.control_surface.proxy.NoteLatchProxy;
import com.bitwig.flt.control_surface.proxy.ObjectThatWantsToDisposeOnControlSurfaceThread;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.document.core.iface.oGX;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DirectNoteInput
extends ControlSurfaceObject
implements NoteInput,
ObjectThatWantsToDisposeOnControlSurfaceThread {
    private int mEngineNoteInputId;
    private boolean mShouldConsumeEvents;
    private final List mFilters;
    private final String mName;
    private final int mPort;
    private final ArpeggiatorProxy mArpeggiatorProxy;
    private final NoteLatchProxy mNoteLatchProxy;
    private Ni3 mNoteSource;
    private final SettableBooleanValueProxy mIncludeInAllInputs;
    private byte[] mKeyTranslationTable;

    public DirectNoteInput(ControlSurfaceObject controlSurfaceObject, int n2, String string, String[] stringArray, boolean bl2) {
        super(controlSurfaceObject, ControlSurfaceObject$AllowedCreationTime.INIT);
        this.mPort = n2;
        this.mName = string;
        this.mEngineNoteInputId = this.getMidiReceiver().CwM(bl2);
        this.mIncludeInAllInputs = new SettableBooleanValueProxy((ControlSurfaceObject)this, true);
        this.mNoteLatchProxy = new NoteLatchProxy(this);
        this.mArpeggiatorProxy = new ArpeggiatorProxy(this);
        this.mFilters = new ArrayList(stringArray.length);
        for (String string2 : stringArray) {
            try {
                MIDIEventFilter mIDIEventFilter = new MIDIEventFilter(string2);
                this.mFilters.add(mIDIEventFilter);
            }
            catch (aRB aRB2) {
                bCi.m2i.OqD("Could not parse note input mask", aRB2);
            }
        }
        this.sendNoteInputMasks();
    }

    public int getEngineNoteInputId() {
        return this.mEngineNoteInputId;
    }

    @Override
    public void disposeOnControlSurfaceThread() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        try {
            assert (bCi.Opd(this.mEngineNoteInputId >= 0));
            this.getMidiReceiver().CwM(this.mEngineNoteInputId);
            this.mEngineNoteInputId = -1;
        }
        catch (IOException iOException) {
            bCi.m2i.CwM(iOException);
        }
    }

    private void sendNoteInputMasks() {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        int n2 = this.mFilters.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            nArray[n3] = mIDIEventFilter.getCheckMask();
            nArray2[n3] = mIDIEventFilter.getMatchMask();
            ++n3;
        }
        this.getMidiReceiver().CwM(this.mEngineNoteInputId, nArray, nArray2);
    }

    private void sendKeyMap(byte[] byArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        assert (bCi.OqD(byArray.length == 128));
        this.getMidiReceiver().CwM(this.mEngineNoteInputId, byArray);
    }

    private void sendVelocityMap(byte[] byArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        assert (bCi.OqD(byArray.length == 128));
        this.getMidiReceiver().Opd(this.mEngineNoteInputId, byArray);
    }

    private jTN getMidiReceiver() {
        return (jTN)this.getControlSurface().UHd().get(this.mPort);
    }

    public int getPort() {
        return this.mPort;
    }

    public boolean shouldConsumeEvents() {
        return this.mShouldConsumeEvents;
    }

    @Override
    public void setShouldConsumeEvents(boolean bl2) {
        this.mShouldConsumeEvents = bl2;
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        try {
            this.getMidiReceiver().CwM(this.mEngineNoteInputId, bl2);
        }
        catch (IOException iOException) {
            throw new TLt(iOException);
        }
    }

    private byte[] convertJavaScriptArrayToByteArray(Object[] objectArray) {
        byte[] byArray = new byte[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!(objectArray[i2] instanceof Number)) {
                throw new aRB("Object in array not instance of Number");
            }
            Number number = (Number)objectArray[i2];
            if (number.intValue() < -128 || number.intValue() > 127) {
                throw new aRB("Value out of range");
            }
            byArray[i2] = number.byteValue();
        }
        return byArray;
    }

    @Override
    public void setKeyTranslationTable(Object[] objectArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new aRB("Map must have a length of 128");
        }
        this.mKeyTranslationTable = this.convertJavaScriptArrayToByteArray(objectArray);
        try {
            this.sendKeyMap(this.mKeyTranslationTable);
        }
        catch (IOException iOException) {
            throw new TLt(iOException);
        }
    }

    @Override
    public void setVelocityTranslationTable(Object[] objectArray) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new aRB("Map must have a length of 128");
        }
        try {
            this.sendVelocityMap(this.convertJavaScriptArrayToByteArray(objectArray));
        }
        catch (IOException iOException) {
            throw new TLt(iOException);
        }
    }

    @Override
    public void assignPolyphonicAftertouchToExpression(int n2, NoteInput$NoteExpression noteInput$NoteExpression, int n3) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        try {
            this.getMidiReceiver().CwM(this.mEngineNoteInputId, n2, noteInput$NoteExpression, n3);
        }
        catch (IOException iOException) {
            throw new TLt(iOException);
        }
    }

    @Override
    public void setUseExpressiveMidi(boolean bl2, int n2, int n3) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (n2 != 0 && n2 != 15) {
            throw new aRB("baseChannel must be either 0 or 15");
        }
        if (n3 < 0 || n3 > 96) {
            throw new aRB("pitchBendRange must be between 0 or 96");
        }
        try {
            this.getMidiReceiver().CwM(this.mEngineNoteInputId, bl2, n2, n3);
        }
        catch (IOException iOException) {
            throw new TLt(iOException);
        }
    }

    @Override
    public void setUseMultidimensionalPolyphonicExpression(boolean bl2, int n2) {
        this.deprecated(1, 2);
        this.setUseExpressiveMidi(bl2, n2, 48);
    }

    @Override
    public void sendRawMidiEvent(int n2, int n3, int n4) {
        if (this.mEngineNoteInputId == -1) {
            return;
        }
        if (n2 < 128 || n2 > 255) {
            throw new aRB("Status byte out of range");
        }
        if (n3 < 0 || n3 > 127) {
            throw new aRB("data0 byte out of range");
        }
        if (n4 < 0 || n4 > 127) {
            throw new aRB("data1 byte out of range");
        }
        try {
            this.getMidiReceiver().CwM(this.mEngineNoteInputId, n2, n3, n4);
        }
        catch (IOException iOException) {
            throw new TLt(iOException);
        }
    }

    @Override
    public NoteLatch noteLatch() {
        this.newSince(10);
        return this.mNoteLatchProxy;
    }

    public boolean isMatchAll() {
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            if (!mIDIEventFilter.isMatchAll()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public Arpeggiator arpeggiator() {
        this.newSince(10);
        return this.mArpeggiatorProxy;
    }

    public void connectToDocument(oGX oGX2) {
        assert (bCi.OqD(this.mNoteSource == null));
        this.mNoteSource = oGX2.CwM(this.mEngineNoteInputId);
        this.mIncludeInAllInputs.setTarget(this.mNoteSource.LTX());
        this.mNoteLatchProxy.setTarget(this.mNoteSource.OqD());
        this.mArpeggiatorProxy.setTarget(this.mNoteSource.hFR());
    }

    public void disconnectFromDocument() {
        assert (bCi.OqD(this.mNoteSource != null));
        this.mNoteLatchProxy.clearTarget();
        this.mArpeggiatorProxy.clearTarget();
        this.mIncludeInAllInputs.clearTarget();
        this.mNoteSource = null;
    }

    Ni3 getNoteSource() {
        return this.mNoteSource;
    }

    @Override
    public SettableBooleanValue includeInAllInputs() {
        this.newSince(10);
        return this.mIncludeInAllInputs;
    }

    public boolean shoulProcessEvent(bnl bnl2) {
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            if (!mIDIEventFilter.matches(bnl2)) continue;
            return true;
        }
        return false;
    }

    public bnl getTransformedEvent(bnl bnl2) {
        assert (bCi.OqD(this.shoulProcessEvent(bnl2)));
        if (bnl2.OqD()) {
            int n2 = bnl2.hFR();
            if (this.mKeyTranslationTable != null) {
                if ((n2 = this.mKeyTranslationTable[n2]) == -1) {
                    return null;
                }
                return new bnl(bnl2.WW1(), n2, bnl2.nSA());
            }
        }
        return bnl2;
    }
}

