/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.Browser;
import com.bitwig.extension.controller.api.DeviceBank;
import com.bitwig.extension.controller.api.DeviceChain;
import com.bitwig.extension.controller.api.InsertionPoint;
import com.bitwig.flt.control_surface.proxy.BitwigStudioHost;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceBankProxy;
import com.bitwig.flt.control_surface.proxy.DeviceChainBrowserProxy;
import java.util.ArrayList;
import java.util.List;

public abstract class DeviceChainProxy
extends ControlSurfaceDocumentObjectProxy
implements DeviceChain {
    private Nu mDeviceChain;
    private final List mDeviceBanks = new ArrayList(2);
    private DeviceChainBrowserProxy mDeviceBrowser;
    private final vxw mStartOfDeviceChainInsertionPoint = new vxw(this);
    private final OyR mEndOfDeviceChainInsertionPoint = new OyR(this);

    public DeviceChainProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.setKey(string);
    }

    @Override
    public void browseToInsertAtEndOfChain() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.deprecated(2, 7, "Use endOfDeviceChainInsertionPoint().browse() instead.");
        this.exec(this::doBrowseToInsertAtEndOfChain);
    }

    private void doBrowseToInsertAtEndOfChain() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mDeviceChain != null) {
            RN.Opd(null, this.mDeviceChain);
        }
    }

    @Override
    public void browseToInsertAtStartOfChain() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.deprecated(2, 7, "Use startOfDeviceChainInsertionPoint().browse() instead.");
        this.exec(this::doBrowseToInsertAtStartOfChain);
    }

    private void doBrowseToInsertAtStartOfChain() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mDeviceChain != null) {
            RN.CwM(null, this.mDeviceChain);
        }
    }

    @Override
    public InsertionPoint startOfDeviceChainInsertionPoint() {
        return this.mStartOfDeviceChainInsertionPoint;
    }

    @Override
    public InsertionPoint endOfDeviceChainInsertionPoint() {
        return this.mEndOfDeviceChainInsertionPoint;
    }

    protected void setDeviceChain(Nu nu2) {
        if (nu2 != this.mDeviceChain) {
            if (this.mDeviceChain != null) {
                this.disconnectFromDeviceChain(this.mDeviceChain);
            }
            this.mDeviceChain = nu2;
            if (this.mDeviceChain != null) {
                this.connectToDeviceChain(this.mDeviceChain);
            }
        }
    }

    private void connectToDeviceChain(Nu nu2) {
        assert (bCi.hFR(nu2 != null));
        for (DeviceBankProxy deviceBankProxy : this.mDeviceBanks) {
            deviceBankProxy.setTarget(nu2);
        }
        if (this.mDeviceBrowser != null) {
            this.mDeviceBrowser.connectToDeviceChain(nu2);
        }
        this.connectObservers(nu2);
    }

    private void disconnectFromDeviceChain(Nu nu2) {
        assert (bCi.hFR(nu2 != null));
        assert (bCi.hFR(nu2 == this.mDeviceChain));
        this.disconnectObservers(nu2);
        if (this.mDeviceBrowser != null) {
            this.mDeviceBrowser.disconnectFromDeviceChain(nu2);
        }
        for (DeviceBankProxy deviceBankProxy : this.mDeviceBanks) {
            deviceBankProxy.clearTarget();
        }
    }

    @Override
    public DeviceBank createDeviceBank(int n2) {
        DeviceBankProxy deviceBankProxy = new DeviceBankProxy(this, n2, this.getNumSends());
        this.mDeviceBanks.add(deviceBankProxy);
        return deviceBankProxy;
    }

    protected int getNumSends() {
        return 0;
    }

    @Override
    public void select() {
        this.selectInEditor();
    }

    @Override
    public void addIsSelectedObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2);
        this.addIsSelectedInEditorObserver(booleanValueChangedCallback);
    }

    public Nu getDeviceChain() {
        return this.mDeviceChain;
    }

    protected abstract String getAutomaticNotificationPrefix();

    protected abstract String getName();

    protected void showSelectionNotification() {
        BitwigStudioHost bitwigStudioHost = this.getHost();
        if (bitwigStudioHost.getNotificationSettings().shouldShowTrackSelectionNotifications()) {
            this.getControlSurface().CwM(this.getAutomaticNotificationPrefix(), this.getName());
        }
    }

    @Override
    public Browser createDeviceBrowser(int n2, int n3) {
        if (this.mDeviceBrowser == null) {
            this.mDeviceBrowser = new DeviceChainBrowserProxy(this, n2, n3);
            this.addChild(this.mDeviceBrowser);
            if (this.mDeviceChain != null) {
                this.mDeviceBrowser.connectToDeviceChain(this.mDeviceChain);
            }
        }
        return this.mDeviceBrowser;
    }
}

