/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.DeviceBank;
import com.bitwig.extension.controller.api.DeviceChain;
import com.bitwig.extension.controller.api.DeviceMatcher;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.AbstractDeviceMatcher;
import com.bitwig.flt.control_surface.proxy.ActiveDeviceMatcher;
import com.bitwig.flt.control_surface.proxy.AndDeviceMatcher;
import com.bitwig.flt.control_surface.proxy.BankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.BankTarget;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceChainProxy;
import com.bitwig.flt.control_surface.proxy.DeviceProxy;
import com.bitwig.flt.control_surface.proxy.MatchingPlaybackDevicesBankTarget;
import com.bitwig.flt.document.core.iface.oGX;
import java.util.Objects;

public class DeviceBankProxy
extends ControlSurfaceDocumentObjectProxy
implements DeviceBank,
yfM {
    private final int mNumDevices;
    private final DeviceProxy[] mDeviceProxies;
    private final BankItemTargetUpdater mDeviceBankUpdater;
    private final DeviceChain mDeviceChainSection;
    private boolean mSkipDisabledItems = false;
    private AbstractDeviceMatcher mDeviceMatcher;

    protected DeviceBankProxy(DeviceChainProxy deviceChainProxy, int n2, int n3) {
        super(deviceChainProxy);
        this.setKey("Device Chain");
        if (n2 < 1) {
            throw new aRB("At least 1 device is required.");
        }
        this.mDeviceChainSection = deviceChainProxy;
        this.mNumDevices = n2;
        this.mDeviceProxies = new DeviceProxy[n2];
        for (int i2 = 0; i2 < this.mNumDevices; ++i2) {
            this.mDeviceProxies[i2] = new DeviceProxy(this, this.getKey() + " / Device " + i2, n3, deviceChainProxy);
        }
        this.mDeviceBankUpdater = new BankItemTargetUpdater((ControlSurfaceObject)this, this.mDeviceProxies);
    }

    @Override
    public Class getTargetType() {
        return Nu.class;
    }

    protected oGX getDocumentFromTarget(Nu nu2) {
        return nu2.Qf();
    }

    @Override
    public DeviceChain getDeviceChain() {
        return this.mDeviceChainSection;
    }

    @Override
    public IntegerValue itemCount() {
        return this.mDeviceBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mDeviceBankUpdater.getCursorIndex();
    }

    @Override
    public void setSkipDisabledItems(boolean bl2) {
        this.newSince(11);
        this.exec(() -> this.doSetSkipDisabledItems(bl2));
    }

    private void doSetSkipDisabledItems(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mSkipDisabledItems != bl2) {
            this.mSkipDisabledItems = bl2;
            this.updateBankTarget();
        }
    }

    private void updateBankTarget() {
        assert (bCi.OqD(this.isDocumentThread()));
        Nu nu2 = (Nu)this.getTarget();
        if (nu2 != null) {
            this.mDeviceBankUpdater.setTarget(this.createBankTarget(nu2));
        }
    }

    private BankTarget createBankTarget(Nu nu2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(nu2 != null));
        AbstractDeviceMatcher abstractDeviceMatcher = this.getEffectiveDeviceMatcher();
        return abstractDeviceMatcher != null ? new MatchingPlaybackDevicesBankTarget(nu2, abstractDeviceMatcher) : BankTarget.create(nu2.Uft());
    }

    private AbstractDeviceMatcher getEffectiveDeviceMatcher() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mSkipDisabledItems) {
            if (this.mDeviceMatcher == null) {
                return new ActiveDeviceMatcher();
            }
            return new AndDeviceMatcher(new AbstractDeviceMatcher[]{new ActiveDeviceMatcher(), this.mDeviceMatcher});
        }
        return this.mDeviceMatcher;
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mDeviceBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mDeviceBankUpdater.getCanScrollForwards();
    }

    @Override
    public int getSizeOfBank() {
        return this.mDeviceBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n2) {
        this.mDeviceBankUpdater.setSizeOfBank(n2);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mDeviceBankUpdater.getCapacityOfBank();
    }

    @Override
    public Device getItemAt(int n2) {
        return (Device)((Object)this.mDeviceBankUpdater.getItemAt(n2));
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mDeviceBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n2) {
        this.newSince(7);
        this.mDeviceBankUpdater.scrollIntoView(n2);
    }

    @Override
    public void scrollBy(int n2) {
        this.mDeviceBankUpdater.scrollBy(n2);
    }

    @Override
    public void doStepForwards() {
        this.mDeviceBankUpdater.doScrollForwards();
    }

    @Override
    public void doStepBackwards() {
        this.mDeviceBankUpdater.doScrollBackwards();
    }

    @Override
    public void scrollByPages(int n2) {
        this.mDeviceBankUpdater.scrollByPages(n2);
    }

    public void navigateToDeviceLayer(int n2, int n3) {
        this.validIndex(this.mDeviceProxies, n2);
        if (n3 < 0) {
            throw new aRB("layerIndex must be >= 0");
        }
        this.exec(() -> {
            guE guE2;
            tRo tRo2;
            VM vM2;
            DeviceProxy deviceProxy = this.mDeviceProxies[n2];
            llf llf2 = deviceProxy.getDevice();
            if (llf2 instanceof Uo3 && (vM2 = (tRo2 = (tRo)llf2.ynG()).uwB()) instanceof guE && n3 < (guE2 = (guE)vM2).fn()) {
                bXE bXE2 = guE2.Opd(n3);
                this.setTarget(bXE2.bh_());
            }
        });
    }

    public void navigateToKeyPad(int n2, int n3) {
        this.validIndex(this.mDeviceProxies, n2);
        if (n3 < 0 || n3 > 127) {
            throw new aRB("Invalid key");
        }
        this.exec(() -> {
            Djn djn2;
            nB nB2;
            bXE bXE2;
            tRo tRo2;
            VM vM2;
            DeviceProxy deviceProxy = this.mDeviceProxies[n2];
            llf llf2 = deviceProxy.getDevice();
            if (llf2 instanceof Uo3 && (vM2 = (tRo2 = (tRo)llf2.ynG()).uwB()) instanceof Djn && (bXE2 = (nB2 = (djn2 = (Djn)vM2).CwM(n3)).OqD()) != null) {
                this.setTarget(bXE2.bh_());
            }
        });
    }

    public void navigateToDeviceSlot(int n2, String string) {
        this.validIndex(this.mDeviceProxies, n2);
        this.notNull(string, "chain");
        this.exec(() -> {
            DeviceProxy deviceProxy = this.mDeviceProxies[n2];
            llf llf2 = deviceProxy.getDevice();
            if (llf2 instanceof Uo3) {
                tRo tRo2 = (tRo)llf2.ynG();
                for (mAr mAr2 : tRo2.aMy()) {
                    nP1 nP12;
                    if (!(mAr2 instanceof nP1) || !(nP12 = (nP1)mAr2).CwM().equals(string)) continue;
                    this.setTarget(nP12.uwB().bh_());
                    return;
                }
            }
        });
    }

    @Override
    public void scrollPageUp() {
        this.mDeviceBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageDown() {
        this.mDeviceBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollUp() {
        this.mDeviceBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollDown() {
        this.mDeviceBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollTo(int n2) {
        this.mDeviceBankUpdater.scrollIntoView(n2);
    }

    @Override
    public Device getDevice(int n2) {
        return (Device)((Object)this.mDeviceBankUpdater.getItemAt(n2));
    }

    protected void connectToTarget(Nu nu2) {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.hFR(nu2 != null));
        this.mDeviceBankUpdater.setTarget(this.createBankTarget(nu2));
        this.connectObservers(nu2);
    }

    protected void disconnectFromTarget(Nu nu2) {
        assert (bCi.CwM(this.isDocumentThread()));
        this.mDeviceBankUpdater.clearTarget();
    }

    @Override
    public void addScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        this.deprecated(1, 2, "Use scrollPosition() instead");
        this.mDeviceBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback, n2);
    }

    @Override
    public void addCanScrollUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollBackwards() instead");
        this.mDeviceBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanScrollDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollForwards() instead");
        this.mDeviceBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addDeviceCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use itemCount().addValueObserver(callback)");
        this.mDeviceBankUpdater.getListItemCount().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public HardwareActionBindable scrollBackwardsAction() {
        return this.mDeviceBankUpdater.scrollBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollForwardsAction() {
        return this.mDeviceBankUpdater.scrollForwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageBackwardsAction() {
        return this.mDeviceBankUpdater.scrollPageBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageForwardsAction() {
        return this.mDeviceBankUpdater.scrollPageForwardsAction();
    }

    @Override
    public void browseToInsertDevice(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.inRange(n2, 0, this.getSizeOfBank(), "index");
        this.exec(() -> this.doBrowseToInsertDevice(n2));
    }

    private void doBrowseToInsertDevice(int n2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(n2 >= 0 && n2 <= this.getSizeOfBank()));
        Nu nu2 = (Nu)this.getTarget();
        if (nu2 != null) {
            int n3 = f2f.CwM(this.mDeviceBankUpdater.getScrollPositionValue() + n2, 0, nu2.AaH());
            if (n3 > 0) {
                llf llf2 = nu2.Opd(n3 - 1);
                RN.CwM(null, new RE(llf2));
            } else {
                RN.CwM(null, new RH(nu2));
            }
        }
    }

    @Override
    public void setDeviceMatcher(DeviceMatcher deviceMatcher) {
        this.newSince(12);
        AbstractDeviceMatcher abstractDeviceMatcher = AbstractDeviceMatcher.get(deviceMatcher);
        if (this.isInitializingDriver()) {
            this.mDeviceMatcher = abstractDeviceMatcher;
        } else {
            this.exec(() -> this.doSetDeviceMatcher(abstractDeviceMatcher));
        }
    }

    private void doSetDeviceMatcher(AbstractDeviceMatcher abstractDeviceMatcher) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (!Objects.equals(abstractDeviceMatcher, this.mDeviceMatcher)) {
            this.mDeviceMatcher = abstractDeviceMatcher;
            this.updateBankTarget();
        }
    }
}

