/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.DataReceivedCallback;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ObjectThatWantsToDisposeOnControlSurfaceThread;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Arrays;

public class DatagramServerSection
extends ControlSurfaceObject
implements ObjectThatWantsToDisposeOnControlSurfaceThread {
    private final Thread mReceiveThread;
    private final DatagramSocket mServerSocket;
    private final String mName;
    private final int mPort;
    private final DataReceivedCallback mCallback;

    public DatagramServerSection(ControlSurfaceObject controlSurfaceObject, String string, int n2, DataReceivedCallback dataReceivedCallback) {
        super(controlSurfaceObject);
        this.mName = string;
        this.mPort = n2;
        this.mCallback = dataReceivedCallback;
        this.mServerSocket = new DatagramSocket(n2);
        this.mReceiveThread = new Thread(() -> {
            Thread.currentThread().setName(string + "/UDP");
            byte[] byArray = new byte[65536];
            while (!this.mServerSocket.isClosed()) {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                try {
                    this.mServerSocket.receive(datagramPacket);
                    byte[] byArray2 = Arrays.copyOfRange(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getOffset() + datagramPacket.getLength());
                    this.queueCallbackFromNonDocumentThread(() -> this.mCallback.dataReceived(byArray2));
                }
                catch (IOException iOException) {
                    bCi.m2i.CwM(iOException);
                }
            }
        }, "DatagramServer-Receiver");
        this.mReceiveThread.start();
    }

    @Override
    public void disposeOnControlSurfaceThread() {
        this.mReceiveThread.interrupt();
        this.mServerSocket.close();
    }
}

