/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.HardwareControlType;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.CursorRemoteControlsPageProxy$SelectedPageIndexValue;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.proxy.ParameterBankProxy;
import com.bitwig.flt.control_surface.proxy.RemoteControlProxy;
import com.bitwig.flt.control_surface.proxy.RemoteControlsPageProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.IntegerValueProxy;
import com.bitwig.flt.control_surface.values.SettableIntegerValueProxy;
import com.bitwig.flt.control_surface.values.StringArrayValueProxy;
import com.bitwig.ramona.core.UHW;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class CursorRemoteControlsPageProxy
extends ControlSurfaceDocumentObjectProxy
implements XQN,
CursorRemoteControlsPage,
ParameterBankProxy,
yfM {
    private static final String[] NO_PAGE_NAMES = new String[0];
    private final bmy mPagesChangedListener = object -> this.invalidatePages();
    private HardwareControlType mHardwareControlType = HardwareControlType.KNOB;
    private int mHardwareColumns = 8;
    private boolean mHasScheduledUpdateToPages;
    private List mPages;
    private final StringArrayValueProxy mPageNamesValue;
    private final SettableIntegerValueProxy mSelectedPageIndexValue;
    private final HQv mPageNames;
    private final YaO mPageCount = new YaO(0);
    private final IntegerValueProxy mPageCountValue;
    private final RemoteControlsPageProxy mSelectedPageProxy;
    private final UZ1 mHasPrevParameterPage = new UZ1(false);
    private final UZ1 mHasNextParameterPage = new UZ1(false);
    private final CursorRemoteControlsPageProxy$SelectedPageIndexValue mSelectedPageIndex = new CursorRemoteControlsPageProxy$SelectedPageIndexValue(this, 0);
    private final BooleanValueProxy mHasNextPageValue;
    private final BooleanValueProxy mHasPreviousPageValue;
    private How mPageSelector;
    private boolean mIsChangingPageFromController;
    private final TgC mSelectedPageListener = svx -> this.scheduleUpdateSelectedPage();
    private boolean mHasScheduledUpdateSelectedPage;
    private boolean mWasChangingPageFromControllerWhenScheduling;

    protected CursorRemoteControlsPageProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2) {
        super(controlSurfaceObject);
        assert (bCi.OqD(string != null));
        assert (bCi.OqD(n2 >= 1));
        this.mSelectedPageProxy = new RemoteControlsPageProxy(this, string, n2);
        this.mPageNamesValue = new StringArrayValueProxy((ControlSurfaceObject)this, NO_PAGE_NAMES);
        this.mPageNames = new HQv(NO_PAGE_NAMES);
        this.mSelectedPageIndexValue = new SettableIntegerValueProxy((ControlSurfaceObject)this, -1);
        this.mHasNextPageValue = new BooleanValueProxy(this);
        this.mHasPreviousPageValue = new BooleanValueProxy(this);
        this.mPageCountValue = new IntegerValueProxy(this);
    }

    @Override
    public int getParameterCount() {
        return this.mSelectedPageProxy.getParameterCount();
    }

    @Override
    public RemoteControlProxy getParameter(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        return this.mSelectedPageProxy.getParameter(n2);
    }

    public RemoteControlsPageProxy getSelectedPage() {
        return this.mSelectedPageProxy;
    }

    @Override
    public StringValue getName() {
        this.newSince(4);
        return this.mSelectedPageProxy.getName();
    }

    @Override
    public SettableIntegerValue selectedPageIndex() {
        return this.mSelectedPageIndexValue;
    }

    @Override
    public IntegerValue pageCount() {
        this.newSince(7);
        return this.mPageCountValue;
    }

    private void doSelectPageAtIndex(int n2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mPageSelector != null && n2 >= 0) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.CwM(n2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectPreviousPage(boolean bl2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(() -> this.doSelectPreviousPage(bl2));
    }

    private void doSelectPreviousPage(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.Opd(bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void doStepBackwards() {
        this.doSelectPreviousPage(false);
    }

    @Override
    public void selectFirst() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(this::doSelectFirst);
    }

    private void doSelectFirst() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.OqD();
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectLast() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(this::doSelectLast);
    }

    private void doSelectLast() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.hFR();
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectNext() {
        this.selectNextPage(false);
    }

    @Override
    public void selectNextPage(boolean bl2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(() -> this.doSelectNextPage(bl2));
    }

    private void doSelectNextPage(boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.CwM(bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public HardwareActionBindable selectNextAction() {
        return new DocumentAction((ControlSurfaceObject)this, () -> this.doSelectNextPage(false));
    }

    @Override
    public HardwareActionBindable selectPreviousAction() {
        return new DocumentAction((ControlSurfaceObject)this, () -> this.doSelectPreviousPage(false));
    }

    @Override
    public void doStepForwards() {
        this.doSelectNextPage(false);
    }

    @Override
    public void selectNextPageMatching(String string, boolean bl2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (string == null) {
            throw new aRB("expression cannot be null");
        }
        this.exec(() -> this.doSelectNextPageMatching(string, bl2));
    }

    private void doSelectNextPageMatching(String string, boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(string != null));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.CwM(string, bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectPrevious() {
        this.selectPreviousPage(false);
    }

    @Override
    public void selectPreviousPageMatching(String string, boolean bl2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (string == null) {
            throw new aRB("expression cannot be null");
        }
        this.exec(() -> this.doSelectPreviousPageMatching(string, bl2));
    }

    private void doSelectPreviousPageMatching(String string, boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(string != null));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.Opd(string, bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void addCanSelectNextObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use hasNext() instead");
        this.mHasNextPageValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanSelectPreviousObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use hasNext() instead");
        this.mHasPreviousPageValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue hasPrevious() {
        return this.mHasPreviousPageValue;
    }

    @Override
    public BooleanValue hasNext() {
        return this.mHasNextPageValue;
    }

    protected abstract How getPageSelectorForRemoteControls(dJi var1);

    protected void connectToTarget(dJi dJi2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(dJi2 != null));
        assert (bCi.OqD(this.mPageSelector == null));
        this.mPageSelector = this.getPageSelectorForRemoteControls(dJi2);
        this.mPageNamesValue.setTarget(this.mPageNames);
        dJi2.CwM(this.mPagesChangedListener);
        this.mPageSelector.CwM(this.mSelectedPageListener);
        this.mSelectedPageIndexValue.setTarget(this.mSelectedPageIndex);
        this.mHasNextPageValue.setTarget(this.mHasNextParameterPage);
        this.mHasPreviousPageValue.setTarget(this.mHasPrevParameterPage);
        this.mPageCountValue.setTarget(this.mPageCount);
        this.updatePages();
        this.updateSelectedPage();
    }

    protected void disconnectFromTarget(dJi dJi2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(dJi2 != null));
        assert (bCi.OqD(this.mPageSelector != null));
        this.mSelectedPageIndexValue.clearTarget();
        this.mHasNextPageValue.clearTarget();
        this.mHasNextPageValue.clearTarget();
        this.mPageNamesValue.clearTarget();
        this.mPageSelector.Opd(this.mSelectedPageListener);
        dJi2.Opd(this.mPagesChangedListener);
        this.mPageSelector = null;
        this.updatePages();
        this.updateSelectedPage();
    }

    private void invalidatePages() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateToPages) {
            this.mHasScheduledUpdateToPages = true;
            this.runAtEndOfEvent(this::updatePages);
        }
    }

    @Override
    public StringArrayValue pageNames() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        return this.mPageNamesValue;
    }

    private void ensurePagesUpdated() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mHasScheduledUpdateToPages) {
            this.updatePages();
        }
    }

    private void updatePages() {
        assert (bCi.OqD(this.isDocumentThread()));
        this.mHasScheduledUpdateToPages = false;
        this.setPages(this.calculatePages());
    }

    private void setPages(List list) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(list != null));
        if (!Objects.equals(this.mPages, list)) {
            int n2;
            Hdp hdp;
            this.mPages = list;
            int n3 = this.mPages.size();
            this.mPageCount.setIntegerValue(n3);
            if (this.mPageSelector == null) {
                assert (bCi.OqD(this.mPages.isEmpty()));
                hdp = null;
                n2 = 0;
            } else {
                hdp = this.mPageSelector.LTX();
                n2 = this.mPages.indexOf(hdp);
                assert (bCi.OqD(hdp != null && n3 > 0 ? n2 != -1 : n2 == -1));
                if (n2 == -1) {
                    n2 = this.mSelectedPageIndex.getIntegerValue();
                    if (n2 < 0 || n2 >= n3) {
                        n2 = n3 > 0 ? n3 - 1 : 0;
                    }
                    hdp = n3 > 0 ? (Hdp)this.mPages.get(n2) : null;
                    this.mPageSelector.Opd(this.mSelectedPageListener);
                    this.mPageSelector.CwM(hdp);
                    this.mPageSelector.CwM(this.mSelectedPageListener);
                }
            }
            this.mSelectedPageIndex.doSetValue(n2);
            this.mSelectedPageProxy.setTarget(hdp);
            this.mHasPrevParameterPage.setBoolValue(n2 > 0);
            this.mHasNextParameterPage.setBoolValue(n2 + 1 < n3);
        }
        this.updatePageNames();
    }

    private void updateHasNextAndPrevPage() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mHasScheduledUpdateSelectedPage) {
            this.updateSelectedPage();
        }
        if (this.getTarget() != null) {
            int n2 = this.getPageCount();
            int n3 = this.mSelectedPageIndex.getValue();
            assert (bCi.OqD(n3 == this.clampPageToRange(n3)));
            this.mPageCount.setValue(n2);
            this.mHasPrevParameterPage.CwM(n3 > 0);
            this.mHasNextParameterPage.CwM(n3 < n2 - 1);
        } else {
            this.mPageCount.setValue(0);
            this.mHasPrevParameterPage.CwM(false);
            this.mHasNextParameterPage.CwM(false);
        }
    }

    private void scheduleUpdateSelectedPage() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateSelectedPage) {
            this.mHasScheduledUpdateSelectedPage = true;
            this.mWasChangingPageFromControllerWhenScheduling = this.mIsChangingPageFromController;
            this.runAtEndOfEvent(this::updateSelectedPage);
        }
    }

    private void updateSelectedPage() {
        assert (bCi.OqD(this.isDocumentThread()));
        this.ensurePagesUpdated();
        this.mHasScheduledUpdateSelectedPage = false;
        Hdp hdp = this.mPageSelector != null ? this.mPageSelector.LTX() : null;
        this.mSelectedPageProxy.setTarget(hdp);
        if (hdp != null) {
            int n2 = this.getPageIndex(hdp);
            assert (bCi.OqD(n2 >= 0));
            this.mSelectedPageIndex.doSetValue(n2);
            if (this.mWasChangingPageFromControllerWhenScheduling) {
                this.getControlSurface().CwM(this);
            }
        } else {
            this.mSelectedPageIndex.doSetValue(0);
        }
        this.updateHasNextAndPrevPage();
    }

    protected int clampPageToRange(int n2) {
        int n3 = this.getPageCount();
        return n3 > 0 ? f2f.CwM(n2, 0, n3 - 1) : 0;
    }

    private List calculatePages() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mPageSelector == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mPageSelector.CwM();
    }

    private void updatePageNames() {
        this.setPageNames(this.calculatePageNames());
    }

    private String[] calculatePageNames() {
        int n2 = this.getPageCount();
        if (n2 == 0) {
            return NO_PAGE_NAMES;
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = (String)this.getPageAt(i2).dhb().getValue();
        }
        return stringArray;
    }

    private void setPageNames(String[] stringArray) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(stringArray != null));
        Object[] objectArray = (String[])this.mPageNames.getValue();
        assert (bCi.OqD(objectArray != null));
        if (!Arrays.equals(stringArray, objectArray)) {
            this.mPageNames.setValue(stringArray);
        }
    }

    public int getPageCount() {
        assert (bCi.OqD(this.isDocumentThread()));
        this.ensurePagesUpdated();
        assert (bCi.OqD(!this.mHasScheduledUpdateToPages));
        return this.mPages != null ? this.mPages.size() : 0;
    }

    public Hdp getPageAt(int n2) {
        assert (bCi.OqD(this.isDocumentThread()));
        this.ensurePagesUpdated();
        assert (bCi.OqD(!this.mHasScheduledUpdateToPages));
        return (Hdp)this.mPages.get(n2);
    }

    public int getPageIndex(Hdp hdp) {
        assert (bCi.OqD(hdp != null));
        assert (bCi.OqD(this.isDocumentThread()));
        this.ensurePagesUpdated();
        return this.mPages.indexOf(hdp);
    }

    @Override
    public chL createVisualizationWidget() {
        assert (bCi.CwM(this.isDocumentThread()));
        cJt cJt2 = cJt.FbZ();
        cJt2.CwM(this::createWidgetForPage);
        chL.CwM((UHW)cJt2.Mzz(), this.mSelectedPageIndex);
        return cJt2;
    }

    private chL createWidgetForPage(Object object) {
        assert (bCi.CwM(this.isDocumentThread()));
        chF chF2 = chF.pqS("");
        chF2.OqD(chF2.nXM().SvI());
        chF2.Opd(chh.m2i);
        chF2.gav("Bold Smaller");
        ccp ccp2 = ccp.CwM(chF2, true, false);
        ccp2.a_(new fVR(61L));
        cJd cJd2 = cJd.CwM(0, ccp2);
        cJd2.hFR(0.5f);
        cJd2.IkS(true);
        int n2 = this.getParameterCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            RemoteControlProxy remoteControlProxy = this.getSelectedPage().getParameterUnchecked(i2);
            if (!remoteControlProxy.shouldIndicate()) continue;
            chL chL2 = remoteControlProxy.createVisualizationWidget();
            cJd2.IwJ(chL2);
        }
        String[] stringArray = (String[])this.mPageNames.getValue();
        int n3 = this.mSelectedPageIndex.getValue();
        if (stringArray != null && n3 >= 0 && n3 < stringArray.length) {
            chF2.cOi(stringArray[n3].toUpperCase());
        }
        return cJd2;
    }

    @Override
    public void setHardwareLayout(HardwareControlType hardwareControlType, int n2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.newSince(7);
        this.mHardwareControlType = hardwareControlType;
        this.mHardwareColumns = n2;
    }

    @Override
    public HardwareControlType getHardwareLayoutControlType() {
        return this.mHardwareControlType;
    }

    @Override
    public int getHardwareLayoutColumns() {
        return this.mHardwareColumns;
    }
}

