/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.ObjectProxy;
import com.bitwig.extension.controller.api.Subscribable;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DelegatingControlSurfaceObjectProxy;
import java.util.Objects;

public abstract class ControlSurfaceProxy
extends ControlSurfaceObject
implements Subscribable {
    private final HQv mTarget = new HQv();
    private int mSubscriptionCountOnDocumentThread;
    private int mSubscriptionCount = 0;
    private boolean mSubscribedToAncestors;

    protected ControlSurfaceProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
        boolean bl2 = this.getControlSurface().Uft().Uft();
        this.mSubscriptionCountOnDocumentThread = this.mSubscriptionCount = bl2 ? 1 : 0;
    }

    public Object getTargetOfType(Class clazz) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(clazz != null));
        if (clazz.isAssignableFrom(this.getTargetType())) {
            return this.getTarget();
        }
        return null;
    }

    public final Object getDeepestTarget() {
        ControlSurfaceProxy controlSurfaceProxy = this.getDeepestProxy();
        assert (bCi.OqD(controlSurfaceProxy != null));
        assert (bCi.OqD(!(controlSurfaceProxy instanceof DelegatingControlSurfaceObjectProxy)));
        return controlSurfaceProxy.getTarget();
    }

    public ControlSurfaceProxy getDeepestProxy() {
        return this;
    }

    @Override
    public void subscribe() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.CwM(this.mSubscriptionCount >= 0));
        ++this.mSubscriptionCount;
        if (this.mSubscriptionCount == 1) {
            this.exec(this::doSubscribe);
        }
    }

    private void doSubscribe() {
        assert (bCi.OqD(this.isDocumentThread()));
        ++this.mSubscriptionCountOnDocumentThread;
        if (this.mSubscriptionCountOnDocumentThread == 1) {
            assert (bCi.OqD(!this.mSubscribedToAncestors));
            Object object = this.mTarget.getValue();
            if (object != null && this.isInterested()) {
                this.connectToTarget(object);
            }
        }
    }

    @Override
    public void unsubscribe() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (this.mSubscriptionCount == 0) {
            throw new aRB("unsubscribe called more times than subscribe");
        }
        --this.mSubscriptionCount;
        if (this.mSubscriptionCount == 0) {
            this.exec(this::doUnsubscribe);
        }
    }

    private void doUnsubscribe() {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.mSubscriptionCountOnDocumentThread > 0));
        --this.mSubscriptionCountOnDocumentThread;
        if (this.mSubscriptionCountOnDocumentThread == 0) {
            Object object = this.mTarget.getValue();
            if (object != null && this.isInterested()) {
                this.disconnectFromTarget(object);
            }
            this.unsubscribeAncestors();
        }
    }

    public abstract Class getTargetType();

    public final Object getTarget() {
        assert (bCi.OqD(this.isDocumentThread()));
        return this.mTarget.getValue();
    }

    public final boolean hasTarget() {
        return this.getTarget() != null;
    }

    public final HQv getTargetValue() {
        assert (bCi.OqD(this.isDocumentThread()));
        return this.mTarget;
    }

    public void setTarget(Object object) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.isTargetValid(object)));
        Object object2 = this.mTarget.getValue();
        if (!Objects.equals(object, object2)) {
            if (object2 != null) {
                this.disconnectFromTargetAlways(object2);
                if (this.mSubscriptionCountOnDocumentThread > 0 && this.isInterested()) {
                    this.disconnectFromTarget(object2);
                }
            }
            this.mTarget.setValue(object);
            this.targetChanged();
            if (object != null) {
                this.connectToTargetAlways(object);
                if (this.mSubscriptionCountOnDocumentThread > 0 && this.isInterested()) {
                    this.connectToTarget(object);
                }
            }
        }
    }

    public final void clearTarget() {
        this.setTarget(null);
    }

    protected boolean isTargetValid(Object object) {
        assert (bCi.OqD(this.isDocumentThread()));
        return true;
    }

    protected void targetChanged() {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.isTargetValid(this.mTarget.getValue())));
        this.getHost().targetChanged(this, this.mTarget.getValue());
    }

    public final BooleanValue createEqualsValue(ObjectProxy objectProxy) {
        return this.getHost().createAreProxiesEqualValue(this, (ControlSurfaceProxy)((Object)objectProxy));
    }

    @Override
    public final boolean isSubscribed() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.CwM(this.mSubscriptionCount >= 0));
        return this.mSubscriptionCount > 0;
    }

    @Override
    public final void setIsSubscribed(boolean bl2) {
        boolean bl3;
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.deprecatedFail(2, 10, "subscription is now counter based, use subscribe and unsubscribe instead");
        boolean bl4 = bl3 = this.mSubscriptionCount > 0;
        if (bl2 != bl3) {
            if (bl2) {
                assert (bCi.OqD(this.mSubscriptionCount == 0));
                this.mSubscriptionCount = 1;
                this.exec(this::doSubscribe);
            } else {
                assert (bCi.OqD(this.mSubscriptionCount == 1));
                this.mSubscriptionCount = 0;
                this.exec(this::doUnsubscribe);
            }
        }
    }

    private void subscribeAncestors() {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(!this.mSubscribedToAncestors));
        for (ControlSurfaceObject controlSurfaceObject = this.getParent(); controlSurfaceObject != null; controlSurfaceObject = controlSurfaceObject.getParent()) {
            if (!(controlSurfaceObject instanceof ControlSurfaceProxy)) continue;
            ((ControlSurfaceProxy)controlSurfaceObject).doSubscribe();
        }
        this.mSubscribedToAncestors = true;
    }

    private void unsubscribeAncestors() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.mSubscribedToAncestors) {
            for (ControlSurfaceObject controlSurfaceObject = this.getParent(); controlSurfaceObject != null; controlSurfaceObject = controlSurfaceObject.getParent()) {
                if (!(controlSurfaceObject instanceof ControlSurfaceProxy)) continue;
                ((ControlSurfaceProxy)controlSurfaceObject).doUnsubscribe();
            }
            this.mSubscribedToAncestors = false;
        }
    }

    public final boolean isActiveOnDocumentThread() {
        assert (bCi.OqD(this.isDocumentThread()));
        return this.mSubscriptionCountOnDocumentThread > 0;
    }

    protected abstract void connectToTarget(Object var1);

    protected abstract void disconnectFromTarget(Object var1);

    protected void connectToTargetAlways(Object object) {
    }

    protected void disconnectFromTargetAlways(Object object) {
    }

    protected boolean isInterested() {
        return true;
    }
}

