/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.base.sound.XOl;
import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.Callback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.NoteStepChangedCallback;
import com.bitwig.extension.callback.StepDataChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.ClipLauncherSlot;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.NoteOccurrence;
import com.bitwig.extension.controller.api.SettableBeatTimeValue;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableEnumValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.flt.app.vWk;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotBankProxy;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotProxy;
import com.bitwig.flt.control_surface.proxy.ClipProxy$1;
import com.bitwig.flt.control_surface.proxy.ClipProxy$2;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.LaunchQuantizationProxy;
import com.bitwig.flt.control_surface.proxy.NoteStep;
import com.bitwig.flt.control_surface.proxy.TrackProxy;
import com.bitwig.flt.control_surface.values.AbsBeatTimeProxy;
import com.bitwig.flt.control_surface.values.BeatTimeProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.RangedValueProxy;
import com.bitwig.flt.control_surface.values.RelativeBeatTimeProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.control_surface.values.SettableEnumAttributeProxy;
import com.bitwig.ramona.core.oGX;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import java.util.function.Consumer;

public class ClipProxy
extends ControlSurfaceDocumentObjectProxy
implements Clip {
    private static final boolean ENABLE_EARLY_LOCAL_CACHE_UPDATE = false;
    private final bmy mPlaybackPositionListener = svx -> {
        double d2 = (Double)svx.Opd();
        assert (bCi.OqD(d2 >= 0.0 || d2 == -1.0));
        this.setPlayingStep(d2 >= 0.0 ? (int)Math.floor(d2 / this.getStepSize()) : -1);
    };
    private final oGX mHierarchyListener = new ClipProxy$1(this);
    private final ZLC mSelectionChangeListener = new ClipProxy$2(this);
    private gOF mStepGrid;
    private final int mGridHeight;
    private final int mGridWidth;
    private HashMap mNoteSteps = new HashMap();
    private int mBaseKey = 0;
    private int mBaseStep;
    private int mLastPlaybackStep = -1;
    private double mStepSize = 0.25;
    private final ComputedBooleanValue mCanScrollKeysUp;
    private final ComputedBooleanValue mCanScrollKeysDown;
    private final ComputedBooleanValue mCanScrollStepsBackwards;
    private final ComputedBooleanValue mCanScrollStepsForwards;
    private final SettableBooleanValueProxy mShuffle;
    private final RangedValueProxy mAccent;
    private final SettableBooleanValueProxy mIsLoopEnabled;
    private final BeatTimeProxy mPlayStart;
    private final BeatTimeProxy mPlayStop;
    private final BeatTimeProxy mLoopStart;
    private final BeatTimeProxy mLoopLength;
    private boolean mHasInvalidatedGrid = false;
    private final TrackProxy mTrackProxy;
    private final SettableColorValueProxy mColor;
    private final ComputedIntegerValue mPlayingStep;
    private final List mStepDataChangedCallbacks = new ArrayList();
    private final List mNoteDataChangedCallback = new ArrayList();
    private TimerTask mUpdateTimerTask = null;
    private final SettableEnumAttributeProxy mLaunchQuantization;
    private final SettableBooleanValueProxy mUseLoopStartAsQuantizationReference;
    private final Runnable mClipEventsChanged = this::invalidateGrid;
    private final ClipLauncherSlotProxy mClipLauncherSlot;
    private final SettableEnumAttributeProxy mLaunchMode;
    private final SettableBooleanValueProxy mLegatoMode;

    public ClipProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3) {
        super(controlSurfaceObject);
        this.setKey(string);
        this.mGridHeight = n3;
        this.mGridWidth = n2;
        this.mStepGrid = new PIP(this.mStepSize);
        this.mShuffle = new SettableBooleanValueProxy(this);
        this.mAccent = new RangedValueProxy(this);
        this.mIsLoopEnabled = new SettableBooleanValueProxy(this);
        this.mPlayStart = new AbsBeatTimeProxy(this);
        this.mPlayStop = new AbsBeatTimeProxy(this);
        this.mLoopStart = new AbsBeatTimeProxy(this);
        this.mLoopLength = new RelativeBeatTimeProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mTrackProxy = new TrackProxy(this, "ClipParentTrack", -1, 0, 1);
        this.mCanScrollKeysDown = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollKeysUp = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsBackwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsForwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mPlayingStep = new ComputedIntegerValue((ControlSurfaceObject)this, -1);
        this.mLaunchQuantization = new LaunchQuantizationProxy((ControlSurfaceObject)this, true);
        this.mUseLoopStartAsQuantizationReference = new SettableBooleanValueProxy(this);
        this.mClipLauncherSlot = new ClipLauncherSlotProxy(this);
        this.mLaunchMode = new SettableEnumAttributeProxy((ControlSurfaceObject)this, NtP.CwM);
        this.mLegatoMode = new SettableBooleanValueProxy(this);
    }

    public int getGridWidth() {
        return this.mGridWidth;
    }

    public int getGridHeight() {
        return this.mGridHeight;
    }

    @Override
    public Class getTargetType() {
        return ahc.class;
    }

    protected com.bitwig.flt.document.core.iface.oGX getDocumentFromTarget(ahc ahc2) {
        return ahc2.RjC();
    }

    @Override
    public BooleanValue canScrollKeysUp() {
        this.newSince(2);
        return this.mCanScrollKeysUp;
    }

    @Override
    public void addCanScrollKeysUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysUp() instead");
        this.mCanScrollKeysUp.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollKeysDown() {
        this.newSince(2);
        return this.mCanScrollKeysDown;
    }

    @Override
    public void addCanScrollKeysDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysDown() instead");
        this.mCanScrollKeysDown.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsBackwards() {
        this.newSince(2);
        return this.mCanScrollStepsBackwards;
    }

    @Override
    public void addCanScrollStepsBackwardsObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsBackwards() instead");
        this.mCanScrollStepsBackwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsForwards() {
        this.newSince(2);
        return this.mCanScrollStepsForwards;
    }

    @Override
    public void addCanScrollStepsForwardObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsForwards() instead");
        this.mCanScrollStepsForwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void scrollKeysPageUp() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(this.mGridHeight));
    }

    @Override
    public void scrollKeysPageDown() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(-this.mGridHeight));
    }

    private void doScrollKeysBy(int n2) {
        assert (bCi.OqD(this.isDocumentThread()));
        int n3 = this.mBaseKey + n2;
        if (n3 >= 0 && n3 <= 127) {
            this.doScrollToKey(n3);
        }
    }

    @Override
    public void scrollKeysStepUp() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(1));
    }

    @Override
    public void scrollKeysStepDown() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollKeysBy(-1));
    }

    @Override
    public void scrollToKey(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.validKey(n2);
        this.exec(() -> this.doScrollToKey(n2));
    }

    private void doScrollToKey(int n2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(n2 >= 0 && n2 <= 127));
        if (n2 != this.mBaseKey) {
            this.mBaseKey = n2;
            ahc ahc2 = (ahc)this.getTarget();
            if (ahc2 != null) {
                this.updateGrid();
            }
        }
    }

    @Override
    public void scrollToStep(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollToStep(n2));
    }

    private void doScrollToStep(int n2) {
        assert (bCi.OqD(this.isDocumentThread()));
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 != null && this.mBaseStep != n2) {
            this.mBaseStep = n2;
            this.updateGrid();
        }
    }

    @Override
    public void setName(String string) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.notNull(string, "name");
        this.exec(() -> this.doSetName(string));
    }

    private void doSetName(String string) {
        assert (bCi.OqD(this.isDocumentThread()));
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 != null && ahc2.elG() != null) {
            ahc2.elG().CwM(string);
        }
    }

    @Override
    public void scrollStepsPageForward() {
        this.exec(() -> this.doScrollStepsBy(this.mGridWidth));
    }

    @Override
    public void scrollStepsPageBackwards() {
        this.exec(() -> this.doScrollStepsBy(-this.mGridWidth));
    }

    @Override
    public void scrollStepsStepForward() {
        this.exec(() -> this.doScrollStepsBy(1));
    }

    @Override
    public void scrollStepsStepBackwards() {
        this.exec(() -> this.doScrollStepsBy(-1));
    }

    private void doScrollStepsBy(int n2) {
        assert (bCi.OqD(this.isDocumentThread()));
        this.doScrollToStep(this.mBaseStep + n2);
    }

    @Override
    public void toggleStep(int n2, int n3, int n4) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.toggleStepCommon(0, n2, n3, n4);
    }

    @Override
    public void toggleStep(int n2, int n3, int n4, int n5) {
        this.newSince(10);
        this.toggleStepCommon(n2, n3, n4, n5);
    }

    private void toggleStepCommon(int n2, int n3, int n4, int n5) {
        this.validPosition(n3, n4);
        this.inRange(n5, 0, 127, "insertVelocity");
        this.exec(() -> this.doToggleStep(n2, n3, n4, n5));
    }

    private void doToggleStep(int n2, int n3, int n4, int n5) {
        assert (bCi.OqD(this.isDocumentThread()));
        lsx lsx2 = this.getInstrumentClip();
        if (lsx2 == null) {
            return;
        }
        ahc ahc2 = (ahc)this.getTarget();
        assert (bCi.OqD(ahc2 != null));
        int n6 = this.getKeyForY(n4);
        double d2 = this.getTimeForCell(n3);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        if (XOl.uwB(n6)) {
            TE1 tE1 = lsx2.hFR().CwM(n2, n6, false);
            List list = tE1 != null ? tE1.OqD(d2, d3) : Collections.EMPTY_LIST;
            ahc2.FCw().sWv();
            if (list.isEmpty()) {
                lsx2.CwM(d2, this.mStepSize, n2, n6, (float)n5 * 0.007874016f, ahc2.FCw().LTX());
            } else {
                for (jHB jHB2 : list) {
                    bvT bvT2 = (bvT)jHB2;
                    if (bvT2.nGB() != n2) continue;
                    tE1.Opd(jHB2);
                }
            }
        }
    }

    @Override
    public void setStep(int n2, int n3, int n4, double d2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.setStepCommon(0, n2, n3, n4, d2);
    }

    @Override
    public void setStep(int n2, int n3, int n4, int n5, double d2) {
        this.newSince(10);
        this.setStepCommon(n2, n3, n4, n5, d2);
    }

    public void setStepCommon(int n2, int n3, int n4, int n5, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.validPosition(n2, n3, n4);
        this.inRange(n5, 0, 127, "insertVelocity");
        this.greaterThan(d2, 0.0, "insertDuration");
        this.exec(() -> this.doSetStep(n2, n3, n4, n5, L.CwM(d2)));
    }

    private void doSetStep(int n2, int n3, int n4, int n5, double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        lsx lsx2 = this.getInstrumentClip();
        if (lsx2 == null) {
            return;
        }
        ahc ahc2 = (ahc)this.getTarget();
        assert (bCi.OqD(ahc2 != null));
        int n6 = n4 + this.mBaseKey;
        double d3 = this.getTimeForCell(n3);
        if (n6 >= 0 && n6 < 128) {
            lsx2.CwM(d3, d2, n2, n6, (float)n5 * 0.007874016f, ahc2.FCw().LTX());
        }
    }

    public void updateStepVelocity(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "velocity");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.CwM(d2)));
    }

    public void updateStepReleaseVelocity(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "velocity");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.Opd(d2)));
    }

    public void updateStepChance(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "chance");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.EuM(d2)));
    }

    public void updateStepEnableChance(NoteStep noteStep, boolean bl2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.hFR(bl2)));
    }

    public void updateStepVelocitySpread(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "amount");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.OqD(d2)));
    }

    public void updateStepEnableOccurrence(NoteStep noteStep, boolean bl2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.LTX(bl2)));
    }

    public void updateStepOccurrence(NoteStep noteStep, NoteOccurrence noteOccurrence) {
        Nw nw2;
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        switch (noteOccurrence) {
            case ALWAYS: {
                nw2 = Nw.CwM;
                break;
            }
            case FIRST: {
                nw2 = Nw.Opd;
                break;
            }
            case NOT_FIRST: {
                nw2 = Nw.OqD;
                break;
            }
            case PREV: {
                nw2 = Nw.m2i;
                break;
            }
            case PREV_CHANNEL: {
                nw2 = Nw.dhb;
                break;
            }
            case NOT_PREV_CHANNEL: {
                nw2 = Nw.aMy;
                break;
            }
            case NOT_PREV: {
                nw2 = Nw.hFR;
                break;
            }
            case PREV_KEY: {
                nw2 = Nw.LTX;
                break;
            }
            case NOT_PREV_KEY: {
                nw2 = Nw.uwB;
                break;
            }
            case FILL: {
                nw2 = Nw.alk;
                break;
            }
            case NOT_FILL: {
                nw2 = Nw.EuM;
                break;
            }
            default: {
                throw new aRB("Unknown occurrence: " + noteOccurrence);
            }
        }
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.CwM(nw2)));
    }

    public void updateStepEnableRecurrence(NoteStep noteStep, boolean bl2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.uwB(bl2)));
    }

    public void updateStepRecurrence(NoteStep noteStep, int n2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n3 = noteStep.x();
        int n4 = noteStep.y();
        int n5 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n3, n4);
        this.validChannel(n5);
        this.exec(() -> this.doUpdateNoteEvent(n5, n3, n4, jrk2 -> jrk2.IkS(n2)));
    }

    public void updateStepEnableRepeat(NoteStep noteStep, boolean bl2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.dhb(bl2)));
    }

    public void updateStepRepeatCount(NoteStep noteStep, int n2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n3 = noteStep.x();
        int n4 = noteStep.y();
        int n5 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n3, n4);
        this.validChannel(n5);
        this.exec(() -> this.doUpdateNoteEvent(n5, n3, n4, jrk2 -> jrk2.AaH(n2)));
    }

    public void updateStepRepeatCurve(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.IkS(d2)));
    }

    public void updateStepRepeatVelocityEnd(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.m2i(d2)));
    }

    public void updateStepRepeatVelocityCurve(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.hFR(d2)));
    }

    public void updateStepIsMuted(NoteStep noteStep, boolean bl2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(14);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> jrk2.aMy(bl2)));
    }

    public void updateStepDuration(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 128.0, "duration");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> {
            TE1 tE1 = jrk2.eSQ();
            double d3 = L.LTX(d2);
            tE1.CwM((IHm)jrk2, jrk2.eOr(), d3);
        }));
    }

    public void updateStepPan(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, -1.0, 1.0, "pan");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> hHu.CwM(jrk2, "panning", 0.0, (d2 + 1.0) / 2.0)));
    }

    public void updateStepTranspose(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, -24.0, 24.0, "transpose");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> hHu.CwM(jrk2, "transpose", 0.0, (d2 + 24.0) / 48.0)));
    }

    public void updateStepGain(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "gain");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> hHu.CwM(jrk2, "amplitude", 0.0, d2)));
    }

    public void updateStepTimbre(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, -1.0, 1.0, "timbre");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> hHu.CwM(jrk2, "timbre", 0.0, (d2 + 1.0) / 2.0)));
    }

    public void updateStepPressure(NoteStep noteStep, double d2) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        int n2 = noteStep.x();
        int n3 = noteStep.y();
        int n4 = noteStep.channel();
        this.newSince(10);
        this.validPosition(n2, n3);
        this.validChannel(n4);
        this.inRange(d2, 0.0, 1.0, "pressure");
        this.exec(() -> this.doUpdateNoteEvent(n4, n2, n3, jrk2 -> hHu.CwM(jrk2, "pressure", 0.0, d2)));
    }

    private void doUpdateNoteEvent(int n2, int n3, int n4, Consumer consumer) {
        assert (bCi.CwM(this.isDocumentThread()));
        lsx lsx2 = this.getInstrumentClip();
        if (lsx2 == null) {
            return;
        }
        ahc ahc2 = (ahc)this.getTarget();
        assert (bCi.CwM(ahc2 != null));
        int n5 = n4 + this.mBaseKey;
        double d2 = this.getTimeForCell(n3);
        if (n5 < 0 || 128 <= n5) {
            return;
        }
        TE1 tE1 = lsx2.hFR().CwM(n2, n5, false);
        if (tE1 == null) {
            return;
        }
        List list = tE1.OqD(d2, d2 + this.mStepSize - 0.001);
        if (list == null) {
            return;
        }
        com.bitwig.flt.document.core.iface.oGX oGX2 = this.getDocument();
        oGX2.CwM("Update Note Data From Controller Extension", false);
        for (jHB jHB2 : list) {
            if (!(jHB2 instanceof jrk)) continue;
            jrk jrk2 = (jrk)jHB2;
            consumer.accept(jrk2);
        }
        oGX2.CwM(false);
    }

    @Override
    public void clearStep(int n2, int n3) {
        this.clearStepCommon(0, n2, n3);
    }

    @Override
    public void clearStep(int n2, int n3, int n4) {
        this.newSince(10);
        this.clearStepCommon(n2, n3, n4);
    }

    public void clearStepCommon(int n2, int n3, int n4) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.validPosition(n2, n3, n4);
        this.exec(() -> this.doClearStep(n2, n3, n4));
    }

    private void doClearStep(int n2, int n3, int n4) {
        assert (bCi.OqD(this.isDocumentThread()));
        int n5 = n4 + this.mBaseKey;
        if (n5 < 0 || n5 > 128) {
            return;
        }
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 == null) {
            return;
        }
        lsx lsx2 = this.getInstrumentClip();
        if (lsx2 == null) {
            return;
        }
        double d2 = this.getTimeForCell(n3);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        TE1 tE1 = lsx2.hFR().CwM(n2, n5, false);
        if (tE1 == null) {
            return;
        }
        List list = tE1.OqD(d2, d3);
        for (jrk jrk2 : list) {
            tE1.Opd(jrk2);
        }
        ahc2.FCw().sWv();
    }

    @Override
    public void clearStepsAtX(int n2, int n3) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.newSince(10);
        this.validX(n3);
        this.validChannel(n2);
        this.exec(() -> this.doClearStepsAtX(n2, n3));
    }

    private void doClearStepsAtX(int n2, int n3) {
        assert (bCi.OqD(this.isDocumentThread()));
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 == null) {
            return;
        }
        lsx lsx2 = this.getInstrumentClip();
        if (lsx2 == null) {
            return;
        }
        double d2 = this.getTimeForCell(n3);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        for (int i2 = 0; i2 < 128; ++i2) {
            TE1 tE1 = lsx2.hFR().CwM(n2, i2, false);
            if (tE1 == null) continue;
            List list = tE1.OqD(d2, d3);
            for (jrk jrk2 : list) {
                tE1.Opd(jrk2);
            }
        }
        ahc2.FCw().sWv();
    }

    @Override
    public void clearSteps() {
        this.exec(this::doClearSteps);
    }

    private void doClearSteps() {
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 != null) {
            lsx lsx2 = this.getInstrumentClip();
            if (lsx2 == null) {
                return;
            }
            lsx2.OqD().m2i(-1.7976931348623157E308, Double.MAX_VALUE);
            ahc2.FCw().sWv();
        }
    }

    @Override
    public void clearSteps(int n2) {
        this.deprecated(1, 10, "Use clearStepsAtY(channel, y) instead.");
        this.validY(n2);
        this.exec(() -> this.doClearSteps(0, n2));
    }

    @Override
    public void clearStepsAtY(int n2, int n3) {
        this.validY(n3);
        this.validChannel(n2);
        this.exec(() -> this.doClearSteps(n2, n3));
    }

    private void doClearSteps(int n2, int n3) {
        assert (bCi.hFR(this.isDocumentThread()));
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 == null) {
            return;
        }
        lsx lsx2 = this.getInstrumentClip();
        if (lsx2 == null) {
            return;
        }
        int n4 = n3 + this.mBaseKey;
        if (n4 < 0 || n4 >= 128) {
            return;
        }
        TE1 tE1 = lsx2.hFR().CwM(n2, n4, false);
        if (tE1 != null) {
            tE1.Ugn();
        }
    }

    @Override
    public void selectStepContents(int n2, int n3, boolean bl2) {
        this.selectStepContentsCommon(0, n2, n3, bl2);
    }

    @Override
    public void selectStepContents(int n2, int n3, int n4, boolean bl2) {
        this.newSince(10);
        this.selectStepContentsCommon(n2, n3, n4, bl2);
    }

    void selectStepContentsCommon(int n2, int n3, int n4, boolean bl2) {
        this.validPosition(n2, n3, n4);
        this.exec(() -> this.doSelectStepContents(0, n3, n4, bl2));
    }

    private void doSelectStepContents(int n2, int n3, int n4, boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 == null) {
            return;
        }
        lsx lsx2 = this.getInstrumentClip();
        if (lsx2 == null) {
            return;
        }
        int n5 = n4 + this.mBaseKey;
        double d2 = this.getTimeForCell(n3);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        if (n5 < 0 || n5 >= 128) {
            return;
        }
        TE1 tE1 = lsx2.hFR().CwM(n2, n5, false);
        List list = tE1 != null ? tE1.OqD(d2, d3) : Collections.EMPTY_LIST;
        ace ace2 = ahc2.FCw();
        if (bl2) {
            ace2.sWv();
        }
        for (bvT bvT2 : list) {
            ace2.LTX(bvT2.CwM(0, false));
        }
    }

    @Override
    public void setStepSize(double d2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.greaterThan(d2, 0.0, "lengthInBeatTime");
        this.exec(() -> this.doSetStepSize(d2));
    }

    private void doSetStepSize(double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        ahc ahc2 = (ahc)this.getTarget();
        if (this.mStepSize != d2) {
            this.mStepSize = d2;
            this.mStepGrid = new PIP(this.mStepSize);
            if (!this.mHasInvalidatedGrid && ahc2 != null) {
                this.mHasInvalidatedGrid = true;
                if (this.mUpdateTimerTask != null) {
                    this.mUpdateTimerTask.cancel();
                }
                this.mUpdateTimerTask = this.scheduleTimerTaskOnDocumentThread(this::updateGridFromTimer, 100L);
            }
        }
    }

    private void updateGridFromTimer() {
        assert (bCi.CwM(this.isDocumentThread()));
        assert (bCi.CwM(this.mUpdateTimerTask != null));
        this.updateGrid();
        this.mHasInvalidatedGrid = false;
        this.mUpdateTimerTask = null;
    }

    private double getStepSize() {
        return this.mStepSize;
    }

    private double getTimeForCell(int n2) {
        return L.CwM((double)(this.mBaseStep + n2) * this.getStepSize());
    }

    private int getKeyForY(int n2) {
        return this.mBaseKey + n2;
    }

    private LlH getClipEvent() {
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 == null) {
            return null;
        }
        cKu cKu2 = ahc2.elG();
        if (cKu2 == null) {
            return null;
        }
        com.bitwig.flt.document.core.iface.oGX oGX2 = (com.bitwig.flt.document.core.iface.oGX)cKu2.hFR(com.bitwig.flt.document.core.iface.oGX.class);
        assert (bCi.CwM(oGX2 != null));
        if (oGX2 == null) {
            return null;
        }
        return cKu2;
    }

    private lsx getInstrumentClip() {
        LlH llH = this.getClipEvent();
        return llH instanceof lsx ? (lsx)llH : null;
    }

    private void invalidateGrid() {
        assert (bCi.CwM(this.isDocumentThread()));
        if (!this.mHasInvalidatedGrid) {
            this.mHasInvalidatedGrid = true;
            vWk.IwJ().runAtEndOfCurrentEvent(() -> {
                this.updateGrid();
                this.mHasInvalidatedGrid = false;
            });
        }
    }

    private void updateGrid() {
        PeA peA;
        assert (bCi.OqD(this.isDocumentThread()));
        lsx lsx2 = this.getInstrumentClip();
        ahc ahc2 = (ahc)this.getTarget();
        double d2 = this.getTimeForCell(0);
        double d3 = this.getTimeForCell(this.mGridWidth - 1) + this.getStepSize() - 1.0E-4;
        if (lsx2 != null) {
            assert (bCi.hFR(lsx2.esf().OqD()));
            peA = lsx2.hFR();
        } else {
            peA = null;
        }
        boolean bl2 = false;
        HashMap<Integer, NoteStep> hashMap = new HashMap<Integer, NoteStep>();
        List list = peA != null ? peA.CwM(d2, d3) : Collections.emptyList();
        for (jHB jHB2 : list) {
            jrk jrk2 = (jrk)jHB2;
            boolean bl3 = ahc2.FCw().CwM(jrk2);
            bl2 |= bl3;
            double d4 = jrk2.eOr();
            double d5 = jrk2.QEO();
            int n2 = Math.max(0, (int)Math.floor((d4 - d2) / this.getStepSize()));
            int n3 = jrk2.aD_();
            int n4 = n3 - this.mBaseKey;
            int n5 = jrk2.nGB();
            if (n4 < 0 || this.mGridHeight <= n4) continue;
            assert (bCi.CwM(XOl.uwB(n3)));
            assert (bCi.CwM(XOl.LTX(n5)));
            assert (bCi.CwM(n2 >= 0 && n2 < this.mGridWidth));
            assert (bCi.CwM(n4 >= 0 && n4 < this.mGridHeight));
            int n6 = d4 < d2 ? 1 : 2;
            NoteStep noteStep = new NoteStep(n2, n4, n5, this);
            noteStep.setCachedVelocity(jrk2.LTX());
            noteStep.setCachedReleaseVelocity(jrk2.uwB());
            noteStep.setCachedDuration(jrk2.g3A());
            noteStep.setCachedIsSelected(bl3);
            noteStep.setCachedEnableChance(jrk2.HwE());
            noteStep.setCachedChance(jrk2.ynG());
            noteStep.setCachedVelocitySpread(jrk2.dhb());
            noteStep.setCachedEnableOccurrence(jrk2.nce());
            switch (jrk2.Ugn()) {
                case CwM: {
                    noteStep.setCachedOccurrence(NoteOccurrence.ALWAYS);
                    break;
                }
                case Opd: {
                    noteStep.setCachedOccurrence(NoteOccurrence.FIRST);
                    break;
                }
                case OqD: {
                    noteStep.setCachedOccurrence(NoteOccurrence.NOT_FIRST);
                    break;
                }
                case m2i: {
                    noteStep.setCachedOccurrence(NoteOccurrence.PREV);
                    break;
                }
                case hFR: {
                    noteStep.setCachedOccurrence(NoteOccurrence.NOT_PREV);
                    break;
                }
                case dhb: {
                    noteStep.setCachedOccurrence(NoteOccurrence.PREV_CHANNEL);
                    break;
                }
                case aMy: {
                    noteStep.setCachedOccurrence(NoteOccurrence.NOT_PREV_CHANNEL);
                    break;
                }
                case LTX: {
                    noteStep.setCachedOccurrence(NoteOccurrence.PREV_KEY);
                    break;
                }
                case uwB: {
                    noteStep.setCachedOccurrence(NoteOccurrence.NOT_PREV_KEY);
                    break;
                }
                case alk: {
                    noteStep.setCachedOccurrence(NoteOccurrence.FILL);
                    break;
                }
                case EuM: {
                    noteStep.setCachedOccurrence(NoteOccurrence.NOT_FILL);
                }
            }
            noteStep.setCachedEnableRecurrence(jrk2.YHh());
            noteStep.setCachedRecurrence(jrk2.uTQ());
            noteStep.setCachedEnableRepeat(jrk2.Dii());
            noteStep.setCachedRepeatCount(jrk2.zdJ());
            noteStep.setCachedRepeatCurve(jrk2.ht());
            noteStep.setCachedRepeatVelocityEnd(jrk2.aMy());
            noteStep.setCachedRepeatVelocityCurve(jrk2.alk());
            noteStep.setCachedIsMuted(jrk2.WKQ());
            wWL wWL2 = jrk2.hFR();
            yuB yuB2 = wWL2.IkS();
            if (yuB2 == null || yuB2.fn() == 0) {
                noteStep.setCachedPan(0.0);
            } else {
                noteStep.setCachedPan(((ihs)yuB2.dS_().get(0)).CwM());
            }
            bF bF2 = wWL2.alk();
            if (bF2 == null || bF2.fn() == 0) {
                noteStep.setCachedTranspose(0.0);
            } else {
                noteStep.setCachedTranspose(((ihs)bF2.dS_().get(0)).CwM());
            }
            Bbn bbn2 = wWL2.CwM();
            if (bbn2 == null || bbn2.fn() == 0) {
                noteStep.setCachedTimbre(0.0);
            } else {
                noteStep.setCachedTimbre(((ihs)bbn2.dS_().get(0)).CwM());
            }
            hzH hzH2 = wWL2.OqD();
            if (hzH2 == null || hzH2.fn() == 0) {
                noteStep.setCachedPressure(0.0);
            } else {
                noteStep.setCachedPressure(((ihs)hzH2.dS_().get(0)).CwM());
            }
            DP3 dP3 = wWL2.EuM();
            if (dP3 == null || dP3.fn() == 0) {
                noteStep.setCachedGain(0.5);
            } else {
                noteStep.setCachedGain(((ihs)dP3.dS_().get(0)).aMy());
            }
            noteStep.setCachedNoteState(n6);
            noteStep.setCachedIsSelected(bl3);
            hashMap.put(this.computeStepInfoIndex(n5, n2, n4), noteStep);
            for (int i2 = n2 + 1; i2 < this.mGridWidth && this.getTimeForCell(i2) < d5; ++i2) {
                assert (bCi.CwM(0 <= i2 && i2 < this.mGridWidth));
                NoteStep noteStep2 = new NoteStep(i2, n4, n5, this);
                noteStep2.copy(noteStep);
                noteStep2.setCachedNoteState(1);
                hashMap.put(this.computeStepInfoIndex(n5, i2, n4), noteStep2);
            }
        }
        this.mCanScrollKeysDown.setBoolValue(this.mBaseKey > 0);
        this.mCanScrollKeysUp.setBoolValue(this.mBaseKey < 128 - this.mGridWidth * this.mGridHeight);
        this.sendNoteStateToObservers(hashMap);
    }

    protected int computeStepInfoIndex(int n2, int n3, int n4) {
        return n2 + 16 * (n3 + n4 * this.mGridWidth);
    }

    @Override
    public void addStepDataObserver(StepDataChangedCallback stepDataChangedCallback) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(stepDataChangedCallback, "callback");
        this.mStepDataChangedCallbacks.add(stepDataChangedCallback);
    }

    @Override
    public void addNoteStepObserver(NoteStepChangedCallback noteStepChangedCallback) {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(noteStepChangedCallback, "callback");
        this.mNoteDataChangedCallback.add(noteStepChangedCallback);
    }

    @Override
    public IntegerValue playingStep() {
        this.newSince(2);
        return this.mPlayingStep;
    }

    @Override
    public void addPlayingStepObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use playingStep() instead");
        this.mPlayingStep.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public SettableBooleanValueProxy getShuffle() {
        return this.mShuffle;
    }

    @Override
    public SettableRangedValue getAccent() {
        return this.mAccent;
    }

    @Override
    public SettableBeatTimeValue getPlayStart() {
        return this.mPlayStart;
    }

    @Override
    public SettableBeatTimeValue getPlayStop() {
        return this.mPlayStop;
    }

    @Override
    public SettableBooleanValueProxy isLoopEnabled() {
        return this.mIsLoopEnabled;
    }

    @Override
    public SettableBeatTimeValue getLoopStart() {
        return this.mLoopStart;
    }

    @Override
    public SettableBeatTimeValue getLoopLength() {
        return this.mLoopLength;
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    @Override
    public void duplicate() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(this::doDuplicate);
    }

    private void doDuplicate() {
        assert (bCi.OqD(this.isDocumentThread()));
        com.bitwig.flt.document.core.iface.oGX oGX2 = this.getDocument();
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 != null && oGX2 != null) {
            cKu cKu2 = ahc2.elG();
            JcJ jcJ = (JcJ)cKu2.hFR(JcJ.class);
            if (jcJ != null) {
                wzr wzr2 = oGX2.rH1().LTX();
                wzr2.EuM(jcJ);
                wzr2.InL();
                if (wzr2.Xt2()) {
                    wzr2.FXs();
                }
            }
            cKu2.P();
        }
    }

    @Override
    public void duplicateContent() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(this::doDuplicateContent);
    }

    private void doDuplicateContent() {
        assert (bCi.OqD(this.isDocumentThread()));
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 != null) {
            ahc2.elG().P();
        }
    }

    @Override
    public void transpose(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(() -> this.doTranspose(n2));
    }

    private void doTranspose(int n2) {
        assert (bCi.OqD(this.isDocumentThread()));
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 != null) {
            ahc2.elG().CwM(n2);
        }
    }

    @Override
    public void quantize(double d2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (d2 <= 0.0 || d2 > 1.0) {
            throw new aRB("Clip.quantize: amount parameter value should be greater than zero and maximal one.");
        }
        this.exec(() -> this.doQuantize(d2));
    }

    private void doQuantize(double d2) {
        assert (bCi.OqD(this.isDocumentThread()));
        ahc ahc2 = (ahc)this.getTarget();
        if (ahc2 != null) {
            ahc2.CwM(d2, this.mStepGrid);
        }
    }

    @Override
    public Track getTrack() {
        return this.mTrackProxy;
    }

    protected void connectToTarget(ahc ahc2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(ahc2 != null));
        cKu cKu2 = ahc2.elG();
        oHm oHm2 = cKu2.nSA();
        lsx lsx2 = this.getInstrumentClip();
        this.mUseLoopStartAsQuantizationReference.setTarget(cKu2.FCw());
        this.mLaunchMode.setTarget(cKu2.nGB());
        this.mLegatoMode.setTarget(cKu2.lIs());
        if (lsx2 != null) {
            lsx2.OqD().OqD(this.mPlaybackPositionListener);
            lsx2.zWN().CwM(this.mHierarchyListener);
        }
        ahc2.FCw().tuW().CwM(this.mSelectionChangeListener);
        oHm2.CwM(this.mClipEventsChanged);
        this.mShuffle.setTarget(oHm2.khV());
        this.mAccent.setTarget(oHm2.nce());
        b2 b22 = oHm2.ynG();
        this.mPlayStart.setTarget(b22.uwB().hCF());
        this.mPlayStop.setTarget(b22.dhb().hCF());
        this.mIsLoopEnabled.setTarget(b22.IkS());
        this.mLoopStart.setTarget(b22.AaH().hCF());
        this.mLoopLength.setTarget(b22.AaH().Aks());
        this.mColor.setTarget(cKu2.nce(), cKu2.ynG());
        this.mLaunchQuantization.setTarget(cKu2.kVL());
        if (this.mTrackProxy != null) {
            JcJ jcJ;
            ClipLauncherSlotBankProxy clipLauncherSlotBankProxy = this.mTrackProxy.getClipLauncherSlots();
            Bzw bzw2 = cKu2.SvI();
            this.mTrackProxy.setTarget(bzw2);
            if (clipLauncherSlotBankProxy != null && (jcJ = (JcJ)cKu2.hFR(JcJ.class)) != null) {
                this.mClipLauncherSlot.setTarget(jcJ);
                clipLauncherSlotBankProxy.scrollToScene(jcJ);
            }
        }
        this.connectObservers(cKu2);
    }

    protected void disconnectFromTarget(ahc ahc2) {
        assert (bCi.OqD(ahc2 != null));
        cKu cKu2 = ahc2.elG();
        this.disconnectObservers(cKu2);
        lsx lsx2 = this.getInstrumentClip();
        if (this.mTrackProxy != null) {
            this.mTrackProxy.clearTarget();
        }
        if (lsx2 != null) {
            lsx2.OqD().m2i(this.mPlaybackPositionListener);
            lsx2.zWN().Opd(this.mHierarchyListener);
        }
        oHm oHm2 = cKu2.nSA();
        oHm2.Opd(this.mClipEventsChanged);
        this.mPlayStart.clearTarget();
        this.mPlayStop.clearTarget();
        this.mIsLoopEnabled.clearTarget();
        this.mLoopStart.clearTarget();
        this.mLoopLength.clearTarget();
        this.mColor.clearTarget();
        this.mShuffle.clearTarget();
        this.mAccent.clearTarget();
        this.mLaunchQuantization.clearTarget();
        this.mUseLoopStartAsQuantizationReference.clearTarget();
        this.mClipLauncherSlot.clearTarget();
        this.mLaunchMode.clearTarget();
        this.mLegatoMode.clearTarget();
        ahc2.FCw().tuW().Opd(this.mSelectionChangeListener);
        this.setPlayingStep(-1);
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        this.updateGrid();
    }

    private void sendNoteStateToObservers(HashMap hashMap) {
        assert (bCi.OqD(this.isDocumentThread()));
        this.queueCallback(() -> this.doSendNoteStateToObservers(hashMap));
    }

    private void doSendNoteStateToObservers(HashMap hashMap) {
        NoteStep noteStep;
        NoteStep noteStep2;
        HashMap hashMap2 = this.mNoteSteps;
        this.mNoteSteps = hashMap;
        Set set = hashMap2.keySet();
        Set set2 = hashMap.keySet();
        for (Integer n2 : set2) {
            noteStep2 = (NoteStep)hashMap.get(n2);
            noteStep = (NoteStep)hashMap2.get(n2);
            if (noteStep != null && noteStep.equals(noteStep2)) continue;
            this.notifyNoteStepToObservers(noteStep2);
        }
        for (Integer n2 : set) {
            noteStep2 = (NoteStep)hashMap.get(n2);
            if (noteStep2 != null) continue;
            noteStep = (NoteStep)hashMap2.get(n2);
            assert (bCi.CwM(noteStep.checkBounds(this.mGridWidth, this.mGridHeight)));
            NoteStep noteStep3 = new NoteStep(noteStep.x(), noteStep.y(), noteStep.channel(), this);
            this.notifyNoteStepToObservers(noteStep3);
        }
    }

    private void notifyNoteStepToObservers(NoteStep noteStep) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.CwM(noteStep.checkBounds(this.mGridWidth, this.mGridHeight)));
        for (Callback callback : this.mNoteDataChangedCallback) {
            callback.noteStepChanged(noteStep);
        }
        for (Callback callback : this.mStepDataChangedCallbacks) {
            callback.stepStateChanged(noteStep.x(), noteStep.y(), noteStep.noteState());
        }
    }

    private void setPlayingStep(int n2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(n2 >= -1));
        if (n2 != this.mLastPlaybackStep) {
            this.mLastPlaybackStep = n2;
            this.mPlayingStep.setIntegerValue(n2);
        }
    }

    private void validPosition(int n2, int n3, int n4) {
        this.validChannel(n2);
        this.validPosition(n3, n4);
    }

    private void validPosition(int n2, int n3) {
        this.validX(n2);
        this.validY(n3);
    }

    private void validChannel(int n2) {
        this.inRange(n2, 0, 15, "channel");
    }

    private void validKey(int n2) {
        this.inRange(n2, 0, 127, "key");
    }

    private void validX(int n2) {
        this.inRange(n2, 0, this.mGridWidth - 1, "x");
    }

    private void validY(int n2) {
        this.inRange(n2, 0, this.mGridHeight - 1, "y");
    }

    @Override
    public SettableEnumValue launchQuantization() {
        this.newSince(8);
        return this.mLaunchQuantization;
    }

    @Override
    public SettableBooleanValue useLoopStartAsQuantizationReference() {
        this.newSince(8);
        return this.mUseLoopStartAsQuantizationReference;
    }

    @Override
    public SettableBooleanValue launchLegato() {
        this.deprecated(8, 9);
        return this.mLegatoMode;
    }

    @Override
    public SettableEnumValue launchMode() {
        this.newSince(9);
        return this.mLaunchMode;
    }

    @Override
    public ClipLauncherSlot clipLauncherSlot() {
        this.newSince(10);
        return this.mClipLauncherSlot;
    }

    @Override
    public void launch() {
        this.newSince(10);
        this.exec(this::doLaunch);
    }

    private void doLaunch() {
        assert (bCi.CwM(this.isDocumentThread()));
        LlH llH = this.getClipEvent();
        if (llH != null) {
            llH.LTX(true);
        }
    }

    @Override
    public com.bitwig.extension.controller.api.NoteStep getStep(int n2, int n3, int n4) {
        this.newSince(10);
        this.validPosition(n2, n3, n4);
        NoteStep noteStep = (NoteStep)this.mNoteSteps.get(this.computeStepInfoIndex(n2, n3, n4));
        if (noteStep == null) {
            noteStep = new NoteStep(n3, n4, n2, this);
        }
        return noteStep;
    }
}

