/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.NotePlaybackCallback;
import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Channel;
import com.bitwig.extension.controller.api.HardwareControlType;
import com.bitwig.extension.controller.api.Send;
import com.bitwig.extension.controller.api.SettableBooleanValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableStringValue;
import com.bitwig.extension.controller.api.SoloValue;
import com.bitwig.flt.control_surface.proxy.ChannelProxy$1;
import com.bitwig.flt.control_surface.proxy.ChannelProxy$2;
import com.bitwig.flt.control_surface.proxy.ChannelProxy$VuMeterObserver;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceChainProxy;
import com.bitwig.flt.control_surface.proxy.SendBankProxy;
import com.bitwig.flt.control_surface.values.BooleanValueAtomProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.ComputedPlayingNoteArrayValue;
import com.bitwig.flt.control_surface.values.PlayingNote;
import com.bitwig.flt.control_surface.values.RemappableParameterProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.control_surface.values.SettableStringValueProxy;
import com.bitwig.flt.control_surface.values.SoloProxy;
import com.bitwig.flt.document.core.iface.Bmg;
import com.bitwig.flt.document.core.iface.YEC;
import com.bitwig.flt.document.core.iface.oGX;
import com.bitwig.ramona.core.TH1;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ChannelProxy
extends DeviceChainProxy
implements Channel {
    protected final SettableBooleanValueProxy mIsActivated;
    protected final BooleanValueAtomProxy mMute;
    protected final SoloProxy mSolo;
    protected final Map mPlayingNotes = new HashMap();
    protected final ComputedPlayingNoteArrayValue mPlayingNotesValue;
    protected final RemappableParameterProxy mVolume;
    protected final RemappableParameterProxy mPan;
    protected final SettableColorValueProxy mColor;
    private final SettableStringValueProxy mNameProxy;
    protected final SendBankProxy mSendBankProxy;
    private final List mNotePlaybackCallbacks = new ArrayList();
    private GcI mNoteObserverAtom;
    private final bmy mNotePlaybackListener = sDn2 -> this.notePlayed(sDn2.OqD(), sDn2.m2i(), sDn2.hFR());
    private boolean mHasScheduledUpdatePlayingNotes = false;
    private final BooleanValueProxy mIsMutedBySolo;

    public ChannelProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3) {
        super(controlSurfaceObject, string);
        this.mNameProxy = new SettableStringValueProxy(this);
        this.mIsActivated = new SettableBooleanValueProxy((ControlSurfaceObject)this, true);
        this.mMute = new BooleanValueAtomProxy(this);
        this.mPan = new RemappableParameterProxy((ControlSurfaceObject)this, string + "/Pan");
        this.mPan.setHardwareControlType(HardwareControlType.KNOB);
        this.mVolume = new RemappableParameterProxy((ControlSurfaceObject)this, string + "/Volume");
        this.mVolume.setHardwareControlType(HardwareControlType.SLIDER);
        this.mSolo = new SoloProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mPlayingNotesValue = new ComputedPlayingNoteArrayValue(this);
        this.mIsMutedBySolo = new BooleanValueProxy((ControlSurfaceObject)this, false);
        this.addChild(this.mIsActivated);
        this.addChild(this.mMute);
        this.addChild(this.mSolo);
        this.addChild(this.mVolume);
        this.addChild(this.mPan);
        this.addChild(this.mPlayingNotesValue);
        this.mVolume.setIndexInGroup(n2);
        this.mPan.setIndexInGroup(n2);
        this.mSendBankProxy = n3 > 0 ? new SendBankProxy(this, string + "/Send/", n3, n2) : null;
    }

    @Override
    protected int getNumSends() {
        return this.mSendBankProxy != null ? this.mSendBankProxy.getSizeOfBank() : 0;
    }

    @Override
    public void select() {
        this.selectInEditor();
    }

    @Override
    public void duplicate() {
        this.exec(() -> {
            ICF iCF;
            if (this.getTarget() != null && (iCF = this.getEditorChannelSelection((Bmg)this.getTarget())) != null) {
                iCF.EuM((TH1)this.getTarget());
                iCF.InL();
                if (iCF.Xt2()) {
                    iCF.FXs();
                }
            }
        });
    }

    @Override
    public SettableBooleanValue isActivated() {
        return this.mIsActivated;
    }

    @Override
    public RemappableParameterProxy getVolume() {
        this.deprecated(1, 5, "Use volume() instead");
        return this.mVolume;
    }

    @Override
    public RemappableParameterProxy volume() {
        this.newSince(5);
        return this.mVolume;
    }

    @Override
    public RemappableParameterProxy getPan() {
        this.deprecated(1, 5, "Use pan() instead");
        return this.mPan;
    }

    @Override
    public RemappableParameterProxy pan() {
        this.newSince(5);
        return this.mPan;
    }

    @Override
    public SettableBooleanValue getMute() {
        this.deprecated(1, 5, "Use mute() instead");
        return this.mMute;
    }

    @Override
    public SettableBooleanValue mute() {
        this.newSince(5);
        return this.mMute;
    }

    @Override
    public SoloProxy getSolo() {
        this.deprecated(1, 5, "Use solo() instead");
        return this.mSolo;
    }

    @Override
    public SoloValue solo() {
        this.newSince(5);
        return this.mSolo;
    }

    @Override
    public BooleanValue isMutedBySolo() {
        this.newSince(10);
        return this.mIsMutedBySolo;
    }

    @Override
    public SendBankProxy sendBank() {
        if (this.mSendBankProxy == null) {
            throw new aRB("No send bank exists: Requested a send bank size of 0");
        }
        return this.mSendBankProxy;
    }

    public SendBankProxy getSendBankOnDocumentThread() {
        assert (bCi.CwM(this.isDocumentThread()));
        return this.mSendBankProxy;
    }

    @Override
    public Send getSend(int n2) {
        if (this.mSendBankProxy == null) {
            if (this.getRequiredApiVersion() == 1) {
                return null;
            }
            throw new aRB("No send bank exists: Requested a send bank size of 0");
        }
        return this.mSendBankProxy.getItemAt(n2);
    }

    @Override
    public SettableStringValue name() {
        this.newSince(2);
        return this.mNameProxy;
    }

    @Override
    public void addNameObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.deprecated(1, 2, "Use name() instead");
        this.mNameProxy.addValueObserver(n2, string, stringValueChangedCallback);
    }

    @Override
    public void addVuMeterObserver(int n2, int n3, boolean bl2, IntegerValueChangedCallback integerValueChangedCallback) {
        if (n3 < -1 || n3 > 1) {
            throw new aRB("No such channel.");
        }
        this.addObserver(new ChannelProxy$VuMeterObserver(this.getControlSurface(), integerValueChangedCallback, n2, n3, bl2));
    }

    @Override
    public ComputedPlayingNoteArrayValue playingNotes() {
        return this.mPlayingNotesValue;
    }

    @Override
    public void addNoteObserver(NotePlaybackCallback notePlaybackCallback) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(notePlaybackCallback, "callback");
        this.mNotePlaybackCallbacks.add(notePlaybackCallback);
    }

    private void notePlayed(boolean bl2, int n2, float f4) {
        assert (bCi.OqD(this.isDocumentThread()));
        if (!this.mNotePlaybackCallbacks.isEmpty()) {
            this.queueCallback(() -> this.notifyNotePlayed(bl2, n2, f4));
        }
        if (!this.mPlayingNotesValue.isInterested()) {
            return;
        }
        if (bl2) {
            this.mPlayingNotes.put(n2, new PlayingNote(n2, (int)(127.0f * f4)));
        } else {
            this.mPlayingNotes.remove(n2);
        }
        this.invalidatePlayingNotes();
    }

    private void invalidatePlayingNotes() {
        assert (bCi.CwM(this.isDocumentThread()));
        if (!this.mHasScheduledUpdatePlayingNotes) {
            this.mHasScheduledUpdatePlayingNotes = true;
            this.runAtEndOfEvent(this::updatePlayingNotes);
        }
    }

    private void updatePlayingNotes() {
        assert (bCi.CwM(this.isDocumentThread()));
        this.mHasScheduledUpdatePlayingNotes = false;
        PlayingNote[] playingNoteArray = this.mPlayingNotes.values().toArray(new PlayingNote[0]);
        this.mPlayingNotesValue.setValue(playingNoteArray);
    }

    private void notifyNotePlayed(boolean bl2, int n2, float f4) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        for (NotePlaybackCallback notePlaybackCallback : this.mNotePlaybackCallbacks) {
            notePlaybackCallback.notePlaybackEventOccurred(bl2, n2, f4);
        }
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    public HkO getColor() {
        MEE mEE = this.mColor.getEditableValue();
        if (mEE != null) {
            return (HkO)mEE.getValue();
        }
        return null;
    }

    protected abstract ICF getEditorChannelSelection(Bmg var1);

    protected ICF getMixerChannelSelection() {
        oGX oGX2 = this.getDocument();
        if (oGX2 != null) {
            return oGX2.rH1().CwM();
        }
        return null;
    }

    @Override
    public void addIsSelectedInEditorObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.addObserver(new ChannelProxy$1(this, this.getControlSurface(), booleanValueChangedCallback));
    }

    @Override
    public void addIsSelectedInMixerObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.addObserver(new ChannelProxy$2(this, this.getControlSurface(), booleanValueChangedCallback));
    }

    @Override
    public void selectInEditor() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(this::doSelectInEditor);
    }

    private void doSelectInEditor() {
        ICF iCF;
        assert (bCi.OqD(this.isDocumentThread()));
        mc mc2 = this.getDocumentGUIWrapper();
        if (mc2 != null && this.getTarget() != null && (iCF = this.getEditorChannelSelection((Bmg)this.getTarget())) != null) {
            iCF.LTX((TH1)this.getTarget());
            this.showSelectionNotification();
        }
    }

    @Override
    public void selectInMixer() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(this::doSelectInMixer);
    }

    private void doSelectInMixer() {
        ICF iCF;
        assert (bCi.OqD(this.isDocumentThread()));
        mc mc2 = this.getDocumentGUIWrapper();
        if (mc2 != null && this.getTarget() != null && (iCF = this.getMixerChannelSelection()) != null) {
            iCF.LTX((TH1)this.getTarget());
            this.showSelectionNotification();
        }
    }

    @Override
    public void makeVisibleInMixer() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(this::doMakeVisibleInMixer);
    }

    private void doMakeVisibleInMixer() {
        mD mD2;
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.getTarget() != null && (mD2 = this.getDocumentWidget()) != null) {
            List list = mD2.OqD(anM.class, true);
            for (anM anM2 : list) {
                anM2.CwM((Bmg)this.getTarget());
            }
        }
    }

    @Override
    public void makeVisibleInArranger() {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.exec(this::doMakeVisibleInArranger);
    }

    private void doMakeVisibleInArranger() {
        mD mD2;
        assert (bCi.OqD(this.isDocumentThread()));
        if (this.getTarget() instanceof YEC && (mD2 = this.getDocumentWidget()) != null) {
            List list = mD2.OqD(pQ.class, true);
            for (pQ pQ2 : list) {
                pQ2.Opd((YEC)this.getTarget());
            }
        }
    }

    @Override
    protected String getName() {
        Bmg bmg2 = (Bmg)this.getTarget();
        if (bmg2 != null) {
            return bmg2.nce();
        }
        return "(none)";
    }

    protected void connectToTarget(Bmg bmg2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(bmg2 != null));
        assert (bCi.OqD(bmg2.hhS()));
        sNz sNz2 = bmg2.IkS();
        this.mNameProxy.setTarget(bmg2.Ugn(), bmg2.khV());
        this.mIsActivated.setTarget(bmg2.eSQ());
        this.mMute.setTarget(sNz2.dhb());
        this.mSolo.setMixerModule(sNz2);
        this.mVolume.setTargetAtom(sNz2.hFR());
        this.mPan.setTargetAtom(sNz2.uwB());
        this.mColor.setTarget(bmg2.JWq(), bmg2.Dii());
        this.mPlayingNotes.clear();
        this.mIsMutedBySolo.setTarget(sNz2.nSA());
        this.invalidatePlayingNotes();
        if (this.mSendBankProxy != null) {
            this.mSendBankProxy.setTarget(bmg2);
        }
        assert (bCi.OqD(this.mNoteObserverAtom == null));
        this.mNoteObserverAtom = bmg2.Uft();
        if (this.mNoteObserverAtom != null) {
            this.mNoteObserverAtom.OqD(this.mNotePlaybackListener);
            this.mNoteObserverAtom.ynG().CwM();
        }
        for (oFt oFt2 : this.getObservers()) {
            if (!(oFt2 instanceof ChannelProxy$VuMeterObserver)) continue;
            ChannelProxy$VuMeterObserver channelProxy$VuMeterObserver = (ChannelProxy$VuMeterObserver)oFt2;
            int n2 = channelProxy$VuMeterObserver.mChannel;
            if (channelProxy$VuMeterObserver.mPeak) {
                channelProxy$VuMeterObserver.sendValue(((wI)sNz2.aMy().uwB().get(n2)).hFR());
                ((wI)sNz2.aMy().uwB().get(n2)).OqD(channelProxy$VuMeterObserver);
                continue;
            }
            channelProxy$VuMeterObserver.sendValue(((wI)sNz2.aMy().uwB().get(n2)).CwM());
            ((wI)sNz2.aMy().uwB().get(n2)).CwM(channelProxy$VuMeterObserver);
        }
        this.setDeviceChain(bmg2.bh_());
        this.connectObservers(bmg2);
    }

    protected void disconnectFromTarget(Bmg bmg2) {
        assert (bCi.OqD(this.getTarget() != null));
        if (this.mNoteObserverAtom != null) {
            this.mNoteObserverAtom.m2i(this.mNotePlaybackListener);
            this.mNoteObserverAtom.ynG().OqD();
            this.mNoteObserverAtom = null;
        }
        this.mNameProxy.clearTarget();
        this.disconnectObservers(bmg2);
        this.setDeviceChain(null);
        sNz sNz2 = ((Bmg)this.getTarget()).IkS();
        if (this.mSendBankProxy != null) {
            this.mSendBankProxy.clearTarget();
        }
        for (oFt oFt2 : this.getObservers()) {
            if (!(oFt2 instanceof ChannelProxy$VuMeterObserver)) continue;
            ChannelProxy$VuMeterObserver channelProxy$VuMeterObserver = (ChannelProxy$VuMeterObserver)oFt2;
            int n2 = channelProxy$VuMeterObserver.mChannel;
            wI wI2 = (wI)sNz2.aMy().uwB().get(n2);
            if (channelProxy$VuMeterObserver.mPeak) {
                wI2.m2i(channelProxy$VuMeterObserver);
            } else {
                wI2.Opd(channelProxy$VuMeterObserver);
            }
            channelProxy$VuMeterObserver.sendValue(0.0);
        }
        this.mIsActivated.clearTarget();
        this.mMute.clearTarget();
        this.mSolo.setMixerModule(null);
        this.mVolume.clearTarget();
        this.mPan.clearTarget();
        this.mColor.clearTarget();
        this.mIsMutedBySolo.clearTarget();
        this.mPlayingNotes.clear();
        this.invalidatePlayingNotes();
    }

    protected Bmg getChannel() {
        return (Bmg)this.getTarget();
    }

    @Override
    public void deleteObject() {
        assert (bCi.CwM(this.isControlSurfaceThread()));
        this.newSince(10);
        this.getHost().deleteObjects("Delete Channel From Controller", this);
    }
}

