/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.BrowserItem;
import com.bitwig.extension.controller.api.BrowserItemBank;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.BrowserColumnProxy;
import com.bitwig.flt.control_surface.proxy.BrowserItemProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObjectProxy;

public abstract class BrowserItemBankProxy
extends ControlSurfaceObjectProxy
implements BrowserItemBank,
yfM {
    private final BankItemTargetUpdater mBankUpdater;
    protected BrowserItemProxy[] mItemProxies;

    public BrowserItemBankProxy(BrowserColumnProxy browserColumnProxy, int n2) {
        super(browserColumnProxy);
        if (n2 < 1) {
            throw new aRB("Item bank size must be >= 1");
        }
        this.mItemProxies = new BrowserItemProxy[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mItemProxies[i2] = this.createResultProxy(i2, browserColumnProxy);
        }
        this.mBankUpdater = new BankItemTargetUpdater((ControlSurfaceObject)this, this.mItemProxies);
    }

    public BrowserColumnProxy getColumn() {
        return (BrowserColumnProxy)this.getParent();
    }

    protected abstract BrowserItemProxy createResultProxy(int var1, BrowserColumnProxy var2);

    @Override
    public int getSizeOfBank() {
        return this.mBankUpdater.getSizeOfBank();
    }

    @Override
    public void setSizeOfBank(int n2) {
        this.mBankUpdater.setSizeOfBank(n2);
    }

    @Override
    public int getCapacityOfBank() {
        return this.mBankUpdater.getCapacityOfBank();
    }

    @Override
    public int getSize() {
        return this.getSizeOfBank();
    }

    @Override
    public IntegerValue itemCount() {
        return this.mBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mBankUpdater.getCursorIndex();
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollIntoView(int n2) {
        this.newSince(7);
        this.mBankUpdater.scrollIntoView(n2);
    }

    @Override
    public void scrollBy(int n2) {
        this.mBankUpdater.scrollBy(n2);
    }

    @Override
    public void doStepForwards() {
        this.mBankUpdater.doScrollForwards();
    }

    @Override
    public void doStepBackwards() {
        this.mBankUpdater.doScrollBackwards();
    }

    @Override
    public void scrollByPages(int n2) {
        this.mBankUpdater.scrollByPages(n2);
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mBankUpdater.getCanScrollForwards();
    }

    @Override
    public HardwareActionBindable scrollBackwardsAction() {
        return this.mBankUpdater.scrollBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollForwardsAction() {
        return this.mBankUpdater.scrollForwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageBackwardsAction() {
        return this.mBankUpdater.scrollPageBackwardsAction();
    }

    @Override
    public HardwareActionBindable scrollPageForwardsAction() {
        return this.mBankUpdater.scrollPageForwardsAction();
    }

    @Override
    public BrowserItem getItemAt(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        return (BrowserItem)((Object)this.mBankUpdater.getItemAt(n2));
    }

    @Override
    public BrowserItem getItem(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        return (BrowserItem)((Object)this.mBankUpdater.getItemAt(n2));
    }

    @Override
    public void scrollUp() {
        this.mBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollDown() {
        this.mBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollPageUp() {
        this.mBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageDown() {
        this.mBankUpdater.scrollByPages(1);
    }

    @Override
    public void addScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.mBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addCanScrollUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanScrollDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    protected void connectToTarget(Object object) {
        dzj dzj2 = this.getResultsListValue(object);
        assert (bCi.OqD(dzj2 != null));
        this.mBankUpdater.setTarget(dzj2);
    }

    @Override
    protected void disconnectFromTarget(Object object) {
        this.mBankUpdater.clearTarget();
    }

    protected abstract dzj getResultsListValue(Object var1);

    public void scrollToItem(aRA aRA2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(aRA2 != null));
        Object object = this.getTarget();
        if (object != null) {
            this.mBankUpdater.doScrollToItem(aRA2);
        }
    }

    @Override
    public void setSkipDisabledItems(boolean bl2) {
    }
}

