/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.HardwareActionBindable;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BankCursorIndex;
import com.bitwig.flt.control_surface.proxy.BankItemWithPosition;
import com.bitwig.flt.control_surface.proxy.BankScrollPosition;
import com.bitwig.flt.control_surface.proxy.BankTarget;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceCursorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.DocumentAction;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.ramona.core.TH1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BankItemTargetUpdater
extends ControlSurfaceProxy
implements Odg {
    private final ControlSurfaceProxy[] mItemProxies;
    private final ComputedBooleanValue mCanScrollBackwards;
    private final ComputedBooleanValue mCanScrollForwards;
    private final BankScrollPosition mScrollPosition;
    private final BankCursorIndex mCursorIndex;
    private ControlSurfaceCursorProxy mCursorProxyToFollow;
    private final ComputedIntegerValue mListItemCount;
    private final int mScrollPositionThatPageShouldAlignTo;
    private boolean mHasScheduledUpdate;
    private TH1 mCursor;
    private List mScrollPositionSlaves;
    private BankItemTargetUpdater mMasterScrollPositionBankUpdater;
    private int mSize;

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray, int n2) {
        super(controlSurfaceObject);
        assert (bCi.OqD(controlSurfaceProxyArray != null));
        assert (bCi.OqD(n2 >= 0));
        this.mItemProxies = controlSurfaceProxyArray;
        this.mSize = controlSurfaceProxyArray.length;
        this.mCanScrollBackwards = new ComputedBooleanValue(this);
        this.mCanScrollForwards = new ComputedBooleanValue(this);
        this.mScrollPosition = new BankScrollPosition(this);
        this.mCursorIndex = new BankCursorIndex(this);
        this.mListItemCount = new ComputedIntegerValue((ControlSurfaceObject)this, 0);
        this.mScrollPositionThatPageShouldAlignTo = n2;
    }

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray) {
        this(controlSurfaceObject, controlSurfaceProxyArray, 0);
    }

    @Override
    public Class getTargetType() {
        return BankTarget.class;
    }

    public void setSizeOfBank(int n2) {
        this.newSince(7);
        this.inRange(n2, 0, this.getCapacityOfBank(), "size");
        this.mSize = n2;
    }

    public int getSizeOfBank() {
        return this.mSize;
    }

    public int getCapacityOfBank() {
        this.newSince(7);
        return this.mItemProxies.length;
    }

    public HardwareActionBindable scrollBackwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::doScrollBackwards);
    }

    public HardwareActionBindable scrollForwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::doScrollForwards);
    }

    public HardwareActionBindable scrollPageBackwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::doScrollPageBackwards);
    }

    public HardwareActionBindable scrollPageForwardsAction() {
        return new DocumentAction((ControlSurfaceObject)this, this::doScrollPageForwards);
    }

    public ControlSurfaceProxy getItemAt(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.inRange(n2, 0, this.getSizeOfBank(), "index");
        return (ControlSurfaceProxy)this.returnArrayItem(this.mItemProxies, n2);
    }

    public void scrollTo(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.postEvent(K3n.CwM(this, Math.max(0, n2)));
    }

    public void scrollIntoView(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.postEvent(K3n.Opd(this, Math.max(0, n2)));
    }

    public void doScrollTo(int n2, boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(n2 >= 0));
        if (n2 >= this.mListItemCount.getValue()) {
            return;
        }
        if (this.mMasterScrollPositionBankUpdater != null) {
            this.mMasterScrollPositionBankUpdater.doScrollTo(n2, bl2);
        } else {
            this.doScrollToImpl(n2, bl2);
        }
    }

    protected int getQuantizedPagePositionThatIncludesItem(int n2, int n3) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(n2 >= 0 && n2 < n3));
        assert (bCi.OqD(n3 > 0));
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.mItemProxies.length;
        int n5 = n4 < this.mScrollPositionThatPageShouldAlignTo ? this.mScrollPositionThatPageShouldAlignTo % n4 : 0;
        int n6 = (n2 - n5) / n4 * n4 + n5;
        if (n6 < this.mScrollPosition.getValue() - n4) {
            n6 += n4;
        }
        int n7 = (n3 - 1) / n4 * n4;
        int n8 = f2f.CwM(n6, 0, n7);
        assert (bCi.OqD(n8 >= 0));
        assert (bCi.OqD(n8 <= n2));
        assert (bCi.OqD(n8 + n4 >= n2));
        return n8;
    }

    private void doScrollToImpl(int n2, boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        int n3 = bl2 ? this.mListItemCount.getValue() - 1 : this.mListItemCount.getValue() - this.mSize;
        int n4 = f2f.CwM(n2, 0, Math.max(0, n3));
        List list = this.getPossibleTargets();
        int n5 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n6 = n4 + i2;
            if (n6 < list.size()) {
                object = (TH1)list.get(n6);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && this.mCursor == object) {
                    n5 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n6);
        }
        if (this.mScrollPositionSlaves != null) {
            for (ControlSurfaceProxy controlSurfaceProxy : this.mScrollPositionSlaves) {
                ((BankItemTargetUpdater)controlSurfaceProxy).doScrollToImpl(n4, bl2);
            }
        }
        this.mScrollPosition.setIntegerValue(n4);
        if (n5 >= 0) {
            this.mCursorIndex.setIntegerValue(n5);
        } else {
            this.mCursorIndex.unassigned();
        }
        this.mCanScrollForwards.setBoolValue(n4 + this.getSizeOfBank() < list.size());
        this.mCanScrollBackwards.setBoolValue(n4 > 0);
    }

    public void scrollBy(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (n2 != 0) {
            this.postEvent(K3n.CwM(this, n2, Math.abs(n2) > 1));
        }
    }

    public void doScrollForwards() {
        this.doScrollBy(1, false);
    }

    public void doScrollBackwards() {
        this.doScrollBy(-1, false);
    }

    public void doScrollPageForwards() {
        this.doScrollBy(this.mItemProxies.length, true);
    }

    public void doScrollPageBackwards() {
        this.doScrollBy(-this.mItemProxies.length, true);
    }

    public void doScrollBy(int n2, boolean bl2) {
        assert (bCi.OqD(this.isDocumentThread()));
        this.doScrollTo(Math.max(0, this.mScrollPosition.getValue() + n2), bl2);
    }

    public void scrollByPages(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        this.scrollBy(n2 * this.mItemProxies.length);
    }

    public ControlSurfaceProxy[] getItemProxies() {
        return this.mItemProxies;
    }

    public BooleanValue getCanScrollForwards() {
        return this.mCanScrollForwards;
    }

    public BooleanValue getCanScrollBackwards() {
        return this.mCanScrollBackwards;
    }

    public IntegerValue getListItemCount() {
        return this.mListItemCount;
    }

    public SettableIntegerValue getScrollPosition() {
        return this.mScrollPosition;
    }

    public int getScrollPositionValue() {
        assert (bCi.OqD(this.isDocumentThread()));
        return this.mScrollPosition.getValue();
    }

    public final void possibleTargetsChanged() {
        assert (bCi.OqD(this.isDocumentThread()));
        if (!this.mHasScheduledUpdate) {
            this.mHasScheduledUpdate = true;
            this.runAtEndOfEvent(this::updateItemTargets);
        }
    }

    private void updateItemTargets() {
        assert (bCi.OqD(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        this.updateItemTargets(list);
        this.mHasScheduledUpdate = false;
    }

    public void setTarget(dzj dzj2) {
        this.setTarget(BankTarget.create(dzj2));
    }

    public void setTarget(List list) {
        this.setTarget(BankTarget.create(list));
    }

    protected void connectToTarget(BankTarget bankTarget) {
        this.updateItemTargets();
        bankTarget.setItemsChangedListener(this::possibleTargetsChanged);
    }

    protected void disconnectFromTarget(BankTarget bankTarget) {
        bankTarget.setItemsChangedListener(null);
        for (ControlSurfaceProxy controlSurfaceProxy : this.mItemProxies) {
            controlSurfaceProxy.clearTarget();
        }
    }

    private List getPossibleTargets() {
        assert (bCi.OqD(this.isDocumentThread()));
        BankTarget bankTarget = (BankTarget)this.getTarget();
        if (bankTarget == null) {
            return Collections.EMPTY_LIST;
        }
        return bankTarget.listItems();
    }

    private void updateItemTargets(List list) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(list != null));
        int n2 = list.size() <= this.mItemProxies.length ? 0 : this.determineNewOffset(list);
        assert (bCi.OqD(n2 >= 0));
        assert (bCi.OqD(list.isEmpty() ? n2 == 0 : n2 < list.size()));
        int n3 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n4 = n2 + i2;
            if (n4 < list.size()) {
                object = (TH1)list.get(n4);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && object == this.mCursor) {
                    n3 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n4);
        }
        BankTarget bankTarget = (BankTarget)this.getTarget();
        if (bankTarget != null) {
            this.mScrollPosition.setIntegerValue(n2);
            this.mListItemCount.setIntegerValue(list.size());
            this.mCanScrollForwards.setBoolValue(n2 + this.getSizeOfBank() < list.size());
            this.mCanScrollBackwards.setBoolValue(n2 > 0);
        } else {
            this.mScrollPosition.unassigned();
            this.mListItemCount.unassigned();
            this.mCanScrollForwards.unassigned();
            this.mCanScrollBackwards.unassigned();
        }
        if (n3 >= 0) {
            this.mCursorIndex.setIntegerValue(n3);
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    private int determineNewOffset(List list) {
        assert (bCi.OqD(list.size() >= this.mItemProxies.length));
        assert (bCi.OqD(this.isDocumentThread()));
        for (ControlSurfaceProxy controlSurfaceProxy : this.mItemProxies) {
            int n2;
            TH1 tH1 = (TH1)controlSurfaceProxy.getTarget();
            if (tH1 == null || (n2 = list.indexOf(tH1)) < 0) continue;
            return this.getQuantizedPagePositionThatIncludesItem(n2, list.size());
        }
        return f2f.CwM(this.mScrollPosition.getValue(), 0, list.size() - 1);
    }

    public void addScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (bCi.OqD(bankItemTargetUpdater != null));
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInitializingDriver()));
        if (this.mScrollPositionSlaves == null) {
            this.mScrollPositionSlaves = new ArrayList(8);
        }
        this.mScrollPositionSlaves.add(bankItemTargetUpdater);
        assert (bCi.OqD(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == null));
        bankItemTargetUpdater.mMasterScrollPositionBankUpdater = this;
    }

    public void removeScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (bCi.OqD(bankItemTargetUpdater != null));
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(this.isInitializingDriver()));
        assert (bCi.OqD(this.mScrollPositionSlaves != null));
        if (this.mScrollPositionSlaves != null) {
            assert (bCi.OqD(this.mScrollPositionSlaves.contains(bankItemTargetUpdater)));
            this.mScrollPositionSlaves.remove(bankItemTargetUpdater);
            assert (bCi.OqD(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == this));
            bankItemTargetUpdater.mMasterScrollPositionBankUpdater = null;
        }
    }

    @Override
    public TH1 getFirstItem(TH1 tH1) {
        assert (bCi.OqD(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        if (!list.isEmpty()) {
            return (TH1)list.get(0);
        }
        return null;
    }

    @Override
    public TH1 getLastItem(TH1 tH1) {
        assert (bCi.OqD(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        if (!list.isEmpty()) {
            return (TH1)list.get(list.size() - 1);
        }
        return null;
    }

    @Override
    public TH1 getPreviousItem(TH1 tH1) {
        assert (bCi.OqD(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        if (tH1 == null) {
            if (!list.isEmpty()) {
                return (TH1)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(tH1);
        if (n2 > 0) {
            return (TH1)list.get(n2 - 1);
        }
        return null;
    }

    @Override
    public TH1 getNextItem(TH1 tH1) {
        assert (bCi.OqD(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        if (tH1 == null) {
            if (!list.isEmpty()) {
                return (TH1)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(tH1);
        if (n2 + 1 < list.size()) {
            return (TH1)list.get(n2 + 1);
        }
        return null;
    }

    protected void cursorMovedToItem(TH1 tH1) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(this.mCursorProxyToFollow != null));
        this.mCursor = tH1;
        if (tH1 != null) {
            this.doScrollToItem(tH1);
            int n2 = -1;
            for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
                ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
                TH1 tH12 = (TH1)controlSurfaceProxy.getTarget();
                if (tH12 != tH1) continue;
                n2 = i2;
                break;
            }
            if (n2 >= 0) {
                this.mCursorIndex.setIntegerValue(n2);
            } else {
                this.mCursorIndex.unassigned();
            }
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    public void doScrollToItem(TH1 tH1) {
        assert (bCi.OqD(tH1 != null));
        assert (bCi.OqD(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        int n2 = list.indexOf(tH1);
        if (n2 >= 0) {
            this.doScrollIntoView(n2, list.size(), true);
        }
    }

    public void doScrollIntoView(int n2) {
        assert (bCi.OqD(n2 >= 0));
        assert (bCi.OqD(this.isDocumentThread()));
        this.doScrollIntoView(n2, true);
    }

    public void doScrollIntoView(int n2, boolean bl2) {
        assert (bCi.OqD(n2 >= 0));
        assert (bCi.OqD(this.isDocumentThread()));
        List list = this.getPossibleTargets();
        this.doScrollIntoView(n2, list.size(), bl2);
    }

    private void doScrollIntoView(int n2, int n3, boolean bl2) {
        assert (bCi.OqD(n2 >= 0));
        assert (bCi.OqD(this.isDocumentThread()));
        int n4 = this.mScrollPosition.getValue();
        if (n2 < n4 || n2 >= n4 + this.mItemProxies.length) {
            int n5 = this.getQuantizedPagePositionThatIncludesItem(n2, n3);
            assert (bCi.OqD(n2 >= n5 && n2 < n5 + this.mItemProxies.length));
            this.doScrollTo(n5, bl2);
        }
    }

    public void followCursorProxy(ControlSurfaceCursorProxy controlSurfaceCursorProxy) {
        this.notNull(controlSurfaceCursorProxy, "cursor");
        this.checkIsInitializingDriver();
        if (this.mCursorProxyToFollow != null) {
            throw new aRB("This bank is already following a cursor");
        }
        this.mCursorProxyToFollow = controlSurfaceCursorProxy;
        controlSurfaceCursorProxy.addBankFollowingCursor(this);
    }

    public SettableIntegerValue getCursorIndex() {
        assert (bCi.OqD(this.mCursorIndex != null));
        return this.mCursorIndex;
    }

    protected void moveCursorIndexTo(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        assert (bCi.OqD(n2 >= 0 && n2 < this.getSizeOfBank()));
        if (this.mCursorProxyToFollow == null) {
            throw new aRB("This bank is not following any cursor");
        }
        this.exec(() -> this.doMoveCursorToIndex(n2));
    }

    public void doMoveCursorToIndex(int n2) {
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(n2 >= 0 && n2 < this.getSizeOfBank()));
        assert (bCi.OqD(this.mCursorProxyToFollow != null));
        ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[n2];
        TH1 tH1 = (TH1)controlSurfaceProxy.getTarget();
        if (tH1 != null) {
            this.mCursorProxyToFollow.doSelect(tH1);
        }
    }

    protected void moveCursorIndexBy(int n2) {
        assert (bCi.OqD(this.isControlSurfaceThread()));
        if (this.mCursorProxyToFollow == null) {
            throw new aRB("This bank is not following any cursor");
        }
        if (n2 != 0) {
            this.exec(() -> this.doMoveCursorIndexBy(n2));
        }
    }

    private void doMoveCursorIndexBy(int n2) {
        int n3;
        assert (bCi.OqD(this.isDocumentThread()));
        assert (bCi.OqD(n2 != 0));
        assert (bCi.OqD(this.mCursorProxyToFollow != null));
        int n4 = this.mCursorIndex.getValue();
        assert (bCi.OqD(n4 >= 0 && n4 < this.getSizeOfBank() || n4 == -1));
        if (n4 >= 0 && n4 < this.getSizeOfBank() && (n3 = n4 + n2) >= 0 && n3 < this.getSizeOfBank()) {
            this.doMoveCursorToIndex(n3);
        }
    }
}

