/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.opensoundcontrol;

import com.bitwig.extension.api.opensoundcontrol.OscInvalidArgumentTypeException;
import com.bitwig.extension.api.opensoundcontrol.OscPacketSizeExceededException;
import com.bitwig.flt.control_surface.opensoundcontrol.rqo;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Stack;

class XOl {
    private final byte[] Opd = new byte[65536];
    private final ByteBuffer OqD = ByteBuffer.wrap(this.Opd);
    private int m2i = 0;
    private final Stack hFR = new Stack();

    XOl() {
        this.OqD.order(ByteOrder.BIG_ENDIAN);
    }

    void CwM() {
        this.OqD.position(0);
        this.m2i = 0;
        this.hFR.clear();
    }

    void Opd() {
        try {
            if (this.m2i > 0) {
                this.hFR.add(this.OqD.position());
                this.CwM(0);
            }
            this.CwM("#bundle");
            this.CwM(42L);
            ++this.m2i;
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new OscPacketSizeExceededException();
        }
    }

    void OqD() {
        try {
            if (this.m2i == 0) {
                throw new IllegalStateException("Call to endBundle() without a call to startBundle() first.");
            }
            --this.m2i;
            if (this.m2i > 0) {
                int n2 = this.OqD.position();
                int n3 = (Integer)this.hFR.pop();
                this.OqD.putInt(n3, n2 - n3 - 4);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new OscPacketSizeExceededException();
        }
    }

    void CwM(String string, Object ... objectArray) {
        try {
            int n2 = this.OqD.position();
            if (this.m2i > 0) {
                this.OqD.putInt(0);
            }
            this.CwM(string);
            String string2 = rqo.CwM(objectArray);
            this.CwM(string2);
            if (objectArray == null) {
                return;
            }
            for (Object object : objectArray) {
                if (object == null || object instanceof Boolean) continue;
                if (object instanceof Integer) {
                    this.CwM((Integer)object);
                    continue;
                }
                if (object instanceof Long) {
                    this.Opd((Long)object);
                    continue;
                }
                if (object instanceof Float) {
                    this.CwM(((Float)object).floatValue());
                    continue;
                }
                if (object instanceof Double) {
                    this.CwM((Double)object);
                    continue;
                }
                if (object instanceof String) {
                    this.CwM((String)object);
                    continue;
                }
                if (object instanceof byte[]) {
                    this.Opd((byte[])object);
                    continue;
                }
                throw new OscInvalidArgumentTypeException(object);
            }
            if (this.m2i > 0) {
                this.OqD.putInt(n2, this.OqD.position() - n2 - 4);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new OscPacketSizeExceededException();
        }
    }

    int m2i() {
        return this.m2i;
    }

    private void CwM(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        if (byArray.length % 4 == 0) {
            this.OqD.put(byArray);
            this.OqD.putInt(0);
        } else {
            this.CwM(byArray);
        }
    }

    private void CwM(byte[] byArray) {
        this.OqD.put(byArray);
        int n2 = byArray.length > 0 ? (4 - byArray.length % 4) % 4 : 4;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.OqD.put((byte)0);
        }
    }

    private void CwM(long l2) {
        this.Opd(l2);
    }

    private void CwM(int n2) {
        assert (bCi.CwM(this.OqD.order() == ByteOrder.BIG_ENDIAN));
        this.OqD.putInt(n2);
    }

    private void Opd(long l2) {
        assert (bCi.CwM(this.OqD.order() == ByteOrder.BIG_ENDIAN));
        this.OqD.putLong(l2);
    }

    private void CwM(float f4) {
        this.OqD.putFloat(f4);
    }

    private void CwM(double d2) {
        this.OqD.putDouble(d2);
    }

    private void Opd(byte[] byArray) {
        this.OqD.putInt(byArray.length);
        this.CwM(byArray);
    }

    byte[] hFR() {
        return this.Opd;
    }

    int LTX() {
        return this.OqD.position();
    }
}

