/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.opensoundcontrol;

import com.bitwig.extension.api.opensoundcontrol.OscBundle;
import com.bitwig.extension.api.opensoundcontrol.OscPacket;
import com.bitwig.flt.control_surface.opensoundcontrol.eac;
import com.bitwig.flt.control_surface.opensoundcontrol.tC3;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class Bmg {
    private ByteBuffer Opd = null;
    private byte[] OqD = null;

    Bmg() {
    }

    OscPacket CwM(byte[] byArray, int n2, int n3) {
        try {
            this.OqD = byArray;
            this.Opd = ByteBuffer.wrap(byArray, n2, n3);
            this.Opd.order(ByteOrder.BIG_ENDIAN);
            return this.CwM(null);
        }
        catch (IllegalArgumentException | BufferUnderflowException runtimeException) {
            return null;
        }
    }

    private OscPacket CwM(OscBundle oscBundle) {
        String string = this.CwM();
        if (string.equals("#bundle")) {
            return this.Opd(oscBundle);
        }
        return this.CwM(oscBundle, string);
    }

    private String CwM() {
        byte by2;
        int n2 = this.Opd.position();
        assert (bCi.CwM(n2 % 4 == 0));
        while ((by2 = this.Opd.get()) != 0) {
        }
        String string = new String(this.OqD, n2, this.Opd.position() - n2 - 1);
        this.uwB();
        return string;
    }

    private int Opd() {
        assert (bCi.CwM(this.Opd.order() == ByteOrder.BIG_ENDIAN));
        return this.Opd.getInt();
    }

    private long OqD() {
        assert (bCi.CwM(this.Opd.order() == ByteOrder.BIG_ENDIAN));
        return this.Opd.getLong();
    }

    private float m2i() {
        return this.Opd.getFloat();
    }

    private double hFR() {
        return this.Opd.getDouble();
    }

    private byte[] LTX() {
        int n2 = this.Opd();
        if (n2 < 0) {
            throw new IOException("Invalid blob size: " + n2);
        }
        byte[] byArray = new byte[n2];
        this.Opd.get(byArray);
        this.uwB();
        return byArray;
    }

    private void uwB() {
        int n2 = this.Opd.position() % 4;
        if (n2 != 0) {
            int n3 = this.Opd.position() + 4 - n2;
            this.Opd.position(n3);
        }
        assert (bCi.CwM(this.Opd.position() % 4 == 0));
    }

    private tC3 CwM(OscBundle oscBundle, String string) {
        String string2 = this.CwM();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!string2.isEmpty() && string2.charAt(0) == ',') {
            block11: for (int i2 = 1; i2 < string2.length(); ++i2) {
                char c3 = string2.charAt(i2);
                switch (c3) {
                    case 'F': {
                        arrayList.add(false);
                        continue block11;
                    }
                    case 'T': {
                        arrayList.add(true);
                        continue block11;
                    }
                    case 'N': {
                        arrayList.add(null);
                        continue block11;
                    }
                    case 'i': {
                        arrayList.add(this.Opd());
                        continue block11;
                    }
                    case 'h': {
                        arrayList.add(this.OqD());
                        continue block11;
                    }
                    case 'f': {
                        arrayList.add(Float.valueOf(this.m2i()));
                        continue block11;
                    }
                    case 'd': {
                        arrayList.add(this.hFR());
                        continue block11;
                    }
                    case 'b': {
                        arrayList.add(this.LTX());
                        continue block11;
                    }
                    case 's': {
                        arrayList.add(this.CwM());
                        continue block11;
                    }
                    default: {
                        i2 = string2.length();
                    }
                }
            }
        }
        return new tC3(oscBundle, string, string2, arrayList);
    }

    private eac Opd(OscBundle oscBundle) {
        long l2 = this.OqD();
        eac eac2 = new eac(oscBundle, l2);
        while (this.Opd.position() < this.Opd.limit()) {
            int n2 = this.Opd();
            if (this.Opd.limit() < this.Opd.position() + n2) {
                throw new IOException("OSC: Invalid Packet Size (" + n2 + ") which exceeds the packet by " + (this.Opd.position() + n2 - this.OqD.length) + " bytes.");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.OqD, this.Opd.position(), n2);
            ByteBuffer byteBuffer2 = this.Opd;
            byteBuffer2.position(byteBuffer2.position() + n2);
            this.Opd = byteBuffer;
            OscPacket oscPacket = this.CwM(eac2);
            eac2.CwM(oscPacket);
            assert (bCi.CwM(byteBuffer.position() <= byteBuffer2.position()));
            this.Opd = byteBuffer2;
        }
        return eac2;
    }
}

