/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests.dnd;

import com.bitwig.base.testing.acS;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.qsZ;
import com.bitwig.flt.app.testing.tests.BitwigStudioTestDataFileTest;
import com.bitwig.flt.app.testing.tests.dnd.Bmg;
import com.bitwig.flt.app.testing.tests.dnd.JsN;
import com.bitwig.flt.app.testing.tests.dnd.LHZ;
import com.bitwig.flt.app.testing.tests.dnd.XOl;
import com.bitwig.flt.app.testing.tests.dnd.kLR;
import com.bitwig.flt.app.testing.tests.dnd.qrx;
import com.bitwig.flt.app.testing.tests.dnd.rqo;
import com.bitwig.flt.app.testing.tests.dnd.tC3;
import com.bitwig.flt.app.testing.tests.dnd.tJb;
import com.bitwig.flt.app.testing.tests.dnd.yEv;
import com.bitwig.flt.document.core.iface.YEC;
import com.bitwig.flt.document.core.iface.clipboard.clip.ArrangerClipInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.clip.ClipLauncherClipInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.device.CH;
import com.bitwig.flt.document.core.iface.clipboard.device.DeviceChainInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.device.DrumPadInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.track.TrackHeaderInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.track.eac;
import com.bitwig.flt.document.core.iface.mEu;
import com.bitwig.flt.document.core.master.device.XlE;
import com.bitwig.flt.document.core.master.device.Zzk;
import com.bitwig.flt.document.core.master.device.iwC;
import com.bitwig.flt.document.core.master.device.oir;
import com.bitwig.flt.document.core.master.device.uMF;
import com.bitwig.ramona.core.JBA;
import com.bitwig.ramona.core.XBP;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AutoDragAndDropTests
extends BitwigStudioTestDataFileTest {
    private Bmg mDataSourceCreator;
    private JsN mInsertionPointCreator;
    private TestProject mProject;
    private int mInsertModifiers = -1;
    private XOl mExpectedAction;
    private tJb mExpectedInsertActionsFile;
    private static final String CORRECT_INSERT_ACTION_NAME = "insert-action";
    private static final int MODIFIERS_TO_IGNORE = 0;
    private TestProject mProjectWeOpenedToFindTestHierarchy;
    private List mAllDataSourceCreators;
    private List mAllInsertionPointCreators;

    @Override
    protected String getTopLevelDirectoryPath() {
        return "auto-drag-and-drop/projects";
    }

    @Override
    protected boolean shouldCreateTestForFileType(eMc eMc2) {
        return eMc2 instanceof def;
    }

    @Override
    protected boolean hasChildTestsPerFile(skj skj2) {
        return true;
    }

    @Override
    protected String getTestNodeNameForFile(skj skj2) {
        return skj2.uwB();
    }

    @Override
    public String getTestName() {
        if (this.mDataSourceCreator != null) {
            if (this.mInsertionPointCreator != null) {
                if (this.mInsertModifiers == 0) {
                    return "none";
                }
                if (this.mInsertModifiers != -1) {
                    return HK.m2i(this.mInsertModifiers);
                }
                return this.mInsertionPointCreator.CwM();
            }
            return this.mDataSourceCreator.CwM();
        }
        return super.getTestName();
    }

    @Override
    protected void listChildrenForFile(skj skj2, Collection collection) {
        if (this.shouldCreateTestForFile(skj2)) {
            if (this.mDataSourceCreator == null) {
                this.listDataSourceTests(skj2, collection);
            } else if (this.mInsertionPointCreator == null) {
                this.listInsertionPointTests(skj2, collection);
            } else if (this.mInsertModifiers == -1) {
                this.listInsertModifierTests(skj2, collection);
            }
        } else {
            super.listChildrenForFile(skj2, collection);
        }
    }

    private void listDataSourceTests(skj skj2, Collection collection) {
        assert (bCb.Opd(this.mAllDataSourceCreators == null));
        assert (bCb.Opd(this.mAllInsertionPointCreators == null));
        assert (bCb.Opd(this.mExpectedInsertActionsFile == null));
        skj skj3 = skj2.m2i(skj2.uwB() + ".expected");
        this.mProjectWeOpenedToFindTestHierarchy = this.openTestProject(skj2);
        this.mAllDataSourceCreators = new ArrayList();
        this.mAllInsertionPointCreators = new ArrayList();
        skj skj4 = this.getTopLevelDirectory().aMy().hFR("files");
        skj4.CwM(new qrx(this, skj4));
        this.exec(() -> {
            cwN cwN2 = (cwN)this.mProjectWeOpenedToFindTestHierarchy.m2i();
            this.listDataSourcesAndInsertionPointsForDocument(cwN2);
        });
        this.mExpectedInsertActionsFile = new tJb(skj3, this.mAllDataSourceCreators, this.mAllInsertionPointCreators);
        this.exec(() -> {
            for (Bmg bmg2 : this.mAllDataSourceCreators) {
                AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)this.createChild(skj2, true);
                autoDragAndDropTests.mDataSourceCreator = bmg2;
                collection.add(autoDragAndDropTests);
            }
        });
    }

    private void listInsertionPointTests(skj skj2, Collection collection) {
        assert (bCb.Opd(this.mDataSourceCreator != null));
        assert (bCb.Opd(this.mExpectedInsertActionsFile != null));
        this.exec(() -> {
            cwN cwN2 = (cwN)this.mProjectWeOpenedToFindTestHierarchy.m2i();
            qKr qKr2 = this.mDataSourceCreator.CwM(cwN2);
            for (JsN jsN : this.mAllInsertionPointCreators) {
                cHJ cHJ2 = jsN.CwM(cwN2);
                if (!cHJ2.OqD(qKr2)) continue;
                AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)this.createChild(skj2, true);
                autoDragAndDropTests.mInsertionPointCreator = jsN;
                collection.add(autoDragAndDropTests);
            }
        });
    }

    private void listInsertModifierTests(skj skj2, Collection collection) {
        assert (bCb.Opd(this.mExpectedInsertActionsFile != null));
        this.exec(() -> {
            Object object;
            Iterator iterator2;
            cwN cwN2 = (cwN)this.mProjectWeOpenedToFindTestHierarchy.m2i();
            qKr qKr2 = this.mDataSourceCreator.CwM(cwN2);
            this.check(qKr2).IkS();
            cHJ cHJ2 = this.mInsertionPointCreator.CwM(cwN2);
            this.check(cHJ2).IkS();
            this.check(cHJ2.OqD(qKr2));
            int n2 = cHJ2.m2i(qKr2) & 0xFFFFFFFF;
            dns dns2 = new dns(4);
            for (Iterator iterator2 : HK.CwM(n2)) {
                dns2.m2i(((HK)((Object)iterator2)).m2i());
            }
            dns dns3 = new dns(4);
            this.listModifierCombinations(dns2, dns3);
            iterator2 = dns3.OqD();
            while (iterator2.hasNext()) {
                int n3 = (Integer)iterator2.next();
                object = (AutoDragAndDropTests)this.createChild(skj2, false);
                ((AutoDragAndDropTests)object).init(n3);
                collection.add(object);
            }
            for (HK hK2 : HK.CwM) {
                if (hK2.Opd(n2) || hK2.Opd(0) || (object = this.mExpectedInsertActionsFile.CwM(this.mDataSourceCreator, this.mInsertionPointCreator, hK2.m2i())) == null) continue;
                if (((XOl)object).CwM()) {
                    this.checkCorrectable("Did not list " + hK2.OqD() + " as a possible insert modifier but the expected actions says that it should be possible", "RemoveInsertModifier", hK2.OqD()).CwM("");
                    continue;
                }
                this.mExpectedInsertActionsFile.Opd(this.mDataSourceCreator, this.mInsertionPointCreator, hK2.m2i());
            }
        });
    }

    private void listModifierCombinations(dnN dnN2, dnN dnN3) {
        dnN3.m2i(0);
        this.listModifierCombinations(dnN2, dnN3, 0, 0);
    }

    private void listModifierCombinations(dnN dnN2, dnN dnN3, int n2, int n3) {
        for (int i2 = n3; i2 < dnN2.size(); ++i2) {
            int n4 = dnN2.urx(i2);
            dnN3.m2i(n2 | n4);
            this.listModifierCombinations(dnN2, dnN3, n2, n3 + 1);
            this.listModifierCombinations(dnN2, dnN3, n2 | n4, n3 + 1);
        }
    }

    @Override
    protected void afterTestHierachyUpdated() {
        super.afterTestHierachyUpdated();
        this.mAllDataSourceCreators = null;
        this.mAllInsertionPointCreators = null;
        if (this.mDataSourceCreator == null && this.mProjectWeOpenedToFindTestHierarchy != null && this.getFile() != null && this.getFile().EuM()) {
            try {
                this.mProjectWeOpenedToFindTestHierarchy.aMy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.mProjectWeOpenedToFindTestHierarchy = null;
    }

    private void init(int n2) {
        this.mInsertModifiers = n2;
        this.mExpectedAction = this.mExpectedInsertActionsFile.CwM(this.mDataSourceCreator, this.mInsertionPointCreator, n2);
    }

    @Override
    protected com.bitwig.base.testing.XOl getRootTestForSetup() {
        if (this.getFile() != null && this.mDataSourceCreator == null && this.mInsertionPointCreator == null && this.mInsertModifiers == -1) {
            return this;
        }
        return super.getRootTestForSetup();
    }

    @Override
    protected void setupDescendandTest(com.bitwig.base.testing.XOl xOl) {
        super.setupDescendandTest(xOl);
        AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)xOl;
        if (this.mProject == null || ((cwN)this.mProject.m2i()).z_()) {
            this.mProject = autoDragAndDropTests.openTestProject(autoDragAndDropTests.getFile());
        }
        qsZ qsZ2 = (qsZ)((cwN)this.mProject.m2i()).QLt();
        qsZ2.CwM(autoDragAndDropTests);
        autoDragAndDropTests.mProject = new TestProject((BitwigStudioTest)autoDragAndDropTests, (cwN)this.mProject.m2i());
        autoDragAndDropTests.openedProject(autoDragAndDropTests.mProject);
    }

    @Override
    protected void tearDownDescendantTest(com.bitwig.base.testing.XOl xOl, boolean bl2) {
        super.tearDownDescendantTest(xOl, bl2);
        if (!bl2) {
            AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)xOl;
            autoDragAndDropTests.mProject.aMy();
            this.mProject = null;
        }
    }

    @acS(m2i=false)
    public void testDragAndDrop() {
        if (this.mProject.nSA()) {
            this.mProject.WW1();
        }
        this.mProject.EuM();
        EAY eAY = new EAY();
        this.asyncExec(() -> {
            cwN cwN2 = (cwN)this.mProject.m2i();
            qKr qKr2 = this.mDataSourceCreator.CwM(cwN2);
            this.check(qKr2).IkS();
            cHJ cHJ2 = this.mInsertionPointCreator.CwM(cwN2);
            this.check(cHJ2).IkS();
            int n2 = cHJ2.m2i(qKr2);
            KAc kAc = this.mInsertModifiers == 0 || (n2 | this.mInsertModifiers) == n2 ? cHJ2.CwM(qKr2, this.mInsertModifiers) : null;
            if (kAc == null) {
                this.checkActionIsExpected(XOl.Opd);
                eAY.CwM();
                return;
            }
            if (!kAc.CwM()) {
                this.checkActionIsExpected(XOl.CwM);
                eAY.CwM();
                return;
            }
            this.asyncExec(() -> {
                kAc.uwB().CwM(true);
                if (kAc.Opd()) {
                    try {
                        kAc.alk();
                    }
                    catch (wi wi2) {
                        this.checkActionIsExpected(XOl.Opd);
                        eAY.CwM();
                        return;
                    }
                }
                this.asyncExec(() -> {
                    if (kAc.Opd()) {
                        kAc.m2i();
                    }
                    kAc.uwB().CwM(false);
                });
                this.asyncExec(() -> kAc.Opd(this.inNewEvent(tfa.CwM(new LHZ(this, cwN2, kAc, cHJ2), eAY))));
            });
        });
        try {
            this.waitForAsyncTask("Insert to finish", eAY, 10L, TimeUnit.SECONDS);
        }
        catch (XBP | wi exception) {
            // empty catch block
        }
        fnA fnA2 = ((cwN)this.mProject.m2i()).QeG();
        if (fnA2 != null) {
            this.waitForLatch("Bounce to finish", fnA2.urx(), 10L, TimeUnit.SECONDS);
        }
    }

    private void checkActionIsExpected(XOl xOl) {
        if (this.mExpectedAction == null) {
            if (xOl.CwM()) {
                this.mExpectedInsertActionsFile.CwM(this.mDataSourceCreator, this.mInsertionPointCreator, this.mInsertModifiers, xOl);
            }
            this.mExpectedAction = XOl.m2i;
        }
        this.checkCorrectable("Actual insert action is correct", CORRECT_INSERT_ACTION_NAME, xOl).CwM(this.mExpectedAction);
    }

    @Override
    public void autoCorrect(String string, String string2) {
        if (string.equals(CORRECT_INSERT_ACTION_NAME)) {
            try {
                XOl xOl;
                this.mExpectedAction = xOl = XOl.CwM(string2);
                this.mExpectedInsertActionsFile.CwM(this.mDataSourceCreator, this.mInsertionPointCreator, this.mInsertModifiers, xOl);
            }
            catch (BwP bwP2) {
                bwP2.printStackTrace();
            }
        } else if (string.equals("RemoveInsertModifier")) {
            HK hK2 = HK.OqD(string2);
            this.mExpectedInsertActionsFile.Opd(this.mDataSourceCreator, this.mInsertionPointCreator, hK2.m2i());
        } else {
            super.autoCorrect(string, string2);
        }
    }

    private void listDataSourcesAndInsertionPointsForDocument(cwN cwN2) {
        Pt1 pt1 = cwN2.pMu();
        this.listDataSourcesAndInsertionPointsForTrackGroup(pt1);
        Collections.sort(this.mAllDataSourceCreators);
        Collections.sort(this.mAllInsertionPointCreators);
    }

    private void listDataSourcesAndInsertionPointsForTrackGroup(Pt1 pt13) {
        DxB dxB3;
        YJb yJb3;
        int n2;
        int n3;
        this.listDataSourcesAndInsertionPointsForTrackOrTrackGroup(pt13);
        for (n3 = 0; n3 < pt13.sWv(); ++n3) {
            n2 = n3;
            yJb3 = pt13.FCw(n2);
            if (yJb3 instanceof cRC) {
                this.listDataSourcesAndInsertionPointsForTrack((cRC)yJb3);
            } else {
                this.listDataSourcesAndInsertionPointsForTrackGroup((Pt1)yJb3);
            }
            this.addInsertionPoint(yJb3, "Before", yJb2 -> new TrackHeaderInsertionPoint(yJb2.SXq(), yTg.CwM, n2));
        }
        this.addInsertionPoint(pt13, "EndOfMainTracksIn", pt1 -> new TrackHeaderInsertionPoint((mEu)((Object)pt1), yTg.CwM, pt1.sWv()));
        if (pt13.sWv() > 1) {
            this.addDataSource(pt13, "AllMainTracksIn", pt1 -> new eac(pt1.cmM()));
        }
        if (pt13.XSQ() > 1) {
            this.addDataSource(pt13, "AllEffectTracksIn", pt1 -> new eac(pt1.g3A()));
        }
        n3 = 0;
        while (n3 < pt13.XSQ()) {
            n2 = n3++;
            yJb3 = pt13.lIs(n2);
            this.listDataSourcesAndInsertionPointsForTrack((cRC)yJb3);
            this.addInsertionPoint(yJb3, "Before", cRC2 -> new TrackHeaderInsertionPoint(cRC2.SXq(), yTg.Opd, n2));
        }
        this.addInsertionPoint(pt13, "EndOfEffectTracksIn", pt12 -> new TrackHeaderInsertionPoint((mEu)((Object)pt12), yTg.Opd, pt13.XSQ()));
        DxB dxB4 = AutoDragAndDropTests.firstSceneWithClips(pt13);
        if (dxB4 != null) {
            this.addDataSource(dxB4, dxB2 -> new koe(Collections.singleton(dxB2), (S2B)dxB2));
        }
        if ((dxB3 = AutoDragAndDropTests.firstEmptyScene(pt13)) != null) {
            this.addDataSource(dxB3, dxB2 -> new koe(Collections.singleton(dxB2), (S2B)dxB2));
        }
    }

    private void listDataSourcesAndInsertionPointsForTrack(cRC cRC2) {
        xYE xYE2;
        this.listDataSourcesAndInsertionPointsForTrackOrTrackGroup(cRC2);
        iwC iwC2 = cRC2.OwQ();
        this.listDataSourcesAndInsertionPointsForDeviceChain(iwC2);
        xYE xYE3 = AutoDragAndDropTests.firstSlotWithClip(cRC2);
        if (xYE3 != null) {
            this.listDataSourcesAndInsertionPointsForSlot(xYE3);
        }
        if ((xYE2 = AutoDragAndDropTests.firstEmptySlot(cRC2)) != null) {
            this.listDataSourcesAndInsertionPointsForSlot(xYE2);
        }
    }

    private void listDataSourcesAndInsertionPointsForSlot(xYE xYE3) {
        eLk eLk2 = xYE3.FDA();
        if (eLk2 != null) {
            this.addDataSource(xYE3, xYE2 -> new koe(Collections.singletonList(xYE2), (S2B)xYE2));
        }
        this.listDataSourcesAndInsertionPointsForSlotOrScene(xYE3);
    }

    private void listDataSourcesAndInsertionPointsForSlotOrScene(S2B s2B2) {
        this.addInsertionPoint(s2B2, s2B -> new ClipLauncherClipInsertionPoint((kKu)((Object)s2B), s2B.eWk().CNI().lPz()));
    }

    private static xYE firstSlotWithClip(cRC cRC2) {
        for (xYE xYE2 : cRC2.jrh().pqS()) {
            if (xYE2.FDA() == null) continue;
            return xYE2;
        }
        return null;
    }

    private static xYE firstEmptySlot(cRC cRC2) {
        for (xYE xYE2 : cRC2.jrh().pqS()) {
            if (xYE2.FDA() != null) continue;
            return xYE2;
        }
        return null;
    }

    private static DxB firstSceneWithClips(Pt1 pt1) {
        for (DxB dxB2 : pt1.Fnc()) {
            ArrayList arrayList = new ArrayList();
            dxB2.OqD(arrayList);
            if (arrayList.isEmpty()) continue;
            return dxB2;
        }
        return null;
    }

    private static DxB firstEmptyScene(Pt1 pt1) {
        for (DxB dxB2 : pt1.Fnc()) {
            ArrayList arrayList = new ArrayList();
            dxB2.OqD(arrayList);
            if (!arrayList.isEmpty()) continue;
            return dxB2;
        }
        return null;
    }

    private void listDataSourcesAndInsertionPointsForTrackOrTrackGroup(YJb yJb3) {
        this.addDataSource(yJb3, yJb2 -> new eac(Collections.singletonList(yJb2)));
        if (yJb3.WuR().fn() > 0) {
            this.addDataSource(yJb3.WuR().uwB(0), iLH2 -> new pXM(Collections.singleton(iLH2), (iLH)iLH2, iLH2.eOr() + iLH2.g3A() / 2.0));
        }
        if (yJb3.SXq() != null) {
            this.addInsertionPoint(yJb3, "Onto", yJb2 -> TrackHeaderInsertionPoint.CwM(yJb2, true, yJb2.aG_().CNI().Dzr()));
        }
        this.addInsertionPoint(yJb3, "Time0In", yJb2 -> new ArrangerClipInsertionPoint((YEC)((Object)yJb2), 0.0, yJb2.aG_().CNI().lMH(), null, false));
    }

    private void listDataSourcesAndInsertionPointsForDeviceChain(iwC iwC3) {
        this.addInsertionPoint(iwC3, "StartOf", iwC2 -> new DeviceChainInsertionPoint((Nu)((Object)iwC2), 0, ((cRC)iwC2.hFR(cRC.class)).arK().FDA()));
        for (int i2 = 0; i2 < iwC3.AaH(); ++i2) {
            int n2 = i2;
            uMF uMF3 = iwC3.m2i(i2);
            this.listDataSourcesAndInsertionPointsForDevice(uMF3);
            if (i2 <= 0) continue;
            this.addInsertionPoint(uMF3, "Before", uMF2 -> new DeviceChainInsertionPoint(uMF2.Xt2(), n2, uMF2.ETb().arK().FDA()));
        }
        if (iwC3.AaH() > 1) {
            this.addInsertionPoint(iwC3, "EndOf", iwC2 -> new DeviceChainInsertionPoint((Nu)((Object)iwC2), iwC2.AaH(), ((cRC)iwC2.hFR(cRC.class)).arK().FDA()));
            this.addDataSource(iwC3, "AllDevicesIn", iwC2 -> new com.bitwig.flt.document.core.iface.clipboard.device.tC3(iwC2.aMy()));
        }
    }

    private void listDataSourcesAndInsertionPointsForDevice(uMF uMF3) {
        this.addDataSource(uMF3, uMF2 -> new com.bitwig.flt.document.core.iface.clipboard.device.tC3(Collections.singletonList(uMF2)));
        uMF3.pXq().forEach(rEY -> this.listDataSourcesAndInsertionPointsForComponent((REY)rEY));
        this.addInsertionPoint(uMF3, "Onto", uMF2 -> {
            iwC iwC2 = uMF2.Xt2();
            int n2 = iwC2.CwM((llf)((Object)uMF2));
            cRC cRC2 = uMF2.ETb();
            return new DeviceChainInsertionPoint(iwC2, n2, true, true, cRC2.arK().FDA());
        });
    }

    private void listDataSourcesAndInsertionPointsForComponent(REY rEY) {
        if (rEY instanceof Ycq) {
            this.listDataSourcesAndInsertionPointsForDrumPads((Ycq)rEY);
        } else if (rEY instanceof oir) {
            this.listDataSourcesAndInsertionPointsForMultiNestedDeviceChainContainer((oir)rEY);
        } else if (rEY instanceof Zzk) {
            this.listDataSourcesAndInsertionPointsForNestedDeviceChainSlot((Zzk)rEY);
        }
    }

    private void listDataSourcesAndInsertionPointsForMultiNestedDeviceChainContainer(oir oir2) {
        oir oir3 = oir2;
        for (XlE xlE : oir3.Uft()) {
            this.listDataSourcesAndInsertionPointsForNestedDeviceChain(xlE);
        }
    }

    private void listDataSourcesAndInsertionPointsForDrumPads(Ycq ycq) {
        this.listDataSourcesAndInsertionPointsForMultiNestedDeviceChainContainer(ycq);
        List list = ycq.Uft();
        for (XlE xlE : list) {
            this.addDataSource(xlE, xlE2 -> new CH(list, xlE));
        }
        for (int i2 = 0; i2 < 128; ++i2) {
            this.addInsertionPoint(ycq.AaH(i2), "Onto", yi2 -> new DrumPadInsertionPoint((nB)((Object)yi2), ycq.SGr().bBu()));
        }
    }

    private void listDataSourcesAndInsertionPointsForNestedDeviceChainSlot(Zzk zzk) {
        this.listDataSourcesAndInsertionPointsForNestedDeviceChain(zzk.eSQ());
    }

    private void listDataSourcesAndInsertionPointsForNestedDeviceChain(XlE xlE) {
        this.listDataSourcesAndInsertionPointsForDeviceChain(xlE.OwQ());
    }

    private void addDataSource(JBA jBA, yEv yEv2) {
        this.addDataSource(jBA, "", yEv2);
    }

    private void addDataSource(JBA jBA, String string, yEv yEv2) {
        com.bitwig.ramona.path.kLR kLR2 = jBA.hoV();
        String string2 = string + AutoDragAndDropTests.getObjectName(jBA);
        Class<?> clazz = jBA.getClass();
        this.mAllDataSourceCreators.add(new rqo(this, string2, kLR2, clazz, yEv2));
    }

    private void addInsertionPoint(JBA jBA, kLR kLR2) {
        this.addInsertionPoint(jBA, "", kLR2);
    }

    private void addInsertionPoint(JBA jBA, String string, kLR kLR2) {
        com.bitwig.ramona.path.kLR kLR3 = jBA.hoV();
        String string2 = string + AutoDragAndDropTests.getObjectName(jBA);
        Class<?> clazz = jBA.getClass();
        this.mAllInsertionPointCreators.add(new tC3(this, string2, kLR3, clazz, kLR2));
    }

    private static String getObjectName(JBA jBA) {
        com.bitwig.ramona.path.kLR kLR2 = jBA.hoV();
        String string = kLR2.toString();
        String string2 = "track_group/";
        if (string.startsWith("track_group/")) {
            string = string.substring("track_group/".length());
        }
        return dgx.CwM(jBA.WW1().UOJ(), true) + "[" + string.replace('/', ':') + "]";
    }
}

