/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.acS;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestItemSelection;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTrackGroup;
import java.util.ArrayList;

public class TrackOperationTests
extends BitwigStudioTest {
    @acS
    public void testTrackGrouping() {
        Object object;
        TestProject testProject = this.createTestProject(8, 0);
        ArrayList<TestTrack> arrayList = new ArrayList<TestTrack>();
        int n2 = 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            object = testProject.CwM(glQ.Opd);
            arrayList.add((TestTrack)object);
        }
        TestItemSelection testItemSelection = testProject.AaH();
        testItemSelection.LTX();
        for (TestTrack testTrack : arrayList) {
            testItemSelection.CwM(testTrack);
        }
        this.check("Created Tracks", testItemSelection.uwB()).CwM(16);
        testItemSelection.dhb();
        object = (TestTrackGroup)this.cast(testProject.dhb().Opd(0), TestTrackGroup.class);
        this.check("Tracks in TrackGroup", ((TestTrackGroup)object).alk()).CwM(16);
    }

    @acS
    public void testTrackGroupingAndUngrouping() {
        TestProject testProject = this.createTestProject(8, 0);
        ArrayList<TestTrack> arrayList = new ArrayList<TestTrack>();
        int n2 = 24;
        for (int i2 = 0; i2 < 24; ++i2) {
            TestTrack testTrack = testProject.CwM(glQ.Opd);
            arrayList.add(testTrack);
        }
        TestItemSelection testItemSelection = testProject.AaH();
        testItemSelection.LTX();
        for (TestTrack testTrackOrTrackGroup2 : arrayList) {
            testItemSelection.CwM(testTrackOrTrackGroup2);
        }
        this.check("Created Tracks", testItemSelection.uwB()).CwM(24);
        int n3 = testProject.dhb().alk();
        testItemSelection.dhb();
        TestTrackGroup testTrackGroup = (TestTrackGroup)this.cast(testProject.dhb().Opd(0), TestTrackGroup.class);
        testTrackGroup.J_();
        testItemSelection.aMy();
        int n4 = testProject.dhb().alk();
        this.check("Tracks Before/After", n3).CwM(n4);
    }

    @acS
    public void testTrackRename() {
        this.testRenameTrack("Renamed");
    }

    @acS
    public void testTrackRenameInvalid() {
        String string = new String(new char[]{'\ud800', 'H', 'E', 'L', 'L', 'O'});
        this.testRenameTrack(string);
    }

    @acS
    public void testDuplicateTrackWithMidiAutomations() {
        TestProject testProject = this.createTestProject();
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        this.exec(() -> {
            int n2;
            cRC cRC2 = (cRC)testTrack.m2i();
            cwN cwN2 = cRC2.aG_();
            cwN2.CwM("testDuplicateTrackWithMidiAutomations", false);
            for (int i2 = 0; i2 < 16; ++i2) {
                cRC2.CwM(i2, cAm.CwM, 0);
                cRC2.CwM(i2, cAm.Opd, 0);
                for (n2 = 0; n2 < 128; ++n2) {
                    cRC2.CwM(i2, cAm.OqD, n2);
                }
            }
            xqE xqE2 = cRC2.Q3();
            n2 = xqE2.pqS();
            for (int i3 = 0; i3 < n2; ++i3) {
                UfF ufF2 = xqE2.hFR(i3);
                Abs abs2 = cRC2.Opd((fiS)ufF2);
                LW3 lW3 = abs2.GYe().JWq();
                lW3.OqD(h1m.CwM(0.0, 0.0));
                lW3.OqD(h1m.CwM(16.0, 127.0));
            }
            cwN2.CwM(false);
        });
        testTrack.LTX();
        TestTrack testTrack2 = (TestTrack)testProject.dhb().Opd(1);
        this.check("Duplicated Track Exists", testTrack2).IkS();
        this.check("Automation Lane Count", testTrack2.WW1()).CwM(testTrack.WW1());
        this.exec(() -> {
            cRC cRC2 = (cRC)testTrack2.m2i();
            xqE xqE2 = cRC2.Q3();
            for (int i2 = 0; i2 < 16; ++i2) {
                this.checkMidiParameterAutomation(cRC2, xqE2, i2, cAm.CwM, 0);
                this.checkMidiParameterAutomation(cRC2, xqE2, i2, cAm.Opd, 0);
                for (int i3 = 0; i3 < 128; ++i3) {
                    this.checkMidiParameterAutomation(cRC2, xqE2, i2, cAm.OqD, i3);
                }
            }
        });
    }

    private void checkMidiParameterAutomation(cRC cRC2, xqE xqE2, int n2, cAm cAm2, int n3) {
        UfF ufF2 = xqE2.Opd(n2, cAm2, n3);
        this.check("Has " + cAm2.OqD() + "/" + n3 + " Atom on channel " + n2, ufF2).IkS();
        if (ufF2 == null) {
            return;
        }
        Abs abs2 = cRC2.Opd((fiS)ufF2);
        this.check("Has " + cAm2.OqD() + "/" + n3 + " AutomationLane on channel " + n2, abs2).IkS();
    }

    private void testRenameTrack(String string) {
        TestProject testProject = this.createTestProject();
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        this.check(testTrack.uwB()).uwB();
        this.check(testTrack.dhb()).dhb();
        testTrack.Opd(string);
        this.check(testTrack.uwB()).CwM(string);
        this.check(testTrack.dhb()).CwM(string);
        this.check(testProject.nSA());
        this.check(!testProject.gav());
        testProject.WW1();
        this.check(testTrack.uwB()).uwB();
        this.check(testTrack.dhb()).dhb();
        this.check(testProject.gav());
        testProject.urx();
        this.check(testTrack.uwB()).CwM(string);
        this.check(testTrack.dhb()).CwM(string);
    }
}

