/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.acS;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestArrangementAutomationTimeline;
import com.bitwig.flt.app.testing.TestInstrumentNoteClipEvent;
import com.bitwig.flt.app.testing.TestInstrumentNoteEvent;
import com.bitwig.flt.app.testing.TestMatrixSlot;
import com.bitwig.flt.app.testing.TestNoteClipEvent;
import com.bitwig.flt.app.testing.TestNoteClipEventTimeline;
import com.bitwig.flt.app.testing.TestNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTimeSignatureEvent;
import com.bitwig.flt.app.testing.TestTimeSignatureTimeline;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;

public class SessionRecordingTests
extends BitwigStudioIntegrationTest {
    @Override
    public int getBlockSize() {
        return 1859;
    }

    @acS(m2i=false)
    public void testRecordingEmptyInstrumentClipToArranger() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.EuM();
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestMatrixSlot testMatrixSlot = testTrack.OqD(0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testMatrixSlot.dhb(), TestInstrumentNoteClipEvent.class);
        testInstrumentNoteClipEvent.Opd(false);
        TestTransport testTransport = testProject.uwB();
        double d2 = 150.0;
        testTransport.uwB().CwM(150.0);
        testTransport.Opd(0.0, 16.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.EuM();
        this.check("clip count", testNoteClipEventTimeline.uwB()).CwM(1);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.Opd(0), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("time", testInstrumentNoteClipEvent2.AaH()).CwM(0.0);
        this.checkBeatTime("duration", testInstrumentNoteClipEvent2.dhb()).hFR().Opd(16.0, this.getBlockBeatLength(150.0));
    }

    @acS(m2i=false)
    public void testRecordingTimeSignatureChangesToArranger() {
        TestProject testProject = this.openTestProject("record-time-signature-changes-from-clip-launcher-to-arranger");
        testProject.EuM();
        TestTrack testTrack = testProject.dhb().EuM();
        TestNoteClipEvent testNoteClipEvent = testTrack.OqD(0).uwB();
        testNoteClipEvent.Opd(false);
        TestTransport testTransport = testProject.uwB();
        testTransport.Opd(0.0, 8.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.EuM();
        this.check("clip count", testNoteClipEventTimeline.uwB()).CwM(2);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.Opd(0), TestInstrumentNoteClipEvent.class);
        this.check("clip1 start time", testInstrumentNoteClipEvent.AaH()).CwM(0.0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.Opd(1), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("clip2 start time", testInstrumentNoteClipEvent2.AaH()).CwM(4.0);
        TestArrangementAutomationTimeline testArrangementAutomationTimeline = testTrack.Opd(testTransport.LTX());
        TestTimeSignatureTimeline testTimeSignatureTimeline = (TestTimeSignatureTimeline)this.cast(testArrangementAutomationTimeline.LTX(), TestTimeSignatureTimeline.class);
        this.check("event count", testTimeSignatureTimeline.uwB()).CwM(2);
        TestTimeSignatureEvent testTimeSignatureEvent = (TestTimeSignatureEvent)this.cast(testTimeSignatureTimeline.OqD(0), TestTimeSignatureEvent.class);
        this.checkBeatTime("time1", testTimeSignatureEvent.AaH()).CwM(0.0);
        this.check("numerator1", testTimeSignatureEvent.uwB()).CwM(4);
        this.check("denominator1", testTimeSignatureEvent.dhb()).CwM(4);
        TestTimeSignatureEvent testTimeSignatureEvent2 = (TestTimeSignatureEvent)this.cast(testTimeSignatureTimeline.OqD(1), TestTimeSignatureEvent.class);
        this.check("time2", testTimeSignatureEvent2.AaH()).CwM(4.0);
        this.check("numerator2", testTimeSignatureEvent2.uwB()).CwM(3);
        this.check("denominator2", testTimeSignatureEvent2.dhb()).CwM(4);
    }

    @acS(m2i=false)
    public void testRecordingClipWithStartMarkerNotAtTimeZero() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.EuM();
        TestTrack testTrack = testProject.CwM(glQ.CwM);
        TestMatrixSlot testMatrixSlot = testTrack.OqD(0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testMatrixSlot.dhb(), TestInstrumentNoteClipEvent.class);
        double d2 = 2.75;
        int n2 = 40;
        double d3 = 1.0;
        testInstrumentNoteClipEvent.Opd(2.75);
        testInstrumentNoteClipEvent.CwM(KNg.m2i(2.75, 1.0), 0, 40);
        testInstrumentNoteClipEvent.Opd(false);
        TestTransport testTransport = testProject.uwB();
        double d4 = 150.0;
        testTransport.uwB().CwM(150.0);
        testTransport.Opd(0.0, 16.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.EuM();
        this.check("clip count", testNoteClipEventTimeline.uwB()).CwM(1);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.Opd(0), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("time", testInstrumentNoteClipEvent2.AaH()).CwM(0.0);
        this.checkBeatTime("duration", testInstrumentNoteClipEvent2.dhb()).hFR().Opd(16.0, this.getBlockBeatLength(150.0));
        this.checkBeatTime("play start in recorded clip", testInstrumentNoteClipEvent2.alk()).CwM(2.75);
        TestNoteEventTimeline testNoteEventTimeline = testInstrumentNoteClipEvent2.uwB().CwM(40, 0);
        int n3 = testNoteEventTimeline.uwB();
        this.check("recorded note count", n3).CwM(1);
        TestInstrumentNoteEvent testInstrumentNoteEvent = (TestInstrumentNoteEvent)this.cast(testNoteEventTimeline.Opd(0), TestInstrumentNoteEvent.class);
        this.check("recorded note start time", testInstrumentNoteEvent.AaH()).CwM(2.75);
        this.check("recorded note duration", testInstrumentNoteEvent.dhb()).CwM(1.0);
    }
}

